/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.openapi.roots.impl.BundledResourceUsageCollectorKt;
import com.intellij.openapi.roots.impl.PluginKind;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R3\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u00070\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/roots/impl/BundledResourcePathValidationRule;", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/CustomValidationRule;", "<init>", "()V", "pluginKindAndDirectoryById", "", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/roots/impl/PluginKind;", "getPluginKindAndDirectoryById", "()Ljava/util/Map;", "pluginKindAndDirectoryById$delegate", "Lkotlin/Lazy;", "getRuleId", "doValidate", "Lcom/intellij/internal/statistic/eventLog/validator/ValidationResultType;", "data", "context", "Lcom/intellij/internal/statistic/eventLog/validator/rules/EventContext;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nBundledResourceUsageCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundledResourceUsageCollector.kt\ncom/intellij/openapi/roots/impl/BundledResourcePathValidationRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n774#2:145\n865#2,2:146\n1222#2,2:148\n1252#2,4:150\n*S KotlinDebug\n*F\n+ 1 BundledResourceUsageCollector.kt\ncom/intellij/openapi/roots/impl/BundledResourcePathValidationRule\n*L\n120#1:145\n120#1:146,2\n121#1:148,2\n121#1:150,4\n*E\n"})
public final class BundledResourcePathValidationRule
extends CustomValidationRule {
    @NotNull
    private final Lazy pluginKindAndDirectoryById$delegate = LazyKt.lazy(BundledResourcePathValidationRule::pluginKindAndDirectoryById_delegate$lambda$0);

    private final Map<String, Pair<PluginKind, String>> getPluginKindAndDirectoryById() {
        Lazy lazy = this.pluginKindAndDirectoryById$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public String getRuleId() {
        return "bundled_resource_path";
    }

    @NotNull
    protected ValidationResultType doValidate(@NotNull String data2, @NotNull EventContext context2) {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (CustomValidationRule.hasPluginField((EventContext)context2)) {
            if (!CustomValidationRule.isReportedByJetBrainsPlugin((EventContext)context2)) {
                return ValidationResultType.REJECTED;
            }
            Pair<PluginKind, String> pair = this.getPluginKindAndDirectoryById().get(context2.eventData.get("plugin"));
            if (pair == null) {
                return ValidationResultType.REJECTED;
            }
            Pair<PluginKind, String> pair2 = pair;
            PluginKind kind = (PluginKind)((Object)pair2.component1());
            String pluginDirectoryName = (String)pair2.component2();
            Object[] objectArray = new String[]{pluginDirectoryName, data2};
            Path path = Path.of(kind.getHomePath(), (String[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            Path path2 = path;
            objectArray = new LinkOption[]{};
            if (Files.exists(path2, (LinkOption[])Arrays.copyOf(objectArray, objectArray.length))) {
                return ValidationResultType.ACCEPTED;
            }
            return ValidationResultType.REJECTED;
        }
        Object[] objectArray = new String[]{data2};
        Path path = Path.of(BundledResourceUsageCollectorKt.access$getIdeLibPath(), (String[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        Path path3 = path;
        objectArray = new LinkOption[]{};
        if (Files.exists(path3, (LinkOption[])Arrays.copyOf(objectArray, objectArray.length))) {
            return ValidationResultType.ACCEPTED;
        }
        return ValidationResultType.REJECTED;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map pluginKindAndDirectoryById_delegate$lambda$0() {
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PluginManagerCore.getLoadedPlugins();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path path;
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it.getPluginPath(), (String)"getPluginPath(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            IdeaPluginDescriptor bl = (IdeaPluginDescriptor)element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl2 = false;
            IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
            String string = it.getPluginId().getIdString();
            boolean bl3 = false;
            Pair pair = TuplesKt.to((Object)((Object)BundledResourceUsageCollectorKt.access$getKind(it)), (Object)((Object)it.getPluginPath().getFileName()).toString());
            map2.put(string, pair);
        }
        return destination$iv$iv2;
    }
}

