/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PathMacro;
import com.intellij.openapi.ui.playback.PlaybackCommand;
import com.intellij.openapi.ui.playback.PlaybackCommandReporter;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.StageInfo;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.ui.playback.commands.AssertFocused;
import com.intellij.openapi.ui.playback.commands.CallCommand;
import com.intellij.openapi.ui.playback.commands.CdCommand;
import com.intellij.openapi.ui.playback.commands.DelayCommand;
import com.intellij.openapi.ui.playback.commands.EmptyCommand;
import com.intellij.openapi.ui.playback.commands.KeyCodeTypeCommand;
import com.intellij.openapi.ui.playback.commands.KeyShortcutCommand;
import com.intellij.openapi.ui.playback.commands.PopStage;
import com.intellij.openapi.ui.playback.commands.PrintCommand;
import com.intellij.openapi.ui.playback.commands.PushStage;
import com.intellij.openapi.ui.playback.commands.RegistryValueCommand;
import com.intellij.openapi.ui.playback.commands.StopCommand;
import com.intellij.openapi.ui.playback.commands.ToggleActionCommand;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.concurrency.EdtScheduler;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.ui.EDT;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.LockSupport;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaybackRunner {
    private PlaybackCommandReporter commandStartStopProcessor = PlaybackCommandReporter.EMPTY_PLAYBACK_COMMAND_REPORTER;
    private static final Logger LOG = Logger.getInstance(PlaybackRunner.class);
    private Robot myRobot;
    private final String myScript;
    private final StatusCallback callback;
    private final List<CommandDescriptor> commands = new ArrayList<CommandDescriptor>();
    private CompletableFuture<?> actionCallback;
    private boolean isStopRequested;
    private final boolean useDirectActionCall;
    private final boolean useTypingTargets;
    private File myScriptDir;
    private final boolean stopOnAppDeactivation;
    private final ApplicationActivationListener appListener;
    private final HashSet<Class<?>> facadeClasses = new HashSet();
    private final ArrayList<StageInfo> currentStageDepth = new ArrayList();
    private final ArrayList<StageInfo> passedStages = new ArrayList();
    private long myContextTimestamp;
    private final Map<String, String> registryValues = new HashMap<String, String>();
    protected final CheckedDisposable onStop = Disposer.newCheckedDisposable();
    static final String INCLUDE_CMD = "%include";
    static final String IMPORT_CALL_CMD = "%importCall";

    public PlaybackRunner(String script, StatusCallback callback, boolean useDirectActionCall, boolean stopOnAppDeactivation, boolean useTypingTargets) {
        this.myScript = script;
        this.callback = callback;
        this.useDirectActionCall = useDirectActionCall;
        this.useTypingTargets = useTypingTargets;
        this.stopOnAppDeactivation = stopOnAppDeactivation;
        this.appListener = new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PlaybackRunner.this.stopOnAppDeactivation) {
                    PlaybackRunner.this.callback.message(null, "App lost focus, stopping...", StatusCallback.Type.message);
                    PlaybackRunner.this.stop();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/openapi/ui/playback/PlaybackRunner$1", "applicationDeactivated"));
            }
        };
    }

    public void runBlocking(long timeoutMs) throws ExecutionException, InterruptedException, TimeoutException {
        if (timeoutMs > 0L) {
            this.run().get(timeoutMs, TimeUnit.MILLISECONDS);
        } else {
            this.run().get();
        }
    }

    public CompletableFuture<?> run() {
        this.commandStartStopProcessor.startOfScript(this.getProject());
        this.isStopRequested = false;
        this.registryValues.clear();
        UiActivityMonitor activityMonitor = UiActivityMonitor.getInstance();
        activityMonitor.clear();
        activityMonitor.setActive(true);
        this.currentStageDepth.clear();
        this.passedStages.clear();
        ++this.myContextTimestamp;
        this.subscribeListeners(ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.onStop));
        Disposer.register((Disposable)this.onStop, () -> {
            this.commandStartStopProcessor.endOfScript(this.getProject());
            this.onStop();
        });
        this.actionCallback = new CompletableFuture();
        this.actionCallback.handle((o, throwable) -> {
            try {
                if (throwable != null) {
                    this.commandStartStopProcessor.scriptCanceled();
                }
            }
            finally {
                Disposer.dispose((Disposable)this.onStop);
                SwingUtilities.invokeLater(() -> {
                    activityMonitor.setActive(false);
                    this.restoreRegistryValues();
                });
            }
            return null;
        });
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            try {
                this.myRobot = new Robot();
            }
            catch (AWTException e) {
                LOG.info((Throwable)e);
            }
        }
        try {
            this.commands.addAll(this.includeScript(this.myScript, this.getScriptDir()));
        }
        catch (Exception e) {
            String message = "Failed to parse script commands: " + this.myScript;
            LOG.error(message, (Throwable)e);
            this.actionCallback.completeExceptionally(new RuntimeException(message, e));
            return this.actionCallback;
        }
        new Thread(null, Context.current().wrap(() -> {
            if (this.useDirectActionCall) {
                this.executeFrom(0, this.getScriptDir());
            } else {
                IdeEventQueue.getInstance().doWhenReady(Context.current().wrap(() -> this.executeFrom(0, this.getScriptDir())));
            }
        }), "playback runner").start();
        return this.actionCallback;
    }

    private void restoreRegistryValues() {
        Set<String> storedKeys = this.registryValues.keySet();
        for (String each : storedKeys) {
            Registry.get((String)each).setValue(this.registryValues.get(each));
        }
    }

    private void executeFrom(int commandIndex, File baseDir) {
        if (commandIndex >= this.commands.size()) {
            this.callback.message(null, "Finished OK " + this.passedStages.size() + " tests", StatusCallback.Type.message);
            this.actionCallback.complete(null);
            return;
        }
        CommandDescriptor commandDescriptor = this.commands.get(commandIndex);
        PlaybackCommand command = this.createCommand(commandDescriptor.fullLine, commandDescriptor.line, commandDescriptor.scriptDir);
        if (this.isStopRequested || command == null) {
            this.callback.message(null, "Stopped", StatusCallback.Type.message);
            this.actionCallback.cancel(false);
            return;
        }
        Set facadeClassesClone = (Set)this.facadeClasses.clone();
        PlaybackContext context2 = new PlaybackContext(this, this.callback, commandIndex, this.myRobot, this.useDirectActionCall, this.useTypingTargets, command, baseDir, facadeClassesClone){
            private final long myTimeStamp;
            {
                this.myTimeStamp = PlaybackRunner.this.myContextTimestamp;
            }

            @Override
            public void pushStage(StageInfo info) {
                PlaybackRunner.this.currentStageDepth.add(info);
            }

            @Override
            public StageInfo popStage() {
                if (!PlaybackRunner.this.currentStageDepth.isEmpty()) {
                    return PlaybackRunner.this.currentStageDepth.remove(PlaybackRunner.this.currentStageDepth.size() - 1);
                }
                return null;
            }

            @Override
            public int getCurrentStageDepth() {
                return PlaybackRunner.this.currentStageDepth.size();
            }

            @Override
            public void addPassed(StageInfo stage) {
                PlaybackRunner.this.passedStages.add(stage);
            }

            @Override
            public boolean isDisposed() {
                return this.myTimeStamp != PlaybackRunner.this.myContextTimestamp || PlaybackRunner.this.isStopRequested;
            }

            @Override
            public void storeRegistryValue(String key) {
                if (!PlaybackRunner.this.registryValues.containsKey(key)) {
                    PlaybackRunner.this.registryValues.put(key, Registry.stringValue((String)key));
                }
            }

            @Override
            public void setProject(@Nullable Project project2) {
                this.myRunner.setProject(project2);
            }

            @Override
            @NotNull
            public Project getProject() {
                Project project2 = this.myRunner.getProject();
                if (project2 == null) {
                    throw new IllegalStateException("Project is null. Use a project-aware runner and check if its project has been set up properly");
                }
                Project project3 = project2;
                if (project3 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return project3;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/playback/PlaybackRunner$2", "getProject"));
            }
        };
        this.commandStartStopProcessor.startOfCommand(commandDescriptor.fullLine);
        CompletableFuture<?> commandFuture = command.execute(context2);
        Context initialContext = Context.current();
        commandFuture.whenComplete((result2, error2) -> {
            if (error2 != null) {
                this.commandStartStopProcessor.endOfCommand(error2.getMessage());
                this.callback.message(null, "Stopped: " + String.valueOf(error2), StatusCallback.Type.message);
                LOG.warn("Callback step stopped with error: " + String.valueOf(error2), error2);
                this.actionCallback.completeExceptionally((Throwable)error2);
                return;
            }
            this.commandStartStopProcessor.endOfCommand(null);
            try (Scope ignored = initialContext.makeCurrent();){
                if (command.canGoFurther()) {
                    int delay = this.getDelay(command);
                    if (delay > 0) {
                        if (EDT.isCurrentThreadEdt()) {
                            EdtScheduler.getInstance().schedule(delay, Context.current().wrap(() -> {
                                if (!this.onStop.isDisposed()) {
                                    this.executeFrom(commandIndex + 1, context2.getBaseDir());
                                }
                            }));
                        } else {
                            LockSupport.parkUntil(System.currentTimeMillis() + (long)delay);
                            this.executeFrom(commandIndex + 1, context2.getBaseDir());
                        }
                    } else {
                        this.executeFrom(commandIndex + 1, context2.getBaseDir());
                    }
                } else {
                    this.callback.message(null, "Stopped: cannot go further", StatusCallback.Type.message);
                    this.actionCallback.complete(null);
                }
            }
        });
    }

    public int getDelay(@NotNull PlaybackCommand command) {
        if (command == null) {
            PlaybackRunner.$$$reportNull$$$0(0);
        }
        return command instanceof TypeCommand ? Registry.intValue((String)"actionSystem.playback.typecommand.delay") : 0;
    }

    protected void setProject(@Nullable Project project2) {
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    protected void subscribeListeners(MessageBusConnection connection) {
        connection.subscribe(ApplicationActivationListener.TOPIC, (Object)this.appListener);
    }

    public PlaybackRunner setCommandStartStopProcessor(@NotNull PlaybackCommandReporter commandStartStopProcessor) {
        if (commandStartStopProcessor == null) {
            PlaybackRunner.$$$reportNull$$$0(1);
        }
        this.commandStartStopProcessor = commandStartStopProcessor;
        return this;
    }

    protected void onStop() {
        this.commands.clear();
    }

    @NotNull
    private List<CommandDescriptor> includeScript(String scriptText, File scriptDir) {
        ArrayList<CommandDescriptor> commands = new ArrayList<CommandDescriptor>();
        StringTokenizer tokens = new StringTokenizer(scriptText, "\n");
        int line = 0;
        while (tokens.hasMoreTokens()) {
            String eachLine = tokens.nextToken();
            if (eachLine.startsWith(INCLUDE_CMD)) {
                File file2 = new PathMacro().setScriptDir(scriptDir).resolveFile(eachLine.substring(INCLUDE_CMD.length()).trim(), scriptDir);
                if (!file2.exists()) {
                    throw new RuntimeException("Cannot find file to include at line " + line + ": " + file2.getAbsolutePath());
                }
                try {
                    String include = FileUtil.loadFile((File)file2, (boolean)true);
                    commands.add(new CommandDescriptor("%print " + eachLine, line, scriptDir));
                    List<CommandDescriptor> includeCommands = this.includeScript(include, file2.getParentFile());
                    commands.addAll(includeCommands);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading file at line " + line + ": " + file2.getAbsolutePath());
                }
            }
            if (eachLine.startsWith(IMPORT_CALL_CMD)) {
                String className = eachLine.substring(IMPORT_CALL_CMD.length()).trim();
                try {
                    Class<?> facadeClass = Class.forName(className);
                    this.facadeClasses.add(facadeClass);
                    commands.add(new CommandDescriptor("%print " + eachLine, line++, scriptDir));
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Cannot find class at line " + line + ": " + className);
                }
            }
            commands.add(new CommandDescriptor(eachLine, line++, scriptDir));
        }
        ArrayList<CommandDescriptor> arrayList = commands;
        if (arrayList == null) {
            PlaybackRunner.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    protected PlaybackCommand createCommand(String string, int line, File scriptDir) {
        AbstractCommand cmd;
        if (string.startsWith("%set")) {
            cmd = new RegistryValueCommand(string, line);
        } else if (string.startsWith("%%")) {
            cmd = new EmptyCommand(line);
        } else if (string.startsWith("%type")) {
            cmd = new KeyCodeTypeCommand(string, line);
        } else if (string.startsWith("%delay")) {
            cmd = new DelayCommand(string, line);
        } else if (string.startsWith("%[")) {
            cmd = new KeyShortcutCommand(string, line);
        } else if (string.startsWith("%action")) {
            cmd = new ActionCommand(string, line);
        } else if (string.startsWith("%toggle")) {
            cmd = new ToggleActionCommand(string, line);
        } else if (string.startsWith("%stop")) {
            cmd = new StopCommand(string, line);
        } else {
            if (string.startsWith("%assert focused")) {
                return new AssertFocused(string, line);
            }
            if (string.startsWith("%call")) {
                cmd = new CallCommand(string, line);
            } else if (string.startsWith("%cd")) {
                cmd = new CdCommand(string, line);
            } else if (string.startsWith("%startTest")) {
                cmd = new PushStage(string, line);
            } else if (string.startsWith("%endTest")) {
                cmd = new PopStage(string, line);
            } else if (string.startsWith("%print")) {
                cmd = new PrintCommand(string.substring("%print".length() + 1), line);
            } else if (string.startsWith("%")) {
                cmd = null;
                LOG.error("Command " + string + " is not found");
            } else {
                cmd = new AlphaNumericTypeCommand(string, line);
            }
        }
        if (cmd != null) {
            cmd.setScriptDir(scriptDir);
        }
        return cmd;
    }

    public void stop() {
        this.isStopRequested = true;
    }

    public File getScriptDir() {
        return this.myScriptDir != null ? this.myScriptDir : new File(System.getProperty("user.dir"));
    }

    public void setScriptDir(File baseDir) {
        this.myScriptDir = baseDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandStartStopProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/playback/PlaybackRunner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/playback/PlaybackRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "includeScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDelay";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCommandStartStopProcessor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static interface StatusCallback {
        public void message(@Nullable PlaybackContext var1, String var2, Type var3);

        public static abstract class Edt
        implements StatusCallback {
            @Override
            public final void message(PlaybackContext context2, String text2, Type type) {
                if (EDT.isCurrentThreadEdt()) {
                    this.messageEdt(context2, text2, type);
                } else {
                    SwingUtilities.invokeLater(() -> this.messageEdt(context2, text2, type));
                }
            }

            public abstract void messageEdt(@Nullable PlaybackContext var1, @NlsContexts.StatusBarText String var2, Type var3);
        }

        public static enum Type {
            message,
            error,
            code,
            test;

        }
    }

    private record CommandDescriptor(String fullLine, int line, File scriptDir) {
    }
}

