/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl.pluginsAdvertisement;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginManagerCoreKt;
import com.intellij.ide.plugins.advertiser.PluginData;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextLikeFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.AdvertiserInfoUpdateService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserEditorNotificationProvider;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserEditorNotificationProviderKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserExtensionsStateService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginsAdvertiser;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeature;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.UnknownFeaturesCollector;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.HyperlinkLabel;
import fleet.util.Either;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@IntellijInternalApi
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0007\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "AdvertiserSuggestion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPluginAdvertiserEditorNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginAdvertiserEditorNotificationProvider.kt\ncom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,463:1\n42#2,3:464\n30#3,2:467\n1563#4:469\n1634#4,3:470\n*S KotlinDebug\n*F\n+ 1 PluginAdvertiserEditorNotificationProvider.kt\ncom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider\n*L\n66#1:464,3\n72#1:467,2\n84#1:469\n84#1:470,3\n*E\n"})
public final class PluginAdvertiserEditorNotificationProvider
implements EditorNotificationProvider,
DumbAware {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment() || PluginAdvertiserServiceKt.tryUltimateIsDisabled()) {
            return null;
        }
        PluginSuggestion providedSuggestion = (PluginSuggestion)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)PluginAdvertiserEditorNotificationProviderKt.access$getSUGGESTION_EP_NAME$p().getExtensionList()), arg_0 -> PluginAdvertiserEditorNotificationProvider.collectNotificationData$lambda$0(project2, file2, arg_0)));
        boolean $i$f$service = false;
        Class serviceClass$iv = ApplicationInfo.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        String string = ((ApplicationInfo)object).getBuild().getProductCode();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductCode(...)");
        Object suggestionChoice = PluginAdvertiserEditorNotificationProviderKt.access$getSuggestionData(project2, string, file2);
        if (Either.isError-impl((Object)suggestionChoice)) {
            ComponentManager $this$service$iv = (ComponentManager)project2;
            $i$f$service = false;
            serviceClass$iv = AdvertiserInfoUpdateService.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((AdvertiserInfoUpdateService)object2).scheduleAdvertiserUpdate(file2);
        }
        AdvertiserSuggestion suggestionData = (AdvertiserSuggestion)Either.getValueOrNull-impl((Object)suggestionChoice);
        if (providedSuggestion == null && suggestionData == null) {
            return null;
        }
        return arg_0 -> PluginAdvertiserEditorNotificationProvider.collectNotificationData$lambda$1(providedSuggestion, project2, suggestionData, arg_0);
    }

    private static final PluginSuggestion collectNotificationData$lambda$0(Project $project, VirtualFile $file, PluginSuggestionProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuggestion($project, $file);
    }

    /*
     * WARNING - void declaration
     */
    private static final EditorNotificationPanel collectNotificationData$lambda$1(PluginSuggestion $providedSuggestion, Project $project, AdvertiserSuggestion $suggestionData, FileEditor editor2) {
        AdvertiserSuggestion advertiserSuggestion;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        if ($providedSuggestion != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = $providedSuggestion.getPluginIds();
            Project project2 = $project;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PluginId.Companion.getId((String)it));
            }
            PluginAdvertiserEditorNotificationProviderKt.access$logSuggestionShown(project2, (List)destination$iv$iv);
            advertiserSuggestion = (EditorNotificationPanel)$providedSuggestion.apply(editor2);
        } else {
            AdvertiserSuggestion advertiserSuggestion2 = $suggestionData;
            if (advertiserSuggestion2 != null && (advertiserSuggestion2 = advertiserSuggestion2.apply(editor2)) != null) {
                AdvertiserSuggestion panel2 = advertiserSuggestion2;
                boolean bl = false;
                PluginAdvertiserEditorNotificationProviderKt.access$logSuggestionShown($project, $suggestionData.getSuggested());
                advertiserSuggestion = panel2;
            } else {
                advertiserSuggestion = null;
            }
        }
        return advertiserSuggestion;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B^\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u000f\b\u0002\u0010\u0010\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0011\u0012\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0'J\u0012\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010)\u001a\u00020\u0002H\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J0\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/2\n\u00100\u001a\u000601R\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u000104H\u0002J\u0012\u00105\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0010\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider$AdvertiserSuggestion;", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lcom/intellij/ui/EditorNotificationPanel;", "project", "Lcom/intellij/openapi/project/Project;", "extensionOrFileName", "", "foundPlugins", "", "Lcom/intellij/ide/plugins/advertiser/PluginData;", "allJetBrainsPluginsMarketplaceIds", "Lcom/intellij/openapi/extensions/PluginId;", "suggestedIdes", "", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/SuggestedIde;", "overrideSuggestionText", "Lcom/intellij/openapi/util/NlsContexts$Label;", "unknownFeature", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeature;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/util/Set;Ljava/util/Set;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeature;)V", "getSuggestedIdes", "()Ljava/util/List;", "getOverrideSuggestionText", "()Ljava/lang/String;", "getUnknownFeature", "()Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/UnknownFeature;", "installedPlugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "thirdParty", "", "getThirdParty", "()Ljava/util/Set;", "jbProduced", "hasSuggestedIde", "", "pluginsToInstall", "getSuggested", "", "apply", "fileEditor", "isMappedToTextMate", "addSuggestedIdes", "", "panel", "label", "Ljavax/swing/JLabel;", "pluginAdvertiserExtensionsState", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsStateService$ExtensionDataProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserExtensionsStateService;", "currentFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "guessPluginIdFromFile", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nPluginAdvertiserEditorNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginAdvertiserEditorNotificationProvider.kt\ncom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider$AdvertiserSuggestion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,463:1\n1563#2:464\n1634#2,3:465\n1563#2:469\n1634#2,3:470\n1634#2,3:473\n1#3:468\n*S KotlinDebug\n*F\n+ 1 PluginAdvertiserEditorNotificationProvider.kt\ncom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginAdvertiserEditorNotificationProvider$AdvertiserSuggestion\n*L\n137#1:464\n137#1:465,3\n160#1:469\n160#1:470,3\n161#1:473,3\n*E\n"})
    public static final class AdvertiserSuggestion
    implements Function<FileEditor, EditorNotificationPanel> {
        @NotNull
        private final Project project;
        @NotNull
        private final String extensionOrFileName;
        @NotNull
        private final List<SuggestedIde> suggestedIdes;
        @Nullable
        private final String overrideSuggestionText;
        @Nullable
        private final UnknownFeature unknownFeature;
        @Nullable
        private IdeaPluginDescriptor installedPlugin;
        @VisibleForTesting
        @NotNull
        private final Set<PluginData> thirdParty;
        @NotNull
        private final Set<PluginData> jbProduced;
        private final boolean hasSuggestedIde;
        @Nullable
        private Set<PluginData> pluginsToInstall;

        public AdvertiserSuggestion(@NotNull Project project2, @NotNull String extensionOrFileName, @NotNull Set<PluginData> foundPlugins, @NotNull Set<PluginId> allJetBrainsPluginsMarketplaceIds, @NotNull List<SuggestedIde> suggestedIdes, @Nullable String overrideSuggestionText, @Nullable UnknownFeature unknownFeature) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)extensionOrFileName, (String)"extensionOrFileName");
            Intrinsics.checkNotNullParameter(foundPlugins, (String)"foundPlugins");
            Intrinsics.checkNotNullParameter(allJetBrainsPluginsMarketplaceIds, (String)"allJetBrainsPluginsMarketplaceIds");
            Intrinsics.checkNotNullParameter(suggestedIdes, (String)"suggestedIdes");
            this.project = project2;
            this.extensionOrFileName = extensionOrFileName;
            this.suggestedIdes = suggestedIdes;
            this.overrideSuggestionText = overrideSuggestionText;
            this.unknownFeature = unknownFeature;
            this.thirdParty = new LinkedHashSet();
            this.jbProduced = new LinkedHashSet();
            Map descriptorsById = PluginManagerCore.INSTANCE.buildPluginIdMap();
            for (PluginData data2 : foundPlugins) {
                PluginId pluginId = data2.getPluginId();
                if (descriptorsById.containsKey(pluginId)) {
                    this.installedPlugin = (IdeaPluginDescriptor)descriptorsById.get(pluginId);
                    continue;
                }
                if (data2.isBundled) continue;
                ((Collection)(allJetBrainsPluginsMarketplaceIds.contains(pluginId) ? this.jbProduced : this.thirdParty)).add(data2);
            }
            this.hasSuggestedIde = !((Collection)this.suggestedIdes).isEmpty() && this.jbProduced.isEmpty() && this.isMappedToTextMate(this.extensionOrFileName);
        }

        public /* synthetic */ AdvertiserSuggestion(Project project2, String string, Set set, Set set2, List list2, String string2, UnknownFeature unknownFeature, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                string2 = null;
            }
            if ((n & 0x40) != 0) {
                unknownFeature = null;
            }
            this(project2, string, set, set2, list2, string2, unknownFeature);
        }

        @NotNull
        public final List<SuggestedIde> getSuggestedIdes() {
            return this.suggestedIdes;
        }

        @Nullable
        public final String getOverrideSuggestionText() {
            return this.overrideSuggestionText;
        }

        @Nullable
        public final UnknownFeature getUnknownFeature() {
            return this.unknownFeature;
        }

        @NotNull
        public final Set<PluginData> getThirdParty() {
            return this.thirdParty;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Collection<PluginId> getSuggested() {
            Collection collection;
            if (this.hasSuggestedIde) {
                return CollectionsKt.emptyList();
            }
            Set<PluginData> set = this.pluginsToInstall;
            if (set != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    PluginData pluginData = (PluginData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(it.getPluginId());
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = CollectionsKt.emptyList();
            }
            return collection;
        }

        @Override
        @Nullable
        public EditorNotificationPanel apply(@NotNull FileEditor fileEditor) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
            Ref.ObjectRef label2 = new Ref.ObjectRef();
            EditorNotificationPanel.Status status2 = PluginAdvertiserService.Companion.isCommunityIde() ? EditorNotificationPanel.Status.Promo : EditorNotificationPanel.Status.Info;
            EditorNotificationPanel panel2 = new EditorNotificationPanel((Ref.ObjectRef<JLabel>)label2, fileEditor, status2){
                {
                    JLabel jLabel = this.myLabel;
                    Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"myLabel");
                    $label.element = jLabel;
                }
            };
            PluginAdvertiserExtensionsStateService.ExtensionDataProvider pluginAdvertiserExtensionsState = PluginAdvertiserExtensionsStateService.Companion.getInstance().createExtensionDataProvider(this.project);
            String string = this.overrideSuggestionText;
            if (string == null) {
                objectArray = new Object[]{this.extensionOrFileName};
                string = IdeBundle.message((String)"plugins.advertiser.plugins.found", (Object[])objectArray);
            }
            panel2.setText(string);
            IdeaPluginDescriptor installedPlugin = this.installedPlugin;
            if (this.hasSuggestedIde) {
                JLabel jLabel;
                EditorNotificationPanel editorNotificationPanel = panel2;
                if (label2.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"label");
                    jLabel = null;
                } else {
                    jLabel = (JLabel)label2.element;
                }
                this.addSuggestedIdes(editorNotificationPanel, jLabel, pluginAdvertiserExtensionsState, fileEditor.getFile());
                return panel2;
            }
            if (installedPlugin != null) {
                if (!installedPlugin.isEnabled()) {
                    PluginId pluginId = installedPlugin.getPluginId();
                    Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
                    if (PluginManagerCoreKt.pluginRequiresUltimatePluginButItsDisabled((PluginId)pluginId)) {
                        return null;
                    }
                } else {
                    return null;
                }
                Object[] objectArray2 = new Object[]{installedPlugin.getName()};
                objectArray = panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.enable.plugin", (Object[])objectArray2), () -> AdvertiserSuggestion.apply$lambda$2(pluginAdvertiserExtensionsState, this, installedPlugin));
                Intrinsics.checkNotNull((Object)objectArray);
            } else {
                if (!((Collection)this.suggestedIdes).isEmpty() && this.jbProduced.isEmpty()) {
                    JLabel jLabel;
                    EditorNotificationPanel editorNotificationPanel = panel2;
                    if (label2.element == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"label");
                        jLabel = null;
                    } else {
                        jLabel = (JLabel)label2.element;
                    }
                    this.addSuggestedIdes(editorNotificationPanel, jLabel, pluginAdvertiserExtensionsState, fileEditor.getFile());
                    return panel2;
                }
                if (!((Collection)this.thirdParty).isEmpty() || !((Collection)this.jbProduced).isEmpty()) {
                    AdvertiserSuggestion.apply$createInstallActionLabel(this, panel2, pluginAdvertiserExtensionsState, SetsKt.plus(this.jbProduced, (Iterable)this.thirdParty));
                } else {
                    return null;
                }
            }
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.extension", (Object[])new Object[0]), () -> AdvertiserSuggestion.apply$lambda$3(this, pluginAdvertiserExtensionsState));
            return panel2;
        }

        private final boolean isMappedToTextMate(String extensionOrFileName) {
            if (!StringsKt.startsWith$default((String)extensionOrFileName, (String)"*.", (boolean)false, (int)2, null)) {
                return false;
            }
            FileType fileType2 = FileTypeManager.getInstance().getFileTypeByExtension(StringsKt.removePrefix((String)extensionOrFileName, (CharSequence)"*."));
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"getFileTypeByExtension(...)");
            FileType fileType3 = fileType2;
            return fileType3 instanceof PlainTextLikeFileType && PluginAdvertiserService.Companion.getReservedIdeExtensions().contains(extensionOrFileName);
        }

        private final void addSuggestedIdes(EditorNotificationPanel panel2, JLabel label2, PluginAdvertiserExtensionsStateService.ExtensionDataProvider pluginAdvertiserExtensionsState, VirtualFile currentFile) {
            PluginAdvertiserEditorNotificationProviderKt.access$logSuggestedProducts(this.project, this.suggestedIdes);
            if (this.suggestedIdes.size() > 1) {
                HyperlinkLabel hyperlinkLabel;
                Container parentPanel = label2.getParent();
                parentPanel.remove(label2);
                HyperlinkLabel $this$addSuggestedIdes_u24lambda_u240 = hyperlinkLabel = new HyperlinkLabel();
                boolean bl = false;
                Object[] objectArray = new Object[]{this.extensionOrFileName};
                $this$addSuggestedIdes_u24lambda_u240.setTextWithHyperlink(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ides", (Object[])objectArray));
                $this$addSuggestedIdes_u24lambda_u240.addHyperlinkListener(arg_0 -> AdvertiserSuggestion.addSuggestedIdes$lambda$0$0(this, arg_0));
                HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
                parentPanel.add((Component)hyperlinkLabel2, "Center");
            } else {
                Object[] objectArray = new Object[]{this.extensionOrFileName, ((SuggestedIde)CollectionsKt.single(this.suggestedIdes)).getName()};
                panel2.setText(IdeBundle.message((String)"plugins.advertiser.extensions.supported.in.ultimate", (Object[])objectArray));
            }
            for (SuggestedIde suggestedIde : this.suggestedIdes) {
                PluginId pluginId;
                if (this.guessPluginIdFromFile(this.extensionOrFileName) != null) {
                    String it;
                    boolean bl = false;
                    pluginId = PluginId.Companion.getId(it);
                } else {
                    pluginId = null;
                }
                PluginId pluginId2 = pluginId;
                PluginAdvertiserServiceKt.createTryUltimateActionLabel(panel2, suggestedIde, this.project, pluginId2, currentFile, (Function0<Unit>)((Function0)() -> AdvertiserSuggestion.addSuggestedIdes$lambda$2(pluginAdvertiserExtensionsState, this)));
            }
            if (this.suggestedIdes.size() == 1) {
                panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.learn.more", (Object[])new Object[0]), () -> AdvertiserSuggestion.addSuggestedIdes$lambda$3(this));
            }
            panel2.createActionLabel(IdeBundle.message((String)"plugins.advertiser.action.ignore.ultimate", (Object[])new Object[0]), () -> AdvertiserSuggestion.addSuggestedIdes$lambda$4(this));
        }

        static /* synthetic */ void addSuggestedIdes$default(AdvertiserSuggestion advertiserSuggestion, EditorNotificationPanel editorNotificationPanel, JLabel jLabel, PluginAdvertiserExtensionsStateService.ExtensionDataProvider extensionDataProvider, VirtualFile virtualFile2, int n, Object object) {
            if ((n & 8) != 0) {
                virtualFile2 = null;
            }
            advertiserSuggestion.addSuggestedIdes(editorNotificationPanel, jLabel, extensionDataProvider, virtualFile2);
        }

        private final String guessPluginIdFromFile(String extensionOrFileName) {
            return switch (extensionOrFileName) {
                case "*.css" -> "com.intellij.css";
                case "*.go" -> "org.jetbrains.plugins.go";
                case "*.js" -> "JavaScript";
                case "*.jsx" -> "JavaScript";
                case "*.php" -> "com.jetbrains.php";
                case "*.rb" -> "org.jetbrains.plugins.ruby";
                case "*.rs" -> "com.jetbrains.rust";
                case "*.sql" -> "com.intellij.database";
                case "*.ts" -> "JavaScript";
                case "*.tsx" -> "JavaScript";
                case "*.vue" -> "org.jetbrains.plugins.vue";
                default -> null;
            };
        }

        private static final void apply$createInstallActionLabel(AdvertiserSuggestion this$0, apply.panel.1 panel2, PluginAdvertiserExtensionsStateService.ExtensionDataProvider pluginAdvertiserExtensionsState, Set<PluginData> plugins2) {
            Object object;
            block3: {
                block2: {
                    this$0.pluginsToInstall = plugins2;
                    object = (PluginData)CollectionsKt.singleOrNull((Iterable)plugins2);
                    if (object == null || (object = ((PluginData)object).nullablePluginName) == null) break block2;
                    Object it = object;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it};
                    String string = IdeBundle.message((String)"plugins.advertiser.action.install.plugin.name", (Object[])objectArray);
                    object = string;
                    if (string != null) break block3;
                }
                String string = IdeBundle.message((String)"plugins.advertiser.action.install.plugins", (Object[])new Object[0]);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            }
            Object labelText = object;
            panel2.createActionLabel((String)labelText, () -> AdvertiserSuggestion.apply$createInstallActionLabel$lambda$1(plugins2, this$0, pluginAdvertiserExtensionsState));
        }

        /*
         * WARNING - void declaration
         */
        private static final void apply$createInstallActionLabel$lambda$1(Set $plugins, AdvertiserSuggestion this$0, PluginAdvertiserExtensionsStateService.ExtensionDataProvider $pluginAdvertiserExtensionsState) {
            void destination$iv;
            void $this$mapTo$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = $plugins;
            FUSEventSource fUSEventSource = FUSEventSource.EDITOR;
            boolean $i$f$map22 = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PluginData pluginData = (PluginData)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.pluginIdString);
            }
            FUSEventSource.logInstallPlugins$default(fUSEventSource, (List)destination$iv$iv, null, 2, null);
            $this$map$iv = $plugins;
            Collection $i$f$map22 = new HashSet();
            fUSEventSource = this$0.project;
            boolean $i$f$mapTo2 = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                PluginData pluginData = (PluginData)item$iv;
                collection = destination$iv;
                boolean bl = false;
                collection.add(it.getPluginId());
            }
            PluginsAdvertiser.installAndEnable$default((Project)fUSEventSource, (Set)destination$iv, true, false, null, () -> AdvertiserSuggestion.apply$createInstallActionLabel$lambda$1$2($pluginAdvertiserExtensionsState, this$0), 24, null);
        }

        private static final void apply$createInstallActionLabel$lambda$1$2(PluginAdvertiserExtensionsStateService.ExtensionDataProvider $pluginAdvertiserExtensionsState, AdvertiserSuggestion this$0) {
            $pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(this$0.extensionOrFileName);
            PluginAdvertiserEditorNotificationProviderKt.access$updateAllNotifications(this$0.project);
        }

        private static final void apply$lambda$2(PluginAdvertiserExtensionsStateService.ExtensionDataProvider $pluginAdvertiserExtensionsState, AdvertiserSuggestion this$0, IdeaPluginDescriptor $installedPlugin) {
            $pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(this$0.extensionOrFileName);
            PluginAdvertiserEditorNotificationProviderKt.access$updateAllNotifications(this$0.project);
            FUSEventSource.EDITOR.logEnablePlugins(CollectionsKt.listOf((Object)$installedPlugin.getPluginId().getIdString()), this$0.project);
            PluginManagerConfigurable.showPluginConfigurableAndEnable(this$0.project, SetsKt.setOf((Object)$installedPlugin));
        }

        private static final void apply$lambda$3(AdvertiserSuggestion this$0, PluginAdvertiserExtensionsStateService.ExtensionDataProvider $pluginAdvertiserExtensionsState) {
            FUSEventSource.EDITOR.logIgnoreExtension(this$0.project);
            if (this$0.unknownFeature == null) {
                $pluginAdvertiserExtensionsState.ignoreExtensionOrFileNameAndInvalidateCache(this$0.extensionOrFileName);
            } else {
                UnknownFeaturesCollector.getInstance(this$0.project).ignoreFeature(this$0.unknownFeature);
            }
            PluginAdvertiserEditorNotificationProviderKt.access$updateAllNotifications(this$0.project);
        }

        private static final void addSuggestedIdes$lambda$0$0(AdvertiserSuggestion this$0, HyperlinkEvent it) {
            FUSEventSource.EDITOR.learnMoreAndLog(this$0.project);
        }

        private static final Unit addSuggestedIdes$lambda$2(PluginAdvertiserExtensionsStateService.ExtensionDataProvider $pluginAdvertiserExtensionsState, AdvertiserSuggestion this$0) {
            $pluginAdvertiserExtensionsState.addEnabledExtensionOrFileNameAndInvalidateCache(this$0.extensionOrFileName);
            return Unit.INSTANCE;
        }

        private static final void addSuggestedIdes$lambda$3(AdvertiserSuggestion this$0) {
            FUSEventSource.EDITOR.learnMoreAndLog(this$0.project);
        }

        private static final void addSuggestedIdes$lambda$4(AdvertiserSuggestion this$0) {
            FUSEventSource.EDITOR.ignoreUltimateAndLog$intellij_platform_ide_impl(this$0.project);
            PluginAdvertiserEditorNotificationProviderKt.access$updateAllNotifications(this$0.project);
        }
    }
}

