/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.ui.IconManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ui.EmptyIcon;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChooseFileEncodingAction
extends ComboBoxAction {
    private final VirtualFile myVirtualFile;
    public static final Charset NO_ENCODING = new Charset("NO_ENCODING", null){

        @Override
        public boolean contains(Charset cs) {
            return false;
        }

        @Override
        public CharsetDecoder newDecoder() {
            return null;
        }

        @Override
        public CharsetEncoder newEncoder() {
            return null;
        }
    };

    protected ChooseFileEncodingAction(@Nullable VirtualFile virtualFile2) {
        this.myVirtualFile = virtualFile2;
    }

    public abstract void update(@NotNull AnActionEvent var1);

    private void fillCharsetActions(@NotNull DefaultActionGroup group2, final @Nullable VirtualFile virtualFile2, @NotNull List<? extends Charset> charsets, final @NotNull Function<? super Charset, @NlsActions.ActionDescription String> descriptionSupplier) {
        if (group2 == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(0);
        }
        if (charsets == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(1);
        }
        if (descriptionSupplier == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(2);
        }
        for (final Charset charset : charsets) {
            CharsetAction action2 = new CharsetAction(charset.displayName(), null, EmptyIcon.ICON_16){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ChooseFileEncodingAction.this.chosen(virtualFile2, charset);
                }

                public void update(@NotNull AnActionEvent e) {
                    Icon defer;
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.update(e);
                    String description = (String)descriptionSupplier.fun((Object)charset);
                    if (virtualFile2 == null || virtualFile2.isDirectory()) {
                        defer = null;
                    } else {
                        NotNullLazyValue myText = NotNullLazyValue.volatileLazy(() -> LoadTextUtil.loadText((VirtualFile)virtualFile2));
                        NotNullLazyValue myBytes = NotNullLazyValue.volatileLazy(() -> {
                            try {
                                return virtualFile2.contentsToByteArray();
                            }
                            catch (IOException e1) {
                                return ArrayUtilRt.EMPTY_BYTE_ARRAY;
                            }
                        });
                        defer = IconManager.getInstance().createDeferredIcon(null, (Object)new Pair((Object)virtualFile2, (Object)charset), pair -> {
                            byte[] bytes;
                            VirtualFile myFile = (VirtualFile)pair.getFirst();
                            Charset charset2 = (Charset)pair.getSecond();
                            CharSequence text2 = (CharSequence)myText.getValue();
                            EncodingUtil.Magic8 safeToReload = EncodingUtil.isSafeToReloadIn(myFile, text2, bytes = (byte[])myBytes.getValue(), charset2);
                            EncodingUtil.Magic8 safeToConvert = safeToReload == EncodingUtil.Magic8.ABSOLUTELY ? EncodingUtil.Magic8.ABSOLUTELY : EncodingUtil.isSafeToConvertTo(myFile, text2, bytes, charset2);
                            return safeToReload == EncodingUtil.Magic8.ABSOLUTELY || safeToConvert == EncodingUtil.Magic8.ABSOLUTELY ? null : (safeToReload == EncodingUtil.Magic8.WELL_IF_YOU_INSIST || safeToConvert == EncodingUtil.Magic8.WELL_IF_YOU_INSIST ? AllIcons.General.Warning : AllIcons.General.Error);
                        });
                    }
                    e.getPresentation().setIcon(defer);
                    e.getPresentation().setDescription(description);
                }

                @NotNull
                public ActionUpdateThread getActionUpdateThread() {
                    ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                    if (actionUpdateThread == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return actionUpdateThread;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 2 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "e";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction$1";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getActionUpdateThread";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "actionPerformed";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "update";
                            break;
                        }
                        case 2: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 2 -> new IllegalStateException(string);
                    };
                }
            };
            group2.add((AnAction)action2);
        }
    }

    protected abstract void chosen(@Nullable VirtualFile var1, @NotNull Charset var2);

    @NotNull
    protected DefaultActionGroup createCharsetsActionGroup(@Nullable @NlsActions.ActionText String clearItemText, @Nullable Charset alreadySelected, @NotNull Function<? super Charset, @NlsActions.ActionDescription String> descriptionSupplier) {
        if (descriptionSupplier == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(3);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        ArrayList favorites = new ArrayList(EncodingManager.getInstance().getFavorites());
        Collections.sort(favorites);
        Charset current = this.myVirtualFile == null ? null : this.myVirtualFile.getCharset();
        favorites.remove(current);
        favorites.remove(alreadySelected);
        if (clearItemText != null) {
            String description = this.myVirtualFile == null ? IdeBundle.message((String)"action.clear.encoding.description", (Object[])new Object[0]) : IdeBundle.message((String)"action.clear.encoding.description.file", (Object[])new Object[]{this.myVirtualFile.getName()});
            group2.add((AnAction)new DumbAwareAction(clearItemText, description, null){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ChooseFileEncodingAction.this.chosen(ChooseFileEncodingAction.this.myVirtualFile, NO_ENCODING);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction$3", "actionPerformed"));
                }
            });
        }
        if (favorites.isEmpty() && clearItemText == null) {
            this.fillCharsetActions(group2, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), descriptionSupplier);
        } else {
            this.fillCharsetActions(group2, this.myVirtualFile, favorites, descriptionSupplier);
            DefaultActionGroup more = DefaultActionGroup.createPopupGroup(() -> IdeBundle.message((String)"action.text.more", (Object[])new Object[0]));
            group2.add((AnAction)more);
            this.fillCharsetActions(more, this.myVirtualFile, Arrays.asList(CharsetToolkit.getAvailableCharsets()), descriptionSupplier);
        }
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            ChooseFileEncodingAction.$$$reportNull$$$0(4);
        }
        return defaultActionGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charsets";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionSupplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/ChooseFileEncodingAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCharsetsActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fillCharsetActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createCharsetsActionGroup";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static abstract class CharsetAction
    extends DumbAwareAction
    implements LightEditCompatible {
        CharsetAction(@NlsSafe String name2, @NlsActions.ActionDescription String description, Icon icon2) {
            super(name2, description, icon2);
        }
    }
}

