/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.FileEncodingProvider;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="Encoding", storages={@Storage(value="encodings.xml")})
public final class EncodingProjectManagerImpl
extends EncodingProjectManager
implements PersistentStateComponent<Element>,
Disposable {
    @NonNls
    private static final String PROJECT_URL = "PROJECT";
    @NotNull
    private final Project myProject;
    private final EncodingManagerImpl myIdeEncodingManager;
    private boolean myNative2AsciiForPropertiesFiles;
    private Charset myDefaultCharsetForPropertiesFiles;
    @Nullable
    private Charset myDefaultConsoleCharset;
    private final SimpleModificationTracker myModificationTracker;
    private BOMForNewUTF8Files myBomForNewUtf8Files;
    private final Map<VirtualFilePointer, Charset> myMapping;
    private volatile Charset myProjectCharset;
    private static final ThreadLocal<Boolean> SUPPRESS_RELOAD = new ThreadLocal();

    public EncodingProjectManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(0);
        }
        this.myModificationTracker = new SimpleModificationTracker();
        this.myBomForNewUtf8Files = BOMForNewUTF8Files.NEVER;
        this.myMapping = ConcurrentCollectionFactory.createConcurrentMap((HashingStrategy)new HashingStrategy<VirtualFilePointer>(this){

            public int hashCode(VirtualFilePointer pointer) {
                String url = pointer.getUrl();
                return SystemInfoRt.isFileSystemCaseSensitive ? url.hashCode() : StringUtilRt.stringHashCodeInsensitive((CharSequence)url);
            }

            public boolean equals(VirtualFilePointer o1, VirtualFilePointer o2) {
                String u2;
                String u1 = o1.getUrl();
                return Strings.areSameInstance((String)u1, (String)(u2 = o2.getUrl())) || (SystemInfoRt.isFileSystemCaseSensitive ? u1.equals(u2) : u1.equalsIgnoreCase(u2));
            }
        });
        this.myProject = project2;
        this.myIdeEncodingManager = (EncodingManagerImpl)EncodingProjectManagerImpl.getInstance();
    }

    public void dispose() {
    }

    public Element getState() {
        Element element = new Element("x");
        if (!this.myMapping.isEmpty()) {
            ArrayList<Map.Entry<VirtualFilePointer, Charset>> mappings = new ArrayList<Map.Entry<VirtualFilePointer, Charset>>(this.myMapping.entrySet());
            ContainerUtil.quickSort(mappings, Comparator.comparing(e -> ((VirtualFilePointer)e.getKey()).getUrl()));
            for (Map.Entry entry : mappings) {
                VirtualFilePointer file2 = (VirtualFilePointer)entry.getKey();
                Charset charset = (Charset)entry.getValue();
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file2.getUrl());
                child.setAttribute("charset", charset.name());
            }
        }
        if (this.myProjectCharset != null) {
            Element child = new Element("file");
            element.addContent(child);
            child.setAttribute("url", PROJECT_URL);
            child.setAttribute("charset", this.myProjectCharset.name());
        }
        if (this.myNative2AsciiForPropertiesFiles) {
            element.setAttribute("native2AsciiForPropertiesFiles", Boolean.toString(true));
        }
        if (this.myDefaultCharsetForPropertiesFiles != null) {
            element.setAttribute("defaultCharsetForPropertiesFiles", this.myDefaultCharsetForPropertiesFiles.name());
        }
        if (this.myDefaultConsoleCharset != null) {
            element.setAttribute("defaultCharsetForConsole", this.myDefaultConsoleCharset.name());
        }
        if (this.myBomForNewUtf8Files != BOMForNewUTF8Files.NEVER) {
            element.setAttribute("addBOMForNewFiles", this.myBomForNewUtf8Files.getExternalName());
        }
        return element;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(1);
        }
        this.myMapping.clear();
        List files2 = element.getChildren("file");
        if (!files2.isEmpty()) {
            HashMap<VirtualFilePointer, Charset> mapping = new HashMap<VirtualFilePointer, Charset>();
            for (Element fileElement : files2) {
                String url = fileElement.getAttributeValue("url");
                String charsetName = fileElement.getAttributeValue("charset");
                Charset charset = CharsetToolkit.forName((String)charsetName);
                if (charset == null) continue;
                if (PROJECT_URL.equals(url)) {
                    this.myProjectCharset = charset;
                    continue;
                }
                if (url == null) continue;
                VirtualFilePointer file2 = VirtualFilePointerManager.getInstance().create(url, (Disposable)this, null);
                mapping.put(file2, charset);
            }
            this.myMapping.putAll(mapping);
        }
        this.myNative2AsciiForPropertiesFiles = Boolean.parseBoolean(element.getAttributeValue("native2AsciiForPropertiesFiles"));
        this.myDefaultCharsetForPropertiesFiles = CharsetToolkit.forName((String)element.getAttributeValue("defaultCharsetForPropertiesFiles"));
        this.myDefaultConsoleCharset = CharsetToolkit.forName((String)element.getAttributeValue("defaultCharsetForConsole"));
        this.myBomForNewUtf8Files = BOMForNewUTF8Files.getByExternalName(element.getAttributeValue("addBOMForNewFiles"));
        this.myModificationTracker.incModificationCount();
    }

    void reloadAlreadyLoadedDocuments() {
        if (this.myMapping.isEmpty()) {
            return;
        }
        FileDocumentManagerImpl fileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
        for (VirtualFilePointer pointer : this.myMapping.keySet()) {
            VirtualFile file2 = pointer.getFile();
            Document cachedDocument = file2 == null ? null : fileDocumentManager.getCachedDocument(file2);
            if (cachedDocument == null) continue;
            EncodingProjectManagerImpl.reload(file2, this.myProject, fileDocumentManager);
        }
    }

    @Nullable
    public Charset getEncoding(@Nullable VirtualFile virtualFile2, boolean useParentDefaults) {
        if (virtualFile2 != null) {
            for (FileEncodingProvider encodingProvider : FileEncodingProvider.EP_NAME.getIterable()) {
                Charset encoding = encodingProvider.getEncoding(virtualFile2, this.myProject);
                if (encoding == null) continue;
                return encoding;
            }
        }
        if (!this.myMapping.isEmpty()) {
            for (VirtualFile parent = virtualFile2; parent != null; parent = parent.getParent()) {
                Charset charset = this.myMapping.get(new LightFilePointer(parent.getUrl()));
                if (charset == null && useParentDefaults) continue;
                return charset;
            }
        }
        return this.getDefaultCharset();
    }

    @NotNull
    public ModificationTracker getModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myModificationTracker;
        if (simpleModificationTracker == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(2);
        }
        return simpleModificationTracker;
    }

    public void setEncoding(@Nullable VirtualFile virtualFileOrDir, @Nullable Charset charset) {
        Charset oldCharset;
        if (virtualFileOrDir == null) {
            oldCharset = this.myProjectCharset;
            this.myProjectCharset = charset;
        } else {
            VirtualFilePointer pointer = VirtualFilePointerManager.getInstance().create(virtualFileOrDir, (Disposable)this, null);
            oldCharset = charset == null ? this.myMapping.remove(pointer) : this.myMapping.put(pointer, charset);
        }
        if (!Comparing.equal((Object)oldCharset, (Object)charset) || virtualFileOrDir != null && !Comparing.equal((Object)virtualFileOrDir.getCharset(), (Object)charset)) {
            this.myModificationTracker.incModificationCount();
            if (virtualFileOrDir != null) {
                virtualFileOrDir.setCharset(virtualFileOrDir.getBOM() == null ? charset : null);
            }
            this.reloadAllFilesUnder(virtualFileOrDir);
        }
    }

    private static void clearAndReload(@NotNull VirtualFile virtualFileOrDir, @NotNull Project project2) {
        if (virtualFileOrDir == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(4);
        }
        virtualFileOrDir.setCharset(null);
        EncodingProjectManagerImpl.reload(virtualFileOrDir, project2, (FileDocumentManagerImpl)FileDocumentManager.getInstance());
    }

    private static void reload(@NotNull VirtualFile virtualFile2, @NotNull Project project2, @NotNull FileDocumentManagerImpl documentManager) {
        if (virtualFile2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(6);
        }
        if (documentManager == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            try (AccessToken ignored = ProjectLocator.withPreferredProject((VirtualFile)virtualFile2, (Project)project2);){
                documentManager.contentsChanged(new VFileContentChangeEvent(null, virtualFile2, 0L, 0L));
            }
        });
    }

    @NotNull
    public Collection<Charset> getFavorites() {
        Set<Charset> result2 = EncodingProjectManagerImpl.widelyKnownCharsets();
        result2.addAll(this.myMapping.values());
        result2.add(this.getDefaultCharset());
        Set<Charset> set = result2;
        if (set == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    static Set<Charset> widelyKnownCharsets() {
        HashSet<Charset> result2 = new HashSet<Charset>();
        result2.add(StandardCharsets.UTF_8);
        result2.add(CharsetToolkit.getDefaultSystemCharset());
        result2.add(CharsetToolkit.getPlatformCharset());
        result2.add(StandardCharsets.UTF_16);
        result2.add(StandardCharsets.ISO_8859_1);
        result2.add(StandardCharsets.US_ASCII);
        result2.add(EncodingProjectManagerImpl.getInstance().getDefaultCharset());
        result2.add(EncodingProjectManagerImpl.getInstance().getDefaultCharsetForPropertiesFiles(null));
        result2.remove(null);
        HashSet<Charset> hashSet = result2;
        if (hashSet == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    @NotNull
    public Map<? extends VirtualFile, ? extends Charset> getAllMappings() {
        Map<VirtualFile, Charset> map2 = this.myMapping.entrySet().stream().map(e -> Pair.create((Object)((VirtualFilePointer)e.getKey()).getFile(), (Object)((Charset)e.getValue()))).filter(e -> e.getFirst() != null).collect(Collectors.toMap(p -> (VirtualFile)p.getFirst(), p -> (Charset)p.getSecond(), (c1, c2) -> c1));
        if (map2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(10);
        }
        return map2;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<? extends VirtualFilePointer, ? extends Charset> getAllPointersMappings() {
        Map<VirtualFilePointer, Charset> map2 = Collections.unmodifiableMap(this.myMapping);
        if (map2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(11);
        }
        return map2;
    }

    @ApiStatus.Internal
    public void setMapping(@NotNull Map<? extends VirtualFile, ? extends Charset> mapping) {
        if (mapping == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        FileDocumentManager.getInstance().saveAllDocuments();
        HashMap<VirtualFilePointer, Charset> newMap = new HashMap<VirtualFilePointer, Charset>(mapping.size());
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            for (Map.Entry entry : mapping.entrySet()) {
                VirtualFilePointer pointer;
                VirtualFile virtualFile2 = (VirtualFile)entry.getKey();
                Charset charset = (Charset)entry.getValue();
                if (charset == null) {
                    throw new IllegalArgumentException("Null charset for " + String.valueOf(virtualFile2) + "; mapping: " + String.valueOf(mapping));
                }
                if (virtualFile2 == null) {
                    this.myProjectCharset = charset;
                    continue;
                }
                if (!fileIndex.isInContent(virtualFile2) || !EncodingProjectManagerImpl.fileEncodingChanged(virtualFile2, this.myMapping.get(pointer = VirtualFilePointerManager.getInstance().create(virtualFile2, (Disposable)this, null)), charset)) continue;
                newMap.put(pointer, charset);
            }
        });
        this.updateMapping(newMap);
    }

    @ApiStatus.Internal
    public void setPointerMapping(@NotNull Map<? extends VirtualFilePointer, ? extends Charset> mapping) {
        if (mapping == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(13);
        }
        ApplicationManager.getApplication().assertWriteIntentLockAcquired();
        FileDocumentManager.getInstance().saveAllDocuments();
        HashMap<VirtualFilePointer, Charset> newMap = new HashMap<VirtualFilePointer, Charset>(mapping.size());
        EncodingProjectManagerImpl.suppressReloadDuring(() -> {
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            for (Map.Entry entry : mapping.entrySet()) {
                VirtualFilePointer filePointer = (VirtualFilePointer)entry.getKey();
                Charset charset = (Charset)entry.getValue();
                if (charset == null) {
                    throw new IllegalArgumentException("Null charset for " + String.valueOf(filePointer) + "; mapping: " + String.valueOf(mapping));
                }
                if (filePointer == null) {
                    this.myProjectCharset = charset;
                    continue;
                }
                VirtualFile virtualFile2 = filePointer.getFile();
                if (virtualFile2 != null && (!fileIndex.isInContent(virtualFile2) || !EncodingProjectManagerImpl.fileEncodingChanged(virtualFile2, this.myMapping.get(filePointer), charset))) continue;
                newMap.put(filePointer, charset);
            }
        });
        this.updateMapping(newMap);
    }

    private void updateMapping(Map<VirtualFilePointer, Charset> newMap) {
        HashMap<VirtualFilePointer, Charset> oldMap = new HashMap<VirtualFilePointer, Charset>(this.myMapping);
        this.myMapping.clear();
        this.myMapping.putAll(newMap);
        HashSet changed = new HashSet(oldMap.keySet());
        for (Map.Entry<VirtualFilePointer, Charset> entry : newMap.entrySet()) {
            VirtualFilePointer file2 = entry.getKey();
            Charset charset = entry.getValue();
            Charset oldCharset = (Charset)oldMap.get(file2);
            if (!Comparing.equal((Object)oldCharset, (Object)charset)) continue;
            changed.remove(file2);
        }
        HashSet<VirtualFilePointer> added = new HashSet<VirtualFilePointer>(newMap.keySet());
        added.removeAll(oldMap.keySet());
        HashSet removed = new HashSet(oldMap.keySet());
        removed.removeAll(newMap.keySet());
        changed.addAll(added);
        changed.addAll(removed);
        changed.remove(null);
        if (!changed.isEmpty()) {
            Processor<VirtualFile> reloadProcessor = EncodingProjectManagerImpl.createChangeCharsetProcessor(this.myProject);
            this.tryStartReloadWithProgress(() -> {
                HashSet<VirtualFile> processed = new HashSet<VirtualFile>();
                block0: for (VirtualFilePointer changedFilePointer : changed) {
                    VirtualFile changedFile = changedFilePointer.getFile();
                    if (changedFile == null) continue;
                    for (VirtualFile processedFile : processed) {
                        if (!VfsUtilCore.isAncestor((VirtualFile)processedFile, (VirtualFile)changedFile, (boolean)false)) continue;
                        continue block0;
                    }
                    this.processSubFiles(changedFile, (Processor<? super VirtualFile>)reloadProcessor);
                    processed.add(changedFile);
                }
            });
        }
        this.myModificationTracker.incModificationCount();
    }

    private static boolean fileEncodingChanged(@NotNull VirtualFile virtualFile2, @Nullable Charset oldCharset, @NotNull Charset newCharset) {
        if (virtualFile2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(14);
        }
        if (newCharset == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(15);
        }
        if (!virtualFile2.isDirectory() && !Comparing.equal((Object)newCharset, (Object)oldCharset)) {
            byte[] bytes;
            Document document2;
            try {
                document2 = FileDocumentManager.getInstance().getDocument(virtualFile2);
                if (document2 == null) {
                    throw new IOException();
                }
                bytes = virtualFile2.contentsToByteArray();
            }
            catch (IOException e) {
                return false;
            }
            return new ChangeFileEncodingAction().chosen(document2, null, virtualFile2, bytes, newCharset);
        }
        return true;
    }

    @NotNull
    private static Processor<VirtualFile> createChangeCharsetProcessor(@NotNull Project project2) {
        if (project2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(16);
        }
        Processor processor2 = file2 -> {
            if (file2.isDirectory()) {
                return true;
            }
            if (!(file2 instanceof VirtualFileSystemEntry)) {
                return false;
            }
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (cachedDocument == null) {
                if (file2.isCharsetSet()) {
                    file2.setCharset(null, null, false);
                }
                return true;
            }
            ProgressManager.progress((String)IdeBundle.message((String)"progress.text.reloading.files", (Object[])new Object[0]), (String)file2.getPresentableUrl());
            TransactionGuard.submitTransaction((Disposable)ApplicationManager.getApplication(), () -> EncodingProjectManagerImpl.clearAndReload(file2, project2));
            return true;
        };
        if (processor2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(17);
        }
        return processor2;
    }

    private boolean processSubFiles(@Nullable(value="null means all in the project") @Nullable(value="null means all in the project") VirtualFile file2, final @NotNull Processor<? super VirtualFile> processor2) {
        if (processor2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            for (VirtualFile virtualFile2 : ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()) {
                if (this.processSubFiles(virtualFile2, processor2)) continue;
                return false;
            }
            return true;
        }
        return VirtualFileVisitor.CONTINUE == VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(this, new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return processor2.process((Object)file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$2", "visitFile"));
            }
        });
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.myProjectCharset;
        Charset charset2 = charset == null ? this.myIdeEncodingManager.getDefaultCharset() : charset;
        if (charset2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(19);
        }
        return charset2;
    }

    @Nullable
    public Charset getConfiguredDefaultCharset() {
        return this.myProjectCharset;
    }

    static void suppressReloadDuring(@NotNull Runnable action2) {
        if (action2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(20);
        }
        Boolean old = SUPPRESS_RELOAD.get();
        try {
            SUPPRESS_RELOAD.set(Boolean.TRUE);
            action2.run();
        }
        finally {
            SUPPRESS_RELOAD.set(old);
        }
    }

    private void tryStartReloadWithProgress(@NotNull Runnable reloadAction) {
        Boolean suppress;
        if (reloadAction == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(21);
        }
        if ((suppress = SUPPRESS_RELOAD.get()) == Boolean.TRUE) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> EncodingProjectManagerImpl.suppressReloadDuring(reloadAction), IdeBundle.message((String)"progress.title.reload.files", (Object[])new Object[0]), false, this.myProject);
    }

    private void reloadAllFilesUnder(@Nullable VirtualFile root) {
        this.tryStartReloadWithProgress(() -> this.processSubFiles(root, (Processor<? super VirtualFile>)((Processor)file2 -> {
            if (!(file2 instanceof VirtualFileSystemEntry)) {
                return true;
            }
            Document cachedDocument = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (cachedDocument != null) {
                ProgressManager.progress((String)IdeBundle.message((String)"progress.text.reloading.file", (Object[])new Object[0]), (String)file2.getPresentableUrl());
                TransactionGuard.submitTransaction((Disposable)this.myProject, () -> EncodingProjectManagerImpl.reload(file2, this.myProject, (FileDocumentManagerImpl)FileDocumentManager.getInstance()));
            } else if (file2.isCharsetSet() && !file2.equals(root)) {
                file2.setCharset(null);
            }
            return true;
        })));
    }

    public boolean isNative2Ascii(@NotNull VirtualFile virtualFile2) {
        if (virtualFile2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(22);
        }
        return FileTypeRegistry.getInstance().isFileOfType(virtualFile2, (FileType)StdFileTypes.PROPERTIES) && this.myNative2AsciiForPropertiesFiles;
    }

    public boolean isNative2AsciiForPropertiesFiles() {
        return this.myNative2AsciiForPropertiesFiles;
    }

    public void setNative2AsciiForPropertiesFiles(VirtualFile virtualFile2, boolean native2Ascii) {
        if (this.myNative2AsciiForPropertiesFiles != native2Ascii) {
            this.myNative2AsciiForPropertiesFiles = native2Ascii;
            EncodingManagerImpl.firePropertyChange(null, "native2ascii", !native2Ascii, native2Ascii);
        }
    }

    @NotNull
    public String getDefaultCharsetName() {
        Charset charset = this.getEncoding(null, false);
        String string = charset == null ? "" : charset.name();
        if (string == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public void setDefaultCharsetName(@NotNull String name2) {
        Charset newCharset;
        Charset oldCharset;
        if (name2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(24);
        }
        if (!Comparing.equal((Object)(oldCharset = this.getDefaultCharset()), (Object)(newCharset = CharsetToolkit.forName((String)name2)))) {
            this.setEncoding(null, name2.isEmpty() ? null : newCharset);
            EncodingManagerImpl.firePropertyChange(null, "defaultFilesEncoding", oldCharset, newCharset);
        }
    }

    @Nullable
    public Charset getDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2) {
        return this.myDefaultCharsetForPropertiesFiles;
    }

    public void setDefaultCharsetForPropertiesFiles(@Nullable VirtualFile virtualFile2, @Nullable Charset charset) {
        Charset old = this.myDefaultCharsetForPropertiesFiles;
        if (!Comparing.equal((Object)old, (Object)charset)) {
            this.myDefaultCharsetForPropertiesFiles = charset;
            EncodingManagerImpl.firePropertyChange(null, "propertiesFilesEncoding", old, charset);
        }
    }

    @NotNull
    public Charset getDefaultConsoleEncoding() {
        Charset charset = this.myIdeEncodingManager.getDefaultConsoleEncoding();
        if (charset == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(25);
        }
        return charset;
    }

    @Nullable
    public Charset getCachedCharsetFromContent(@NotNull Document document2) {
        if (document2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(26);
        }
        return this.myIdeEncodingManager.getCachedCharsetFromContent(document2);
    }

    public void setBOMForNewUtf8Files(@NotNull BOMForNewUTF8Files option2) {
        if (option2 == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(27);
        }
        this.myBomForNewUtf8Files = option2;
    }

    @ApiStatus.Internal
    @NotNull
    public BOMForNewUTF8Files getBOMForNewUTF8Files() {
        BOMForNewUTF8Files bOMForNewUTF8Files = this.myBomForNewUtf8Files;
        if (bOMForNewUTF8Files == null) {
            EncodingProjectManagerImpl.$$$reportNull$$$0(28);
        }
        return bOMForNewUTF8Files;
    }

    public boolean shouldAddBOMForNewUtf8File() {
        return switch (this.myBomForNewUtf8Files.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> true;
            case 1 -> false;
            case 2 -> SystemInfo.isWindows;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 10, 11, 17, 19, 23, 25, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFileOrDir";
                break;
            }
            case 5: 
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentManager";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCharset";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reloadAction";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModificationTracker";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFavorites";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "widelyKnownCharsets";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMappings";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPointersMappings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangeCharsetProcessor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharset";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultCharsetName";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultConsoleEncoding";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getBOMForNewUTF8Files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: 
            case 19: 
            case 23: 
            case 25: 
            case 28: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "clearAndReload";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reload";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPointerMapping";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fileEncodingChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createChangeCharsetProcessor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processSubFiles";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suppressReloadDuring";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "tryStartReloadWithProgress";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNative2Ascii";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultCharsetName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCharsetFromContent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setBOMForNewUtf8Files";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 10, 11, 17, 19, 23, 25, 28 -> new IllegalStateException(string);
        };
    }

    public static enum BOMForNewUTF8Files {
        ALWAYS("create.new.UT8.file.option.always"),
        NEVER("create.new.UT8.file.option.never"),
        WINDOWS_ONLY("create.new.UT8.file.option.only.under.windows");

        private final String key;
        static final Pair<String, BOMForNewUTF8Files>[] EXTERNAL_NAMES;

        private BOMForNewUTF8Files(String key) {
            if (key == null) {
                BOMForNewUTF8Files.$$$reportNull$$$0(0);
            }
            this.key = key;
        }

        public String toString() {
            return IdeBundle.message((String)this.key, (Object[])new Object[0]);
        }

        @NotNull
        private static BOMForNewUTF8Files getByExternalName(@Nullable String externalName) {
            int i2 = ArrayUtil.indexOf((Object[])EXTERNAL_NAMES, (Object)Pair.create((Object)externalName, null), (pair1, pair2) -> ((String)pair1.first).equalsIgnoreCase((String)pair2.first));
            if (i2 == -1) {
                i2 = 1;
            }
            BOMForNewUTF8Files bOMForNewUTF8Files = (BOMForNewUTF8Files)((Object)BOMForNewUTF8Files.EXTERNAL_NAMES[i2].second);
            if (bOMForNewUTF8Files == null) {
                BOMForNewUTF8Files.$$$reportNull$$$0(1);
            }
            return bOMForNewUTF8Files;
        }

        @NotNull
        private String getExternalName() {
            int i2 = ArrayUtil.indexOf((Object[])EXTERNAL_NAMES, (Object)Pair.create(null, (Object)((Object)this)), (pair1, pair2) -> pair1.second == pair2.second);
            String string = (String)BOMForNewUTF8Files.EXTERNAL_NAMES[i2].first;
            if (string == null) {
                BOMForNewUTF8Files.$$$reportNull$$$0(2);
            }
            return string;
        }

        static {
            EXTERNAL_NAMES = new Pair[]{Pair.create((Object)"with BOM", (Object)((Object)ALWAYS)), Pair.create((Object)"with NO BOM", (Object)((Object)NEVER)), Pair.create((Object)"with BOM under Windows, with no BOM otherwise", (Object)((Object)WINDOWS_ONLY))};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl$BOMForNewUTF8Files";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByExternalName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExternalName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

