/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.eel;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.impl.eel.EelData;
import com.intellij.openapi.vfs.impl.eel.EelFileWatcher;
import com.intellij.openapi.vfs.impl.eel.FileWatcherUtil;
import com.intellij.openapi.vfs.impl.eel.WatchedEel;
import com.intellij.openapi.vfs.local.FileWatcherNotificationSink;
import com.intellij.openapi.vfs.local.PluggableFileWatcher;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.WatchOptionsBuilder;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.path.EelPathException;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J,\u0010\u0018\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J2\u0010!\u001a\u00020\u00132\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001a2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u0006\u0010(\u001a\u00020%H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002J\b\u0010-\u001a\u00020\u0013H\u0017J\b\u0010.\u001a\u00020\u0013H\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/openapi/vfs/impl/eel/EelFileWatcher;", "Lcom/intellij/openapi/vfs/local/PluggableFileWatcher;", "<init>", "()V", "myNotificationSink", "Lcom/intellij/openapi/vfs/local/FileWatcherNotificationSink;", "myWatchedEels", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/platform/eel/EelDescriptor;", "Lcom/intellij/openapi/vfs/impl/eel/WatchedEel;", "mySettingRoots", "Ljava/util/concurrent/atomic/AtomicInteger;", "watchedOptions", "", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$FileChangeType;", "isEnabled", "", "myShuttingDown", "initialize", "", "notificationSink", "dispose", "isOperational", "isSettingRoots", "setWatchRoots", "recursive", "", "", "flat", "shuttingDown", "filterAndNotifyManualWatchRoots", "Lcom/intellij/platform/eel/path/EelPath;", "all", "sortRoots", "roots", "eelData", "", "Lcom/intellij/openapi/vfs/impl/eel/EelData;", "setupWatcherJob", "Lkotlin/Function0;", "data", "notifyChange", "change", "Lcom/intellij/platform/eel/fs/EelFileSystemApi$PathChange;", "shutdownWatcherJobs", "startup", "shutdown", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nEelFileWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelFileWatcher.kt\ncom/intellij/openapi/vfs/impl/eel/EelFileWatcher\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,191:1\n216#2,2:192\n1563#3:194\n1634#3,3:195\n1563#3:198\n1634#3,3:199\n1563#3:202\n1634#3,3:203\n1617#3,9:206\n1869#3:215\n1870#3:218\n1626#3:219\n1869#3,2:220\n1761#3,3:222\n1869#3,2:225\n1#4:216\n1#4:217\n13#5:227\n*S KotlinDebug\n*F\n+ 1 EelFileWatcher.kt\ncom/intellij/openapi/vfs/impl/eel/EelFileWatcher\n*L\n76#1:192,2\n98#1:194\n98#1:195,3\n99#1:198\n99#1:199,3\n100#1:202\n100#1:203,3\n105#1:206,9\n105#1:215\n105#1:218\n105#1:219\n116#1:220,2\n154#1:222,3\n166#1:225,2\n105#1:217\n41#1:227\n*E\n"})
public final class EelFileWatcher
extends PluggableFileWatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private FileWatcherNotificationSink myNotificationSink;
    @NotNull
    private final ConcurrentHashMap<EelDescriptor, WatchedEel> myWatchedEels = new ConcurrentHashMap();
    @NotNull
    private final AtomicInteger mySettingRoots = new AtomicInteger(0);
    @NotNull
    private final Set<EelFileSystemApi.FileChangeType> watchedOptions;
    private boolean isEnabled;
    private volatile boolean myShuttingDown;
    @NotNull
    private static final Logger LOG;

    public EelFileWatcher() {
        Object[] objectArray = new EelFileSystemApi.FileChangeType[]{EelFileSystemApi.FileChangeType.CHANGED, EelFileSystemApi.FileChangeType.CREATED, EelFileSystemApi.FileChangeType.DELETED};
        this.watchedOptions = SetsKt.setOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(@NotNull FileWatcherNotificationSink notificationSink) {
        void app;
        Intrinsics.checkNotNullParameter((Object)notificationSink, (String)"notificationSink");
        this.myNotificationSink = notificationSink;
        Application application = ApplicationManager.getApplication();
        EelFileWatcher eelFileWatcher = this;
        boolean bl = false;
        boolean bl2 = !app.isCommandLine() && !app.isUnitTestMode();
        eelFileWatcher.isEnabled = bl2;
    }

    public void dispose() {
        this.myShuttingDown = true;
        this.shutdownWatcherJobs();
    }

    public boolean isOperational() {
        return Registry.Companion.is("use.eel.file.watcher", false) && this.isEnabled;
    }

    public boolean isSettingRoots() {
        return this.isOperational() && this.mySettingRoots.get() > 0;
    }

    public void setWatchRoots(@NotNull List<String> recursive, @NotNull List<String> flat, boolean shuttingDown) {
        Intrinsics.checkNotNullParameter(recursive, (String)"recursive");
        Intrinsics.checkNotNullParameter(flat, (String)"flat");
        if (!this.isOperational()) {
            return;
        }
        List<EelPath> recursiveFiltered = this.filterAndNotifyManualWatchRoots(recursive);
        List<EelPath> flatFiltered = this.filterAndNotifyManualWatchRoots(recursive);
        if (recursiveFiltered.isEmpty() && flatFiltered.isEmpty()) {
            return;
        }
        if (shuttingDown) {
            this.myShuttingDown = true;
            this.shutdownWatcherJobs();
            return;
        }
        HashMap newData = new HashMap();
        this.sortRoots(recursiveFiltered, newData, true);
        this.sortRoots(flatFiltered, newData, false);
        Map $this$forEach$iv = newData;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            EelDescriptor key = (EelDescriptor)entry.getKey();
            EelData incoming = (EelData)entry.getValue();
            WatchedEel existing = this.myWatchedEels.get(key);
            if (existing == null) {
                ((Map)this.myWatchedEels).put(key, new WatchedEel(incoming, this.setupWatcherJob(incoming)));
                continue;
            }
            if (Intrinsics.areEqual((Object)existing.getData(), (Object)incoming)) continue;
            existing.cancel();
            existing.getData().reload(incoming);
            ((Map)this.myWatchedEels).put(key, new WatchedEel(incoming, this.setupWatcherJob(incoming)));
        }
        this.myWatchedEels.entrySet().removeIf(arg_0 -> EelFileWatcher.setWatchRoots$lambda$2(arg_0 -> EelFileWatcher.setWatchRoots$lambda$1(newData, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final List<EelPath> filterAndNotifyManualWatchRoots(List<String> all) {
        void $this$mapNotNullTo$iv$iv;
        EelPath nioPath;
        Path p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = all;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(NioPathUtil.toNioPathOrNull((String)((Object)p0)));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v0 = nioPath;
            collection.add(v0 != null ? EelNioBridgeServiceKt.asEelPath((Path)v0) : null);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void eelPath;
            nioPath = (EelPath)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(eelPath == null || Intrinsics.areEqual((Object)eelPath.getDescriptor(), (Object)LocalEelDescriptor.INSTANCE) ? null : eelPath);
        }
        List filtered = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.zip((Iterable)all, (Iterable)filtered);
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            String sourcePath = (String)pair.component1();
            EelPath flag = (EelPath)pair.component2();
            String it = string = sourcePath;
            boolean bl3 = false;
            if ((flag == null ? string : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List ignoredPaths = (List)destination$iv$iv2;
        FileWatcherNotificationSink fileWatcherNotificationSink = this.myNotificationSink;
        if (fileWatcherNotificationSink == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myNotificationSink");
            fileWatcherNotificationSink = null;
        }
        fileWatcherNotificationSink.notifyManualWatchRoots((PluggableFileWatcher)this, (Collection)ignoredPaths);
        return CollectionsKt.filterNotNull((Iterable)filtered);
    }

    private final void sortRoots(List<? extends EelPath> roots, Map<EelDescriptor, EelData> eelData, boolean recursive) {
        Iterable $this$forEach$iv = roots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EelData data2;
            EelPath path = (EelPath)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)eelData.computeIfAbsent(path.getDescriptor(), arg_0 -> EelFileWatcher.sortRoots$lambda$0$0(sortRoots.1.data.1.INSTANCE, arg_0)), (String)"computeIfAbsent(...)");
            (recursive ? data2.getRecursive() : data2.getFlat()).add(path);
        }
    }

    private final Function0<Unit> setupWatcherJob(EelData data2) {
        if (this.myShuttingDown) {
            return EelFileWatcher::setupWatcherJob$lambda$0;
        }
        this.mySettingRoots.incrementAndGet();
        CoroutineScope scope = CoroutineScopeKt.childScope$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (String)"IJentFileWatcher", null, (boolean)false, (int)6, null);
        EelApi eel = EelProviderUtil.upgradeBlocking((EelDescriptor)data2.getDescriptor());
        Job job2 = BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(eel, this, data2, scope, null){
            Object L$0;
            int label;
            final /* synthetic */ EelApi $eel;
            final /* synthetic */ EelFileWatcher this$0;
            final /* synthetic */ EelData $data;
            final /* synthetic */ CoroutineScope $scope;
            {
                this.$eel = $eel;
                this.this$0 = $receiver;
                this.$data = $data;
                this.$scope = $scope;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$eel.getFs().watchChanges((Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        flow = (Flow)v0;
                        this.L$0 = flow;
                        this.label = 2;
                        v1 = this.$eel.getFs().addWatchRoots(new WatchOptionsBuilder().changeTypes(EelFileWatcher.access$getWatchedOptions$p(this.this$0)).paths(this.$data.getWatchedPaths()).build(), (Continuation)this);
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl24
                    }
                    case 2: {
                        flow = (Flow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl24:
                        // 2 sources

                        job = BuildersKt.launch$default((CoroutineScope)this.$scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Flow<? extends EelFileSystemApi.PathChange>)flow, this.this$0, this.$data, null){
                            int label;
                            final /* synthetic */ Flow<EelFileSystemApi.PathChange> $flow;
                            final /* synthetic */ EelFileWatcher this$0;
                            final /* synthetic */ EelData $data;
                            {
                                this.$flow = $flow;
                                this.this$0 = $receiver;
                                this.$data = $data;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = this.$flow.collect(new FlowCollector(this.this$0, this.$data){
                                            final /* synthetic */ EelFileWatcher this$0;
                                            final /* synthetic */ EelData $data;
                                            {
                                                this.this$0 = $receiver;
                                                this.$data = $data;
                                            }

                                            public final Object emit(EelFileSystemApi.PathChange it, Continuation<? super Unit> $completion) {
                                                EelFileWatcher.access$notifyChange(this.this$0, it, this.$data);
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        EelFileWatcher.access$getMySettingRoots$p(this.this$0).decrementAndGet();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return () -> EelFileWatcher.setupWatcherJob$lambda$1(job2, scope, eel);
    }

    private final void notifyChange(EelFileSystemApi.PathChange change, EelData data2) {
        EelPath eelPath;
        try {
            eelPath = EelPath.Companion.parse(change.getPath(), data2.getDescriptor());
        }
        catch (EelPathException eelPathException) {
            return;
        }
        EelPath eelPath2 = eelPath;
        if (!data2.getFlat().contains(eelPath2)) {
            boolean bl;
            block13: {
                Iterable $this$any$iv = data2.getRecursive();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        EelPath p0 = (EelPath)element$iv;
                        boolean bl2 = false;
                        if (!eelPath2.startsWith(p0)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                return;
            }
        }
        String mrfsPath = ((Object)EelNioBridgeServiceKt.asNioPath((EelPath)eelPath2)).toString();
        switch (WhenMappings.$EnumSwitchMapping$0[change.getType().ordinal()]) {
            case 1: {
                FileWatcherNotificationSink fileWatcherNotificationSink = this.myNotificationSink;
                if (fileWatcherNotificationSink == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myNotificationSink");
                    fileWatcherNotificationSink = null;
                }
                fileWatcherNotificationSink.notifyDirtyPath(mrfsPath);
                break;
            }
            case 2: 
            case 3: {
                FileWatcherNotificationSink fileWatcherNotificationSink = this.myNotificationSink;
                if (fileWatcherNotificationSink == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"myNotificationSink");
                    fileWatcherNotificationSink = null;
                }
                fileWatcherNotificationSink.notifyPathCreatedOrDeleted(mrfsPath);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void shutdownWatcherJobs() {
        Collection<WatchedEel> collection = this.myWatchedEels.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchedEel it = (WatchedEel)element$iv;
            boolean bl = false;
            it.cancel();
        }
        this.myWatchedEels.clear();
    }

    @TestOnly
    public void startup() {
        this.isEnabled = true;
    }

    @TestOnly
    public void shutdown() {
        this.isEnabled = false;
        this.shutdownWatcherJobs();
    }

    private static final boolean setWatchRoots$lambda$1(HashMap $newData, Map.Entry entry) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        Object k = entry.getKey();
        Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
        EelDescriptor key = (EelDescriptor)k;
        Object v = entry.getValue();
        Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
        WatchedEel value = (WatchedEel)v;
        if (!$newData.containsKey(key)) {
            value.cancel();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean setWatchRoots$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final EelData sortRoots$lambda$0$0(Function1 $tmp0, Object p0) {
        return (EelData)$tmp0.invoke(p0);
    }

    private static final Unit setupWatcherJob$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit setupWatcherJob$lambda$1(Job $job, CoroutineScope $scope, EelApi $eel) {
        Job.DefaultImpls.cancel$default((Job)$job, null, (int)1, null);
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)$scope, null, (int)1, null);
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($eel, null){
            int label;
            final /* synthetic */ EelApi $eel;
            {
                this.$eel = $eel;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FileWatcherUtil.INSTANCE.reset$intellij_platform_ide_impl(this.$eel, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Set access$getWatchedOptions$p(EelFileWatcher $this) {
        return $this.watchedOptions;
    }

    public static final /* synthetic */ void access$notifyChange(EelFileWatcher $this, EelFileSystemApi.PathChange change, EelData data2) {
        $this.notifyChange(change, data2);
    }

    public static final /* synthetic */ AtomicInteger access$getMySettingRoots$p(EelFileWatcher $this) {
        return $this.mySettingRoots;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(EelFileWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vfs/impl/eel/EelFileWatcher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EelFileSystemApi.FileChangeType.values().length];
            try {
                nArray[EelFileSystemApi.FileChangeType.CHANGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.FileChangeType.CREATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EelFileSystemApi.FileChangeType.DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

