/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.InternalThreading;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorWithDelayedPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.VirtualFileManagerImpl;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshQueueImpl;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.RefreshWorker;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.monitoring.VfsUsageCollector;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.progress.CancellationUtil;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0001\u0018\u0000 G2\u00020\u0001:\u0001GB3\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0017\b\u0010\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\n\u0010\u000fB\u001f\b\u0010\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r\u00a2\u0006\u0004\b\n\u0010\u0013J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0016J\u0016\u0010)\u001a\u00020'2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0*H\u0016J\b\u0010+\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0002J\b\u0010-\u001a\u00020'H\u0016J\u000e\u0010.\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010/J\u0006\u00100\u001a\u00020\u0003J\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u00120*2\u0006\u00103\u001a\u000204J\u0016\u00105\u001a\u00020'2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\rH\u0016J\b\u00106\u001a\u00020'H\u0016J,\u00107\u001a\u00020'2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002080\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u0010;\u001a\u00020\u0003H\u0007J,\u0010<\u001a\u00020'2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002080\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u0010;\u001a\u00020\u0003H\u0003J\u0010\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020\u0007H\u0002J$\u0010?\u001a\u00020'2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002080\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\rH\u0007J,\u0010@\u001a\u00020'2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002080\r2\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\r2\u0006\u0010;\u001a\u00020\u0003H\u0003J\u0006\u0010A\u001a\u00020'J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EJ\b\u0010F\u001a\u00020EH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00101\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0014\u00a8\u0006H"}, d2={"Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl;", "Lcom/intellij/openapi/vfs/newvfs/RefreshSession;", "isAsynchronous", "", "myIsRecursive", "myIsBackground", "myFinishRunnable", "Ljava/lang/Runnable;", "modality", "Lcom/intellij/openapi/application/ModalityState;", "<init>", "(ZZZLjava/lang/Runnable;Lcom/intellij/openapi/application/ModalityState;)V", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Ljava/util/List;)V", "async", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(ZLjava/util/List;)V", "()Z", "getMyFinishRunnable$intellij_platform_ide_impl", "()Ljava/lang/Runnable;", "getModality", "()Lcom/intellij/openapi/application/ModalityState;", "myStartTrace", "", "mySemaphore", "Lcom/intellij/util/concurrency/Semaphore;", "myWorkQueue", "", "myEvents", "myWorker", "Lcom/intellij/openapi/vfs/newvfs/RefreshWorker;", "myCancelled", "myLaunched", "myEventCount", "", "addFile", "", "file", "addAllFiles", "", "checkState", "doAddFile", "launch", "executeInBackgroundWriteAction", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "prepareExecution", "isEventSession", "scan", "timeInQueue", "", "addEvents", "cancel", "fireEvents", "Lcom/intellij/openapi/vfs/newvfs/CompoundVFileEvent;", "appliers", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "asyncProcessing", "fireEventsInWriteAction", "invokeOnEdt", "r", "fireEventsInBackgroundWriteAction", "doFireEvents", "waitFor", "metric", "", "key", "", "toString", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nRefreshSessionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefreshSessionImpl.kt\ncom/intellij/openapi/vfs/newvfs/RefreshSessionImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,351:1\n774#2:352\n865#2,2:353\n1761#2,3:356\n1#3:355\n*S KotlinDebug\n*F\n+ 1 RefreshSessionImpl.kt\ncom/intellij/openapi/vfs/newvfs/RefreshSessionImpl\n*L\n81#1:352\n81#1:353,2\n188#1:356,3\n*E\n"})
public final class RefreshSessionImpl
extends RefreshSession {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isAsynchronous;
    private final boolean myIsRecursive;
    private final boolean myIsBackground;
    @Nullable
    private final Runnable myFinishRunnable;
    @NotNull
    private final ModalityState modality;
    @Nullable
    private final Throwable myStartTrace;
    @NotNull
    private final Semaphore mySemaphore;
    @NotNull
    private List<VirtualFile> myWorkQueue;
    @NotNull
    private final List<VFileEvent> myEvents;
    @Nullable
    private volatile RefreshWorker myWorker;
    private volatile boolean myCancelled;
    private volatile boolean myLaunched;
    private volatile int myEventCount;
    @NotNull
    private static final Logger LOG;
    private static final int RETRY_LIMIT;
    private static final long DURATION_REPORT_THRESHOLD_MS;
    private static final int PROGRESS_THRESHOLD_MILLIS = 5000;

    public RefreshSessionImpl(boolean isAsynchronous, boolean myIsRecursive, boolean myIsBackground, @Nullable Runnable myFinishRunnable, @NotNull ModalityState modality) {
        Intrinsics.checkNotNullParameter((Object)modality, (String)"modality");
        this.isAsynchronous = isAsynchronous;
        this.myIsRecursive = myIsRecursive;
        this.myIsBackground = myIsBackground;
        this.myFinishRunnable = myFinishRunnable;
        this.modality = RefreshSessionImpl.Companion.getSaneModalityState(modality);
        this.mySemaphore = new Semaphore();
        this.myWorkQueue = new ArrayList();
        this.myEvents = new ArrayList();
        TransactionGuard.getInstance().assertWriteSafeContext(this.modality);
        Application app = ApplicationManager.getApplication();
        Throwable throwable = this.myStartTrace = app.isUnitTestMode() && (this.isAsynchronous || !app.isDispatchThread()) ? new Throwable() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("RefreshSessionImpl created. Trace.", new Throwable());
        }
    }

    public final boolean isAsynchronous() {
        return this.isAsynchronous;
    }

    @Nullable
    public final Runnable getMyFinishRunnable$intellij_platform_ide_impl() {
        return this.myFinishRunnable;
    }

    @NotNull
    public final ModalityState getModality() {
        return this.modality;
    }

    public RefreshSessionImpl(@NotNull List<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        this(false, true, true, null, modalityState);
        this.addAllFiles((Collection<? extends VirtualFile>)files2);
    }

    /*
     * WARNING - void declaration
     */
    public RefreshSessionImpl(boolean async2, @NotNull List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        this(async2, false, false, null, modalityState);
        Iterable $this$filter$iv = events;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv;
            Object obj2 = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!Objects.nonNull(obj2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filtered = (List)destination$iv$iv;
        if (filtered.size() < events.size()) {
            LOG.error("The list of events must not contain null elements");
        }
        this.addEvents(filtered);
    }

    public void addFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkState();
        this.doAddFile(file2);
    }

    public void addAllFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        this.checkState();
        for (VirtualFile virtualFile2 : files2) {
            this.doAddFile(virtualFile2);
        }
    }

    private final void checkState() {
        if (!(!this.myCancelled)) {
            boolean $i$a$-check-RefreshSessionImpl$checkState$32 = false;
            String $i$a$-check-RefreshSessionImpl$checkState$32 = "Already cancelled";
            throw new IllegalStateException($i$a$-check-RefreshSessionImpl$checkState$32.toString());
        }
        if (!(!this.myLaunched)) {
            boolean bl = false;
            String string = "Already launched";
            throw new IllegalStateException(string.toString());
        }
    }

    private final void doAddFile(VirtualFile file2) {
        if (file2 instanceof NewVirtualFile) {
            this.myWorkQueue.add(file2);
        } else {
            LOG.debug("skipped: " + file2 + " / " + file2.getClass());
        }
    }

    public void launch() {
        if (this.prepareExecution()) {
            return;
        }
        RefreshQueue refreshQueue = RefreshQueue.Companion.getInstance();
        Intrinsics.checkNotNull((Object)refreshQueue, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
        ((RefreshQueueImpl)refreshQueue).execute$intellij_platform_ide_impl(this);
    }

    @Nullable
    public Object executeInBackgroundWriteAction(@NotNull Continuation<? super Unit> $completion) {
        if (this.prepareExecution()) {
            return Unit.INSTANCE;
        }
        RefreshQueue refreshQueue = RefreshQueue.Companion.getInstance();
        Intrinsics.checkNotNull((Object)refreshQueue, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.RefreshQueueImpl");
        Object object = ((RefreshQueueImpl)refreshQueue).executeSuspending$intellij_platform_ide_impl(this, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean prepareExecution() {
        this.checkState();
        if (this.myWorkQueue.isEmpty() && this.myEvents.isEmpty()) {
            if (this.myFinishRunnable == null) {
                return true;
            }
            LOG.warn((Throwable)new Exception("no files to refresh"));
        }
        this.myLaunched = true;
        this.mySemaphore.down();
        return false;
    }

    public final boolean isEventSession() {
        return this.myWorkQueue.isEmpty() && !this.myEvents.isEmpty();
    }

    @NotNull
    public final Collection<VFileEvent> scan(long timeInQueue) {
        if (this.myWorkQueue.isEmpty()) {
            return this.myEvents;
        }
        List<VirtualFile> workQueue = this.myWorkQueue;
        this.myWorkQueue = new ArrayList();
        boolean forceRefresh = !this.myIsRecursive && !this.isAsynchronous;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)localFileSystem, (String)"getInstance(...)");
        LocalFileSystem fs = localFileSystem;
        if (!forceRefresh && fs instanceof LocalFileSystemImpl) {
            ((LocalFileSystemImpl)fs).markSuspiciousFilesDirty(workQueue);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("scanning " + workQueue);
        }
        long t = System.nanoTime();
        PerformanceWatcher.Snapshot snapshot2 = null;
        Map types = null;
        if (DURATION_REPORT_THRESHOLD_MS > 0L) {
            snapshot2 = PerformanceWatcher.Companion.takeSnapshot();
            types = new HashMap();
        }
        ArrayList<NewVirtualFile> refreshRoots = new ArrayList<NewVirtualFile>(workQueue.size());
        for (VirtualFile file2 : workQueue) {
            if (this.myCancelled) break;
            Intrinsics.checkNotNull((Object)file2, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.NewVirtualFile");
            NewVirtualFile nvf = (NewVirtualFile)file2;
            if (forceRefresh) {
                nvf.markDirty();
            }
            if (!nvf.isDirty()) continue;
            refreshRoots.add(nvf);
            if (types == null) continue;
            String type = !file2.isDirectory() ? "file" : (((NewVirtualFile)file2).getFileSystem() instanceof ArchiveFileSystem ? "arc" : "dir");
            Integer n = types.getOrDefault(type, 0);
            Intrinsics.checkNotNull((Object)n);
            types.put(type, ((Number)n).intValue() + 1);
        }
        int count = 0;
        ArrayList events = new ArrayList();
        while (!this.myCancelled) {
            boolean bl;
            block18: {
                RefreshWorker worker;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("try=" + count);
                }
                this.myWorker = worker = new RefreshWorker((Collection<NewVirtualFile>)refreshRoots, this.myIsRecursive);
                events.addAll(worker.scan());
                this.myWorker = null;
                ++count;
                if (LOG.isTraceEnabled()) {
                    LOG.trace("events=" + events.size());
                }
                if (!this.myIsRecursive || this.myIsBackground || count >= RETRY_LIMIT) break;
                Iterable $this$any$iv = workQueue;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        VirtualFile f = (VirtualFile)element$iv;
                        boolean bl2 = false;
                        Intrinsics.checkNotNull((Object)f, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.newvfs.NewVirtualFile");
                        if (!((NewVirtualFile)f).isDirty()) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
            }
            if (bl) continue;
        }
        t = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
        int localRoots = 0;
        int archiveRoots = 0;
        int otherRoots = 0;
        Iterator iterator2 = refreshRoots.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            NewVirtualFile file3 = (NewVirtualFile)e;
            if (file3.getFileSystem() instanceof LocalFileSystem) {
                ++localRoots;
                continue;
            }
            if (file3.getFileSystem() instanceof ArchiveFileSystem) {
                ++archiveRoots;
                continue;
            }
            ++otherRoots;
        }
        VfsUsageCollector.logRefreshSession(this.myIsRecursive, localRoots, archiveRoots, otherRoots, this.myCancelled, timeInQueue, t, count);
        if (LOG.isTraceEnabled()) {
            LOG.trace((this.myCancelled ? "cancelled, " : "done, ") + t + " ms, tries " + count + ", events " + events);
        } else if (snapshot2 != null && t > DURATION_REPORT_THRESHOLD_MS) {
            String string = "Refresh session (queue size: %s, scanned: %s, result: %s, tries: %s, events: %d)";
            Object[] objectArray = new Object[]{workQueue.size(), types, this.myCancelled ? "cancelled" : "done", count, events.size()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            snapshot2.logResponsivenessSinceCreation(string2);
        }
        Collection result2 = events.isEmpty() ? (Collection)new ArrayList() : (Collection)new LinkedHashSet(events);
        this.myEventCount = result2.size();
        return result2;
    }

    public void addEvents(@NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        this.myEvents.addAll((Collection<VFileEvent>)events);
    }

    public void cancel() {
        block0: {
            RefreshWorker worker;
            this.myCancelled = true;
            RefreshWorker refreshWorker = worker = this.myWorker;
            if (refreshWorker == null) break block0;
            refreshWorker.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    @RequiresWriteLock
    public final void fireEvents(@NotNull List<CompoundVFileEvent> events, @NotNull List<? extends AsyncFileListener.ChangeApplier> appliers, boolean asyncProcessing) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(appliers, (String)"appliers");
        try {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (!(this.myFinishRunnable == null && events.isEmpty() || app.isDisposed())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("events are about to fire: " + events);
                }
                app.runWriteActionWithNonCancellableProgressInDispatchThread(IdeCoreBundle.message((String)"progress.title.file.system.synchronization", (Object[])new Object[0]), null, null, arg_0 -> RefreshSessionImpl.fireEvents$lambda$0(events, this, appliers, asyncProcessing, arg_0));
            }
        }
        finally {
            this.mySemaphore.up();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    private final void fireEventsInWriteAction(List<CompoundVFileEvent> events, List<? extends AsyncFileListener.ChangeApplier> appliers, boolean asyncProcessing) {
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNull((Object)virtualFileManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.impl.VirtualFileManagerImpl");
        VirtualFileManagerImpl manager2 = (VirtualFileManagerImpl)virtualFileManager;
        this.invokeOnEdt(() -> RefreshSessionImpl.fireEventsInWriteAction$lambda$0(manager2, this));
        try {
            AsyncEventSupport.processEventsFromRefresh(events, appliers, asyncProcessing);
        }
        catch (AssertionError e) {
            if (Intrinsics.areEqual((Object)"PSI/document/model changes are not allowed during highlighting, because it leads to the daemon unnecessary restarts. If you really do need to start write action during the highlighting, you can pass `canChangeDocument=true` to the CodeInsightTestFixtureImpl#instantiateAndRun() and accept the daemon unresponsiveness/blinking/slowdowns.", (Object)((Throwable)((Object)e)).getMessage())) {
                throw new AssertionError("VFS changes are not allowed during highlighting", this.myStartTrace);
            }
            throw e;
        }
        finally {
            this.invokeOnEdt(() -> RefreshSessionImpl.fireEventsInWriteAction$lambda$1(manager2, this));
        }
    }

    private final void invokeOnEdt(Runnable r) {
        if (EDT.isCurrentThreadEdt()) {
            r.run();
        } else {
            InternalThreading.invokeAndWaitWithTransferredWriteAction(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresWriteLock
    @RequiresBackgroundThread
    public final void fireEventsInBackgroundWriteAction(@NotNull List<CompoundVFileEvent> events, @NotNull List<? extends AsyncFileListener.ChangeApplier> appliers) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter(appliers, (String)"appliers");
        try {
            ApplicationEx app = ApplicationManagerEx.getApplicationEx();
            if (!(this.myFinishRunnable == null && events.isEmpty() || app.isDisposed())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("events are about to fire: " + events);
                }
                String string = IdeCoreBundle.message((String)"progress.title.file.system.synchronization", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                CoroutinesKt.withWriteActionTitle((String)string, () -> RefreshSessionImpl.fireEventsInBackgroundWriteAction$lambda$0(this, events, appliers));
            }
        }
        finally {
            this.mySemaphore.up();
        }
    }

    @RequiresWriteLock
    private final void doFireEvents(List<CompoundVFileEvent> events, List<? extends AsyncFileListener.ChangeApplier> appliers, boolean asyncProcessing) {
        long t = System.nanoTime();
        this.fireEventsInWriteAction(events, appliers, asyncProcessing);
        t = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - t);
        if (t > 5000L) {
            LOG.warn("Long VFS change processing (" + t + "ms, " + events.size() + " events): " + StringUtil.trimLog((String)events.subList(0, Math.min(events.size(), 100)).toString(), (int)10000));
        }
    }

    public final void waitFor() {
        CancellationUtil.waitForMaybeCancellable((Semaphore)this.mySemaphore);
    }

    @NotNull
    public final Object metric(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (Intrinsics.areEqual((Object)key, (Object)"events")) {
            return this.myEventCount;
        }
        throw new IllegalArgumentException();
    }

    @NotNull
    public String toString() {
        return "RefreshSessionImpl: canceled=" + this.myCancelled + " launched=" + this.myLaunched + " queue=" + this.myWorkQueue.size() + " events=" + this.myEventCount;
    }

    private static final void fireEvents$lambda$0(List $events, RefreshSessionImpl this$0, List $appliers, boolean $asyncProcessing, ProgressIndicator indicator2) {
        ProgressIndicator progressIndicator = indicator2;
        Intrinsics.checkNotNull((Object)progressIndicator);
        Object[] objectArray = new Object[]{$events.size()};
        progressIndicator.setText(IdeCoreBundle.message((String)"progress.text.processing.detected.file.changes", (Object[])objectArray));
        if (indicator2 instanceof ProgressIndicatorWithDelayedPresentation) {
            ((ProgressIndicatorWithDelayedPresentation)indicator2).setDelayInMillis(5000);
        }
        this$0.doFireEvents($events, $appliers, $asyncProcessing);
    }

    private static final void fireEventsInWriteAction$lambda$0(VirtualFileManagerImpl $manager, RefreshSessionImpl this$0) {
        $manager.fireBeforeRefreshStart(this$0.isAsynchronous);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void fireEventsInWriteAction$lambda$1(VirtualFileManagerImpl $manager, RefreshSessionImpl this$0) {
        try {
            $manager.fireAfterRefreshFinish(this$0.isAsynchronous);
        }
        finally {
            Runnable runnable2 = this$0.myFinishRunnable;
            if (runnable2 != null) {
                runnable2.run();
            }
        }
    }

    private static final Unit fireEventsInBackgroundWriteAction$lambda$0(RefreshSessionImpl this$0, List $events, List $appliers) {
        this$0.doFireEvents($events, $appliers, true);
        return Unit.INSTANCE;
    }

    static {
        Logger logger2 = Logger.getInstance(RefreshSession.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        RETRY_LIMIT = SystemProperties.getIntProperty((String)"refresh.session.retry.limit", (int)3);
        DURATION_REPORT_THRESHOLD_MS = (long)SystemProperties.getIntProperty((String)"refresh.session.duration.report.threshold.seconds", (int)-1) * 1000L;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vfs/newvfs/RefreshSessionImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RETRY_LIMIT", "", "DURATION_REPORT_THRESHOLD_MS", "", "PROGRESS_THRESHOLD_MILLIS", "getSaneModalityState", "Lcom/intellij/openapi/application/ModalityState;", "state", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final ModalityState getSaneModalityState(ModalityState state2) {
            ModalityState modalityState;
            if (state2 != ModalityState.any()) {
                modalityState = state2;
            } else {
                ModalityState modalityState2 = ModalityState.nonModal();
                modalityState = modalityState2;
                Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"nonModal(...)");
            }
            return modalityState;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

