/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootModelProvider;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.serialization.JpsMavenSettings;

public final class VfsRootAccess {
    private static final boolean SHOULD_PERFORM_ACCESS_CHECK = System.getenv("NO_FS_ROOTS_ACCESS_CHECK") == null && System.getProperty("NO_FS_ROOTS_ACCESS_CHECK") == null;
    private static final Set<String> ourAdditionalRoots = CollectionFactory.createFilePathSet();
    private static boolean insideGettingRoots;

    @TestOnly
    static void assertAccessInTests(@NotNull VirtualFile child, @NotNull NewVirtualFileSystem delegate) {
        if (child == null) {
            VfsRootAccess.$$$reportNull$$$0(0);
        }
        if (delegate == null) {
            VfsRootAccess.$$$reportNull$$$0(1);
        }
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        if (SHOULD_PERFORM_ACCESS_CHECK && app.isUnitTestMode() && app.isComponentCreated() && !ApplicationManagerEx.isInStressTest()) {
            boolean isUnder;
            if (delegate != LocalFileSystem.getInstance() && delegate != JarFileSystem.getInstance()) {
                return;
            }
            if (child.getParent() == null || child.getParent().getParent() == null) {
                return;
            }
            Set<String> allowed = VfsRootAccess.allowedRoots();
            boolean bl = isUnder = allowed == null || allowed.isEmpty();
            if (!isUnder) {
                VirtualFile local = child;
                if (delegate == JarFileSystem.getInstance()) {
                    local = JarFileSystem.getInstance().getVirtualFileForJar(child);
                    assert (local != null) : child;
                }
                for (String root : allowed) {
                    String rootLocalPath;
                    if (VfsUtilCore.isAncestorOrSelf((String)root, (VirtualFile)local)) {
                        isUnder = true;
                        break;
                    }
                    if (!root.startsWith("jar://") || !(isUnder = VfsUtilCore.isAncestorOrSelf((String)(rootLocalPath = FileUtil.toSystemIndependentName((String)PathUtil.toPresentableUrl((String)root))), (VirtualFile)local))) continue;
                    break;
                }
            }
            if (!isUnder) {
                throw new VfsRootAccessNotAllowedError(child, new ArrayList<String>(allowed));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Set<String> allowedRoots() {
        String homePath2;
        if (insideGettingRoots) {
            return null;
        }
        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        if (openProjects.length == 0) {
            return null;
        }
        Set allowed = CollectionFactory.createFilePathSet();
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getHomePath()));
        allowed.add(FileUtil.toSystemIndependentName((String)PathManager.getConfigPath()));
        File globalMavenSettings = JpsMavenSettings.getGlobalMavenSettingsXml();
        if (globalMavenSettings != null) {
            allowed.add(globalMavenSettings.getAbsolutePath());
        }
        if ((homePath2 = PathManager.getHomePathFor(Application.class)) != null) {
            allowed.add(FileUtil.toSystemIndependentName((String)homePath2));
        }
        try {
            URL outUrl = Application.class.getResource("/");
            if (outUrl != null) {
                String output = new File(outUrl.toURI()).getParentFile().getParentFile().getPath();
                allowed.add(FileUtil.toSystemIndependentName((String)output));
            }
        }
        catch (IllegalArgumentException | URISyntaxException outUrl) {
            // empty catch block
        }
        try {
            String gradleHome;
            allowed.add(FileUtil.toSystemIndependentName((String)VfsRootAccess.getJavaHome()));
            allowed.add(FileUtil.toSystemIndependentName((String)FileUtil.getTempDirectory()));
            allowed.add(FileUtil.toSystemIndependentName((String)System.getProperty("java.io.tmpdir")));
            Arrays.stream(System.getProperty("vfs.additional-allowed-roots", "").split(File.pathSeparator)).filter(Predicate.not(String::isBlank)).map(FileUtil::toSystemIndependentName).forEach(allowed::add);
            String userHome = FileUtil.toSystemIndependentName((String)SystemProperties.getUserHome());
            allowed.add(userHome);
            String mavenHome = VfsRootAccess.resolvedPath(userHome + "/.m2");
            if (!mavenHome.startsWith(userHome + "/")) {
                allowed.add(mavenHome);
            }
            if (!(mavenHome = VfsRootAccess.resolvedPath(userHome + "/.m2/repository")).startsWith(userHome + "/")) {
                allowed.add(mavenHome);
            }
            if ((gradleHome = VfsRootAccess.resolvedPath(userHome + "/.gradle")).startsWith(userHome + "/")) {
                allowed.add(gradleHome);
            }
            if ((gradleHome = System.getenv("GRADLE_USER_HOME")) != null) {
                allowed.add(FileUtil.toSystemIndependentName((String)gradleHome));
            }
            if (SystemInfo.isWindows) {
                String wslName = System.getProperty("wsl.distribution.name");
                if (wslName != null) {
                    allowed.add(FileUtil.toSystemIndependentName((String)("\\\\wsl$\\" + wslName)));
                    allowed.add(FileUtil.toSystemIndependentName((String)("\\\\wsl.localhost\\" + wslName)));
                }
            } else {
                allowed.add("/etc");
                allowed.add("/private/etc");
                allowed.add("/usr/lib/jvm");
            }
            String testSrcDir = System.getenv("TEST_SRCDIR");
            if (testSrcDir != null && !testSrcDir.isBlank()) {
                Path testSrcDirPath = Path.of(testSrcDir, new String[0]).toAbsolutePath();
                allowed.add(FileUtil.toSystemIndependentName((String)testSrcDirPath.toString()));
            }
            for (Project project2 : openProjects) {
                if (!project2.isInitialized()) {
                    return null;
                }
                ReadAction.run(() -> {
                    for (VirtualFile virtualFile2 : ProjectRootManager.getInstance((Project)project2).getContentRoots()) {
                        allowed.add(virtualFile2.getPath());
                        allowed.add(virtualFile2.getCanonicalPath());
                    }
                    for (VirtualFile virtualFile3 : ModuleManager.getInstance((Project)project2).getModules()) {
                        String homePath;
                        Sdk moduleSdk = ModuleRootManager.getInstance((Module)virtualFile3).getSdk();
                        if (moduleSdk == null || (homePath = moduleSdk.getHomePath()) == null) continue;
                        allowed.add(homePath);
                    }
                    for (String url : VfsRootAccess.getAllRootUrls(project2)) {
                        allowed.add(StringUtil.trimEnd((String)VfsUtilCore.urlToPath((String)url), (String)"!/"));
                    }
                    String location = project2.getBasePath();
                    assert (location != null) : project2;
                    allowed.add(FileUtil.toSystemIndependentName((String)location));
                });
            }
        }
        catch (Error error2) {
            // empty catch block
        }
        Set<String> set = ourAdditionalRoots;
        synchronized (set) {
            allowed.addAll(ourAdditionalRoots);
        }
        assert (!allowed.contains("/")) : "Allowed roots should not contain '/'. You can disable roots access check explicitly if you don't need it.";
        return allowed;
    }

    private static String getJavaHome() {
        String javaHomeParent;
        String javaHome = SystemProperties.getJavaHome();
        if (JdkUtil.checkForJre((String)javaHome) && !JdkUtil.checkForJdk((String)javaHome) && JdkUtil.checkForJre((String)(javaHomeParent = PathUtil.getParentPath((String)javaHome))) && JdkUtil.checkForJdk((String)javaHomeParent)) {
            javaHome = javaHomeParent;
        }
        return javaHome;
    }

    private static String resolvedPath(String path) {
        try {
            return FileUtil.toSystemIndependentName((String)Path.of(path, new String[0]).toRealPath(new LinkOption[0]).toString());
        }
        catch (IOException e) {
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<String> getAllRootUrls(Project project2) {
        insideGettingRoots = true;
        try {
            Set roots = CollectionFactory.createSmallMemoryFootprintSet();
            OrderEnumerator enumerator2 = ProjectRootManager.getInstance((Project)project2).orderEntries().using((RootModelProvider)new DefaultModulesProvider(project2));
            ContainerUtil.addAll((Collection)roots, (Object[])enumerator2.classes().getUrls());
            ContainerUtil.addAll((Collection)roots, (Object[])enumerator2.sources().getUrls());
            Set set = roots;
            return set;
        }
        finally {
            insideGettingRoots = false;
        }
    }

    @TestOnly
    public static void allowRootAccess(@NotNull Disposable disposable, String ... roots) {
        if (disposable == null) {
            VfsRootAccess.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            VfsRootAccess.$$$reportNull$$$0(3);
        }
        if (roots.length == 0) {
            return;
        }
        VfsRootAccess.doAllow(roots);
        Disposer.register((Disposable)disposable, () -> VfsRootAccess.disallowRootAccess(roots));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doAllow(String ... roots) {
        Set<String> set = ourAdditionalRoots;
        synchronized (set) {
            for (String root : roots) {
                String path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/');
                if (path.isEmpty()) {
                    throw new IllegalArgumentException("Must not pass empty pat but got: '" + Arrays.toString(roots) + "'");
                }
                ourAdditionalRoots.add(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disallowRootAccess(String ... roots) {
        Set<String> set = ourAdditionalRoots;
        synchronized (set) {
            for (String root : roots) {
                ourAdditionalRoots.remove(StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)root), (char)'/'));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsRootAccess";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "assertAccessInTests";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "allowRootAccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static class VfsRootAccessNotAllowedError
    extends AssertionError {
        public VfsRootAccessNotAllowedError(@NotNull VirtualFile child, @NotNull ArrayList<String> allowed) {
            if (child == null) {
                VfsRootAccessNotAllowedError.$$$reportNull$$$0(0);
            }
            if (allowed == null) {
                VfsRootAccessNotAllowedError.$$$reportNull$$$0(1);
            }
            super((Object)("File accessed outside allowed roots: " + String.valueOf(child) + ";\nAllowed roots: " + String.valueOf(new ArrayList<String>(allowed))));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "child";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "allowed";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/vfs/newvfs/impl/VfsRootAccess$VfsRootAccessNotAllowedError";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

