/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.UserDataInterner;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.LineSeparator;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.keyFMap.KeyFMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class VirtualFileImpl
extends VirtualFileSystemEntry {
    private static final Key<byte[]> ourPreloadedContentKey = Key.create((String)"preloaded.content.key");

    VirtualFileImpl(int id2, @NotNull VfsData.Segment segment, VirtualDirectoryImpl parent) {
        if (segment == null) {
            VirtualFileImpl.$$$reportNull$$$0(0);
        }
        super(id2, segment, parent);
        this.registerLink((VirtualFileSystem)this.getFileSystem());
    }

    @Nullable
    public NewVirtualFile findChild(@NotNull @NonNls String name2) {
        if (name2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(1);
        }
        return null;
    }

    public boolean allChildrenLoaded() {
        return true;
    }

    public boolean allChildrenCached() {
        return true;
    }

    @NotNull
    public Collection<VirtualFile> getCachedChildren() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public Iterable<VirtualFile> iterInDbChildren() {
        List<VirtualFile> list2 = Collections.emptyList();
        if (list2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public NewVirtualFileSystem getFileSystem() {
        VirtualDirectoryImpl parent = this.getParent();
        assert (parent != null);
        NewVirtualFileSystem newVirtualFileSystem = parent.getFileSystem();
        if (newVirtualFileSystem == null) {
            VirtualFileImpl.$$$reportNull$$$0(4);
        }
        return newVirtualFileSystem;
    }

    @Nullable
    public NewVirtualFile refreshAndFindChild(@NotNull String name2) {
        if (name2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public NewVirtualFile findChildIfCached(@NotNull String name2) {
        if (name2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(6);
        }
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    public boolean isDirectory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeWithPreloadedContentHint(byte @NotNull [] preloadedContentHint, @NotNull Supplier<? extends T> computable) {
        if (computable == null) {
            VirtualFileImpl.$$$reportNull$$$0(7);
        }
        if (preloadedContentHint == null) {
            VirtualFileImpl.$$$reportNull$$$0(8);
        }
        this.putUserData(ourPreloadedContentKey, preloadedContentHint);
        try {
            T t = computable.get();
            return t;
        }
        finally {
            this.putUserData(ourPreloadedContentKey, null);
        }
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        InputStream inputStream = VfsUtilCore.inputStreamSkippingBOM((InputStream)(preloadedContent == null ? this.owningPersistentFS().getInputStream((VirtualFile)this) : new DataInputStream((InputStream)new UnsyncByteArrayInputStream(preloadedContent))), (VirtualFile)this);
        if (inputStream == null) {
            VirtualFileImpl.$$$reportNull$$$0(9);
        }
        return inputStream;
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        byte[] byArray = this.contentsToByteArray(true);
        if (byArray == null) {
            VirtualFileImpl.$$$reportNull$$$0(10);
        }
        return byArray;
    }

    public byte @NotNull [] contentsToByteArray(boolean cacheContent) throws IOException {
        this.checkNotTooLarge(null);
        byte[] preloadedContent = (byte[])this.getUserData(ourPreloadedContentKey);
        if (preloadedContent != null) {
            if (preloadedContent == null) {
                VirtualFileImpl.$$$reportNull$$$0(11);
            }
            return preloadedContent;
        }
        byte[] bytes = this.owningPersistentFS().contentsToByteArray((VirtualFile)this, cacheContent);
        if (this.isCharsetSet()) {
            if (bytes == null) {
                VirtualFileImpl.$$$reportNull$$$0(12);
            }
            return bytes;
        }
        FileType fileType2 = FileTypeManagerEx.getInstanceEx().getFileTypeByFile((VirtualFile)this, bytes);
        if (fileType2 != UnknownFileType.INSTANCE && !fileType2.isBinary() && bytes.length != 0) {
            try {
                ((ApplicationEx)ApplicationManager.getApplication()).executeByImpatientReader(() -> LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, (byte[])bytes, (FileType)fileType2));
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        if (bytes == null) {
            VirtualFileImpl.$$$reportNull$$$0(13);
        }
        return bytes;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long modStamp, long timeStamp) throws IOException {
        this.checkNotTooLarge(requestor);
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM((OutputStream)this.owningPersistentFS().getOutputStream((VirtualFile)this, requestor, modStamp, timeStamp), (VirtualFile)this);
        if (outputStream == null) {
            VirtualFileImpl.$$$reportNull$$$0(14);
        }
        return outputStream;
    }

    /*
     * WARNING - void declaration
     */
    public void setBinaryContent(byte @NotNull [] content2, long newModificationStamp, long newTimeStamp, Object object) throws IOException {
        void requestor;
        if (content2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(15);
        }
        this.checkNotTooLarge(requestor);
        try (OutputStream outputStream = this.owningPersistentFS().getOutputStream((VirtualFile)this, requestor, newModificationStamp, newTimeStamp);){
            outputStream.write(content2);
        }
    }

    @Nullable
    public String getDetectedLineSeparator() {
        if (this.isDirectory()) {
            throw new IllegalArgumentException("getDetectedLineSeparator() must not be called for a directory");
        }
        if (this.getFlagInt(0x8000000)) {
            return LineSeparator.getSystemLineSeparator().getSeparatorString();
        }
        return super.getDetectedLineSeparator();
    }

    public void setDetectedLineSeparator(String separator) {
        if (this.isDirectory()) {
            throw new IllegalArgumentException("setDetectedLineSeparator() must not be called for a directory");
        }
        boolean hasSystemSeparator = LineSeparator.getSystemLineSeparator().getSeparatorString().equals(separator);
        this.setFlagInt(0x8000000, hasSystemSeparator);
        super.setDetectedLineSeparator(hasSystemSeparator ? null : separator);
    }

    protected void setUserMap(@NotNull KeyFMap map2) {
        if (map2 == null) {
            VirtualFileImpl.$$$reportNull$$$0(16);
        }
        this.getSegment().setUserMap(this.getId(), map2);
    }

    @ApiStatus.Internal
    @NotNull
    public KeyFMap getUserMap() {
        KeyFMap keyFMap = this.getSegment().getUserMap(this, this.getId());
        if (keyFMap == null) {
            VirtualFileImpl.$$$reportNull$$$0(17);
        }
        return keyFMap;
    }

    protected boolean changeUserMap(@NotNull KeyFMap oldMap, @NotNull KeyFMap newMap) {
        if (oldMap == null) {
            VirtualFileImpl.$$$reportNull$$$0(18);
        }
        if (newMap == null) {
            VirtualFileImpl.$$$reportNull$$$0(19);
        }
        VirtualDirectoryImpl.checkLeaks(newMap);
        return this.getSegment().changeUserMap(this.getId(), oldMap, UserDataInterner.internUserData(newMap));
    }

    private void checkNotTooLarge(@Nullable Object requestor) throws FileTooBigException {
        if (!(requestor instanceof LargeFileWriteRequestor) && VirtualFileUtil.isTooLarge((VirtualFile)this)) {
            throw new FileTooBigException(this.getPath());
        }
    }

    public boolean isCaseSensitive() {
        return this.getParent().isCaseSensitive();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 9, 10, 11, 12, 13, 14, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preloadedContentHint";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldMap";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterInDbChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findChild";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindChild";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findChildIfCached";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeWithPreloadedContentHint";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setBinaryContent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setUserMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "changeUserMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 9, 10, 11, 12, 13, 14, 17 -> new IllegalStateException(string);
        };
    }
}

