/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.core.CoreBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.openapi.vfs.impl.local.LocalFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.impl.CachedFileType;
import com.intellij.openapi.vfs.newvfs.impl.VfsData;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.serviceContainer.AlreadyDisposedException;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public abstract class VirtualFileSystemEntry
extends NewVirtualFile {
    public static final VirtualFileSystemEntry[] EMPTY_ARRAY = new VirtualFileSystemEntry[0];
    private static final boolean USE_RECURSIVE_PATH_COMPUTE = SystemProperties.getBooleanProperty((String)"VirtualFileSystemEntry.USE_RECURSIVE_PATH_COMPUTE", (boolean)true);
    private static final boolean TREAT_ALIEN_FILES_AS_INVALID_INSTEAD_OF_CODE_BUG = SystemProperties.getBooleanProperty((String)"VirtualFileSystemEntry.TREAT_ALIEN_FILES_AS_INVALID_INSTEAD_OF_CODE_BUG", (boolean)true);
    private static final int MAX_DEPTH_FOR_RECURSIVE_PATH_COMPUTATION = 64;
    @Flags
    static final int ALL_FLAGS_MASK = -16777216;
    private final int id;
    private volatile VirtualDirectoryImpl parent;
    @NotNull(value="except `NULL_VIRTUAL_FILE`")
    private volatile @NotNull(value="except `NULL_VIRTUAL_FILE`") VfsData.Segment segment;
    private volatile CachedFileType cachedFileType;
    private static final ThreadLocal<ArrayList<String>> parentsNames = ThreadLocal.withInitial(ArrayList::new);
    static final VirtualFileSystemEntry NULL_VIRTUAL_FILE = new VirtualFileSystemEntry(){

        @Override
        public String toString() {
            return "NULL";
        }

        @NotNull
        public NewVirtualFileSystem getFileSystem() {
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile findChild(@NotNull String name2) {
            if (name2 == null) {
                1.$$$reportNull$$$0(0);
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile refreshAndFindChild(@NotNull String name2) {
            if (name2 == null) {
                1.$$$reportNull$$$0(1);
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        public NewVirtualFile findChildIfCached(@NotNull String name2) {
            if (name2 == null) {
                1.$$$reportNull$$$0(2);
            }
            throw new UnsupportedOperationException();
        }

        public boolean allChildrenLoaded() {
            throw new UnsupportedOperationException();
        }

        public boolean allChildrenCached() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Collection<VirtualFile> getCachedChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public Iterable<VirtualFile> iterInDbChildren() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public VirtualFile[] getChildren() {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public InputStream getInputStream() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "name";
            objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findChild";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refreshAndFindChild";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findChildIfCached";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    VirtualFileSystemEntry(int id2, @NotNull VfsData.Segment segment, @Nullable VirtualDirectoryImpl parent) {
        if (segment == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(0);
        }
        if (id2 <= 0) {
            throw new IllegalArgumentException("file id(=" + id2 + ") must be positive");
        }
        this.id = id2;
        this.segment = segment;
        this.parent = parent;
    }

    private VirtualFileSystemEntry() {
        this.segment = null;
        this.parent = null;
        this.id = -42;
    }

    Throwable owningDiscrepancyError(@NotNull VfsData owningVfsData) {
        PersistentFSImpl owningPersistentFS;
        if (owningVfsData == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(1);
        }
        if (!(owningPersistentFS = owningVfsData.owningPersistentFS()).isOwnData(owningVfsData)) {
            if (!owningPersistentFS.isConnected()) {
                return new AlreadyDisposedException("VFS is disconnected, all it's files are invalid now");
            }
            return new AssertionError((Object)("'Alien' file object: was created before PersistentFS (re-)connected (id=" + this.id + ", parent=" + String.valueOf((Object)this.parent) + ")"));
        }
        return null;
    }

    VfsData getVfsData() {
        VfsData owningVfsData = this.segment.owningVfsData();
        Throwable error2 = this.owningDiscrepancyError(owningVfsData);
        if (error2 != null) {
            ExceptionUtil.rethrowUnchecked((Throwable)error2);
        }
        return owningVfsData;
    }

    PersistentFSImpl owningPersistentFS() {
        return this.getVfsData().owningPersistentFS();
    }

    @NotNull
    VfsData.Segment getSegment() {
        VfsData.Segment segment = this.segment;
        if (segment.replacement != null) {
            segment = this.updateSegmentAndParent(segment);
        }
        VfsData.Segment segment2 = segment;
        if (segment2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(2);
        }
        return segment2;
    }

    @NotNull
    private VfsData.Segment updateSegmentAndParent(@NotNull VfsData.Segment segment) {
        if (segment == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(3);
        }
        while (segment.replacement != null) {
            segment = segment.replacement;
        }
        VirtualDirectoryImpl changedParent = segment.owningVfsData().getChangedParent(this.id);
        if (changedParent != null) {
            this.parent = changedParent;
        }
        this.segment = segment;
        VfsData.Segment segment2 = segment;
        if (segment2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(4);
        }
        return segment2;
    }

    void registerLink(@NotNull VirtualFileSystem fs) {
        if (fs == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(5);
        }
        if (fs instanceof LocalFileSystemImpl && this.isSymlink() && this.isValid()) {
            ((LocalFileSystemImpl)fs).symlinkUpdated(this.id, (VirtualFile)this.parent, this.getNameSequence(), this.getPath(), this.getCanonicalPath());
        }
    }

    void updateLinkStatus(@NotNull VirtualFileSystemEntry parent) {
        if (parent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(6);
        }
        this.setFlagInt(0x40000000, parent.thisOrParentHaveSymlink());
        this.registerLink((VirtualFileSystem)this.getFileSystem());
    }

    @NotNull
    public String getName() {
        PersistentFSImpl pfs = this.owningPersistentFS();
        if (pfs == null) {
            return "<FS-is-disposed>";
        }
        String string = pfs.getName(this.id);
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public CharSequence getNameSequence() {
        String string = this.getName();
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(8);
        }
        return string;
    }

    public final int getNameId() {
        return this.owningPersistentFS().peer().getNameIdByFileId(this.id);
    }

    public VirtualDirectoryImpl getParent() {
        VfsData.Segment segment = this.segment;
        if (segment.replacement != null) {
            this.updateSegmentAndParent(segment);
        }
        return this.parent;
    }

    public boolean isDirty() {
        return this.getFlagInt(0x10000000) && !this.getFlagInt(0x4000000);
    }

    public boolean isOffline() {
        for (VirtualFileSystemEntry v = this; v != null; v = v.getParent()) {
            if (!v.getFlagInt(0x4000000)) continue;
            return true;
        }
        return false;
    }

    public void setOffline(boolean offline) {
        boolean wasOffline = this.isOffline();
        this.setFlagInt(0x4000000, offline);
        if (wasOffline && !this.isOffline()) {
            this.markDirtyRecursively();
        }
    }

    public long getModificationStamp() {
        return this.isValid() ? this.getSegment().getModificationStamp(this.id) : -1L;
    }

    public void setModificationStamp(long modificationStamp) {
        this.getSegment().setModificationStamp(this.id, modificationStamp);
    }

    boolean getFlagInt(@Flags int mask) {
        return this.getSegment().getFlag(this.id, mask);
    }

    void setFlagInt(@Flags int mask, boolean value) {
        this.getSegment().setFlag(this.id, mask, value);
    }

    public void markClean() {
        this.setFlagInt(0x10000000, false);
    }

    public void markDirty() {
        if (!this.isDirty()) {
            this.markDirtyInternal();
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                parent.markDirty();
            }
        }
    }

    void markDirtyInternal() {
        this.setFlagInt(0x10000000, true);
    }

    public void markDirtyRecursively() {
        this.markDirty();
        for (VirtualFile file2 : this.getCachedChildren()) {
            ((NewVirtualFile)file2).markDirtyRecursively();
        }
    }

    @NotNull
    private String computePath(@NotNull String protocol, @NotNull String protoSeparator) {
        if (protocol == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(9);
        }
        if (protoSeparator == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(10);
        }
        if (USE_RECURSIVE_PATH_COMPUTE) {
            String string = VirtualFileSystemEntry.computePathRecursively((VirtualFile)this, protocol, protoSeparator).toString();
            if (string == null) {
                VirtualFileSystemEntry.$$$reportNull$$$0(11);
            }
            return string;
        }
        return VirtualFileSystemEntry.computePathIteratively(this, protocol, protoSeparator);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static StringBuilder computePathRecursively(@NotNull VirtualFile file2, @NotNull String protocol, @NotNull String protoSeparator) {
        if (file2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(12);
        }
        if (protocol == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(13);
        }
        if (protoSeparator == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(14);
        }
        return VirtualFileSystemEntry.computePathRecursively((VirtualFileSystemEntry)file2, protocol, protoSeparator, 0, 0);
    }

    @NotNull
    private static StringBuilder computePathRecursively(@NotNull VirtualFileSystemEntry file2, @NotNull String protocol, @NotNull String protoSeparator, int requiredBufferSize, int depth) {
        if (file2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(15);
        }
        if (protocol == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(16);
        }
        if (protoSeparator == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(17);
        }
        if (depth > 64) {
            String pathPrefix = VirtualFileSystemEntry.computePathIteratively(file2, protocol, protoSeparator);
            StringBuilder pathBuilder = new StringBuilder(pathPrefix.length() + 1 + requiredBufferSize).append(pathPrefix);
            if (!pathPrefix.endsWith("/")) {
                pathBuilder.append('/');
            }
            StringBuilder stringBuilder = pathBuilder;
            if (stringBuilder == null) {
                VirtualFileSystemEntry.$$$reportNull$$$0(18);
            }
            return stringBuilder;
        }
        VirtualDirectoryImpl parent = file2.getParent();
        if (parent == null) {
            String rootPath = file2.getPath();
            StringBuilder stringBuilder = new StringBuilder(protocol.length() + protoSeparator.length() + rootPath.length() + requiredBufferSize).append(protocol).append(protoSeparator).append(rootPath);
            if (stringBuilder == null) {
                VirtualFileSystemEntry.$$$reportNull$$$0(19);
            }
            return stringBuilder;
        }
        String fileName = file2.getName();
        StringBuilder pathBuilder = VirtualFileSystemEntry.computePathRecursively(parent, protocol, protoSeparator, requiredBufferSize + fileName.length() + 1, depth + 1);
        pathBuilder.append(fileName);
        if (requiredBufferSize > 0) {
            pathBuilder.append('/');
        }
        StringBuilder stringBuilder = pathBuilder;
        if (stringBuilder == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(20);
        }
        return stringBuilder;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public static String computePathIteratively(@NotNull VirtualFileSystemEntry file2, @NotNull String protocol, @NotNull String protoSeparator) {
        VirtualDirectoryImpl parent;
        if (file2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(21);
        }
        if (protocol == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(22);
        }
        if (protoSeparator == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(23);
        }
        VirtualFileSystemEntry v = file2;
        int length = 0;
        List names = parentsNames.get();
        while ((parent = v.getParent()) != null) {
            String name2 = v.getName();
            names.add(name2);
            length = length != 0 ? (length += name2.length() + 1) : (length += name2.length());
            v = parent;
        }
        String rootPath = v.getPath();
        StringBuilder pathBuilder = new StringBuilder(protocol.length() + protoSeparator.length() + rootPath.length() + length).append(protocol).append(protoSeparator).append(rootPath);
        for (int i2 = names.size() - 1; i2 >= 1; --i2) {
            String name3 = (String)names.get(i2);
            pathBuilder.append(name3).append('/');
        }
        if (!names.isEmpty()) {
            String name4 = (String)names.get(0);
            pathBuilder.append(name4);
        }
        names.clear();
        String string = pathBuilder.toString();
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    public String getUrl() {
        return this.computePath(this.getFileSystem().getProtocol(), "://");
    }

    @NotNull
    public String getPath() {
        return this.computePath("", "");
    }

    public void delete(Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.owningPersistentFS().deleteFile(requestor, (VirtualFile)this);
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        if (newName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(25);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getName().equals(newName)) {
            return;
        }
        this.validateName(newName);
        this.owningPersistentFS().renameFile(requestor, (VirtualFile)this, newName);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name2) throws IOException {
        if (name2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(26);
        }
        this.validateName(name2);
        VirtualFile virtualFile2 = this.owningPersistentFS().createChildFile(requestor, (VirtualFile)this, name2);
        if (virtualFile2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(27);
        }
        return virtualFile2;
    }

    public boolean isWritable() {
        return this.getFlagInt(0x1000000);
    }

    public void setWritable(boolean writable) throws IOException {
        this.owningPersistentFS().setWritable((VirtualFile)this, writable);
    }

    public long getTimeStamp() {
        return this.owningPersistentFS().getTimeStamp((VirtualFile)this);
    }

    public void setTimeStamp(long time) throws IOException {
        this.owningPersistentFS().setTimeStamp((VirtualFile)this, time);
    }

    public long getLength() {
        return this.owningPersistentFS().getLength((VirtualFile)this);
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(28);
        }
        if (copyName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(29);
        }
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message((String)"file.copy.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(CoreBundle.message((String)"file.copy.target.must.be.directory", (Object[])new Object[0]));
        }
        VirtualFile virtualFile2 = EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> this.owningPersistentFS().copyFile(requestor, (VirtualFile)this, newParent, copyName));
        if (virtualFile2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(30);
        }
        return virtualFile2;
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        if (newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message((String)"file.move.error", (Object[])new Object[]{newParent.getPresentableUrl()}));
        }
        EncodingRegistry.doActionAndRestoreEncoding((VirtualFile)this, () -> {
            this.owningPersistentFS().moveFile(requestor, (VirtualFile)this, newParent);
            return this;
        });
    }

    public int getId() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFileWithId)) {
            return false;
        }
        return ((VirtualFileWithId)o).getId() == this.id;
    }

    public final int hashCode() {
        return this.id;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name2) throws IOException {
        if (name2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(32);
        }
        this.validateName(name2);
        VirtualFile virtualFile2 = this.owningPersistentFS().createChildDirectory(requestor, (VirtualFile)this, name2);
        if (virtualFile2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(33);
        }
        return virtualFile2;
    }

    private void validateName(@NotNull String name2) throws IOException {
        if (name2 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(34);
        }
        if (!this.getFileSystem().isValidName(name2)) {
            throw new IOException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{name2}));
        }
    }

    public final boolean exists() {
        return this.getVfsData().isFileValid(this.id);
    }

    public final boolean isValid() {
        if (!TREAT_ALIEN_FILES_AS_INVALID_INSTEAD_OF_CODE_BUG) {
            return this.exists();
        }
        VfsData owningVfsData = this.getVfsData();
        Throwable error2 = this.owningDiscrepancyError(owningVfsData);
        if (error2 != null) {
            Logger.getInstance(VirtualFileSystemEntry.class).warn(error2);
        }
        return error2 == null && owningVfsData.isFileValid(this.id);
    }

    @NonNls
    public String toString() {
        VfsData owningVfsData = this.segment.owningVfsData();
        Throwable error2 = this.owningDiscrepancyError(owningVfsData);
        if (error2 != null) {
            return error2.getMessage();
        }
        if (this.exists()) {
            return this.getUrl();
        }
        String reason = InvalidVirtualFileAccessException.getInvalidationReason((VirtualFile)this);
        return this.getUrl() + " (invalid" + (String)(reason == null ? "" : ", reason: " + reason) + ")";
    }

    public void setNewName(@NotNull String newName) {
        if (newName == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(35);
        }
        if (!this.getFileSystem().isValidName(newName)) {
            throw new IllegalArgumentException(CoreBundle.message((String)"file.invalid.name.error", (Object[])new Object[]{newName}));
        }
        PersistentFSImpl pfs = this.owningPersistentFS();
        VirtualDirectoryImpl parent = this.getParent();
        parent.removeChild(this);
        pfs.peer().setName(this.id, newName);
        parent.addChild(this);
        pfs.incStructuralModificationCount();
    }

    public void setParent(@NotNull VirtualFile _newParent) {
        if (_newParent == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(36);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualDirectoryImpl newParent = (VirtualDirectoryImpl)_newParent;
        VirtualDirectoryImpl oldParent = this.getParent();
        VirtualDirectoryImpl.runUnderAllLocksAcquired(() -> {
            oldParent.removeChild(this);
            this.getSegment().changeParent(this.id, newParent);
            newParent.addChild(this);
            return null;
        }, oldParent, newParent);
        this.updateLinkStatus(newParent);
        this.owningPersistentFS().incStructuralModificationCount();
    }

    public boolean isInLocalFileSystem() {
        return this.getFileSystem() instanceof LocalFileSystem;
    }

    @ApiStatus.Internal
    public void invalidate(@NotNull Object source, @NotNull Object reason) {
        if (source == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(37);
        }
        if (reason == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(38);
        }
        this.getVfsData().invalidateFile(this.id);
        this.appendInvalidationReason(source, reason);
    }

    @ApiStatus.Internal
    public void appendInvalidationReason(@NotNull Object source, @NotNull Object reason) {
        if (source == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(39);
        }
        if (reason == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(40);
        }
        if (DebugInvalidation.DEBUG && !ApplicationManagerEx.isInStressTest()) {
            InvalidVirtualFileAccessException.appendInvalidationReason((VirtualFile)this, (String)(String.valueOf(source) + ": " + String.valueOf(reason)));
        }
    }

    @NotNull
    public Charset getCharset() {
        return this.isCharsetSet() ? super.getCharset() : this.computeCharset();
    }

    @NotNull
    private Charset computeCharset() {
        Charset charset;
        if (this.isDirectory()) {
            Charset configured = EncodingManager.getInstance().getEncoding((VirtualFile)this, true);
            charset = configured == null ? Charset.defaultCharset() : configured;
            this.setCharset(charset);
        } else {
            byte[] content2;
            FileType fileType2;
            block10: {
                Charset charset2;
                fileType2 = this.getFileType();
                if (this.isCharsetSet()) {
                    Charset charset3 = super.getCharset();
                    if (charset3 == null) {
                        VirtualFileSystemEntry.$$$reportNull$$$0(41);
                    }
                    return charset3;
                }
                try {
                    content2 = VfsUtilCore.loadBytes((VirtualFile)this);
                    if (!this.isCharsetSet()) break block10;
                    charset2 = super.getCharset();
                }
                catch (IOException e) {
                    Charset charset4 = super.getCharset();
                    if (charset4 == null) {
                        VirtualFileSystemEntry.$$$reportNull$$$0(43);
                    }
                    return charset4;
                }
                if (charset2 == null) {
                    VirtualFileSystemEntry.$$$reportNull$$$0(42);
                }
                return charset2;
            }
            charset = LoadTextUtil.detectCharsetAndSetBOM((VirtualFile)this, (byte[])content2, (FileType)fileType2);
        }
        Charset charset5 = charset;
        if (charset5 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(44);
        }
        return charset5;
    }

    @NotNull
    public String getPresentableName() {
        if (UISettings.getInstance().getHideKnownExtensionInTabs() && !this.isDirectory()) {
            String nameWithoutExtension = this.getNameWithoutExtension();
            String string = nameWithoutExtension.isEmpty() ? this.getName() : nameWithoutExtension;
            if (string == null) {
                VirtualFileSystemEntry.$$$reportNull$$$0(45);
            }
            return string;
        }
        String string = this.getName();
        if (string == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(46);
        }
        return string;
    }

    public boolean is(@NotNull VFileProperty property) {
        if (property == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(47);
        }
        if (property == VFileProperty.SPECIAL) {
            return !this.isDirectory() && this.isSpecial();
        }
        if (property == VFileProperty.HIDDEN) {
            return this.getFlagInt(0x2000000);
        }
        if (property == VFileProperty.SYMLINK) {
            return this.isSymlink();
        }
        throw new IllegalArgumentException("unknown property: " + String.valueOf(property));
    }

    private boolean isSymlink() {
        return this.getFlagInt(0x20000000);
    }

    private boolean isSpecial() {
        return !this.isDirectory() && this.getFlagInt(Integer.MIN_VALUE);
    }

    @ApiStatus.Internal
    public boolean thisOrParentHaveSymlink() {
        return this.isSymlink() || this.getFlagInt(0x40000000);
    }

    @ApiStatus.Internal
    public void setWritableFlag(boolean value) {
        this.setFlagInt(0x1000000, value);
    }

    @ApiStatus.Internal
    public void setHiddenFlag(boolean value) {
        this.setFlagInt(0x2000000, value);
    }

    public String getCanonicalPath() {
        if (this.thisOrParentHaveSymlink()) {
            if (this.isSymlink()) {
                return this.owningPersistentFS().resolveSymLink((VirtualFile)this);
            }
            VirtualDirectoryImpl parent = this.getParent();
            if (parent != null) {
                return parent.getCanonicalPath() + "/" + this.getName();
            }
            return this.getName();
        }
        return this.getPath();
    }

    public NewVirtualFile getCanonicalFile() {
        if (this.thisOrParentHaveSymlink()) {
            String path = this.getCanonicalPath();
            return path != null ? (NewVirtualFile)this.getFileSystem().findFileByPath(path) : null;
        }
        return this;
    }

    public boolean isRecursiveOrCircularSymlink() {
        if (!this.isSymlink()) {
            return false;
        }
        NewVirtualFile resolved = this.getCanonicalFile();
        if (resolved == null) {
            return false;
        }
        if (VfsUtilCore.isAncestor((VirtualFile)resolved, (VirtualFile)this, (boolean)false)) {
            return true;
        }
        for (VirtualDirectoryImpl p = this.getParent(); p != null; p = p.getParent()) {
            NewVirtualFile parentResolved;
            if (!p.thisOrParentHaveSymlink()) {
                return false;
            }
            if (!p.isSymlink() || !resolved.equals(parentResolved = p.getCanonicalFile())) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final FileType getFileType() {
        FileType type;
        CachedFileType cache2 = this.cachedFileType;
        FileType fileType2 = type = cache2 == null ? null : cache2.getUpToDateOrNull();
        if (type == null) {
            type = super.getFileType();
            this.cachedFileType = CachedFileType.forType(type);
        }
        FileType fileType3 = type;
        if (fileType3 == null) {
            VirtualFileSystemEntry.$$$reportNull$$$0(48);
        }
        return fileType3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 7, 8, 11, 18, 19, 20, 24, 27, 30, 33, 41, 42, 43, 44, 45, 46, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owningVfsData";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 10: 
            case 14: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protoSeparator";
                break;
            }
            case 12: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 25: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 26: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_newParent";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSegment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "updateSegmentAndParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameSequence";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computePathRecursively";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "computePathIteratively";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildData";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCharset";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "owningDiscrepancyError";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 27: 
            case 30: 
            case 33: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 48: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateSegmentAndParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerLink";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateLinkStatus";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computePath";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computePathRecursively";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "computePathIteratively";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "validateName";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setNewName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "appendInvalidationReason";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "is";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 7, 8, 11, 18, 19, 20, 24, 27, 30, 33, 41, 42, 43, 44, 45, 46, 48 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    static final class VfsDataFlags {
        static final int IS_WRITABLE_FLAG = 0x1000000;
        static final int IS_HIDDEN_FLAG = 0x2000000;
        static final int IS_OFFLINE = 0x4000000;
        static final int SYSTEM_LINE_SEPARATOR_DETECTED = 0x8000000;
        static final int CHILDREN_CASE_SENSITIVITY_CACHED = 0x8000000;
        private static final int DIRTY_FLAG = 0x10000000;
        static final int IS_SYMLINK_FLAG = 0x20000000;
        static final int STRICT_PARENT_HAS_SYMLINK_FLAG = 0x40000000;
        static final int CHILDREN_CASE_SENSITIVE = Integer.MIN_VALUE;
        static final int IS_SPECIAL_FLAG = Integer.MIN_VALUE;

        VfsDataFlags() {
        }

        @Flags
        static int toFlags(@PersistentFS.Attributes int attributes, boolean isDirectory) {
            FileAttributes.CaseSensitivity sensitivity = isDirectory ? PersistentFS.areChildrenCaseSensitive(attributes) : FileAttributes.CaseSensitivity.UNKNOWN;
            return (PersistentFS.isWritable(attributes) ? 0x1000000 : 0) | (PersistentFS.isHidden(attributes) ? 0x2000000 : 0) | (PersistentFS.isOfflineByDefault(attributes) ? 0x4000000 : 0) | (sensitivity.isKnown() ? 0x8000000 : 0) | (PersistentFS.isSymLink(attributes) ? 0x20000000 : 0) | (sensitivity.isSensitive() ? Integer.MIN_VALUE : 0) | (PersistentFS.isSpecialFile(attributes) ? Integer.MIN_VALUE : 0);
        }

        @Flags
        static int toFlags(@NotNull FileAttributes attributes, boolean isOfflineByDefault) {
            if (attributes == null) {
                VfsDataFlags.$$$reportNull$$$0(0);
            }
            FileAttributes.CaseSensitivity sensitivity = attributes.areChildrenCaseSensitive();
            return (attributes.isWritable() ? 0x1000000 : 0) | (attributes.isHidden() ? 0x2000000 : 0) | (isOfflineByDefault ? 0x4000000 : 0) | (sensitivity.isKnown() ? 0x8000000 : 0) | (attributes.isSymLink() ? 0x20000000 : 0) | (sensitivity.isSensitive() ? Integer.MIN_VALUE : 0) | (attributes.isSpecial() ? Integer.MIN_VALUE : 0);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/openapi/vfs/newvfs/impl/VirtualFileSystemEntry$VfsDataFlags", "toFlags"));
        }
    }

    private static final class DebugInvalidation {
        private static final Logger LOG = Logger.getInstance(VirtualFileSystemEntry.class);
        private static final boolean DEBUG = LOG.isDebugEnabled();

        private DebugInvalidation() {
        }
    }

    static @interface Flags {
    }
}

