/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSLoader;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSPaths;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFsConnectorHelper;
import com.intellij.openapi.vfs.newvfs.persistent.VFSAsyncTaskExecutor;
import com.intellij.openapi.vfs.newvfs.persistent.VFSInitException;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.ContentStoragesRecoverer;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.NotClosedProperlyRecoverer;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSInitializationResult;
import com.intellij.openapi.vfs.newvfs.persistent.recovery.VFSRecoverer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.StorageAlreadyInUseException;
import com.intellij.util.io.VersionUpdatedException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class PersistentFSConnector {
    private static final Logger LOG = Logger.getInstance(PersistentFSConnector.class);
    private static final int MAX_INITIALIZATION_ATTEMPTS = SystemProperties.getIntProperty((String)"vfs.max-initialization-attempts", (int)3);
    public static final List<VFSRecoverer> RECOVERERS = List.of(new NotClosedProperlyRecoverer(), new ContentStoragesRecoverer());

    @NotNull
    public static VFSInitializationResult connect(@NotNull Path cachesDir, int version) {
        if (cachesDir == null) {
            PersistentFSConnector.$$$reportNull$$$0(0);
        }
        return PersistentFSConnector.init(cachesDir, version);
    }

    @NotNull
    private static VFSInitializationResult init(@NotNull Path cachesDir, int expectedVersion) {
        if (cachesDir == null) {
            PersistentFSConnector.$$$reportNull$$$0(1);
        }
        ArrayList<Throwable> attemptsFailures = new ArrayList<Throwable>();
        long initializationStartedNs = System.nanoTime();
        for (int attempt = 0; attempt < MAX_INITIALIZATION_ATTEMPTS; ++attempt) {
            try {
                PersistentFSConnection connection = PersistentFSConnector.tryInit(cachesDir, expectedVersion, RECOVERERS);
                boolean justCreated = connection.records().recordsCount() == 1 && connection.isDirty();
                return new VFSInitializationResult(connection, justCreated, attemptsFailures, System.nanoTime() - initializationStartedNs);
            }
            catch (CancellationException e) {
                LOG.info("VFS initialization was canceled. The application was likely disposed early.");
                throw e;
            }
            catch (Exception e) {
                LOG.info("Init VFS attempt #" + attempt + " failed: " + e.getMessage());
                attemptsFailures.add(e);
                continue;
            }
        }
        RuntimeException fail = new RuntimeException("VFS can't be initialized (" + MAX_INITIALIZATION_ATTEMPTS + " attempts failed)");
        for (Throwable failure : attemptsFailures) {
            fail.addSuppressed(failure);
        }
        throw fail;
    }

    @VisibleForTesting
    @NotNull
    public static PersistentFSConnection tryInit(@NotNull Path cachesDir, int currentImplVersion, @NotNull List<VFSRecoverer> recoverers) throws IOException {
        PersistentFSConnection persistentFSConnection;
        if (cachesDir == null) {
            PersistentFSConnector.$$$reportNull$$$0(2);
        }
        if (recoverers == null) {
            PersistentFSConnector.$$$reportNull$$$0(3);
        }
        Path basePath = cachesDir.toAbsolutePath();
        Files.createDirectories(basePath, new FileAttribute[0]);
        VFSAsyncTaskExecutor asyncExecutor = PersistentFsConnectorHelper.INSTANCE.executor();
        PersistentFSPaths persistentFSPaths = new PersistentFSPaths(cachesDir);
        PersistentFSLoader vfsLoader = new PersistentFSLoader(persistentFSPaths, asyncExecutor);
        try {
            PersistentFSConnection connection;
            vfsLoader.failIfCorruptionMarkerPresent();
            vfsLoader.initializeStorages();
            vfsLoader.ensureStoragesVersionsAreConsistent(currentImplVersion);
            boolean needInitialization = vfsLoader.isJustCreated();
            if (needInitialization) {
                int rootRecordId = vfsLoader.recordsStorage().allocateRecord();
                if (rootRecordId != 1) {
                    throw new AssertionError((Object)("First record created must have id=1 but " + rootRecordId + " got instead"));
                }
            } else {
                vfsLoader.selfCheck();
                if (!vfsLoader.problemsDuringLoad().isEmpty()) {
                    for (VFSRecoverer recoverer : recoverers) {
                        recoverer.tryRecover(vfsLoader);
                    }
                    List<VFSInitException> problemsNotRecovered = vfsLoader.problemsDuringLoad();
                    if (!problemsNotRecovered.isEmpty()) {
                        VFSInitException mainEx = problemsNotRecovered.get(0);
                        for (int i2 = 1; i2 < problemsNotRecovered.size(); ++i2) {
                            mainEx.addSuppressed(problemsNotRecovered.get(i2));
                        }
                        throw mainEx;
                    }
                }
            }
            persistentFSConnection = connection = vfsLoader.createConnection();
        }
        catch (Throwable e) {
            String errorMessage = ExceptionUtil.getNonEmptyMessage((Throwable)e, (String)"<unrecognized>");
            LOG.warn("Filesystem storage is corrupted or does not exist. [Re]Building. Reason: " + errorMessage);
            try {
                vfsLoader.closeEverything();
                List storageAlreadyInUseExceptions = ExceptionUtil.findCauseAndSuppressed((Throwable)e, StorageAlreadyInUseException.class);
                if (!storageAlreadyInUseExceptions.isEmpty()) {
                    throw new IOException("Some of VFS storages are already in use: is an IDE process already running?", e);
                }
                vfsLoader.deleteEverything();
            }
            catch (IOException cleanEx) {
                e.addSuppressed(cleanEx);
                LOG.warn("Cannot clean filesystem storage", (Throwable)cleanEx);
            }
            List vfsNeedsRebuildExceptions = ExceptionUtil.findCauseAndSuppressed((Throwable)e, VFSInitException.class);
            if (!vfsNeedsRebuildExceptions.isEmpty()) {
                VFSInitException mainEx = (VFSInitException)vfsNeedsRebuildExceptions.get(0);
                for (VFSInitException suppressed : vfsNeedsRebuildExceptions.subList(1, vfsNeedsRebuildExceptions.size())) {
                    mainEx.addSuppressed(suppressed);
                }
                throw mainEx;
            }
            if (!ExceptionUtil.findCauseAndSuppressed((Throwable)e, VersionUpdatedException.class).isEmpty()) {
                throw new VFSInitException(VFSInitException.ErrorCategory.IMPL_VERSION_MISMATCH, "Some of storages versions were changed", e);
            }
            if (!ExceptionUtil.findCauseAndSuppressed((Throwable)e, CorruptedException.class).isEmpty()) {
                throw new VFSInitException(VFSInitException.ErrorCategory.NOT_CLOSED_PROPERLY, "Some of storages were corrupted", e);
            }
            throw new VFSInitException(VFSInitException.ErrorCategory.UNRECOGNIZED, "VFS init failure of unrecognized category: " + errorMessage, e);
        }
        if (persistentFSConnection == null) {
            PersistentFSConnector.$$$reportNull$$$0(4);
        }
        return persistentFSConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachesDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recoverers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSConnector";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tryInit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "tryInit";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

