/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent.namecache;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.persistent.namecache.FileNameCache;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.util.IntSLRUCache;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.IntObjectLRUMap;
import com.intellij.util.io.DataEnumeratorEx;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class SLRUFileNameCache
implements FileNameCache {
    private static final boolean TRACK_STATS = SystemProperties.getBooleanProperty((String)"vfs.name-cache.track-stats", (boolean)true);
    private static final int PROTECTED_SEGMENTS_TOTAL_SIZE = 40000;
    private static final int PROBATION_SEGMENTS_TOTAL_SIZE = 20000;
    private static final int MRU_CACHE_SIZE = 1024;
    private final IntSLRUCache<String>[] cacheSegments;
    private final IntObjectLRUMap.MapEntry<String>[] mruCache;
    @NotNull
    private final DataEnumeratorEx<String> namesEnumerator;
    private final boolean checkFileNamesSanity;
    private final AtomicInteger requestsCount;
    private final AtomicInteger fastCacheMissesCount;
    private final AtomicInteger totalCacheMissesCount;
    @Nullable
    private final AutoCloseable otelHandlerToClose;
    private static final String FS_SEPARATORS = "/" + String.valueOf(File.separatorChar == '/' ? "" : Character.valueOf(File.separatorChar));

    public SLRUFileNameCache(@NotNull DataEnumeratorEx<String> namesEnumerator) {
        if (namesEnumerator == null) {
            SLRUFileNameCache.$$$reportNull$$$0(0);
        }
        this(namesEnumerator, SLRUFileNameCache.isFileNameSanityCheckEnabledByDefault());
    }

    public SLRUFileNameCache(@NotNull DataEnumeratorEx<String> namesEnumerator, boolean checkFileNamesSanity) {
        if (namesEnumerator == null) {
            SLRUFileNameCache.$$$reportNull$$$0(1);
        }
        this.cacheSegments = new IntSLRUCache[16];
        this.mruCache = new IntObjectLRUMap.MapEntry[1024];
        this.requestsCount = new AtomicInteger();
        this.fastCacheMissesCount = new AtomicInteger();
        this.totalCacheMissesCount = new AtomicInteger();
        this.namesEnumerator = namesEnumerator;
        int protectedSize = 40000 / this.cacheSegments.length;
        int probationalSize = 20000 / this.cacheSegments.length;
        for (int i2 = 0; i2 < this.cacheSegments.length; ++i2) {
            this.cacheSegments[i2] = new IntSLRUCache(protectedSize, probationalSize);
        }
        this.checkFileNamesSanity = checkFileNamesSanity;
        this.otelHandlerToClose = TRACK_STATS ? this.setupReportingToOpenTelemetry() : null;
    }

    @Override
    public int tryEnumerate(@NotNull String name2) throws IOException {
        int nameId;
        if (name2 == null) {
            SLRUFileNameCache.$$$reportNull$$$0(2);
        }
        if ((nameId = this.namesEnumerator.tryEnumerate((Object)name2)) != 0) {
            this.cacheData(name2, nameId, this.calcStripeIdFromNameId(nameId));
        }
        return nameId;
    }

    @Override
    public int enumerate(@NotNull String name2) throws IOException {
        if (name2 == null) {
            SLRUFileNameCache.$$$reportNull$$$0(3);
        }
        if (this.checkFileNamesSanity) {
            SLRUFileNameCache.assertShortFileName(name2);
        }
        int nameId = this.namesEnumerator.enumerate((Object)name2);
        this.cacheData(name2, nameId, this.calcStripeIdFromNameId(nameId));
        return nameId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String valueOf(int nameId) throws IOException {
        IntSLRUCache<String> cache2;
        int mruCacheEntryIndex;
        IntObjectLRUMap.MapEntry<String> entry;
        assert (nameId > 0) : nameId;
        if (TRACK_STATS) {
            this.requestsCount.incrementAndGet();
        }
        if ((entry = this.mruCache[mruCacheEntryIndex = nameId % 1024]) != null && entry.key == nameId) {
            String string = (String)entry.value;
            if (string == null) {
                SLRUFileNameCache.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (TRACK_STATS) {
            this.fastCacheMissesCount.incrementAndGet();
        }
        int stripe = this.calcStripeIdFromNameId(nameId);
        IntSLRUCache<String> intSLRUCache = cache2 = this.cacheSegments[stripe];
        synchronized (intSLRUCache) {
            entry = cache2.getCachedEntry(nameId);
        }
        if (entry == null) {
            String name2;
            if (TRACK_STATS) {
                this.totalCacheMissesCount.incrementAndGet();
            }
            if ((name2 = (String)this.namesEnumerator.valueOf(nameId)) == null) {
                throw new IOException("VFS name enumerator corrupted: nameId(=" + nameId + ") is not found in enumerator (=null)");
            }
            entry = this.cacheData(name2, nameId, stripe);
        }
        this.mruCache[mruCacheEntryIndex] = entry;
        String string = (String)entry.value;
        if (string == null) {
            SLRUFileNameCache.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public void close() throws Exception {
        if (this.otelHandlerToClose != null) {
            this.otelHandlerToClose.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private IntObjectLRUMap.MapEntry<String> cacheData(@Nullable String name2, int nameId, int stripe) {
        IntSLRUCache<String> cache2;
        IntSLRUCache<String> intSLRUCache = cache2 = this.cacheSegments[stripe];
        // MONITORENTER : intSLRUCache
        IntObjectLRUMap.MapEntry mapEntry = cache2.cacheEntry(nameId, (Object)name2);
        // MONITOREXIT : intSLRUCache
        if (mapEntry != null) return mapEntry;
        SLRUFileNameCache.$$$reportNull$$$0(6);
        return mapEntry;
    }

    private int calcStripeIdFromNameId(int id2) {
        int h = id2;
        h -= h << 6;
        h ^= h >> 17;
        h -= h << 9;
        h ^= h << 4;
        h -= h << 3;
        h ^= h << 10;
        h ^= h >> 15;
        return h % this.cacheSegments.length;
    }

    @VisibleForTesting
    public static void assertShortFileName(@NotNull String name2) throws IllegalArgumentException {
        if (name2 == null) {
            SLRUFileNameCache.$$$reportNull$$$0(7);
        }
        if (name2.length() <= 1) {
            return;
        }
        int start2 = 0;
        int end = name2.length();
        if (SystemInfo.isWindows && name2.startsWith("//")) {
            int idx = name2.indexOf(47, 2);
            start2 = idx == -1 ? 2 : idx + 1;
        } else if (name2.charAt(0) == '/') {
            start2 = 1;
        }
        if (name2.endsWith("://")) {
            end -= "://".length();
        }
        if (StringUtil.containsAnyChar((String)name2, (String)FS_SEPARATORS, (int)start2, (int)end)) {
            throw new IllegalArgumentException("Must not intern long path: '" + name2 + "'");
        }
    }

    static boolean isFileNameSanityCheckEnabledByDefault() {
        boolean enabled2 = ApplicationManagerEx.isInIntegrationTest();
        Application app = ApplicationManager.getApplication();
        if (app != null) {
            enabled2 = app.isUnitTestMode() || app.isEAP() || app.isInternal();
        }
        return SystemProperties.getBooleanProperty((String)"vfs.name-cache.check-names", (boolean)enabled2);
    }

    private AutoCloseable setupReportingToOpenTelemetry() {
        Meter meter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.VFS);
        ObservableLongMeasurement queriesCounter = meter.counterBuilder("FileNameCache.queries").buildObserver();
        ObservableLongMeasurement fastMissesCounter = meter.counterBuilder("FileNameCache.fastMisses").buildObserver();
        ObservableLongMeasurement totalMissesCounter = meter.counterBuilder("FileNameCache.totalMisses").buildObserver();
        return meter.batchCallback(() -> {
            queriesCounter.record(this.requestsCount.longValue());
            fastMissesCounter.record(this.fastCacheMissesCount.longValue());
            totalMissesCounter.record(this.totalCacheMissesCount.longValue());
        }, (ObservableMeasurement)queriesCounter, new ObservableMeasurement[]{fastMissesCounter, totalMissesCounter});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesEnumerator";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/namecache/SLRUFileNameCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/namecache/SLRUFileNameCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "valueOf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryEnumerate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enumerate";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertShortFileName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

