/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomWindowHeaderUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.WindowResizeListenerEx;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u001a\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a&\u0010\u0014\u001a\u00020\u00072\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001a"}, d2={"INIT_BOUNDS_KEY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "updateFullScreenState", "", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "isFullScreen", "", "isTemporaryDisposed", "frame", "Ljavax/swing/RootPaneContainer;", "installLinuxResizeHandler", "cs", "Lkotlinx/coroutines/CoroutineScope;", "Ljavax/swing/JFrame;", "glassPane", "Lcom/intellij/openapi/wm/IdeGlassPane;", "appendTitlePart", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "s", "separator", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nProjectFrameHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectFrameHelper.kt\ncom/intellij/openapi/wm/impl/ProjectFrameHelperKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,660:1\n13#2:661\n*S KotlinDebug\n*F\n+ 1 ProjectFrameHelper.kt\ncom/intellij/openapi/wm/impl/ProjectFrameHelperKt\n*L\n75#1:661\n*E\n"})
public final class ProjectFrameHelperKt {
    @NotNull
    private static final String INIT_BOUNDS_KEY = "InitBounds";

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(ProjectFrameHelper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    @ApiStatus.Internal
    public static final void updateFullScreenState(@NotNull ProjectFrameHelper $this$updateFullScreenState, boolean isFullScreen) {
        Intrinsics.checkNotNullParameter((Object)$this$updateFullScreenState, (String)"<this>");
        if (isFullScreen && FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs()) {
            $this$updateFullScreenState.toggleFullScreen(true);
        }
    }

    private static final boolean isTemporaryDisposed(RootPaneContainer frame) {
        RootPaneContainer rootPaneContainer = frame;
        return ClientProperty.isTrue((Component)(rootPaneContainer != null ? rootPaneContainer.getRootPane() : null), (Object)"dispose.temporary");
    }

    private static final void installLinuxResizeHandler(CoroutineScope cs, JFrame frame, IdeGlassPane glassPane) {
        if (CustomWindowHeaderUtil.INSTANCE.hideNativeLinuxTitle$intellij_platform_ide_impl(UISettings.Companion.getShadowInstance())) {
            boolean toolkitCannotResizeUndecorated;
            boolean bl = toolkitCannotResizeUndecorated = !StartupUiUtil.isWaylandToolkit();
            if (toolkitCannotResizeUndecorated) {
                WindowResizeListenerEx windowResizeListener = new WindowResizeListenerEx(glassPane, frame, true);
                windowResizeListener.install(cs);
                windowResizeListener.setLeftMouseButtonOnly(true);
            }
        }
    }

    private static final void appendTitlePart(StringBuilder builder, String s, String separator) {
        CharSequence charSequence = s;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            if (((CharSequence)builder).length() > 0) {
                builder.append(separator);
            }
            builder.append(s);
        }
    }

    public static final /* synthetic */ void access$installLinuxResizeHandler(CoroutineScope cs, JFrame frame, IdeGlassPane glassPane) {
        ProjectFrameHelperKt.installLinuxResizeHandler(cs, frame, glassPane);
    }

    public static final /* synthetic */ void access$appendTitlePart(StringBuilder builder, String s, String separator) {
        ProjectFrameHelperKt.appendTitlePart(builder, s, separator);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return ProjectFrameHelperKt.getLOG();
    }

    public static final /* synthetic */ boolean access$isTemporaryDisposed(RootPaneContainer frame) {
        return ProjectFrameHelperKt.isTemporaryDisposed(frame);
    }
}

