/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.idea.AppMode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FrameBoundsConverter;
import com.intellij.openapi.wm.impl.FrameInfo;
import com.intellij.openapi.wm.impl.FrameInfoHelperKt;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.openapi.wm.impl.WinUiUtilKt;
import com.intellij.openapi.wm.impl.WindowManagerImpl;
import com.intellij.ui.ScreenUtil;
import com.sun.jna.platform.WindowUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a&\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "IDE_FRAME_EVENT_LOG", "FOCUSED_WINDOW_PROPERTY_NAME", "", "FRAME_ELEMENT", "calcAlphaModelSupported", "", "setAlphaMode", "", "window", "Ljava/awt/Window;", "ratio", "", "tryToFindTheOnlyFrame", "Lcom/intellij/openapi/wm/IdeFrame;", "getIdeFrame", "component", "Ljava/awt/Component;", "getFrameInfoByFrameHelper", "Lcom/intellij/openapi/wm/impl/FrameInfo;", "frameHelper", "Lcom/intellij/openapi/wm/impl/ProjectFrameHelper;", "getNormalFrameBounds", "Ljava/awt/Rectangle;", "frame", "Lcom/intellij/openapi/wm/impl/IdeFrameImpl;", "oldScreen", "newScreen", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nWindowManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowManagerImpl.kt\ncom/intellij/openapi/wm/impl/WindowManagerImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,546:1\n60#2,5:547\n60#2,5:552\n13#2:557\n*S KotlinDebug\n*F\n+ 1 WindowManagerImpl.kt\ncom/intellij/openapi/wm/impl/WindowManagerImplKt\n*L\n512#1:547,5\n514#1:552,5\n48#1:557\n*E\n"})
public final class WindowManagerImplKt {
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final Logger IDE_FRAME_EVENT_LOG;
    @NonNls
    @NotNull
    private static final String FOCUSED_WINDOW_PROPERTY_NAME = "focusedWindow";
    @NonNls
    @NotNull
    private static final String FRAME_ELEMENT = "frame";

    private static final boolean calcAlphaModelSupported() {
        boolean bl;
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (device.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
            return true;
        }
        if (AppMode.isRemoteDevHost()) {
            return false;
        }
        try {
            bl = WindowUtils.isWindowAlphaSupported();
        }
        catch (Throwable throwable) {
            bl = false;
        }
        return bl;
    }

    private static final void setAlphaMode(Window window, float ratio) {
        try {
            if (SystemInfoRt.isMac) {
                Window window2 = window;
                if (window2 instanceof JWindow) {
                    ((JWindow)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window2 instanceof JDialog) {
                    ((JDialog)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                } else if (window2 instanceof JFrame) {
                    ((JFrame)window).getRootPane().putClientProperty("Window.alpha", Float.valueOf(1.0f - ratio));
                }
            } else if (GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT)) {
                window.setOpacity(1.0f - ratio);
            } else {
                WindowUtils.setWindowAlpha((Window)window, (float)(1.0f - ratio));
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
    }

    private static final IdeFrame tryToFindTheOnlyFrame() {
        IdeFrameImpl candidate = null;
        Frame[] frameArray = Frame.getFrames();
        Intrinsics.checkNotNullExpressionValue((Object)frameArray, (String)"getFrames(...)");
        for (Frame each : frameArray) {
            if (!(each instanceof IdeFrameImpl)) continue;
            if (candidate == null) {
                candidate = (IdeFrameImpl)each;
                continue;
            }
            candidate = null;
            break;
        }
        IdeFrameImpl ideFrameImpl = candidate;
        return ideFrameImpl == null ? null : (IdeFrame)ProjectFrameHelper.Companion.getFrameHelper(ideFrameImpl);
    }

    private static final IdeFrame getIdeFrame(Component component2) {
        Component component3 = component2;
        return component3 instanceof IdeFrameImpl ? (IdeFrame)ProjectFrameHelper.Companion.getFrameHelper((Window)component2) : (component3 instanceof IdeFrame ? (IdeFrame)component2 : null);
    }

    @NotNull
    public static final FrameInfo getFrameInfoByFrameHelper(@NotNull ProjectFrameHelper frameHelper) {
        Intrinsics.checkNotNullParameter((Object)frameHelper, (String)"frameHelper");
        return FrameInfoHelperKt.updateFrameInfo(frameHelper, frameHelper.getFrame(), null, null);
    }

    private static final Rectangle getNormalFrameBounds(IdeFrameImpl frame, Rectangle oldScreen, Rectangle newScreen) {
        Rectangle nativeBounds = WinUiUtilKt.getNativeNormalBounds(frame);
        if (nativeBounds != null) {
            Logger logger2;
            FrameInfoHelperKt.checkForNonsenseBounds("getNormalFrameBounds.nativeBounds", nativeBounds);
            Logger $this$debug_u24default$iv = IDE_FRAME_EVENT_LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("Got native bounds: " + nativeBounds, t$iv);
            }
            FrameBoundsConverter.scaleDown(nativeBounds, frame.getGraphicsConfiguration());
            $this$debug_u24default$iv = IDE_FRAME_EVENT_LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("Updated normal frame bounds from native bounds: " + nativeBounds, t$iv);
            }
            return nativeBounds;
        }
        Rectangle result2 = null;
        Rectangle normalBounds = frame.getNormalBounds();
        FrameInfoHelperKt.checkForNonsenseBounds("getNormalFrameBounds.normalBounds", normalBounds);
        if (normalBounds == null) {
            IDE_FRAME_EVENT_LOG.debug("Not updating frame bounds because normalBounds == null");
        }
        if (normalBounds != null) {
            result2 = normalBounds;
            if (!(oldScreen == null || oldScreen.isEmpty() || newScreen == null || newScreen.isEmpty() || Intrinsics.areEqual((Object)newScreen, (Object)oldScreen))) {
                result2 = new Rectangle(result2);
                ScreenUtil.moveAndScale((Rectangle)result2, (Rectangle)oldScreen, (Rectangle)newScreen);
                FrameInfoHelperKt.checkForNonsenseBounds("getNormalFrameBounds.result (moved from " + oldScreen + " to " + newScreen + ")", result2);
                if (IDE_FRAME_EVENT_LOG.isDebugEnabled()) {
                    IDE_FRAME_EVENT_LOG.debug("Updated bounds for IDE frame " + result2 + " after moving from " + oldScreen + " to " + newScreen);
                }
            } else if (IDE_FRAME_EVENT_LOG.isDebugEnabled()) {
                IDE_FRAME_EVENT_LOG.debug("Frame moved from " + oldScreen + " to " + newScreen + ", not updating normal bounds " + normalBounds);
            }
        }
        return result2;
    }

    public static final /* synthetic */ boolean access$calcAlphaModelSupported() {
        return WindowManagerImplKt.calcAlphaModelSupported();
    }

    public static final /* synthetic */ void access$setAlphaMode(Window window, float ratio) {
        WindowManagerImplKt.setAlphaMode(window, ratio);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ IdeFrame access$tryToFindTheOnlyFrame() {
        return WindowManagerImplKt.tryToFindTheOnlyFrame();
    }

    public static final /* synthetic */ IdeFrame access$getIdeFrame(Component component2) {
        return WindowManagerImplKt.getIdeFrame(component2);
    }

    public static final /* synthetic */ Rectangle access$getNormalFrameBounds(IdeFrameImpl frame, Rectangle oldScreen, Rectangle newScreen) {
        return WindowManagerImplKt.getNormalFrameBounds(frame, oldScreen, newScreen);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(WindowManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
        Logger logger3 = Logger.getInstance((String)"ide.frame.events");
        Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
        IDE_FRAME_EVENT_LOG = logger3;
    }
}

