/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.help.impl.HelpManagerImpl;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.wm.impl.status.AnalyzingBannerDecoratorKt;
import com.intellij.openapi.wm.impl.status.ProcessPopup;
import com.intellij.openapi.wm.impl.status.ProgressComponent;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InlineBanner;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0016H\u0002J\u0006\u0010 \u001a\u00020\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/wm/impl/status/AnalyzingBannerDecorator;", "", "panel", "Ljavax/swing/JPanel;", "popupGetter", "Lkotlin/Function0;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "onBannerClose", "Ljava/lang/Runnable;", "<init>", "(Ljavax/swing/JPanel;Lkotlin/jvm/functions/Function0;Ljava/lang/Runnable;)V", "analyzingComponent", "Ljava/awt/Component;", "banner", "getBanner", "()Ljava/awt/Component;", "banner$delegate", "Lkotlin/Lazy;", "popup", "getPopup", "()Lcom/intellij/openapi/ui/popup/JBPopup;", "indicatorAdded", "", "indicator", "Lcom/intellij/openapi/wm/impl/status/ProgressComponent;", "indicatorRemoved", "isShowing", "", "isBannerPresent", "getPopupRequiredHeight", "", "removeBanner", "handlePopupClose", "createBanner", "revalidatePanel", "intellij.platform.ide.impl"})
public final class AnalyzingBannerDecorator {
    @NotNull
    private final JPanel panel;
    @NotNull
    private final Function0<JBPopup> popupGetter;
    @Nullable
    private Component analyzingComponent;
    @NotNull
    private final Lazy banner$delegate;

    public AnalyzingBannerDecorator(@NotNull JPanel panel2, @NotNull Function0<? extends JBPopup> popupGetter, @NotNull Runnable onBannerClose) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter(popupGetter, (String)"popupGetter");
        Intrinsics.checkNotNullParameter((Object)onBannerClose, (String)"onBannerClose");
        this.panel = panel2;
        this.popupGetter = popupGetter;
        this.banner$delegate = LazyKt.lazy(() -> AnalyzingBannerDecorator.banner_delegate$lambda$0(this, onBannerClose));
    }

    private final Component getBanner() {
        Lazy lazy = this.banner$delegate;
        return (Component)lazy.getValue();
    }

    private final JBPopup getPopup() {
        return (JBPopup)this.popupGetter.invoke();
    }

    public final void indicatorAdded(@NotNull ProgressComponent indicator2) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner()) {
            return;
        }
        if (this.analyzingComponent == null && AnalyzingBannerDecoratorKt.access$isAnalyzingIndicator(indicator2)) {
            this.analyzingComponent = indicator2.getComponent();
            this.panel.add(this.analyzingComponent, 0, 0);
            this.panel.add(this.getBanner(), 1, 1);
        }
    }

    public final void indicatorRemoved(@NotNull ProgressComponent indicator2, boolean isShowing) {
        Intrinsics.checkNotNullParameter((Object)indicator2, (String)"indicator");
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner()) {
            return;
        }
        if (Intrinsics.areEqual((Object)indicator2.getComponent(), (Object)this.analyzingComponent)) {
            this.analyzingComponent = null;
            if (!isShowing) {
                this.removeBanner();
            }
        }
    }

    public final boolean isBannerPresent() {
        boolean bl;
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner()) {
            bl = false;
        } else {
            Component[] componentArray = this.panel.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
            bl = ArraysKt.contains((Object[])componentArray, (Object)this.getBanner());
        }
        return bl;
    }

    public final int getPopupRequiredHeight() {
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner()) {
            return 0;
        }
        Serializable serializable = this.analyzingComponent;
        return this.getBanner().getPreferredSize().height + (serializable != null && (serializable = serializable.getPreferredSize()) != null ? ((Dimension)serializable).height : 0) + JBUI.scale((int)28);
    }

    private final void removeBanner() {
        block1: {
            Object object;
            this.panel.remove(this.getBanner());
            JBPopup jBPopup = this.getPopup();
            if (jBPopup != null) {
                jBPopup.setMinimumSize((Dimension)ProcessPopup.POPUP_MIN_SIZE);
            }
            if ((object = this.getPopup()) == null || (object = object.getContent()) == null) break block1;
            ((JComponent)object).setMinimumSize(null);
        }
    }

    public final void handlePopupClose() {
        if (AnalyzingBannerDecoratorKt.access$userClosedBanner() || this.analyzingComponent != null) {
            return;
        }
        this.removeBanner();
    }

    private final Component createBanner(Runnable revalidatePanel) {
        BorderLayoutPanel borderLayoutPanel;
        InlineBanner inlineBanner;
        InlineBanner $this$createBanner_u24lambda_u240 = inlineBanner = new InlineBanner(null, null, 3, null);
        boolean bl = false;
        String string = IndexingBundle.message((String)"progress.indexing.banner.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$createBanner_u24lambda_u240.setMessage(string);
        String string2 = IdeBundle.message((String)"link.learn.more", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$createBanner_u24lambda_u240.addAction(string2, AnalyzingBannerDecorator::createBanner$lambda$0$0);
        if (ExperimentalUI.Companion.isNewUI()) {
            $this$createBanner_u24lambda_u240.setOpaque(false);
        }
        $this$createBanner_u24lambda_u240.setCloseAction(() -> AnalyzingBannerDecorator.createBanner$lambda$0$1(this, revalidatePanel));
        InlineBanner banner = inlineBanner;
        BorderLayoutPanel $this$createBanner_u24lambda_u241 = borderLayoutPanel = JBUI.Panels.simplePanel((Component)((Component)banner));
        boolean bl2 = false;
        $this$createBanner_u24lambda_u241.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        ProcessPopup.hideSeparator((Component)$this$createBanner_u24lambda_u241);
        if (ExperimentalUI.Companion.isNewUI()) {
            $this$createBanner_u24lambda_u241.setOpaque(false);
        }
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"apply(...)");
        BorderLayoutPanel panel2 = borderLayoutPanel2;
        return (Component)panel2;
    }

    private static final Component banner_delegate$lambda$0(AnalyzingBannerDecorator this$0, Runnable $onBannerClose) {
        return this$0.createBanner($onBannerClose);
    }

    private static final void createBanner$lambda$0$0() {
        String url = HelpManagerImpl.getHelpUrl("Indexing");
        if (url != null) {
            BrowserUtil.browse((String)url);
        }
    }

    private static final void createBanner$lambda$0$1(AnalyzingBannerDecorator this$0, Runnable $revalidatePanel) {
        this$0.removeBanner();
        PropertiesComponent.getInstance().setValue("USER_CLOSED_ANALYZING_BANNER_KEY", true);
        $revalidatePanel.run();
    }
}

