/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.panel.ProgressPanel;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.util.MinimizeButton;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.status.AnalyzingBannerDecorator;
import com.intellij.openapi.wm.impl.status.InfoAndProgressPanel;
import com.intellij.openapi.wm.impl.status.ProgressComponent;
import com.intellij.openapi.wm.impl.status.SeparatorDecorator;
import com.intellij.openapi.wm.impl.status.TasksFinishedDecorator;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

final class ProcessPopup {
    public static final Key<ProgressPanel> KEY = new Key("ProgressPanel");
    static final JBDimension POPUP_MIN_SIZE = new JBDimension(300, 100);
    static final JBDimension POPUP_MIN_SIZE_WITH_BANNER = new JBDimension(464, 100);
    private static final String DIMENSION_SERVICE_KEY = "ProcessPopupWindow";
    private final InfoAndProgressPanel myProgressPanel;
    private final JPanel myIndicatorPanel;
    private final JScrollPane myContentPanel;
    private JBPopup myPopup;
    private boolean myPopupVisible;
    private final TasksFinishedDecorator myTasksFinishedDecorator;
    private final AnalyzingBannerDecorator myAnalyzingBannerDecorator;
    private final SeparatorDecorator mySeparatorDecorator;

    ProcessPopup(@NotNull InfoAndProgressPanel progressPanel) {
        if (progressPanel == null) {
            ProcessPopup.$$$reportNull$$$0(0);
        }
        this.myProgressPanel = progressPanel;
        this.myIndicatorPanel = new JBPanelWithEmptyText((LayoutManager)new VerticalLayout(0)).withEmptyText(IdeBundle.message((String)"progress.window.empty.text", (Object[])new Object[0])).andTransparent();
        this.myIndicatorPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)18, (int)0));
        this.myIndicatorPanel.setFocusable(true);
        if (ExperimentalUI.isNewUI()) {
            this.myIndicatorPanel.setBackground(JBUI.CurrentTheme.Popup.BACKGROUND);
        }
        this.myTasksFinishedDecorator = new TasksFinishedDecorator(this.myIndicatorPanel);
        this.myAnalyzingBannerDecorator = new AnalyzingBannerDecorator(this.myIndicatorPanel, (Function0<? extends JBPopup>)((Function0)() -> this.myPopup), () -> {
            SeparatorDecorator.placeSeparators(this.myIndicatorPanel);
            this.revalidateAll();
        });
        this.mySeparatorDecorator = new SeparatorDecorator(this.myIndicatorPanel);
        this.myContentPanel = new JBScrollPane((Component)this.myIndicatorPanel, 20, 31);
        this.updateContentUI();
    }

    public void addIndicator(@NotNull ProgressComponent indicator2) {
        if (indicator2 == null) {
            ProcessPopup.$$$reportNull$$$0(1);
        }
        JPanel component2 = indicator2.getComponent();
        if (ExperimentalUI.isNewUI()) {
            component2.setOpaque(false);
        }
        this.myIndicatorPanel.add(component2);
        this.myTasksFinishedDecorator.indicatorAdded();
        this.myAnalyzingBannerDecorator.indicatorAdded(indicator2);
        this.mySeparatorDecorator.indicatorAdded();
        this.revalidateAll();
        this.ensureSufficientSize();
    }

    public void removeIndicator(@NotNull ProgressComponent indicator2) {
        JPanel component2;
        int index;
        if (indicator2 == null) {
            ProcessPopup.$$$reportNull$$$0(2);
        }
        if ((index = this.myIndicatorPanel.getComponentZOrder(component2 = indicator2.getComponent())) == -1) {
            return;
        }
        this.myIndicatorPanel.remove(component2);
        this.myTasksFinishedDecorator.indicatorRemoved();
        this.myAnalyzingBannerDecorator.indicatorRemoved(indicator2, this.isShowing());
        this.mySeparatorDecorator.indicatorRemoved();
        this.revalidateAll();
        this.ensureSufficientSize();
    }

    private void ensureSufficientSize() {
        if (this.myPopup == null) {
            return;
        }
        if (!this.myAnalyzingBannerDecorator.isBannerPresent()) {
            this.myPopup.setMinimumSize((Dimension)POPUP_MIN_SIZE);
            return;
        }
        this.myPopup.setMinimumSize((Dimension)POPUP_MIN_SIZE_WITH_BANNER);
        this.updateContentUI();
        int requiredHeight = this.myAnalyzingBannerDecorator.getPopupRequiredHeight();
        if (this.myContentPanel.getHeight() >= requiredHeight) {
            return;
        }
        this.myContentPanel.setPreferredSize(new Dimension(this.myContentPanel.getPreferredSize().width, requiredHeight));
        this.myContentPanel.revalidate();
        this.myPopup.pack(false, true);
        this.myPopup.moveToFitScreen();
    }

    @NotNull
    private Rectangle calculateBounds() {
        StatusBarEx sb;
        JFrame frame = (JFrame)ComponentUtil.findUltimateParent((Component)this.myProgressPanel.getComponent());
        Dimension contentSize = this.myContentPanel.getPreferredSize();
        int contentHeight = Math.max(contentSize.height, JBUI.scale((int)100));
        int titleHeight = 0;
        if (this.myPopup instanceof AbstractPopup) {
            titleHeight = ((AbstractPopup)this.myPopup).getHeaderPreferredSize().height;
        }
        Rectangle frameBounds = frame.getBounds();
        int fullHeight = frameBounds.height - titleHeight;
        boolean isEmpty = this.myIndicatorPanel.getComponentCount() == 0;
        int width = Math.clamp((long)contentSize.width, JBUI.scale((int)300), JBUI.scale((int)500));
        int height = Math.min(isEmpty ? frameBounds.height / 4 : fullHeight, contentHeight);
        int x = frameBounds.x + frameBounds.width - width - JBUI.scale((int)20);
        int y = frameBounds.y + frameBounds.height - height;
        if (height != fullHeight) {
            y -= JBUI.scale((int)10);
        }
        if ((sb = (StatusBarEx)((IdeFrame)frame).getStatusBar()) != null && sb.isVisible()) {
            int statusBarHeight = sb.getSize().height;
            if (height == fullHeight) {
                height -= statusBarHeight + JBUI.scale((int)10);
            } else {
                y -= statusBarHeight;
            }
        }
        return new Rectangle(x, y -= titleHeight, width, height);
    }

    public void show(boolean requestFocus) {
        this.updateContentUI();
        this.createPopup(this.myContentPanel, this.myIndicatorPanel, requestFocus);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myPopup).subscribe(LafManagerListener.TOPIC, source -> this.updateContentUI());
        Rectangle popupBounds = this.calculateBounds();
        this.myContentPanel.setPreferredSize(popupBounds.getSize());
        this.myPopupVisible = true;
        this.myPopup.showInScreenCoordinates((Component)this.myProgressPanel.getComponent().getRootPane(), popupBounds.getLocation());
        this.ensureSufficientSize();
    }

    public boolean isShowing() {
        return this.myPopupVisible;
    }

    public void hide() {
        if (this.myPopup != null) {
            this.myAnalyzingBannerDecorator.handlePopupClose();
            this.mySeparatorDecorator.handlePopupClose();
            this.myPopupVisible = false;
            this.myPopup.cancel();
            this.myPopup = null;
            this.myContentPanel.setPreferredSize(null);
        }
    }

    private void revalidateAll() {
        this.myContentPanel.doLayout();
        this.myContentPanel.revalidate();
        this.myContentPanel.repaint();
    }

    private void updateContentUI() {
        IJSwingUtilities.updateComponentTreeUI(this.myContentPanel);
        this.myContentPanel.getViewport().setBackground(this.myIndicatorPanel.getBackground());
        this.myContentPanel.setBorder(null);
    }

    public void setHideOnFocusLost(boolean value) {
        JBPopup jBPopup = this.myPopup;
        if (jBPopup instanceof AbstractPopup) {
            AbstractPopup popup2 = (AbstractPopup)jBPopup;
            popup2.setCancelOnClickOutside(value);
            popup2.setCancelOnOtherWindowOpen(value);
        }
    }

    static void hideSeparator(@NotNull Component component2) {
        ProgressPanel panel2;
        if (component2 == null) {
            ProcessPopup.$$$reportNull$$$0(3);
        }
        if ((panel2 = (ProgressPanel)ClientProperty.get((Component)component2, KEY)) != null) {
            panel2.setSeparatorEnabled(false);
        }
    }

    static boolean isProgressIndicator(@NotNull Component component2) {
        if (component2 == null) {
            ProcessPopup.$$$reportNull$$$0(4);
        }
        return ClientProperty.get((Component)component2, KEY) != null;
    }

    private void createPopup(@NotNull JComponent content2, @NotNull JComponent focus, boolean requestFocus) {
        if (content2 == null) {
            ProcessPopup.$$$reportNull$$$0(5);
        }
        if (focus == null) {
            ProcessPopup.$$$reportNull$$$0(6);
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(content2, focus);
        builder.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProcessPopup.this.myProgressPanel.hideProcessPopup();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/ProcessPopup$1", "onClosed"));
            }
        });
        builder.setNormalWindowLevel(true);
        builder.setMovable(true);
        builder.setResizable(true);
        builder.setTitle(IdeBundle.message((String)"progress.window.title", (Object[])new Object[0]));
        builder.setCancelOnClickOutside(false);
        builder.setRequestFocus(requestFocus);
        builder.setBelongsToGlobalPopupStack(false);
        builder.setMinSize((Dimension)POPUP_MIN_SIZE);
        Project project2 = ProjectUtil.getProjectForComponent(this.myProgressPanel.getComponent());
        builder.setDimensionServiceKey(project2, DIMENSION_SERVICE_KEY, true);
        builder.setLocateWithinScreenBounds(false);
        builder.setCancelButton((IconButton)new MinimizeButton(IdeBundle.message((String)"tooltip.hide", (Object[])new Object[0])));
        this.myPopup = builder.createPopup();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressPanel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focus";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/status/ProcessPopup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addIndicator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeIndicator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hideSeparator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isProgressIndicator";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

