/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListenerBackgroundable;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.IconWidgetPresentation;
import com.intellij.openapi.wm.WidgetPresentationDataContext;
import com.intellij.openapi.wm.impl.status.ToggleReadOnlyAttributePanelKt;
import com.intellij.ui.UIBundle;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\fH\u0002J\u0010\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\fH\u0016J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u0014\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\n0\u0014H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/wm/impl/status/ToggleReadOnlyAttributePanel;", "Lcom/intellij/openapi/wm/IconWidgetPresentation;", "dataContext", "Lcom/intellij/openapi/wm/WidgetPresentationDataContext;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/wm/WidgetPresentationDataContext;Lkotlinx/coroutines/CoroutineScope;)V", "updateIconRequests", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "createFileFlow", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/openapi/vfs/VirtualFile;", "icon", "Ljavax/swing/Icon;", "getTooltipText", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getClickConsumer", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "getCurrentFile", "intellij.platform.ide.impl"})
public final class ToggleReadOnlyAttributePanel
implements IconWidgetPresentation {
    @NotNull
    private final WidgetPresentationDataContext dataContext;
    @NotNull
    private final MutableSharedFlow<Unit> updateIconRequests;

    public ToggleReadOnlyAttributePanel(@NotNull WidgetPresentationDataContext dataContext2, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)dataContext2, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.dataContext = dataContext2;
        this.updateIconRequests = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        MessageBusConnection connection = this.dataContext.getProject().getMessageBus().connect(disposable2);
        Topic topic = VirtualFileManager.VFS_CHANGES_BG;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES_BG");
        connection.subscribe(topic, (Object)new BulkFileListenerBackgroundable(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !Intrinsics.areEqual((Object)"writable", (Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                    if (!updateIconRequests.tryEmit((Object)Unit.INSTANCE)) {
                        throw new IllegalStateException("Check failed.");
                    }
                    return;
                }
            }
        });
        JobKt.getJob((CoroutineContext)scope.getCoroutineContext()).invokeOnCompletion(arg_0 -> ToggleReadOnlyAttributePanel._init_$lambda$0(disposable2, arg_0));
    }

    private final Flow<VirtualFile> createFileFlow() {
        Flow[] flowArray = new Flow[]{FlowKt.mapLatest((Flow)((Flow)this.updateIconRequests), (Function2)((Function2)new Function2<Unit, Continuation<? super FileEditor>, Object>(this, null){
            int label;
            final /* synthetic */ ToggleReadOnlyAttributePanel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return ToggleReadOnlyAttributePanel.access$getDataContext$p(this.this$0).getCurrentFileEditor().getValue();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super FileEditor> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), this.dataContext.getCurrentFileEditor()};
        return FlowKt.mapLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)FlowKt.merge((Flow[])flowArray), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS)), (Function2)((Function2)new Function2<FileEditor, Continuation<? super VirtualFile>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                FileEditor fileEditor = (FileEditor)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        void v0 = it;
                        return v0 != null ? v0.getFile() : null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FileEditor p1, Continuation<? super VirtualFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public Flow<Icon> icon() {
        return FlowKt.mapLatest(this.createFileFlow(), (Function2)((Function2)new Function2<VirtualFile, Continuation<? super Icon>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                VirtualFile virtualFile2 = (VirtualFile)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void var4_3;
                        void it;
                        ResultKt.throwOnFailure((Object)$result);
                        void v0 = it;
                        Object v1 = v0;
                        if (v0 == null) return null;
                        void p0 = var4_3 = v1;
                        boolean bl = false;
                        if (!ToggleReadOnlyAttributePanelKt.access$isReadOnlyApplicableForFile((VirtualFile)p0)) return null;
                        Object v2 = var4_3;
                        v1 = v2;
                        Object file2 = v1;
                        if (v2 != null) return file2.isWritable() ? AllIcons.Ide.Readwrite : AllIcons.Ide.Readonly;
                        return null;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(VirtualFile p1, Continuation<? super Icon> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Nullable
    public Object getTooltipText(@NotNull Continuation<? super String> $completion) {
        VirtualFile virtualFile2 = this.getCurrentFile();
        int writable = virtualFile2 == null || virtualFile2.isWritable() ? 1 : 0;
        int readonly = writable == 1 ? 0 : 1;
        Object[] objectArray = new Object[]{Boxing.boxInt((int)readonly), Boxing.boxInt((int)writable), Boxing.boxInt((int)1), Boxing.boxInt((int)0)};
        return ActionsBundle.message((String)"action.ToggleReadOnlyAttribute.files", (Object[])objectArray);
    }

    @NotNull
    public Function1<MouseEvent, Unit> getClickConsumer() {
        return arg_0 -> ToggleReadOnlyAttributePanel.getClickConsumer$lambda$0(this, arg_0);
    }

    private final VirtualFile getCurrentFile() {
        FileEditor fileEditor = (FileEditor)this.dataContext.getCurrentFileEditor().getValue();
        return fileEditor != null ? fileEditor.getFile() : null;
    }

    private static final Unit _init_$lambda$0(Disposable $disposable, Throwable it) {
        Disposer.dispose((Disposable)$disposable);
        return Unit.INSTANCE;
    }

    private static final Unit getClickConsumer$lambda$0(ToggleReadOnlyAttributePanel this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        VirtualFile file2 = this$0.getCurrentFile();
        if (file2 == null || !ToggleReadOnlyAttributePanelKt.access$isReadOnlyApplicableForFile(file2)) {
            return Unit.INSTANCE;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            WriteAction.run(() -> ToggleReadOnlyAttributePanel.getClickConsumer$lambda$0$0(file2));
        }
        catch (IOException e) {
            Messages.showMessageDialog((Project)this$0.dataContext.getProject(), (String)e.getMessage(), (String)UIBundle.message((String)"error.dialog.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
        }
        return Unit.INSTANCE;
    }

    private static final void getClickConsumer$lambda$0$0(VirtualFile $file) {
        ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)$file, (boolean)$file.isWritable());
    }

    public static final /* synthetic */ WidgetPresentationDataContext access$getDataContext$p(ToggleReadOnlyAttributePanel $this) {
        return $this.dataContext;
    }
}

