/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.impl.status.widget.ToggleWidgetAction;
import com.intellij.util.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\tJ\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\r\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getStatusBarToggleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getStatusBarToggleActions$intellij_platform_ide_impl", "getActionsFor", "widgetFactories", "", "Lcom/intellij/openapi/wm/StatusBarWidgetFactory;", "getActionFor", "widgetFactory", "Companion", "intellij.platform.ide.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStatusBarWidgetsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusBarWidgetsActionGroup.kt\ncom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,213:1\n774#2:214\n865#2,2:215\n1617#2,9:217\n1869#2:226\n1870#2:228\n1626#2:229\n774#2:230\n865#2,2:231\n1563#2:233\n1634#2,3:234\n1#3:227\n*S KotlinDebug\n*F\n+ 1 StatusBarWidgetsActionGroup.kt\ncom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager\n*L\n181#1:214\n181#1:215,2\n182#1:217,9\n182#1:226\n182#1:228\n182#1:229\n187#1:230\n187#1:231,2\n188#1:233\n188#1:234,3\n182#1:227\n*E\n"})
public final class StatusBarActionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TOGGLE_ACTION_ID_PREFIX = "StatusBarWidgets.Toggle.";

    public StatusBarActionManager(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        StatusBarWidgetFactory.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetFactory>(){

            public void extensionAdded(StatusBarWidgetFactory widgetFactory, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)widgetFactory, (String)"widgetFactory");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                if (widgetFactory.isConfigurable()) {
                    String actionId = Companion.getToggleActionId(widgetFactory);
                    AnAction oldAction = ActionManager.getInstance().getAction(actionId);
                    if (oldAction == null) {
                        ActionManager.getInstance().registerAction(actionId, (AnAction)new ToggleWidgetAction(widgetFactory));
                    } else {
                        boolean $i$f$logger = false;
                        Logger logger2 = Logger.getInstance(StatusBarWidgetFactory.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                        logger2.debug("Skip " + actionId + " - already registered as " + oldAction);
                    }
                }
            }

            public void extensionRemoved(StatusBarWidgetFactory widgetFactory, PluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)widgetFactory, (String)"widgetFactory");
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                String actionId = Companion.getToggleActionId(widgetFactory);
                if (ActionManager.getInstance().getAction(actionId) instanceof ToggleWidgetAction) {
                    ActionManager.getInstance().unregisterAction(actionId);
                }
            }
        }, true, CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnAction> getStatusBarToggleActions$intellij_platform_ide_impl() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        ActionManager actionManager = ActionManager.getInstance();
        Iterable $this$filter$iv = StatusBarWidgetFactory.EP_NAME.getExtensionList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StatusBarWidgetFactory it = (StatusBarWidgetFactory)element$iv$iv;
            boolean bl = false;
            if (!it.isConfigurable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AnAction it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            StatusBarWidgetFactory factory2 = (StatusBarWidgetFactory)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)factory2);
            if (actionManager.getActionOrStub(StatusBarActionManager.Companion.getToggleActionId(factory2)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnAction> getActionsFor(@NotNull Collection<? extends StatusBarWidgetFactory> widgetFactories) {
        void $this$mapTo$iv$iv;
        StatusBarWidgetFactory it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(widgetFactories, (String)"widgetFactories");
        Iterable $this$filter$iv = widgetFactories;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (StatusBarWidgetFactory)element$iv$iv;
            boolean bl = false;
            if (!it.isConfigurable()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void widgetFactory;
            it = (StatusBarWidgetFactory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getActionFor((StatusBarWidgetFactory)widgetFactory));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final AnAction getActionFor(@NotNull StatusBarWidgetFactory widgetFactory) {
        Intrinsics.checkNotNullParameter((Object)widgetFactory, (String)"widgetFactory");
        AnAction anAction = ActionManager.getInstance().getAction(StatusBarActionManager.Companion.getToggleActionId(widgetFactory));
        if (anAction == null) {
            anAction = (AnAction)new ToggleWidgetAction(widgetFactory);
        }
        return anAction;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0015\u0010\b\u001a\u00070\u0007\u00a2\u0006\u0002\b\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager;", "TOGGLE_ACTION_ID_PREFIX", "", "getToggleActionId", "Lorg/jetbrains/annotations/NonNls;", "widgetFactory", "Lcom/intellij/openapi/wm/StatusBarWidgetFactory;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nStatusBarWidgetsActionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StatusBarWidgetsActionGroup.kt\ncom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,213:1\n42#2,3:214\n*S KotlinDebug\n*F\n+ 1 StatusBarWidgetsActionGroup.kt\ncom/intellij/openapi/wm/impl/status/widget/StatusBarActionManager$Companion\n*L\n144#1:214,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatusBarActionManager getInstance() {
            boolean $i$f$service = false;
            Class<StatusBarActionManager> serviceClass$iv = StatusBarActionManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (StatusBarActionManager)object;
        }

        private final String getToggleActionId(StatusBarWidgetFactory widgetFactory) {
            String string = widgetFactory.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            return StatusBarActionManager.TOGGLE_ACTION_ID_PREFIX + StringsKt.replace$default((String)string, (String)" ", (String)"", (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

