/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.featureStatistics.fusCollectors.WslUsagesCollector;
import com.intellij.ide.RecentProjectMetaInfo;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.impl.welcomeScreen.cloneableProjects.VcsCloneCollector;
import com.intellij.openapi.wm.impl.welcomeScreen.recentProjects.CloneableProjectItem;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\b\u0007\u0018\u0000 +2\u00020\u0001:\u0007%&'()*+B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010!\u001a\u00020\u000bH\u0002J\b\u0010\"\u001a\u00020\u000bH\u0002J\b\u0010#\u001a\u00020\u000bH\u0002J\b\u0010$\u001a\u00020\u000bH\u0002R:\u0010\u0004\u001a.\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\t\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,\u00b2\u0006\n\u0010-\u001a\u00020.X\u008a\u0084\u0002"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService;", "", "<init>", "()V", "cloneableProjects", "", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneableProject;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "runCloneTask", "", "projectPath", "", "cloneTask", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTask;", "Ljava/nio/file/Path;", "collectCloneableProjects", "Lkotlin/sequences/Sequence;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/recentProjects/CloneableProjectItem;", "cloneCount", "", "isCloneActive", "", "cancelClone", "cloneableProject", "removeCloneableProject", "upgradeCloneProjectToRecent", "addCloneableProject", "onSuccess", "onFailure", "onCancel", "fireCloneAddedEvent", "fireCloneRemovedEvent", "fireCloneSuccessEvent", "fireCloneFailedEvent", "fireCloneCanceledEvent", "CloneStatus", "CloneTaskInfo", "CloneableProject", "CloneableProjectProgressIndicator", "CloneTask", "CloneProjectListener", "Companion", "intellij.platform.ide.impl", "recentProjectManager", "Lcom/intellij/ide/RecentProjectsManagerBase;"})
@SourceDebugExtension(value={"SMAP\nCloneableProjectsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloneableProjectsService.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,251:1\n774#2:252\n865#2,2:253\n1761#2,3:255\n13#3:258\n*S KotlinDebug\n*F\n+ 1 CloneableProjectsService.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService\n*L\n89#1:252\n89#1:253,2\n93#1:255,3\n59#1:258\n*E\n"})
public final class CloneableProjectsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CloneableProject> cloneableProjects;
    @Topic.AppLevel
    @NotNull
    private static final Topic<CloneProjectListener> TOPIC = new Topic(CloneProjectListener.class, Topic.BroadcastDirection.NONE);

    public CloneableProjectsService() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.cloneableProjects = list2;
    }

    public final void runCloneTask(@NotNull String projectPath, @NotNull CloneTask cloneTask) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)cloneTask, (String)"cloneTask");
        Path path = Path.of(projectPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
        this.runCloneTask(path, cloneTask);
    }

    public final void runCloneTask(@NotNull Path projectPath, @NotNull CloneTask cloneTask) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)cloneTask, (String)"cloneTask");
        CloneTaskInfo taskInfo2 = cloneTask.taskInfo();
        CloneableProjectProgressIndicator progressIndicator = new CloneableProjectProgressIndicator(taskInfo2);
        CloneableProject cloneableProject = new CloneableProject(projectPath, taskInfo2, (ProgressIndicatorEx)progressIndicator, CloneStatus.PROGRESS);
        this.addCloneableProject(cloneableProject);
        WslUsagesCollector.INSTANCE.beforeProjectCreated(projectPath, cloneTask);
        ApplicationManager.getApplication().executeOnPooledThread(() -> CloneableProjectsService.runCloneTask$lambda$0(progressIndicator, taskInfo2, cloneTask, this, cloneableProject));
    }

    @ApiStatus.Internal
    @NotNull
    public final Sequence<CloneableProjectItem> collectCloneableProjects() {
        Lazy recentProjectManager$delegate = LazyKt.lazy(CloneableProjectsService::collectCloneableProjects$lambda$0);
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.cloneableProjects), arg_0 -> CloneableProjectsService.collectCloneableProjects$lambda$2(recentProjectManager$delegate, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final int cloneCount() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.cloneableProjects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CloneableProject it = (CloneableProject)element$iv$iv;
            boolean bl = false;
            if (!(it.getCloneStatus() == CloneStatus.PROGRESS)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return ((List)destination$iv$iv).size();
    }

    public final boolean isCloneActive() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.cloneableProjects;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CloneableProject it = (CloneableProject)element$iv;
                    boolean bl2 = false;
                    if (!(it.getCloneStatus() == CloneStatus.PROGRESS)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void cancelClone(@NotNull CloneableProject cloneableProject) {
        Intrinsics.checkNotNullParameter((Object)cloneableProject, (String)"cloneableProject");
        cloneableProject.getProgressIndicator().cancel();
    }

    public final void removeCloneableProject(@NotNull CloneableProject cloneableProject) {
        Intrinsics.checkNotNullParameter((Object)cloneableProject, (String)"cloneableProject");
        if (cloneableProject.getCloneStatus() == CloneStatus.PROGRESS) {
            cloneableProject.getProgressIndicator().cancel();
        }
        this.cloneableProjects.removeIf(arg_0 -> CloneableProjectsService.removeCloneableProject$lambda$1(arg_0 -> CloneableProjectsService.removeCloneableProject$lambda$0(cloneableProject, arg_0), arg_0));
        this.fireCloneRemovedEvent();
    }

    private final void upgradeCloneProjectToRecent(CloneableProject cloneableProject) {
        RecentProjectsManager recentProjectsManager = RecentProjectsManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)recentProjectsManager, (String)"null cannot be cast to non-null type com.intellij.ide.RecentProjectsManagerBase");
        RecentProjectsManagerBase recentProjectsManager2 = (RecentProjectsManagerBase)recentProjectsManager;
        recentProjectsManager2.addRecentPath(cloneableProject.getProjectPath(), new RecentProjectMetaInfo());
        this.removeCloneableProject(cloneableProject);
    }

    private final void addCloneableProject(CloneableProject cloneableProject) {
        this.cloneableProjects.removeIf(arg_0 -> CloneableProjectsService.addCloneableProject$lambda$1(arg_0 -> CloneableProjectsService.addCloneableProject$lambda$0(cloneableProject, arg_0), arg_0));
        this.cloneableProjects.add(cloneableProject);
        this.fireCloneAddedEvent(cloneableProject);
    }

    private final void onSuccess(CloneableProject cloneableProject) {
        cloneableProject.setCloneStatus(CloneStatus.SUCCESS);
        this.upgradeCloneProjectToRecent(cloneableProject);
        this.fireCloneSuccessEvent();
    }

    private final void onFailure(CloneableProject cloneableProject) {
        cloneableProject.setCloneStatus(CloneStatus.FAILURE);
        this.fireCloneFailedEvent();
    }

    private final void onCancel(CloneableProject cloneableProject) {
        cloneableProject.setCloneStatus(CloneStatus.CANCEL);
        this.fireCloneCanceledEvent();
    }

    private final void fireCloneAddedEvent(CloneableProject cloneableProject) {
        ApplicationManager.getApplication().invokeLater(() -> CloneableProjectsService.fireCloneAddedEvent$lambda$0(cloneableProject));
    }

    private final void fireCloneRemovedEvent() {
        ApplicationManager.getApplication().invokeLater(CloneableProjectsService::fireCloneRemovedEvent$lambda$0);
    }

    private final void fireCloneSuccessEvent() {
        ApplicationManager.getApplication().invokeLater(CloneableProjectsService::fireCloneSuccessEvent$lambda$0);
    }

    private final void fireCloneFailedEvent() {
        ApplicationManager.getApplication().invokeLater(CloneableProjectsService::fireCloneFailedEvent$lambda$0);
    }

    private final void fireCloneCanceledEvent() {
        ApplicationManager.getApplication().invokeLater(CloneableProjectsService::fireCloneCanceledEvent$lambda$0);
    }

    private static final void runCloneTask$lambda$0(CloneableProjectProgressIndicator $progressIndicator, CloneTaskInfo $taskInfo, CloneTask $cloneTask, CloneableProjectsService this$0, CloneableProject $cloneableProject) {
        ProgressManager.getInstance().runProcess(() -> CloneableProjectsService.runCloneTask$lambda$0$0($taskInfo, $cloneTask, $progressIndicator, this$0, $cloneableProject), (ProgressIndicator)$progressIndicator);
    }

    private static final void runCloneTask$lambda$0$0(CloneTaskInfo $taskInfo, CloneTask $cloneTask, CloneableProjectProgressIndicator $progressIndicator, CloneableProjectsService this$0, CloneableProject $cloneableProject) {
        CloneStatus cloneStatus;
        StructuredIdeActivity activity = VcsCloneCollector.INSTANCE.cloneStarted($taskInfo);
        try {
            cloneStatus = $cloneTask.run((ProgressIndicator)$progressIndicator);
        }
        catch (ProcessCanceledException processCanceledException) {
            cloneStatus = CloneStatus.CANCEL;
        }
        catch (Throwable exception) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(CloneableProjectsService.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error(exception);
            cloneStatus = CloneStatus.FAILURE;
        }
        CloneStatus cloneStatus2 = cloneStatus;
        VcsCloneCollector.INSTANCE.cloneFinished(activity, cloneStatus2, $taskInfo);
        switch (WhenMappings.$EnumSwitchMapping$0[cloneStatus2.ordinal()]) {
            case 1: {
                this$0.onSuccess($cloneableProject);
                break;
            }
            case 2: {
                this$0.onFailure($cloneableProject);
                break;
            }
            case 3: {
                this$0.onCancel($cloneableProject);
            }
        }
    }

    private static final RecentProjectsManagerBase collectCloneableProjects$lambda$0() {
        RecentProjectsManager recentProjectsManager = RecentProjectsManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)recentProjectsManager, (String)"null cannot be cast to non-null type com.intellij.ide.RecentProjectsManagerBase");
        return (RecentProjectsManagerBase)recentProjectsManager;
    }

    private static final RecentProjectsManagerBase collectCloneableProjects$lambda$1(Lazy<? extends RecentProjectsManagerBase> $recentProjectManager$delegate) {
        Lazy<? extends RecentProjectsManagerBase> lazy = $recentProjectManager$delegate;
        return (RecentProjectsManagerBase)lazy.getValue();
    }

    private static final CloneableProjectItem collectCloneableProjects$lambda$2(Lazy $recentProjectManager$delegate, CloneableProject cloneableProject) {
        Path projectPath = cloneableProject.getProjectPath();
        String projectName = CloneableProjectsService.collectCloneableProjects$lambda$1((Lazy<? extends RecentProjectsManagerBase>)$recentProjectManager$delegate).getProjectName(projectPath);
        String string = CloneableProjectsService.collectCloneableProjects$lambda$1((Lazy<? extends RecentProjectsManagerBase>)$recentProjectManager$delegate).getDisplayName(projectPath);
        if (string == null) {
            string = projectName;
        }
        String displayName = string;
        Intrinsics.checkNotNull((Object)cloneableProject);
        return new CloneableProjectItem(projectPath, projectName, displayName, cloneableProject);
    }

    private static final boolean removeCloneableProject$lambda$0(CloneableProject $cloneableProject, CloneableProject it) {
        return Intrinsics.areEqual((Object)it.getProjectPath(), (Object)$cloneableProject.getProjectPath());
    }

    private static final boolean removeCloneableProject$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean addCloneableProject$lambda$0(CloneableProject $cloneableProject, CloneableProject it) {
        return Intrinsics.areEqual((Object)it.getProjectPath(), (Object)$cloneableProject.getProjectPath());
    }

    private static final boolean addCloneableProject$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void fireCloneAddedEvent$lambda$0(CloneableProject $cloneableProject) {
        ((CloneProjectListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).onCloneAdded($cloneableProject.getProgressIndicator(), $cloneableProject.getCloneTaskInfo());
    }

    private static final void fireCloneRemovedEvent$lambda$0() {
        ((CloneProjectListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).onCloneRemoved();
    }

    private static final void fireCloneSuccessEvent$lambda$0() {
        ((CloneProjectListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).onCloneSuccess();
    }

    private static final void fireCloneFailedEvent$lambda$0() {
        ((CloneProjectListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).onCloneFailed();
    }

    private static final void fireCloneCanceledEvent$lambda$0() {
        ((CloneProjectListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).onCloneCanceled();
    }

    @JvmStatic
    @NotNull
    public static final CloneableProjectsService getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0003H\u0017J\b\u0010\t\u001a\u00020\u0003H\u0017J\b\u0010\n\u001a\u00020\u0003H\u0017J\b\u0010\u000b\u001a\u00020\u0003H\u0017\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneProjectListener;", "", "onCloneAdded", "", "progressIndicator", "Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;", "taskInfo", "Lcom/intellij/openapi/progress/TaskInfo;", "onCloneRemoved", "onCloneSuccess", "onCloneFailed", "onCloneCanceled", "intellij.platform.ide.impl"})
    public static interface CloneProjectListener {
        @RequiresEdt
        default public void onCloneAdded(@NotNull ProgressIndicatorEx progressIndicator, @NotNull TaskInfo taskInfo2) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Intrinsics.checkNotNullParameter((Object)taskInfo2, (String)"taskInfo");
        }

        @RequiresEdt
        default public void onCloneRemoved() {
        }

        @RequiresEdt
        default public void onCloneSuccess() {
        }

        @RequiresEdt
        default public void onCloneFailed() {
        }

        @RequiresEdt
        default public void onCloneCanceled() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;", "", "<init>", "(Ljava/lang/String;I)V", "SUCCESS", "PROGRESS", "FAILURE", "CANCEL", "intellij.platform.ide.impl"})
    public static final class CloneStatus
    extends Enum<CloneStatus> {
        public static final /* enum */ CloneStatus SUCCESS = new CloneStatus();
        public static final /* enum */ CloneStatus PROGRESS = new CloneStatus();
        public static final /* enum */ CloneStatus FAILURE = new CloneStatus();
        public static final /* enum */ CloneStatus CANCEL = new CloneStatus();
        private static final /* synthetic */ CloneStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CloneStatus[] values() {
            return (CloneStatus[])$VALUES.clone();
        }

        public static CloneStatus valueOf(String value) {
            return Enum.valueOf(CloneStatus.class, value);
        }

        @NotNull
        public static EnumEntries<CloneStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = cloneStatusArray = new CloneStatus[]{CloneStatus.SUCCESS, CloneStatus.PROGRESS, CloneStatus.FAILURE, CloneStatus.CANCEL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTask;", "", "taskInfo", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;", "run", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.platform.ide.impl"})
    public static interface CloneTask {
        @NotNull
        public CloneTaskInfo taskInfo();

        @NotNull
        public CloneStatus run(@NotNull ProgressIndicator var1);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001Bo\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\n\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001cH\u0017R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0016\u0010\t\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0016\u0010\n\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0016\u0010\u000b\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0016\u0010\f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;", "Lcom/intellij/openapi/progress/TaskInfo;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressTitle;", "cancelTooltipText", "Lorg/jetbrains/annotations/Nls;", "actionTitle", "actionTooltipText", "failedTitle", "canceledTitle", "stopTitle", "stopDescription", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getActionTitle", "()Ljava/lang/String;", "getActionTooltipText", "getFailedTitle", "getCanceledTitle", "getStopTitle", "getStopDescription", "getTitle", "getCancelText", "getCancelTooltipText", "isCancellable", "", "getActivityData", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "intellij.platform.ide.impl"})
    public static class CloneTaskInfo
    implements TaskInfo {
        @NotNull
        private final String title;
        @NotNull
        private final String cancelTooltipText;
        @NotNull
        private final String actionTitle;
        @NotNull
        private final String actionTooltipText;
        @NotNull
        private final String failedTitle;
        @NotNull
        private final String canceledTitle;
        @NotNull
        private final String stopTitle;
        @NotNull
        private final String stopDescription;

        public CloneTaskInfo(@NotNull String title2, @NotNull String cancelTooltipText, @NotNull String actionTitle, @NotNull String actionTooltipText, @NotNull String failedTitle, @NotNull String canceledTitle, @NotNull String stopTitle, @NotNull String stopDescription) {
            Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
            Intrinsics.checkNotNullParameter((Object)cancelTooltipText, (String)"cancelTooltipText");
            Intrinsics.checkNotNullParameter((Object)actionTitle, (String)"actionTitle");
            Intrinsics.checkNotNullParameter((Object)actionTooltipText, (String)"actionTooltipText");
            Intrinsics.checkNotNullParameter((Object)failedTitle, (String)"failedTitle");
            Intrinsics.checkNotNullParameter((Object)canceledTitle, (String)"canceledTitle");
            Intrinsics.checkNotNullParameter((Object)stopTitle, (String)"stopTitle");
            Intrinsics.checkNotNullParameter((Object)stopDescription, (String)"stopDescription");
            this.title = title2;
            this.cancelTooltipText = cancelTooltipText;
            this.actionTitle = actionTitle;
            this.actionTooltipText = actionTooltipText;
            this.failedTitle = failedTitle;
            this.canceledTitle = canceledTitle;
            this.stopTitle = stopTitle;
            this.stopDescription = stopDescription;
        }

        @NotNull
        public final String getActionTitle() {
            return this.actionTitle;
        }

        @NotNull
        public final String getActionTooltipText() {
            return this.actionTooltipText;
        }

        @NotNull
        public final String getFailedTitle() {
            return this.failedTitle;
        }

        @NotNull
        public final String getCanceledTitle() {
            return this.canceledTitle;
        }

        @NotNull
        public final String getStopTitle() {
            return this.stopTitle;
        }

        @NotNull
        public final String getStopDescription() {
            return this.stopDescription;
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        @NotNull
        public String getCancelText() {
            String string = CommonBundle.getCancelButtonText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCancelButtonText(...)");
            return string;
        }

        @NotNull
        public String getCancelTooltipText() {
            return this.cancelTooltipText;
        }

        public boolean isCancellable() {
            return true;
        }

        @ApiStatus.Internal
        @NotNull
        public List<EventPair<?>> getActivityData() {
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneableProject;", "", "projectPath", "Ljava/nio/file/Path;", "cloneTaskInfo", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;", "progressIndicator", "Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;", "cloneStatus", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;)V", "getProjectPath", "()Ljava/nio/file/Path;", "getCloneTaskInfo", "()Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;", "getProgressIndicator", "()Lcom/intellij/openapi/wm/ex/ProgressIndicatorEx;", "getCloneStatus", "()Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;", "setCloneStatus", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneStatus;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide.impl"})
    public static final class CloneableProject {
        @NotNull
        private final Path projectPath;
        @NotNull
        private final CloneTaskInfo cloneTaskInfo;
        @NotNull
        private final ProgressIndicatorEx progressIndicator;
        @NotNull
        private CloneStatus cloneStatus;

        public CloneableProject(@NotNull Path projectPath, @NotNull CloneTaskInfo cloneTaskInfo, @NotNull ProgressIndicatorEx progressIndicator, @NotNull CloneStatus cloneStatus) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)cloneTaskInfo, (String)"cloneTaskInfo");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Intrinsics.checkNotNullParameter((Object)((Object)cloneStatus), (String)"cloneStatus");
            this.projectPath = projectPath;
            this.cloneTaskInfo = cloneTaskInfo;
            this.progressIndicator = progressIndicator;
            this.cloneStatus = cloneStatus;
        }

        @NotNull
        public final Path getProjectPath() {
            return this.projectPath;
        }

        @NotNull
        public final CloneTaskInfo getCloneTaskInfo() {
            return this.cloneTaskInfo;
        }

        @NotNull
        public final ProgressIndicatorEx getProgressIndicator() {
            return this.progressIndicator;
        }

        @NotNull
        public final CloneStatus getCloneStatus() {
            return this.cloneStatus;
        }

        public final void setCloneStatus(@NotNull CloneStatus cloneStatus) {
            Intrinsics.checkNotNullParameter((Object)((Object)cloneStatus), (String)"<set-?>");
            this.cloneStatus = cloneStatus;
        }

        @NotNull
        public final Path component1() {
            return this.projectPath;
        }

        @NotNull
        public final CloneTaskInfo component2() {
            return this.cloneTaskInfo;
        }

        @NotNull
        public final ProgressIndicatorEx component3() {
            return this.progressIndicator;
        }

        @NotNull
        public final CloneStatus component4() {
            return this.cloneStatus;
        }

        @NotNull
        public final CloneableProject copy(@NotNull Path projectPath, @NotNull CloneTaskInfo cloneTaskInfo, @NotNull ProgressIndicatorEx progressIndicator, @NotNull CloneStatus cloneStatus) {
            Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
            Intrinsics.checkNotNullParameter((Object)cloneTaskInfo, (String)"cloneTaskInfo");
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            Intrinsics.checkNotNullParameter((Object)((Object)cloneStatus), (String)"cloneStatus");
            return new CloneableProject(projectPath, cloneTaskInfo, progressIndicator, cloneStatus);
        }

        public static /* synthetic */ CloneableProject copy$default(CloneableProject cloneableProject, Path path, CloneTaskInfo cloneTaskInfo, ProgressIndicatorEx progressIndicatorEx, CloneStatus cloneStatus, int n, Object object) {
            if ((n & 1) != 0) {
                path = cloneableProject.projectPath;
            }
            if ((n & 2) != 0) {
                cloneTaskInfo = cloneableProject.cloneTaskInfo;
            }
            if ((n & 4) != 0) {
                progressIndicatorEx = cloneableProject.progressIndicator;
            }
            if ((n & 8) != 0) {
                cloneStatus = cloneableProject.cloneStatus;
            }
            return cloneableProject.copy(path, cloneTaskInfo, progressIndicatorEx, cloneStatus);
        }

        @NotNull
        public String toString() {
            return "CloneableProject(projectPath=" + this.projectPath + ", cloneTaskInfo=" + this.cloneTaskInfo + ", progressIndicator=" + this.progressIndicator + ", cloneStatus=" + this.cloneStatus + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.projectPath).hashCode();
            result2 = result2 * 31 + this.cloneTaskInfo.hashCode();
            result2 = result2 * 31 + this.progressIndicator.hashCode();
            result2 = result2 * 31 + this.cloneStatus.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CloneableProject)) {
                return false;
            }
            CloneableProject cloneableProject = (CloneableProject)other;
            if (!Intrinsics.areEqual((Object)this.projectPath, (Object)cloneableProject.projectPath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cloneTaskInfo, (Object)cloneableProject.cloneTaskInfo)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.progressIndicator, (Object)cloneableProject.progressIndicator)) {
                return false;
            }
            return this.cloneStatus == cloneableProject.cloneStatus;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneableProjectProgressIndicator;", "Lcom/intellij/openapi/progress/util/ProgressIndicatorBase;", "cloneTaskInfo", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;", "<init>", "(Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneTaskInfo;)V", "intellij.platform.ide.impl"})
    private static final class CloneableProjectProgressIndicator
    extends ProgressIndicatorBase {
        public CloneableProjectProgressIndicator(@NotNull CloneTaskInfo cloneTaskInfo) {
            Intrinsics.checkNotNullParameter((Object)cloneTaskInfo, (String)"cloneTaskInfo");
            this.setOwnerTask(cloneTaskInfo);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0007R\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$CloneProjectListener;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "getInstance", "Lcom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService;", "intellij.platform.ide.impl"})
    @SourceDebugExtension(value={"SMAP\nCloneableProjectsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CloneableProjectsService.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,251:1\n42#2,3:252\n*S KotlinDebug\n*F\n+ 1 CloneableProjectsService.kt\ncom/intellij/openapi/wm/impl/welcomeScreen/cloneableProjects/CloneableProjectsService$Companion\n*L\n249#1:252,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<CloneProjectListener> getTOPIC() {
            return TOPIC;
        }

        @JvmStatic
        @NotNull
        public final CloneableProjectsService getInstance() {
            boolean $i$f$service = false;
            Class<CloneableProjectsService> serviceClass$iv = CloneableProjectsService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (CloneableProjectsService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CloneStatus.values().length];
            try {
                nArray[CloneStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloneStatus.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CloneStatus.CANCEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

