/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u0014R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/FolderProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "<init>", "()V", "name", "", "Lorg/jetbrains/annotations/Nls;", "getName", "()Ljava/lang/String;", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectFile", "lookForProjectsInDirectory", "openProjectAsync", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nFolderProjectOpenProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FolderProjectOpenProcessor.kt\ncom/intellij/platform/FolderProjectOpenProcessor\n+ 2 OpenProjectTask.kt\ncom/intellij/ide/impl/OpenProjectTaskKt\n+ 3 OpenProjectTask.kt\ncom/intellij/ide/impl/OpenProjectTaskBuilder\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,38:1\n217#2:39\n174#3,3:40\n179#3,32:44\n178#3:76\n23#4:43\n*S KotlinDebug\n*F\n+ 1 FolderProjectOpenProcessor.kt\ncom/intellij/platform/FolderProjectOpenProcessor\n*L\n32#1:39\n32#1:40,3\n32#1:44,32\n32#1:76\n32#1:43\n*E\n"})
public final class FolderProjectOpenProcessor
extends ProjectOpenProcessor {
    @NotNull
    private final String name;

    public FolderProjectOpenProcessor() {
        String string = IdeBundle.message((String)"folder.open.processor.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.name = string;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean canOpenProject(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return Registry.Companion.is("ide.allow.folder.as.project", false) && file2.isDirectory();
    }

    public boolean isProjectFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return false;
    }

    public boolean lookForProjectsInDirectory() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object openProjectAsync(@NotNull VirtualFile virtualFile2, @Nullable Project projectToClose, boolean forceOpenInNewFrame, @NotNull Continuation<? super Project> $completion) {
        void $this$openProjectAsync_u24lambda_u240;
        Path path = virtualFile2.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path projectPath = path;
        boolean $i$f$OpenProjectTask = false;
        OpenProjectTaskBuilder this_$iv$iv = new OpenProjectTaskBuilder();
        boolean $i$f$build = false;
        OpenProjectTaskBuilder openProjectTaskBuilder = this_$iv$iv;
        Path path2 = projectPath;
        ProjectManagerEx projectManagerEx = ProjectManagerEx.Companion.getInstanceEx();
        boolean bl = false;
        $this$openProjectAsync_u24lambda_u240.setProjectRootDir(projectPath);
        $this$openProjectAsync_u24lambda_u240.setProjectName(virtualFile2.getName());
        $this$openProjectAsync_u24lambda_u240.setCreateModule(false);
        Unit unit = Unit.INSTANCE;
        if (this_$iv$iv.getProject() != null && this_$iv$iv.getCreateModule()) {
            OpenProjectTaskBuilder $this$thisLogger$iv$iv$iv = this_$iv$iv;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(OpenProjectTaskBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            Project project2 = this_$iv$iv.getProject();
            logger2.warn("Project is explicitly set (name=" + (project2 != null ? project2.getName() : null) + "), but createModule is true");
        }
        boolean bl2 = this_$iv$iv.getForceOpenInNewFrame();
        boolean bl3 = this_$iv$iv.getForceReuseFrame();
        boolean bl4 = this_$iv$iv.getPreloadServices();
        Project project3 = this_$iv$iv.getProjectToClose();
        boolean bl5 = this_$iv$iv.isRefreshVfsNeeded();
        String string = this_$iv$iv.getProjectName();
        boolean bl6 = this_$iv$iv.isNewProject();
        Boolean bl7 = this_$iv$iv.getUseDefaultProjectAsTemplate();
        boolean bl8 = bl7 != null ? bl7.booleanValue() : this_$iv$iv.isNewProject();
        boolean bl9 = this_$iv$iv.getRunConfigurators();
        boolean bl10 = this_$iv$iv.isProjectCreatedWithWizard();
        boolean bl11 = this_$iv$iv.getRunConversionBeforeOpen();
        boolean bl12 = this_$iv$iv.getShowWelcomeScreen();
        Function2 function2 = this_$iv$iv.getBeforeOpen();
        Function1 function1 = this_$iv$iv.getBeforeInit();
        Function2 function22 = this_$iv$iv.getPreparedToOpen();
        ProjectOpenedCallback projectOpenedCallback = this_$iv$iv.getCallback();
        boolean bl13 = this_$iv$iv.getPreventIprLookup();
        Function1 function12 = this_$iv$iv.getProcessorChooser();
        String string2 = this_$iv$iv.getProjectWorkspaceId();
        Object object = this_$iv$iv.getImplOptions();
        boolean bl14 = this_$iv$iv.getCreateModule();
        int n = this_$iv$iv.getLine();
        int n2 = this_$iv$iv.getColumn();
        Project project4 = this_$iv$iv.getProject();
        Path path3 = this_$iv$iv.getProjectRootDir();
        return projectManagerEx.openProjectAsync(path2, new OpenProjectTask(bl2, bl3, project3, bl6, bl8, project4, string, bl12, projectOpenedCallback, n, n2, bl5, bl9, bl11, string2, bl10, bl4, function1, function2, function22, bl13, function12, object, path3, bl14), $completion);
    }
}

