/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.IdeIdeaFormatWriterKt;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.IdeaFormatWriter;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.lang.ClassPath;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0004H\u0014J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001d0\u0003H\u0002J \u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001dH\u0014J \u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u0004H\u0014R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriter;", "Lcom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "pluginCostMap", "", "Lit/unimi/dsi/fastutil/objects/Object2LongOpenHashMap;", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "<init>", "(Ljava/util/Map;Ljava/util/Map;Lcom/intellij/diagnostic/ThreadNameManager;)V", "publicStatMetrics", "Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "getPublicStatMetrics", "()Lit/unimi/dsi/fastutil/objects/Object2IntOpenHashMap;", "writeToLog", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "writeAppInfo", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeProjectName", "projectName", "writeExtraData", "getClassAndResourceLoadingStats", "", "writeTotalDuration", "end", "timeOffset", "beforeActivityWrite", "item", "ownOrTotalDuration", "fieldName", "intellij.platform.diagnostic.startUpPerformanceReporter"})
@SourceDebugExtension(value={"SMAP\nIdeIdeaFormatWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeIdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 jackson.kt\ncom/intellij/util/io/jackson/JacksonUtil\n*L\n1#1,217:1\n1761#2,3:218\n12#3,7:221\n12#3,7:228\n12#3,7:235\n12#3,7:242\n*S KotlinDebug\n*F\n+ 1 IdeIdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeIdeaFormatWriter\n*L\n58#1:218,3\n71#1:221,7\n79#1:228,7\n83#1:235,7\n88#1:242,7\n*E\n"})
public final class IdeIdeaFormatWriter
extends IdeaFormatWriter {
    @NotNull
    private final Map<String, Object2LongOpenHashMap<String>> pluginCostMap;
    @NotNull
    private final Object2IntOpenHashMap<String> publicStatMetrics;

    public IdeIdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities2, @NotNull Map<String, Object2LongOpenHashMap<String>> pluginCostMap, @NotNull ThreadNameManager threadNameManager) {
        Intrinsics.checkNotNullParameter(activities2, (String)"activities");
        Intrinsics.checkNotNullParameter(pluginCostMap, (String)"pluginCostMap");
        Intrinsics.checkNotNullParameter((Object)threadNameManager, (String)"threadNameManager");
        super(activities2, threadNameManager, "38");
        this.pluginCostMap = pluginCostMap;
        this.publicStatMetrics = new Object2IntOpenHashMap();
        this.publicStatMetrics.defaultReturnValue(-1);
    }

    @NotNull
    public final Object2IntOpenHashMap<String> getPublicStatMetrics() {
        return this.publicStatMetrics;
    }

    public final void writeToLog(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.getStringWriter().write("\n=== Stop: StartUp Measurement ===");
        log.info(this.getStringWriter().toString());
    }

    @Override
    protected void writeAppInfo(@NotNull JsonGenerator writer) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            writer.writeStringField("build", appInfo.getBuild().asStringWithoutProductCode());
            writer.writeStringField("buildDate", ZonedDateTime.ofInstant(appInfo.getBuildDate().toInstant(), ZoneId.systemDefault()).format(DateTimeFormatter.RFC_1123_DATE_TIME));
            writer.writeStringField("productCode", appInfo.getBuild().getProductCode());
            List<String> list2 = ManagementFactory.getRuntimeMXBean().getInputArguments();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getInputArguments(...)");
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it, (Object)"-Xshare:auto") || Intrinsics.areEqual((Object)it, (Object)"-Xshare:on"))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            writer.writeBooleanField("cds", true);
        }
    }

    @Override
    protected void writeProjectName(@NotNull JsonGenerator writer, @NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        String string = System.getProperty("idea.performanceReport.projectName");
        if (string == null) {
            string = IdeIdeaFormatWriterKt.access$safeHashValue(projectName);
        }
        writer.writeStringField("project", string);
    }

    @Override
    protected void writeExtraData(@NotNull JsonGenerator writer) {
        JsonGenerator $this$obj$iv;
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Map<String, Long> stats = this.getClassAndResourceLoadingStats();
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = "classLoading";
        boolean $i$f$obj = false;
        String it$iv = fieldName$iv;
        boolean bl = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl2 = false;
        long time = ((Number)stats.getOrDefault("classLoadingTime", 0L)).longValue();
        writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(time));
        long defineTime = ((Number)stats.getOrDefault("classDefineTime", 0L)).longValue();
        writer.writeNumberField("searchTime", TimeUnit.NANOSECONDS.toMillis(time - defineTime));
        writer.writeNumberField("defineTime", TimeUnit.NANOSECONDS.toMillis(defineTime));
        writer.writeNumberField("count", ((Number)stats.getOrDefault("classRequests", 0L)).longValue());
        $this$obj$iv.writeEndObject();
        $this$obj$iv = writer;
        fieldName$iv = "resourceLoading";
        $i$f$obj = false;
        it$iv = fieldName$iv;
        bl = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl3 = false;
        writer.writeNumberField("time", TimeUnit.NANOSECONDS.toMillis(((Number)stats.getOrDefault("resourceLoadingTime", 0L)).longValue()));
        writer.writeNumberField("count", ((Number)stats.getOrDefault("resourceRequests", 0L)).longValue());
        $this$obj$iv.writeEndObject();
        $this$obj$iv = writer;
        fieldName$iv = "langLoading";
        $i$f$obj = false;
        it$iv = fieldName$iv;
        bl = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl4 = false;
        IElementType[] iElementTypeArray = IElementType.enumerate((IElementType.Predicate)IElementType.TRUE);
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"enumerate(...)");
        IElementType[] allTypes = iElementTypeArray;
        writer.writeNumberField("elementTypeCount", allTypes.length);
        $this$obj$iv.writeEndObject();
        $this$obj$iv = writer;
        fieldName$iv = "jvm";
        $i$f$obj = false;
        it$iv = fieldName$iv;
        bl = false;
        $this$obj$iv.writeFieldName(it$iv);
        $this$obj$iv.writeStartObject();
        boolean bl5 = false;
        long bootstrapTime = (StartUpMeasurer.getStartTimeUnixNanoDiff() + StartUpMeasurer.getStartTime()) / (long)1000000;
        writer.writeNumberField("loadingTime", bootstrapTime - ManagementFactory.getRuntimeMXBean().getStartTime());
        $this$obj$iv.writeEndObject();
        IdeIdeaFormatWriterKt.access$writeServiceStats(writer);
        IdeIdeaFormatWriterKt.access$writeIcons(writer);
    }

    private final Map<String, Long> getClassAndResourceLoadingStats() {
        Object $i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22;
        ClassLoader classLoader = IdeIdeaFormatWriter.class.getClassLoader();
        try {
            boolean $i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22 = false;
            $i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22 = Result.constructor-impl((Object)MethodHandles.lookup().findVirtual(classLoader.getClass(), "getLoadingStats", MethodType.methodType(Map.class)));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22);
        if (throwable != null) {
            Throwable throwable2;
            Throwable it = throwable2 = throwable;
            boolean bl = false;
            if (!(it instanceof IllegalAccessException)) {
                IdeIdeaFormatWriterKt.access$getLogger().info("Failed to get MethodHandle for getLoadingStats", it);
            }
            return MapsKt.emptyMap();
        }
        ResultKt.throwOnFailure((Object)$i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22);
        MethodHandle lookupResult = (MethodHandle)$i$a$-runCatching-IdeIdeaFormatWriter$getClassAndResourceLoadingStats$lookupResult$22;
        Map stats = lookupResult.bindTo(classLoader).invokeExact();
        Map map2 = ClassPath.getLoadingStats();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLoadingStats(...)");
        Map coreStats = map2;
        if (!Intrinsics.areEqual(coreStats.get("identity"), stats.get("identity"))) {
            for (Map.Entry entry : coreStats.entrySet()) {
                long v1;
                Long l = (Long)entry.getValue();
                if (l != null && (v1 = ((Number)MapsKt.getValue((Map)stats, entry.getKey())).longValue()) == l) continue;
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                stats.put(k, v1 + ((Number)v).longValue());
            }
        }
        return stats;
    }

    @Override
    protected long writeTotalDuration(@NotNull JsonGenerator writer, long end, long timeOffset) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        long totalDurationActual = super.writeTotalDuration(writer, end, timeOffset);
        this.publicStatMetrics.put((Object)"totalDuration", (int)totalDurationActual);
        return totalDurationActual;
    }

    @Override
    protected void beforeActivityWrite(@NotNull ActivityImpl item, long ownOrTotalDuration, @NotNull String fieldName) {
        block17: {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            String string = item.getPluginId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                Object object = item.getCategory();
                if (object == null || (object = object.name()) == null) {
                    object = "unknown";
                }
                StartUpMeasurer.doAddPluginCost((String)it, (String)object, (long)ownOrTotalDuration, this.pluginCostMap);
            }
            if (!Intrinsics.areEqual((Object)fieldName, (Object)"items")) break block17;
            String string2 = item.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            switch (string2) {
                case "splash initialization": {
                    ((Map)this.publicStatMetrics).put("splash", (int)TimeUnit.NANOSECONDS.toMillis(ownOrTotalDuration));
                    break;
                }
                case "app initialization": 
                case "bootstrap": {
                    String itemName;
                    ((Map)this.publicStatMetrics).put(itemName, (int)TimeUnit.NANOSECONDS.toMillis(ownOrTotalDuration));
                    break;
                }
                case "project frame initialization": {
                    ((Map)this.publicStatMetrics).put("projectFrameVisible", (int)TimeUnit.NANOSECONDS.toMillis(item.getStart() - StartUpMeasurer.getStartTime()));
                }
            }
        }
    }
}

