/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.ExposingCharArrayWriter;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.IdeaFormatWriterKt;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.ServiceReporterKt;
import com.intellij.util.system.OS;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B1\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJF\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0004J \u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0014J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J2\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010 \u001a\u00020\u0013H\u0002J\u0006\u0010!\u001a\u00020\"J\u0018\u0010#\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0002JL\u0010$\u001a\u00020\u00112\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010 \u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u00042\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00060'2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020*H\u0002J \u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00132\u0006\u0010%\u001a\u00020\u0004H\u0014R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006."}, d2={"Lcom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeaFormatWriter;", "", "activities", "", "", "", "Lcom/intellij/diagnostic/ActivityImpl;", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "version", "<init>", "(Ljava/util/Map;Lcom/intellij/diagnostic/ThreadNameManager;Ljava/lang/String;)V", "stringWriter", "Lcom/intellij/platform/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "getStringWriter", "()Lcom/intellij/platform/diagnostic/startUpPerformanceReporter/ExposingCharArrayWriter;", "write", "", "timeOffset", "", "serviceActivities", "instantEvents", "", "end", "projectName", "writeTotalDuration", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "writeProjectName", "writeExtraData", "writeAppInfo", "writeServiceEvents", "startTime", "toByteBuffer", "Ljava/nio/ByteBuffer;", "writeParallelActivities", "writeActivities", "fieldName", "ownDurations", "Lit/unimi/dsi/fastutil/objects/Object2LongMap;", "measureThreshold", "timeUnit", "Lkotlin/time/DurationUnit;", "beforeActivityWrite", "item", "ownOrTotalDuration", "intellij.platform.diagnostic.startUpPerformanceReporter"})
@SourceDebugExtension(value={"SMAP\nIdeaFormatWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeaFormatWriter\n+ 2 jackson.kt\ncom/intellij/util/io/jackson/JacksonUtil\n*L\n1#1,269:1\n11#2,6:270\n21#2,7:276\n17#2,2:283\n21#2,5:285\n11#2,8:290\n11#2,8:298\n26#2,2:306\n*S KotlinDebug\n*F\n+ 1 IdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeaFormatWriter\n*L\n40#1:270,6\n51#1:276,7\n40#1:283,2\n121#1:285,5\n139#1:290,8\n155#1:298,8\n121#1:306,2\n*E\n"})
public abstract class IdeaFormatWriter {
    @NotNull
    private final Map<String, List<ActivityImpl>> activities;
    @NotNull
    private final ThreadNameManager threadNameManager;
    @NotNull
    private final String version;
    @NotNull
    private final ExposingCharArrayWriter stringWriter;

    public IdeaFormatWriter(@NotNull Map<String, ? extends List<ActivityImpl>> activities2, @NotNull ThreadNameManager threadNameManager, @NotNull String version) {
        Intrinsics.checkNotNullParameter(activities2, (String)"activities");
        Intrinsics.checkNotNullParameter((Object)threadNameManager, (String)"threadNameManager");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.activities = activities2;
        this.threadNameManager = threadNameManager;
        this.version = version;
        this.stringWriter = new ExposingCharArrayWriter();
    }

    @NotNull
    protected final ExposingCharArrayWriter getStringWriter() {
        return this.stringWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void write(long timeOffset, @NotNull Map<String, ? extends List<ActivityImpl>> serviceActivities, @NotNull List<ActivityImpl> instantEvents, long end, @NotNull String projectName) {
        Intrinsics.checkNotNullParameter(serviceActivities, (String)"serviceActivities");
        Intrinsics.checkNotNullParameter(instantEvents, (String)"instantEvents");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        JsonGenerator writer = IdeaFormatWriterKt.createJsonGenerator(this.stringWriter);
        Closeable closeable = (Closeable)writer;
        Throwable throwable = null;
        try {
            void $this$array$iv;
            JsonGenerator it = (JsonGenerator)closeable;
            boolean bl = false;
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl2 = false;
            writer.writeStringField("version", this.version);
            this.writeAppInfo(writer);
            writer.writeStringField("generated", ZonedDateTime.now().format(DateTimeFormatter.RFC_1123_DATE_TIME));
            writer.writeStringField("os", OS.CURRENT.name() + " " + OS.CURRENT.version());
            writer.writeStringField("runtime", SystemInfo.JAVA_VENDOR + " " + SystemInfo.JAVA_VERSION + " " + SystemInfo.JAVA_RUNTIME_VERSION);
            this.writeProjectName(writer, projectName);
            this.writeExtraData(writer);
            this.writeParallelActivities(timeOffset, writer);
            JsonGenerator jsonGenerator = writer;
            String fieldName$iv2 = "traceEvents";
            boolean $i$f$array = false;
            String it$iv = fieldName$iv2;
            boolean bl3 = false;
            $this$array$iv.writeFieldName(it$iv);
            $this$array$iv.writeStartArray();
            boolean bl4 = false;
            IdeaFormatWriterKt.access$writeInstantEvents(writer, instantEvents, timeOffset, this.threadNameManager);
            $this$array$iv.writeEndArray();
            this.writeServiceEvents(writer, serviceActivities, timeOffset);
            this.writeTotalDuration(writer, end, timeOffset);
            $this$obj_u24default$iv.writeEndObject();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    protected long writeTotalDuration(@NotNull JsonGenerator writer, long end, long timeOffset) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        long totalDurationActual = TimeUnit.NANOSECONDS.toMillis(end - timeOffset);
        writer.writeNumberField("totalDuration", totalDurationActual);
        return totalDurationActual;
    }

    protected void writeProjectName(@NotNull JsonGenerator writer, @NotNull String projectName) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        writer.writeStringField("project", projectName);
    }

    protected void writeExtraData(@NotNull JsonGenerator writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
    }

    protected void writeAppInfo(@NotNull JsonGenerator writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
    }

    private final void writeServiceEvents(JsonGenerator writer, Map<String, ? extends List<ActivityImpl>> serviceActivities, long startTime) {
        Comparator comparator = IdeaFormatWriterKt::access$compareTime;
        for (String name2 : CollectionsKt.sorted((Iterable)serviceActivities.keySet())) {
            List list2 = CollectionsKt.sortedWith((Iterable)((Iterable)MapsKt.getValue(serviceActivities, (Object)name2)), (Comparator)comparator);
            Object2LongMap<ActivityImpl> ownDurations = ServiceReporterKt.computeOwnTime(list2, this.threadNameManager);
            this.writeActivities(list2, startTime, writer, name2, ownDurations, 0L, DurationUnit.MICROSECONDS);
        }
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        return this.stringWriter.toByteBuffer();
    }

    private final void writeParallelActivities(long startTime, JsonGenerator writer) {
        for (Map.Entry<String, List<ActivityImpl>> entry : this.activities.entrySet()) {
            String name2 = entry.getKey();
            List<ActivityImpl> list2 = entry.getValue();
            CollectionsKt.sortWith(list2, IdeaFormatWriterKt.getItemComparator());
            long measureThreshold = Intrinsics.areEqual((Object)name2, (Object)ActivityCategory.DEFAULT.getJsonName()) ? -1L : StartUpMeasurer.MEASURE_THRESHOLD;
            Object2LongOpenHashMap ownDurations = new Object2LongOpenHashMap();
            ownDurations.defaultReturnValue(-1L);
            this.writeActivities(list2, startTime, writer, IdeaFormatWriterKt.access$activityNameToJsonFieldName(name2), (Object2LongMap<ActivityImpl>)((Object2LongMap)ownDurations), measureThreshold, DurationUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeActivities(List<ActivityImpl> activities2, long startTime, JsonGenerator writer, String fieldName, Object2LongMap<ActivityImpl> ownDurations, long measureThreshold, DurationUnit timeUnit) {
        void $this$array$iv;
        if (activities2.isEmpty()) {
            return;
        }
        JsonGenerator jsonGenerator = writer;
        String fieldName$iv = fieldName;
        boolean $i$f$array = false;
        String string = fieldName$iv;
        if (string != null) {
            String it$iv = string;
            boolean bl = false;
            $this$array$iv.writeFieldName(it$iv);
        }
        $this$array$iv.writeStartArray();
        boolean bl = false;
        long skippedDuration = 0L;
        for (ActivityImpl item : activities2) {
            long ownDuration = ownDurations.getLong((Object)item);
            long ownOrTotalDuration = ownDuration == -1L ? item.getEnd() - item.getStart() : ownDuration;
            this.beforeActivityWrite(item, ownOrTotalDuration, fieldName);
            if (ownOrTotalDuration <= measureThreshold) {
                skippedDuration += ownOrTotalDuration;
                continue;
            }
            long convertedDuration = Duration.toLong-impl((long)DurationKt.toDuration((long)(item.getEnd() - item.getStart()), (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)timeUnit);
            if (convertedDuration == 0L) {
                String string2 = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string2, (String)": completing", (boolean)false, (int)2, null)) continue;
                String string3 = item.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string3, (String)": scheduled", (boolean)false, (int)2, null)) continue;
            }
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv2 = null;
            boolean $i$f$obj = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl2 = false;
            String string4 = item.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            writer.writeStringField("n", IdeaFormatWriterKt.access$compactName(string4));
            writer.writeNumberField("s", Duration.toLong-impl((long)DurationKt.toDuration((long)(item.getStart() - startTime), (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)timeUnit));
            writer.writeNumberField("d", convertedDuration);
            if (ownDuration != -1L) {
                writer.writeNumberField("od", Duration.toLong-impl((long)DurationKt.toDuration((long)ownDuration, (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)timeUnit));
            }
            writer.writeStringField("t", this.threadNameManager.getThreadName(item));
            if (item.getPluginId() != null) {
                writer.writeStringField("p", item.getPluginId());
            }
            $this$obj_u24default$iv.writeEndObject();
        }
        if (skippedDuration > 0L) {
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv3 = null;
            boolean $i$f$obj = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl3 = false;
            writer.writeStringField("n", "Other");
            writer.writeNumberField("d", Duration.toLong-impl((long)DurationKt.toDuration((long)skippedDuration, (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)timeUnit));
            writer.writeNumberField("s", Duration.toLong-impl((long)DurationKt.toDuration((long)(((ActivityImpl)CollectionsKt.last(activities2)).getStart() - startTime), (DurationUnit)DurationUnit.NANOSECONDS), (DurationUnit)timeUnit));
            $this$obj_u24default$iv.writeEndObject();
        }
        $this$array$iv.writeEndArray();
    }

    protected void beforeActivityWrite(@NotNull ActivityImpl item, long ownOrTotalDuration, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
    }
}

