/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.diagnostic.startUpPerformanceReporter;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.ActivityImpl;
import com.intellij.diagnostic.ThreadNameManager;
import com.intellij.platform.diagnostic.startUpPerformanceReporter.MyJsonPrettyPrinter;
import java.io.Writer;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a.\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a(\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u001a\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\fH\u0002\" \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0017j\b\u0012\u0004\u0012\u00020\f`\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001f"}, d2={"activityNameToJsonFieldName", "", "name", "packageNameReplacements", "", "Lkotlin/Pair;", "compactName", "writeInstantEvents", "", "writer", "Lcom/fasterxml/jackson/core/JsonGenerator;", "instantEvents", "Lcom/intellij/diagnostic/ActivityImpl;", "timeOffset", "", "threadNameManager", "Lcom/intellij/diagnostic/ThreadNameManager;", "writeCommonFields", "event", "createJsonGenerator", "output", "Ljava/io/Writer;", "itemComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getItemComparator", "()Ljava/util/Comparator;", "compareTime", "", "o1", "o2", "intellij.platform.diagnostic.startUpPerformanceReporter"})
@SourceDebugExtension(value={"SMAP\nIdeaFormatWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeaFormatWriterKt\n+ 2 jackson.kt\ncom/intellij/util/io/jackson/JacksonUtil\n*L\n1#1,269:1\n11#2,8:270\n*S KotlinDebug\n*F\n+ 1 IdeaFormatWriter.kt\ncom/intellij/platform/diagnostic/startUpPerformanceReporter/IdeaFormatWriterKt\n*L\n192#1:270,8\n*E\n"})
public final class IdeaFormatWriterKt {
    @NotNull
    private static final List<Pair<String, String>> packageNameReplacements;
    @NotNull
    private static final Comparator<ActivityImpl> itemComparator;

    private static final String activityNameToJsonFieldName(String name2) {
        return switch (StringsKt.last((CharSequence)name2)) {
            case 'y' -> {
                String v0 = name2.substring(0, name2.length() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"substring(...)");
                yield v0 + "ies";
            }
            case 's' -> name2;
            default -> {
                String v2 = name2.substring(0);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                yield v2 + "s";
            }
        };
    }

    private static final String compactName(String name2) {
        for (Pair<String, String> replacement : packageNameReplacements) {
            if (!StringsKt.startsWith$default((String)name2, (String)((String)replacement.getFirst()), (boolean)false, (int)2, null)) continue;
            Object object = replacement.getSecond();
            String string = name2.substring(((String)replacement.getFirst()).length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return object + string;
        }
        return name2;
    }

    private static final void writeInstantEvents(JsonGenerator writer, List<ActivityImpl> instantEvents, long timeOffset, ThreadNameManager threadNameManager) {
        for (ActivityImpl event : instantEvents) {
            JsonGenerator $this$obj_u24default$iv = writer;
            Object fieldName$iv = null;
            boolean $i$f$obj = false;
            $this$obj_u24default$iv.writeStartObject();
            boolean bl = false;
            IdeaFormatWriterKt.writeCommonFields(event, writer, timeOffset, threadNameManager);
            writer.writeStringField("ph", "i");
            writer.writeStringField("s", "g");
            $this$obj_u24default$iv.writeEndObject();
        }
    }

    private static final void writeCommonFields(ActivityImpl event, JsonGenerator writer, long timeOffset, ThreadNameManager threadNameManager) {
        block0: {
            writer.writeStringField("name", event.getName());
            writer.writeNumberField("ts", TimeUnit.NANOSECONDS.toMicros(event.getStart() - timeOffset));
            writer.writeNumberField("pid", 1);
            writer.writeStringField("tid", threadNameManager.getThreadName(event));
            ActivityCategory activityCategory = event.getCategory();
            if (activityCategory == null) break block0;
            ActivityCategory it = activityCategory;
            boolean bl = false;
            writer.writeStringField("cat", it.getJsonName());
        }
    }

    @NotNull
    public static final JsonGenerator createJsonGenerator(@NotNull Writer output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        JsonGenerator writer = new JsonFactory().createGenerator(output);
        writer.setPrettyPrinter((PrettyPrinter)new MyJsonPrettyPrinter());
        Intrinsics.checkNotNull((Object)writer);
        return writer;
    }

    @NotNull
    public static final Comparator<ActivityImpl> getItemComparator() {
        return itemComparator;
    }

    private static final int compareTime(ActivityImpl o1, ActivityImpl o2) {
        return o1.getStart() > o2.getStart() ? 1 : (o1.getStart() < o2.getStart() ? -1 : (o1.getEnd() > o2.getEnd() ? -1 : (o1.getEnd() < o2.getEnd() ? 1 : 0)));
    }

    private static final int itemComparator$lambda$0(ActivityImpl o1, ActivityImpl o2) {
        if (Intrinsics.areEqual((Object)o1, (Object)o2.getParent())) {
            return -1;
        }
        if (Intrinsics.areEqual((Object)o2, (Object)o1.getParent())) {
            return 1;
        }
        Intrinsics.checkNotNull((Object)o1);
        Intrinsics.checkNotNull((Object)o2);
        return IdeaFormatWriterKt.compareTime(o1, o2);
    }

    public static final /* synthetic */ int access$compareTime(ActivityImpl o1, ActivityImpl o2) {
        return IdeaFormatWriterKt.compareTime(o1, o2);
    }

    public static final /* synthetic */ String access$activityNameToJsonFieldName(String name2) {
        return IdeaFormatWriterKt.activityNameToJsonFieldName(name2);
    }

    public static final /* synthetic */ void access$writeInstantEvents(JsonGenerator writer, List instantEvents, long timeOffset, ThreadNameManager threadNameManager) {
        IdeaFormatWriterKt.writeInstantEvents(writer, instantEvents, timeOffset, threadNameManager);
    }

    public static final /* synthetic */ String access$compactName(String name2) {
        return IdeaFormatWriterKt.compactName(name2);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"com.intellij.", (Object)"c.i."), TuplesKt.to((Object)"org.jetbrains.", (Object)"o.j.")};
        packageNameReplacements = CollectionsKt.listOf((Object[])objectArray);
        itemComparator = IdeaFormatWriterKt::itemComparator$lambda$0;
    }
}

