/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.core.nio.fs.BasicFileAttributesHolder2;
import com.intellij.platform.eel.EelOsFamily;
import com.intellij.platform.eel.EelPlatformKt;
import com.intellij.platform.eel.EelResult;
import com.intellij.platform.eel.EelUserPosixInfo;
import com.intellij.platform.eel.OwnedBuilder;
import com.intellij.platform.eel.fs.EelFileInfo;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpers;
import com.intellij.platform.eel.fs.EelFileSystemApiHelpersKt;
import com.intellij.platform.eel.fs.EelFileSystemPosixApi;
import com.intellij.platform.eel.fs.EelFileSystemPosixApiHelpersKt;
import com.intellij.platform.eel.fs.EelFsError;
import com.intellij.platform.eel.fs.EelPosixFileInfo;
import com.intellij.platform.eel.fs.EelPosixFileInfoImpl;
import com.intellij.platform.eel.fs.EelWindowsFileInfo;
import com.intellij.platform.eel.impl.fs.EelFsResultImpl;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.eel.provider.utils.EelUtilsKt;
import com.intellij.platform.ijent.community.impl.nio.AbsoluteIjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.EelPosixGroupPrincipal;
import com.intellij.platform.ijent.community.impl.nio.EelPosixUserPrincipal;
import com.intellij.platform.ijent.community.impl.nio.IjentNioBasicFileAttributeView;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileChannel;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileStore;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystem;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProvider;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemProviderKt;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystemUtil;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPosixFileAttributeView;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPosixFileAttributes;
import com.intellij.platform.ijent.community.impl.nio.RelativeIjentNioPath;
import com.intellij.platform.ijent.fs.IjentFileSystemApi;
import com.intellij.platform.ijent.fs.IjentFileSystemPosixApi;
import com.intellij.platform.ijent.fs.IjentFileSystemWindowsApi;
import com.intellij.util.io.PosixFilePermissionsUtil;
import com.intellij.util.text.StringKt;
import com.sun.nio.file.ExtendedCopyOption;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmInline;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f1\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0006\u0018\u0000 i2\u00020\u0001:\u0002ijB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0010\u0010\u000e\u001a\f\u0012\u0004\u0012\u00020\t\u0012\u0002\b\u00030\u000fH\u0016J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0016J?\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u001a\u0010\u001c\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d\"\u0006\u0012\u0002\b\u00030\u001eH\u0016\u00a2\u0006\u0002\u0010\u001fJ?\u0010 \u001a\u00020!2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u001a\u0010\u001c\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001d\"\u0006\u0012\u0002\b\u00030\u001eH\u0016\u00a2\u0006\u0002\u0010\"J!\u0010#\u001a\u00020$2\u0012\u0010\u001c\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u001e0\u001dH\u0002\u00a2\u0006\u0002\u0010%J(\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00130'2\u0006\u0010(\u001a\u00020\u00132\u0010\u0010)\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0013\u0018\u00010*H\u0016J5\u0010+\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00132\u001e\u0010\u001c\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001e0\u001d\"\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J1\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00132\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u0002010\u001d\"\u000201H\u0016\u00a2\u0006\u0002\u00102J5\u00103\u001a\u00020$2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00132\u0016\u0010\u0019\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001010\u001d\"\u0004\u0018\u000101H\u0016\u00a2\u0006\u0002\u00102J\u0018\u00104\u001a\u0002052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u0013H\u0016J\u0010\u00107\u001a\u0002052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J)\u0010:\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010;\u001a\n\u0012\u0006\b\u0001\u0012\u00020<0\u001d\"\u00020<H\u0016\u00a2\u0006\u0002\u0010=JG\u0010>\u001a\u0004\u0018\u0001H?\"\n\b\u0000\u0010?*\u0004\u0018\u00010@2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010A\u001a\n\u0012\u0004\u0012\u0002H?\u0018\u00010B2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0\u001d\"\u00020CH\u0016\u00a2\u0006\u0002\u0010DJA\u0010E\u001a\u0002HF\"\b\b\u0000\u0010F*\u00020G2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010A\u001a\b\u0012\u0004\u0012\u0002HF0B2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0\u001d\"\u00020CH\u0016\u00a2\u0006\u0002\u0010HJ=\u0010E\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020J0I2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\t2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0\u001d\"\u00020CH\u0016\u00a2\u0006\u0002\u0010LJ\"\u0010M\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0O0N2\u0006\u0010P\u001a\u00020\tH\u0002J9\u0010Q\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010R\u001a\u00020\t2\u0006\u0010S\u001a\u00020J2\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020C0\u001d\"\u00020CH\u0016\u00a2\u0006\u0002\u0010TJS\u0010U\u001a\u00020V2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0010\u0010\u0019\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u001b\u0018\u00010W2\b\u0010X\u001a\u0004\u0018\u00010Y2\u001e\u0010\u001c\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001e0\u001d\"\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010ZJ=\u0010[\u001a\u00020$2\u0006\u0010\\\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u00132\u001e\u0010\u001c\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001e0\u001d\"\b\u0012\u0002\b\u0003\u0018\u00010\u001eH\u0016\u00a2\u0006\u0002\u0010]J\u001c\u0010^\u001a\u00020$2\b\u0010\\\u001a\u0004\u0018\u00010\u00132\b\u0010_\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010`\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020\u0013H\u0016J\u0015\u0010a\u001a\u00020$2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\bbJ\u0017\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\beJ\u001d\u0010f\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u0082\u0002\n\n\b\b\u0000\u001a\u0004\u0010\u0001(\u0000J\u001d\u0010g\u001a\u00020h2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u0082\u0002\n\n\b\b\u0000\u001a\u0004\u0010\u0001(\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00f2\u0001\b\n\u00020\u0016\n\u00020h\u00a8\u0006k"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider;", "Ljava/nio/file/spi/FileSystemProvider;", "<init>", "()V", "criticalSection", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$CriticalSection;", "com/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$criticalSection$1", "Ljava/lang/Object;", "getScheme", "", "newFileSystem", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem;", "uri", "Ljava/net/URI;", "env", "", "getUriParts", "", "path", "Ljava/nio/file/Path;", "getFileSystem", "getPath", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "newByteChannel", "Ljava/nio/channels/SeekableByteChannel;", "options", "", "Ljava/nio/file/OpenOption;", "attrs", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", "newFileChannel", "Ljava/nio/channels/FileChannel;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/FileChannel;", "validateAttributes", "", "([Ljava/nio/file/attribute/FileAttribute;)V", "newDirectoryStream", "Ljava/nio/file/DirectoryStream;", "dir", "pathFilter", "Ljava/nio/file/DirectoryStream$Filter;", "createDirectory", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "copy", "source", "target", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "move", "isSameFile", "", "path2", "isHidden", "getFileStore", "Ljava/nio/file/FileStore;", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)V", "getFileAttributeView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "type", "Ljava/lang/Class;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "", "attributes", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "parseAttributesParameter", "Lkotlin/Pair;", "", "parameter", "setAttribute", "attribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)V", "newAsynchronousFileChannel", "Ljava/nio/channels/AsynchronousFileChannel;", "", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/nio/file/Path;Ljava/util/Set;Ljava/util/concurrent/ExecutorService;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;", "createSymbolicLink", "link", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "createLink", "existing", "readSymbolicLink", "close", "close$intellij_platform_ijent_community_impl", "ijentFsApi", "Lcom/intellij/platform/ijent/fs/IjentFileSystemApi;", "ijentFsApi$intellij_platform_ijent_community_impl", "ensureIjentNioPath", "ensureAbsoluteIjentNioPath", "Lcom/intellij/platform/ijent/community/impl/nio/AbsoluteIjentNioPath;", "Companion", "CriticalSection", "intellij.platform.ijent.community.impl"})
@SourceDebugExtension(value={"SMAP\nIjentNioFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentNioFileSystemProvider.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider\n+ 2 IjentNioFileSystemProvider.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$CriticalSection\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,610:1\n63#2,3:611\n63#2,2:614\n65#2:618\n63#2,3:628\n63#2,3:631\n295#3,2:616\n1#4:619\n23#5:620\n488#6,7:621\n*S KotlinDebug\n*F\n+ 1 IjentNioFileSystemProvider.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider\n*L\n96#1:611,3\n121#1:614,2\n121#1:618\n568#1:628,3\n574#1:631,3\n122#1:616,2\n289#1:620\n438#1:621,7\n*E\n"})
public final class IjentNioFileSystemProvider
extends FileSystemProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object criticalSection = CriticalSection.constructor-impl(new Object(){
        private final Map<URI, IjentFileSystemApi> authorityRegistry;
        {
            this.authorityRegistry = new HashMap<K, V>();
        }

        public final Map<URI, IjentFileSystemApi> getAuthorityRegistry() {
            return this.authorityRegistry;
        }
    });
    @NotNull
    private static final String SCHEME = "ijent";
    @NotNull
    private static final String KEY_IJENT_FS = "ijentFs";

    @Override
    @NotNull
    public String getScheme() {
        return SCHEME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IjentNioFileSystem newFileSystem(@NotNull URI uri, @NotNull Map<String, ?> env) {
        IjentFileSystemApi ijentFileSystemApi;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        URI uri2 = uri.normalize();
        CharSequence charSequence = uri2.getAuthority();
        if (charSequence == null || charSequence.length() == 0 || !Intrinsics.areEqual((Object)uri2.getScheme(), (Object)this.getScheme()) || !((charSequence = (CharSequence)uri2.getQuery()) == null || charSequence.length() == 0) || !((charSequence = (CharSequence)uri2.getFragment()) == null || charSequence.length() == 0)) {
            throw new UnsupportedOperationException(uri2.toString() + " doesn't look like a proper URL for " + Reflection.getOrCreateKotlinClass(IjentNioFileSystemProvider.class).getSimpleName());
        }
        try {
            Object obj2 = env.get(KEY_IJENT_FS);
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type com.intellij.platform.ijent.fs.IjentFileSystemApi");
            ijentFileSystemApi = (IjentFileSystemApi)obj2;
        }
        catch (Exception err) {
            Exception exception = err;
            throw exception instanceof NullPointerException || exception instanceof ClassCastException ? (Throwable)new IllegalArgumentException("Invalid map. `IjentNioFileSystemProvider.newFileSystemMap` should be used for map creation.") : (Throwable)err;
        }
        IjentFileSystemApi ijentFs = ijentFileSystemApi;
        Intrinsics.checkNotNull((Object)uri2);
        Collection<URI> uriParts = this.getUriParts(uri2);
        Object object = this.criticalSection;
        boolean bl = false;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2 = false;
            criticalSection.1 $this$newFileSystem_u24lambda_u240 = object;
            boolean bl3 = false;
            for (URI uriPart : uriParts) {
                if (!$this$newFileSystem_u24lambda_u240.getAuthorityRegistry().containsKey(uriPart)) continue;
                throw new FileSystemAlreadyExistsException("`" + uri2 + "` can't be registered because there's an already registered as IJent FS provider `" + uriPart + "`");
            }
            $this$newFileSystem_u24lambda_u240.getAuthorityRegistry().put(uri2, ijentFs);
            Unit unit = Unit.INSTANCE;
        }
        return new IjentNioFileSystem(this, uri2);
    }

    private final Collection<URI> getUriParts(URI uri) {
        String string = uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return CollectionsKt.asReversed((List)SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)SequencesKt.map((Sequence)SequencesKt.mapIndexedNotNull((Sequence)StringsKt.asSequence((CharSequence)string), IjentNioFileSystemProvider::getUriParts$lambda$0), arg_0 -> IjentNioFileSystemProvider.getUriParts$lambda$1(uri, arg_0)), (Sequence)SequencesKt.sequenceOf((Object)uri))));
    }

    @Override
    @NotNull
    public IjentNioFileSystem newFileSystem(@NotNull Path path, @NotNull Map<String, ?> env) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        URI uRI = path.toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return this.newFileSystem(uRI, (Map)env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IjentNioFileSystem getFileSystem(@NotNull URI uri) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        URI uRI2 = uri.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"normalize(...)");
        Collection<URI> uriParts = this.getUriParts(uRI2);
        Object object = this.criticalSection;
        boolean bl = false;
        Object object2 = object;
        synchronized (object2) {
            Object v1;
            block5: {
                boolean bl2 = false;
                criticalSection.1 $this$getFileSystem_u24lambda_u240 = object;
                boolean bl3 = false;
                Iterable $this$firstOrNull$iv = uriParts;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    URI it = (URI)element$iv;
                    boolean bl4 = false;
                    if (!$this$getFileSystem_u24lambda_u240.getAuthorityRegistry().containsKey(it)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            uRI = v1;
        }
        URI matchingUri = uRI;
        if (matchingUri != null) {
            return new IjentNioFileSystem(this, matchingUri);
        }
        throw new FileSystemNotFoundException("`" + uri + "` is not registered as IJent FS provider");
    }

    @Override
    @NotNull
    public IjentNioPath getPath(@NotNull URI uri) {
        String string;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        IjentNioFileSystem nioFs = this.getFileSystem(uri);
        URI relativeUri = nioFs.getUri$intellij_platform_ijent_community_impl().relativize(uri);
        IjentFileSystemApi ijentFileSystemApi = nioFs.getIjentFs();
        if (ijentFileSystemApi instanceof IjentFileSystemPosixApi) {
            string = StringKt.nullize$default((String)relativeUri.getPath(), (boolean)false, (int)1, null);
            if (string == null) {
                string = "/";
            }
        } else if (ijentFileSystemApi instanceof IjentFileSystemWindowsApi) {
            String string2 = relativeUri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            char[] cArray = new char[]{'/'};
            string = StringsKt.trimStart((String)string2, (char[])cArray);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nioFs.getPath(string, new String[0]);
    }

    @Override
    @NotNull
    public SeekableByteChannel newByteChannel(@NotNull Path path, @NotNull Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        return this.newFileChannel(path, options2, Arrays.copyOf(attrs, attrs.length));
    }

    @Override
    @NotNull
    public FileChannel newFileChannel(@NotNull Path path, @NotNull Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) {
        FileChannel fileChannel;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.ensureIjentNioPath(path);
        if (!(path instanceof AbsoluteIjentNioPath)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.validateAttributes(attrs);
        IjentNioFileSystem fs = ((AbsoluteIjentNioPath)path).getNioFs$intellij_platform_ijent_community_impl();
        if (!(!options2.contains(StandardOpenOption.READ) || !options2.contains(StandardOpenOption.APPEND))) {
            boolean $i$a$-require-IjentNioFileSystemProvider$newFileChannel$32 = false;
            String $i$a$-require-IjentNioFileSystemProvider$newFileChannel$32 = "READ + APPEND not allowed";
            throw new IllegalArgumentException($i$a$-require-IjentNioFileSystemProvider$newFileChannel$32.toString());
        }
        if (!(!options2.contains(StandardOpenOption.APPEND) || !options2.contains(StandardOpenOption.TRUNCATE_EXISTING))) {
            boolean bl = false;
            String string = "APPEND + TRUNCATE_EXISTING not allowed";
            throw new IllegalArgumentException(string.toString());
        }
        if (options2.contains(StandardOpenOption.WRITE) || options2.contains(StandardOpenOption.APPEND)) {
            if (options2.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
                String string = "WRITE + CREATE_NEW";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (options2.contains(LinkOption.NOFOLLOW_LINKS)) {
                String string = "WRITE + NOFOLLOW_LINKS";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            EelFileSystemApi.WriteOptions writeOptions = EelFileSystemApi.WriteOptions.Companion.Builder(((AbsoluteIjentNioPath)path).getEelPath()).append(options2.contains(StandardOpenOption.APPEND)).truncateExisting(options2.contains(StandardOpenOption.TRUNCATE_EXISTING)).creationMode(options2.contains(StandardOpenOption.CREATE_NEW) ? EelFileSystemApi.FileWriterCreationMode.ONLY_CREATE : (options2.contains(StandardOpenOption.CREATE) ? EelFileSystemApi.FileWriterCreationMode.ALLOW_CREATE : EelFileSystemApi.FileWriterCreationMode.ONLY_OPEN_EXISTING)).build();
            fileChannel = (FileChannel)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super IjentNioFileChannel>, Object>(options2, fs, writeOptions, null){
                int label;
                final /* synthetic */ Set<OpenOption> $options;
                final /* synthetic */ IjentNioFileSystem $fs;
                final /* synthetic */ EelFileSystemApi.WriteOptions $writeOptions;
                {
                    this.$options = $options;
                    this.$fs = $fs;
                    this.$writeOptions = $writeOptions;
                    super(1, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            if (!this.$options.contains(StandardOpenOption.READ)) break;
                            this.label = 1;
                            v0 = IjentNioFileChannel.Companion.createReadingWriting$intellij_platform_ijent_community_impl(this.$fs, this.$writeOptions, (Continuation<? super IjentNioFileChannel>)((Continuation)this));
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl14
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl14:
                            // 2 sources

                            v1 = (IjentNioFileChannel)v0;
                            ** GOTO lbl25
                        }
                    }
                    this.label = 2;
                    v2 = IjentNioFileChannel.Companion.createWriting$intellij_platform_ijent_community_impl(this.$fs, this.$writeOptions, (Continuation<? super IjentNioFileChannel>)((Continuation)this));
                    if (v2 == var2_2) {
                        return var2_2;
                    }
                    ** GOTO lbl24
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl24:
                            // 2 sources

                            v1 = (IjentNioFileChannel)v2;
lbl25:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super IjentNioFileChannel> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            });
        } else {
            if (options2.contains(StandardOpenOption.CREATE)) {
                String string = "READ + CREATE";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (options2.contains(StandardOpenOption.CREATE_NEW)) {
                String string = "READ + CREATE_NEW";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (options2.contains(StandardOpenOption.DELETE_ON_CLOSE)) {
                String string = "READ + CREATE_NEW";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            if (options2.contains(LinkOption.NOFOLLOW_LINKS)) {
                String string = "READ + NOFOLLOW_LINKS";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            fileChannel = (FileChannel)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super IjentNioFileChannel>, Object>(fs, path, null){
                int label;
                final /* synthetic */ IjentNioFileSystem $fs;
                final /* synthetic */ Path $path;
                {
                    this.$fs = $fs;
                    this.$path = $path;
                    super(1, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = IjentNioFileChannel.Companion.createReading$intellij_platform_ijent_community_impl(this.$fs, ((AbsoluteIjentNioPath)this.$path).getEelPath(), (Continuation<? super IjentNioFileChannel>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(Continuation<? super IjentNioFileChannel> p1) {
                    return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                }
            });
        }
        return fileChannel;
    }

    private final void validateAttributes(FileAttribute<?>[] attrs) {
        for (FileAttribute<?> attribute : attrs) {
            String string = attribute.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
            Pair<String, List<String>> pair = this.parseAttributesParameter(string);
            String viewName = (String)pair.component1();
            List paramName = (List)pair.component2();
            if (Intrinsics.areEqual((Object)viewName, (Object)"posix") && Intrinsics.areEqual((Object)paramName, (Object)CollectionsKt.listOf((Object)"permissions"))) continue;
            throw new UnsupportedOperationException("Cannot create file with atomically set parameter " + paramName);
        }
    }

    @Override
    @NotNull
    public DirectoryStream<Path> newDirectoryStream(@NotNull Path dir, @Nullable DirectoryStream.Filter<? super Path> pathFilter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.ensureAbsoluteIjentNioPath(dir);
        IjentNioFileSystem nioFs = ((AbsoluteIjentNioPath)dir).getNioFs$intellij_platform_ijent_community_impl();
        return (DirectoryStream)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super newDirectoryStream.1>, Object>(pathFilter, nioFs, dir, null){
            int label;
            final /* synthetic */ DirectoryStream.Filter<? super Path> $pathFilter;
            final /* synthetic */ IjentNioFileSystem $nioFs;
            final /* synthetic */ Path $dir;
            {
                this.$pathFilter = $pathFilter;
                this.$nioFs = $nioFs;
                this.$dir = $dir;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!BasicFileAttributesHolder2.FetchAttributesFilter.isFetchAttributesFilter(this.$pathFilter)) break;
                        this.label = 1;
                        v0 = this.$nioFs.getIjentFs().listDirectoryWithAttrs(((AbsoluteIjentNioPath)this.$dir).getEelPath(), EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE, (Continuation)this);
                        if (v0 == var12_2) {
                            return var12_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        v1 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v0)))), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.nio.file.Path com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystem kotlin.Pair ), (Lkotlin/Pair;)Lcom/intellij/platform/ijent/community/impl/nio/AbsoluteIjentNioPath;)((Path)this.$dir, (IjentNioFileSystem)this.$nioFs));
                        ** GOTO lbl25
                    }
                }
                this.label = 2;
                v2 = this.$nioFs.getIjentFs().listDirectory(((AbsoluteIjentNioPath)this.$dir).getEelPath(), (Continuation)this);
                if (v2 == var12_2) {
                    return var12_2;
                }
                ** GOTO lbl24
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl24:
                        // 2 sources

                        v1 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v2)))), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(java.nio.file.Path com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystem java.lang.String ), (Ljava/lang/String;)Lcom/intellij/platform/ijent/community/impl/nio/AbsoluteIjentNioPath;)((Path)this.$dir, (IjentNioFileSystem)this.$nioFs));
lbl25:
                        // 2 sources

                        var4_4 = notFilteredPaths = v1;
                        var5_5 = new ArrayList<E>();
                        var6_6 = this.$pathFilter;
                        $i$f$filterTo = false;
                        for (E element$iv : $this$filterTo$iv) {
                            nioPath = (AbsoluteIjentNioPath)element$iv;
                            $i$a$-filterTo-IjentNioFileSystemProvider$newDirectoryStream$1$nioPathList$1 = false;
                            v3 = var6_6;
                            v4 = v3 != null ? !v3.accept(nioPath) : false;
                            if (!(v4 == false)) continue;
                            destination$iv.add(element$iv);
                        }
                        nioPathList = (List)destination$iv;
                        return new DirectoryStream<Path>((List<AbsoluteIjentNioPath>)nioPathList){
                            final /* synthetic */ List<AbsoluteIjentNioPath> $nioPathList;
                            {
                                this.$nioPathList = $nioPathList;
                            }

                            public Iterator<Path> iterator() {
                                return this.$nioPathList.iterator();
                            }

                            public void close() {
                            }
                        };
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super newDirectoryStream.1> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }

            private static final AbsoluteIjentNioPath invokeSuspend$lambda$0(Path $dir, IjentNioFileSystem $nioFs, Pair pair) {
                String childName = (String)pair.component1();
                EelFileInfo childStat = (EelFileInfo)pair.component2();
                EelPath childIjentPath = ((AbsoluteIjentNioPath)$dir).getEelPath().getChild(childName);
                EelFileInfo eelFileInfo = childStat;
                if (!(eelFileInfo instanceof EelPosixFileInfo)) {
                    if (eelFileInfo instanceof EelWindowsFileInfo) {
                        throw new NotImplementedError(null, 1, null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                IjentNioPosixFileAttributes childAttrs = new IjentNioPosixFileAttributes((EelPosixFileInfo)childStat);
                return new AbsoluteIjentNioPath(childIjentPath, $nioFs, childAttrs);
            }

            private static final AbsoluteIjentNioPath invokeSuspend$lambda$1(Path $dir, IjentNioFileSystem $nioFs, String childName) {
                EelPath childIjentPath = ((AbsoluteIjentNioPath)$dir).getEelPath().getChild(childName);
                return new AbsoluteIjentNioPath(childIjentPath, $nioFs, null);
            }
        });
    }

    @Override
    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        try {
            this.ensureAbsoluteIjentNioPath(dir);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        EelPath path = ((AbsoluteIjentNioPath)dir).getEelPath();
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(dir, path, null){
            Object L$0;
            int label;
            final /* synthetic */ Path $dir;
            final /* synthetic */ EelPath $path;
            {
                this.$dir = $dir;
                this.$path = $path;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block6: {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            fsApi = ((AbsoluteIjentNioPath)this.$dir).getNioFs$intellij_platform_ijent_community_impl().getIjentFs();
                            if (!(fsApi instanceof IjentFileSystemPosixApi)) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)fsApi);
                            this.label = 1;
                            v0 = ((IjentFileSystemPosixApi)fsApi).createDirectory(this.$path, CollectionsKt.emptyList(), (Continuation)this);
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            fsApi = (IjentFileSystemApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v0));
                            break block6;
                        }
                    }
                    if (fsApi instanceof IjentFileSystemWindowsApi) {
                        throw new NotImplementedError(null, 1, null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.ensureAbsoluteIjentNioPath(path);
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(path, null){
            int label;
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = ((AbsoluteIjentNioPath)this.$path).getNioFs$intellij_platform_ijent_community_impl().getIjentFs().delete(((AbsoluteIjentNioPath)this.$path).getEelPath(), false, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void copy(@NotNull Path source, @NotNull Path target, CopyOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        if (ArraysKt.contains((Object[])options2, (Object)StandardCopyOption.ATOMIC_MOVE)) {
            throw new UnsupportedOperationException("Unsupported copy option");
        }
        this.ensureAbsoluteIjentNioPath(source);
        this.ensureAbsoluteIjentNioPath(target);
        EelPath sourcePath = ((AbsoluteIjentNioPath)source).getEelPath();
        EelPath targetPath = ((AbsoluteIjentNioPath)target).getEelPath();
        IjentFileSystemApi fs = ((AbsoluteIjentNioPath)source).getNioFs$intellij_platform_ijent_community_impl().getIjentFs();
        EelFileSystemApiHelpers.Copy copyOptions = EelFileSystemApiHelpersKt.copy((EelFileSystemApi)fs, (EelPath)sourcePath, (EelPath)targetPath);
        copyOptions.followLinks(true);
        for (CopyOption option2 : options2) {
            EelFileSystemApiHelpers.Copy copy2;
            CopyOption copyOption = option2;
            if (copyOption == StandardCopyOption.REPLACE_EXISTING) {
                copy2 = copyOptions.replaceExisting(true);
                continue;
            }
            if (copyOption == StandardCopyOption.COPY_ATTRIBUTES) {
                copy2 = copyOptions.preserveAttributes(true);
                continue;
            }
            if (copyOption == ExtendedCopyOption.INTERRUPTIBLE) {
                copy2 = copyOptions.interruptible(true);
                continue;
            }
            if (copyOption == LinkOption.NOFOLLOW_LINKS) {
                copy2 = copyOptions.followLinks(false);
                continue;
            }
            IjentNioFileSystemProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(IjentNioFileSystemProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Unknown copy option: " + option2 + ". This option will be ignored.");
            copy2 = Unit.INSTANCE;
        }
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(copyOptions, null){
            int label;
            final /* synthetic */ EelFileSystemApiHelpers.Copy $copyOptions;
            {
                this.$copyOptions = $copyOptions;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelUtilsKt.getOrThrowFileSystemException((OwnedBuilder)((OwnedBuilder)this.$copyOptions), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void move(@NotNull Path source, @NotNull Path target, CopyOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.ensureAbsoluteIjentNioPath(source);
        this.ensureAbsoluteIjentNioPath(target);
        EelPath sourcePath = ((AbsoluteIjentNioPath)source).getEelPath();
        EelPath targetPath = ((AbsoluteIjentNioPath)target).getEelPath();
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(source, sourcePath, targetPath, options2, null){
            int label;
            final /* synthetic */ Path $source;
            final /* synthetic */ EelPath $sourcePath;
            final /* synthetic */ EelPath $targetPath;
            final /* synthetic */ CopyOption[] $options;
            {
                this.$source = $source;
                this.$sourcePath = $sourcePath;
                this.$targetPath = $targetPath;
                this.$options = $options;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelUtilsKt.getOrThrowFileSystemException((OwnedBuilder)((OwnedBuilder)EelFileSystemApiHelpersKt.move((EelFileSystemApi)((AbsoluteIjentNioPath)this.$source).getNioFs$intellij_platform_ijent_community_impl().getIjentFs(), (EelPath)this.$sourcePath, (EelPath)this.$targetPath).replaceExisting(ArraysKt.contains((Object[])this.$options, (Object)StandardCopyOption.ATOMIC_MOVE) ? EelFileSystemApi.ReplaceExistingDuringMove.DO_NOT_REPLACE_DIRECTORIES : (ArraysKt.contains((Object[])this.$options, (Object)StandardCopyOption.REPLACE_EXISTING) ? EelFileSystemApi.ReplaceExistingDuringMove.REPLACE_EVERYTHING : EelFileSystemApi.ReplaceExistingDuringMove.DO_NOT_REPLACE)).followLinks(false)), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        this.ensureAbsoluteIjentNioPath(path);
        this.ensureAbsoluteIjentNioPath(path2);
        IjentNioFileSystem nioFs = ((AbsoluteIjentNioPath)path).getNioFs$intellij_platform_ijent_community_impl();
        return (Boolean)EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super EelResult<? extends Boolean, ? extends EelFileSystemApi.SameFileError>>, Object>(nioFs, path, path2, null){
            int label;
            final /* synthetic */ IjentNioFileSystem $nioFs;
            final /* synthetic */ Path $path;
            final /* synthetic */ Path $path2;
            {
                this.$nioFs = $nioFs;
                this.$path = $path;
                this.$path2 = $path2;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$nioFs.getIjentFs().sameFile(((AbsoluteIjentNioPath)this.$path).getEelPath(), ((AbsoluteIjentNioPath)this.$path2).getEelPath(), (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super EelResult<Boolean, ? extends EelFileSystemApi.SameFileError>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        })));
    }

    @Override
    public boolean isHidden(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.ensureAbsoluteIjentNioPath(path);
        IjentFileSystemApi ijentFileSystemApi = ((AbsoluteIjentNioPath)path).getNioFs$intellij_platform_ijent_community_impl().getIjentFs();
        if (!(ijentFileSystemApi instanceof IjentFileSystemPosixApi)) {
            if (ijentFileSystemApi instanceof IjentFileSystemWindowsApi) {
                String string = "Not implemented for Windows";
                throw new NotImplementedError("An operation is not implemented: " + string);
            }
            throw new NoWhenBranchMatchedException();
        }
        return StringsKt.startsWith$default((String)((Object)((AbsoluteIjentNioPath)path).normalize().getFileName()).toString(), (String)".", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public FileStore getFileStore(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.ensureAbsoluteIjentNioPath(path);
        return new IjentNioFileStore(((AbsoluteIjentNioPath)path).getEelPath(), ((AbsoluteIjentNioPath)path).getNioFs$intellij_platform_ijent_community_impl().getIjentFs());
    }

    @Override
    public void checkAccess(@NotNull Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        IjentNioFileSystem fs = this.ensureAbsoluteIjentNioPath(path).getNioFs$intellij_platform_ijent_community_impl();
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(fs, path, modes, null){
            Object L$0;
            int label;
            final /* synthetic */ IjentNioFileSystem $fs;
            final /* synthetic */ Path $path;
            final /* synthetic */ AccessMode[] $modes;
            {
                this.$fs = $fs;
                this.$path = $path;
                this.$modes = $modes;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block7: {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ijentFs = this.$fs.getIjentFs();
                            if (!(ijentFs instanceof IjentFileSystemPosixApi)) break;
                            this.L$0 = ijentFs;
                            this.label = 1;
                            v0 = EelUtilsKt.getOrThrowFileSystemException((OwnedBuilder)((OwnedBuilder)EelFileSystemPosixApiHelpersKt.stat((EelFileSystemPosixApi)((EelFileSystemPosixApi)ijentFs), (EelPath)((AbsoluteIjentNioPath)this.$path).getEelPath()).resolveAndFollow()), (Continuation)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            ijentFs = (IjentFileSystemApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            fileInfo = (EelPosixFileInfo)v0;
                            error = EelPathUtils.INSTANCE.checkAccess((EelUserPosixInfo)((IjentFileSystemPosixApi)ijentFs).getUser(), fileInfo, Arrays.copyOf(this.$modes, this.$modes.length));
                            if (error != null) {
                                EelUtilsKt.throwFileSystemException((EelFsError)((EelFsError)new EelFsResultImpl.PermissionDenied(((AbsoluteIjentNioPath)this.$path).getEelPath(), "Permission denied: " + error.name())));
                                throw new KotlinNothingValueException();
                            }
                            break block7;
                        }
                    }
                    if (ijentFs instanceof IjentFileSystemWindowsApi) {
                        throw new NotImplementedError(null, 1, null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @Nullable
    public <V extends FileAttributeView> V getFileAttributeView(@NotNull Path path, @Nullable Class<V> type, LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.ensureAbsoluteIjentNioPath(path);
        if (Intrinsics.areEqual(type, BasicFileAttributeView.class)) {
            return (V)new IjentNioBasicFileAttributeView(((AbsoluteIjentNioPath)path).getNioFs$intellij_platform_ijent_community_impl().getIjentFs(), ((AbsoluteIjentNioPath)path).getEelPath(), (IjentNioPath)path);
        }
        IjentNioFileSystem nioFs = this.ensureIjentNioPath(path).getNioFs$intellij_platform_ijent_community_impl();
        IjentFileSystemApi ijentFileSystemApi = nioFs.getIjentFs();
        if (ijentFileSystemApi instanceof IjentFileSystemPosixApi) {
            if (Intrinsics.areEqual(type, PosixFileAttributeView.class)) {
                return (V)new IjentNioPosixFileAttributeView(((AbsoluteIjentNioPath)path).getNioFs$intellij_platform_ijent_community_impl().getIjentFs(), ((AbsoluteIjentNioPath)path).getEelPath(), (IjentNioPath)path);
            }
            return null;
        }
        if (ijentFileSystemApi instanceof IjentFileSystemWindowsApi) {
            throw new NotImplementedError(null, 1, null);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public <A extends BasicFileAttributes> A readAttributes(@NotNull Path path, @NotNull Class<A> type, LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        IjentNioFileSystem fs = this.ensureAbsoluteIjentNioPath(path).getNioFs$intellij_platform_ijent_community_impl();
        EelFileSystemApi.SymlinkPolicy linkPolicy = ArraysKt.contains((Object[])options2, (Object)LinkOption.NOFOLLOW_LINKS) ? EelFileSystemApi.SymlinkPolicy.DO_NOT_RESOLVE : EelFileSystemApi.SymlinkPolicy.RESOLVE_AND_FOLLOW;
        IjentFileSystemApi ijentFs = fs.getIjentFs();
        if (!(ijentFs instanceof IjentFileSystemPosixApi)) {
            if (ijentFs instanceof IjentFileSystemWindowsApi) {
                throw new NotImplementedError(null, 1, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        IjentNioPosixFileAttributes result2 = new IjentNioPosixFileAttributes((EelPosixFileInfo)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super EelPosixFileInfo>, Object>(ijentFs, path, linkPolicy, null){
            int label;
            final /* synthetic */ IjentFileSystemApi $ijentFs;
            final /* synthetic */ Path $path;
            final /* synthetic */ EelFileSystemApi.SymlinkPolicy $linkPolicy;
            {
                this.$ijentFs = $ijentFs;
                this.$path = $path;
                this.$linkPolicy = $linkPolicy;
                super(1, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = EelUtilsKt.getOrThrowFileSystemException((OwnedBuilder)((OwnedBuilder)EelFileSystemPosixApiHelpersKt.stat((EelFileSystemPosixApi)((EelFileSystemPosixApi)this.$ijentFs), (EelPath)((AbsoluteIjentNioPath)this.$path).getEelPath()).symlinkPolicy(this.$linkPolicy)), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super EelPosixFileInfo> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        return (A)result2;
    }

    @Override
    @NotNull
    public Map<String, Object> readAttributes(@NotNull Path path, @NotNull String attributes, LinkOption ... options2) {
        Map rawMap;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Pair<String, List<String>> pair = this.parseAttributesParameter(attributes);
        String viewName = (String)pair.component1();
        List requestedAttributes = (List)pair.component2();
        String string = viewName;
        if (Intrinsics.areEqual((Object)string, (Object)"basic")) {
            BasicFileAttributes basicAttributes = this.readAttributes(path, BasicFileAttributes.class, Arrays.copyOf(options2, options2.length));
            var10_10 = new Pair[]{TuplesKt.to((Object)"lastModifiedTime", (Object)basicAttributes.lastModifiedTime()), TuplesKt.to((Object)"lastAccessTime", (Object)basicAttributes.lastAccessTime()), TuplesKt.to((Object)"creationTime", (Object)basicAttributes.creationTime()), TuplesKt.to((Object)"size", (Object)basicAttributes.size()), TuplesKt.to((Object)"isRegularFile", (Object)basicAttributes.isRegularFile()), TuplesKt.to((Object)"isDirectory", (Object)basicAttributes.isDirectory()), TuplesKt.to((Object)"isSymbolicLink", (Object)basicAttributes.isSymbolicLink()), TuplesKt.to((Object)"isOther", (Object)basicAttributes.isOther()), TuplesKt.to((Object)"fileKey", (Object)basicAttributes.fileKey())};
            map2 = MapsKt.mapOf((Pair[])var10_10);
        } else if (Intrinsics.areEqual((Object)string, (Object)"posix")) {
            PosixFileAttributes posixAttributes = this.readAttributes(path, PosixFileAttributes.class, Arrays.copyOf(options2, options2.length));
            var10_10 = new Pair[]{TuplesKt.to((Object)"permissions", posixAttributes.permissions()), TuplesKt.to((Object)"group", (Object)posixAttributes.group())};
            map2 = MapsKt.mapOf((Pair[])var10_10);
        } else {
            throw new UnsupportedOperationException("Unsupported file attribute view " + attributes);
        }
        Map $this$filterKeys$iv = rawMap = map2;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = (String)entry$iv.getKey();
            boolean bl = false;
            if (!requestedAttributes.contains(it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    private final Pair<String, List<String>> parseAttributesParameter(String parameter) {
        Pair pair;
        char[] cArray = new char[]{':'};
        List viewNameAndList = StringsKt.split$default((CharSequence)parameter, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        if (viewNameAndList.size() == 2) {
            cArray = new char[]{','};
            pair = TuplesKt.to(viewNameAndList.get(0), (Object)StringsKt.split$default((CharSequence)((CharSequence)viewNameAndList.get(1)), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        } else {
            cArray = new char[]{','};
            pair = TuplesKt.to((Object)"basic", (Object)StringsKt.split$default((CharSequence)((CharSequence)viewNameAndList.get(0)), (char[])cArray, (boolean)false, (int)0, (int)6, null));
        }
        return pair;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAttribute(@NotNull Path path, @NotNull String attribute, @NotNull Object value, LinkOption ... options2) {
        EelFileSystemApi.ChangeAttributesOptions.Builder builder;
        IjentNioFileSystem nioFs;
        block30: {
            int n;
            String string;
            List requestedAttributes;
            block28: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
                Pair<String, List<String>> pair = this.parseAttributesParameter(attribute);
                String viewName = (String)pair.component1();
                requestedAttributes = (List)pair.component2();
                nioFs = this.ensureAbsoluteIjentNioPath(path).getNioFs$intellij_platform_ijent_community_impl();
                builder = EelFileSystemApi.ChangeAttributesOptions.Companion.Builder();
                string = viewName;
                if (!Intrinsics.areEqual((Object)string, (Object)"basic")) break block28;
                String string2 = (String)CollectionsKt.singleOrNull((List)requestedAttributes);
                if (string2 == null) throw new IllegalArgumentException("Unrecognized attribute: " + attribute);
                n = -1;
                switch (string2.hashCode()) {
                    case -1540361492: {
                        if (string2.equals("lastModifiedTime")) {
                            n = 1;
                        }
                        break;
                    }
                    case -932915833: {
                        if (string2.equals("lastAccessTime")) {
                            n = 2;
                        }
                        break;
                    }
                    case 1586015820: {
                        if (string2.equals("creationTime")) {
                            n = 3;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 1: {
                        IjentNioFileSystemProviderKt.updateTime(builder, (Function2<? super EelFileSystemApi.ChangeAttributesOptions.Builder, ? super EelFileSystemApi.TimeSinceEpoch, Unit>)((Function2)setAttribute.1.INSTANCE), value);
                        break block30;
                    }
                    case 2: {
                        IjentNioFileSystemProviderKt.updateTime(builder, (Function2<? super EelFileSystemApi.ChangeAttributesOptions.Builder, ? super EelFileSystemApi.TimeSinceEpoch, Unit>)((Function2)setAttribute.2.INSTANCE), value);
                        break block30;
                    }
                    case 3: {
                        FileTime cfr_ignored_0 = (FileTime)value;
                        break block30;
                    }
                    default: {
                        throw new IllegalArgumentException("Unrecognized attribute: " + attribute);
                    }
                }
            }
            if (!Intrinsics.areEqual((Object)string, (Object)"posix")) throw new IllegalArgumentException("Unrecognized attribute: " + attribute);
            PosixFileAttributes posixFileAttributes = this.readAttributes(path, PosixFileAttributes.class, Arrays.copyOf(options2, options2.length));
            Intrinsics.checkNotNull((Object)posixFileAttributes, (String)"null cannot be cast to non-null type com.intellij.platform.ijent.community.impl.nio.IjentNioPosixFileAttributes");
            EelPosixFileInfo.Permissions oldPermissions = ((IjentNioPosixFileAttributes)posixFileAttributes).getFileInfo$intellij_platform_ijent_community_impl().getPermissions();
            String string3 = (String)CollectionsKt.singleOrNull((List)requestedAttributes);
            if (string3 == null) throw new IllegalArgumentException("Unrecognized attribute: " + attribute);
            tmp = -1;
            switch (string3.hashCode()) {
                case 106164915: {
                    if (string3.equals("owner")) {
                        tmp = 1;
                    }
                    break;
                }
                case 1133704324: {
                    if (string3.equals("permissions")) {
                        tmp = 2;
                    }
                    break;
                }
                case 98629247: {
                    if (string3.equals("group")) {
                        tmp = 3;
                    }
                    break;
                }
            }
            builder.permissions((EelFileInfo.Permissions)(switch (tmp) {
                case 2 -> {
                    (Set)value;
                    int mask = PosixFilePermissionsUtil.toUnixMode((Set)((Set)value));
                    yield (EelPosixFileInfo.Permissions)new EelPosixFileInfoImpl.Permissions(oldPermissions.getOwner(), oldPermissions.getGroup(), mask);
                }
                case 1 -> {
                    if (!(value instanceof EelPosixUserPrincipal)) throw new UnsupportedOperationException("Unsupported owner principal: " + value);
                    if (((EelPosixUserPrincipal)value).getUid() != oldPermissions.getOwner()) {
                        String var13_15 = "Changing uid is not supported yet";
                        throw new NotImplementedError("An operation is not implemented: " + var13_15);
                    }
                    yield oldPermissions;
                }
                case 3 -> {
                    if (!(value instanceof EelPosixGroupPrincipal)) throw new UnsupportedOperationException("Unsupported group principal: " + value);
                    if (((EelPosixGroupPrincipal)value).getGid() != oldPermissions.getGroup()) {
                        String var13_16 = "Changing gid is not supported yet";
                        throw new NotImplementedError("An operation is not implemented: " + var13_16);
                    }
                    yield oldPermissions;
                }
                default -> throw new IllegalArgumentException("Unrecognized attribute: " + attribute);
            }));
        }
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(nioFs, path, builder, null){
            int label;
            final /* synthetic */ IjentNioFileSystem $nioFs;
            final /* synthetic */ Path $path;
            final /* synthetic */ EelFileSystemApi.ChangeAttributesOptions.Builder $builder;
            {
                this.$nioFs = $nioFs;
                this.$path = $path;
                this.$builder = $builder;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$nioFs.getIjentFs().changeAttributes(((AbsoluteIjentNioPath)this.$path).getEelPath(), this.$builder.build(), (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    @NotNull
    public AsynchronousFileChannel newAsynchronousFileChannel(@Nullable Path path, @Nullable Set<? extends OpenOption> options2, @Nullable ExecutorService executor, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        String string = "Not yet implemented -> com.intellij.platform.ijent.functional.fs.TodoOperation.ASYNC_FILE_CHANNEL";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void createSymbolicLink(@NotNull Path link, @NotNull Path target, FileAttribute<?> ... attrs) {
        EelFileSystemPosixApi.SymbolicLinkTarget symbolicLinkTarget;
        IjentNioPath target2;
        IjentNioPath ijentNioPath;
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        if (!(attrs.length == 0)) {
            throw new UnsupportedOperationException("Attributes are not supported for symbolic links");
        }
        IjentNioFileSystem fs = this.ensureAbsoluteIjentNioPath(link).getNioFs$intellij_platform_ijent_community_impl();
        if (target.isAbsolute() || Intrinsics.areEqual((Object)target.getFileSystem(), (Object)fs)) {
            ijentNioPath = this.ensureIjentNioPath(target);
        } else {
            String string = ((Object)target).toString();
            String string2 = target.getFileSystem().getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
            ijentNioPath = fs.getPath(StringsKt.replace$default((String)string, (String)string2, (String)fs.getSeparator(), (boolean)false, (int)4, null), new String[0]);
        }
        IjentNioPath ijentNioPath2 = target2 = ijentNioPath;
        if (ijentNioPath2 instanceof AbsoluteIjentNioPath) {
            symbolicLinkTarget = (EelFileSystemPosixApi.SymbolicLinkTarget)EelFileSystemPosixApi.SymbolicLinkTarget.Companion.Absolute(((AbsoluteIjentNioPath)target2).getEelPath());
        } else if (ijentNioPath2 instanceof RelativeIjentNioPath) {
            symbolicLinkTarget = (EelFileSystemPosixApi.SymbolicLinkTarget)EelFileSystemPosixApi.SymbolicLinkTarget.Companion.Relative(((RelativeIjentNioPath)target2).getSegments());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        EelFileSystemPosixApi.SymbolicLinkTarget eelTarget = symbolicLinkTarget;
        if (!Intrinsics.areEqual((Object)target2.getNioFs$intellij_platform_ijent_community_impl(), (Object)fs)) {
            boolean bl = false;
            String string = "Can't create symlinks between different file systems";
            throw new IllegalArgumentException(string.toString());
        }
        IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super Unit>, Object>(fs, eelTarget, link, null){
            Object L$0;
            int label;
            final /* synthetic */ IjentNioFileSystem $fs;
            final /* synthetic */ EelFileSystemPosixApi.SymbolicLinkTarget $eelTarget;
            final /* synthetic */ Path $link;
            {
                this.$fs = $fs;
                this.$eelTarget = $eelTarget;
                this.$link = $link;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block6: {
                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ijentFs = this.$fs.getIjentFs();
                            if (!(ijentFs instanceof IjentFileSystemPosixApi)) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ijentFs);
                            this.label = 1;
                            v0 = ((IjentFileSystemPosixApi)ijentFs).createSymbolicLink(this.$eelTarget, ((AbsoluteIjentNioPath)this.$link).getEelPath(), (Continuation)this);
                            if (v0 == var4_2) {
                                return var4_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            ijentFs = (IjentFileSystemApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            EelUtilsKt.getOrThrowFileSystemException((EelResult)((EelResult)v0));
                            break block6;
                        }
                    }
                    if (ijentFs instanceof IjentFileSystemWindowsApi) {
                        var3_5 = "Symbolic links are not supported on Windows";
                        throw new NotImplementedError("An operation is not implemented: " + var3_5);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Unit> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void createLink(@Nullable Path link, @Nullable Path existing) {
        String string = "Not yet implemented -> com.intellij.platform.ijent.functional.fs.TodoOperation.HARD_LINK";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public Path readSymbolicLink(@NotNull Path link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        IjentNioFileSystem fs = this.ensureAbsoluteIjentNioPath(link).getNioFs$intellij_platform_ijent_community_impl();
        EelPath absolutePath = ((AbsoluteIjentNioPath)link).getEelPath();
        EelOsFamily os = fs.getIjentFs().getDescriptor().getOsFamily();
        return (Path)IjentNioFileSystemUtil.fsBlocking((Function1)new Function1<Continuation<? super IjentNioPath>, Object>(fs, absolutePath, link, os, null){
            Object L$0;
            int label;
            final /* synthetic */ IjentNioFileSystem $fs;
            final /* synthetic */ EelPath $absolutePath;
            final /* synthetic */ Path $link;
            final /* synthetic */ EelOsFamily $os;
            {
                this.$fs = $fs;
                this.$absolutePath = $absolutePath;
                this.$link = $link;
                this.$os = $os;
                super(1, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                block8: {
                    var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ijentFs = this.$fs.getIjentFs();
                            if (!(ijentFs instanceof IjentFileSystemPosixApi)) break;
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)ijentFs);
                            this.label = 1;
                            v0 = EelUtilsKt.getOrThrowFileSystemException((OwnedBuilder)((OwnedBuilder)EelFileSystemPosixApiHelpersKt.stat((EelFileSystemPosixApi)((EelFileSystemPosixApi)ijentFs), (EelPath)this.$absolutePath).justResolve()), (Continuation)((Continuation)this));
                            if (v0 == var5_2) {
                                return var5_2;
                            }
                            ** GOTO lbl17
                        }
                        case 1: {
                            ijentFs = (IjentFileSystemApi)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            if (!((type = ((EelPosixFileInfo)v0).getType()) instanceof EelPosixFileInfo.Type.Symlink.Resolved.Absolute)) ** GOTO lbl20
                            v1 = new AbsoluteIjentNioPath(((EelPosixFileInfo.Type.Symlink.Resolved.Absolute)type).getResult(), ((AbsoluteIjentNioPath)this.$link).getNioFs$intellij_platform_ijent_community_impl(), null);
                            break block8;
lbl20:
                            // 1 sources

                            if (!(type instanceof EelPosixFileInfo.Type.Symlink.Resolved.Relative)) ** GOTO lbl24
                            var4_6 = EelPlatformKt.getDirectorySeparators((EelOsFamily)this.$os);
                            v1 = new RelativeIjentNioPath(StringsKt.split$default((CharSequence)((EelPosixFileInfo.Type.Symlink.Resolved.Relative)type).getResult(), (char[])Arrays.copyOf(var4_6, var4_6.length), (boolean)false, (int)0, (int)6, null), ((AbsoluteIjentNioPath)this.$link).getNioFs$intellij_platform_ijent_community_impl());
                            break block8;
lbl24:
                            // 1 sources

                            if (type instanceof EelFileInfo.Type.Directory || type instanceof EelFileInfo.Type.Regular || type instanceof EelFileInfo.Type.Other) {
                                throw new NotLinkException(((AbsoluteIjentNioPath)this.$link).toString());
                            }
                            if (type instanceof EelPosixFileInfo.Type.Symlink.Unresolved) {
                                throw new IllegalStateException("Impossible, the link should be resolved".toString());
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (ijentFs instanceof IjentFileSystemWindowsApi) {
                        throw new NotImplementedError(null, 1, null);
                    }
                    throw new NoWhenBranchMatchedException();
                }
                return v1;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super IjentNioPath> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close$intellij_platform_ijent_community_impl(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object object = this.criticalSection;
        boolean bl = false;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2 = false;
            criticalSection.1 $this$close_u24lambda_u240 = object;
            boolean bl3 = false;
            IjentFileSystemApi ijentFileSystemApi = $this$close_u24lambda_u240.getAuthorityRegistry().remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IjentFileSystemApi ijentFsApi$intellij_platform_ijent_community_impl(@NotNull URI uri) {
        IjentFileSystemApi ijentFileSystemApi;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Object object = this.criticalSection;
        boolean bl = false;
        Object object2 = object;
        synchronized (object2) {
            boolean bl2 = false;
            criticalSection.1 $this$ijentFsApi_u24lambda_u240 = object;
            boolean bl3 = false;
            ijentFileSystemApi = $this$ijentFsApi_u24lambda_u240.getAuthorityRegistry().get(uri);
        }
        return ijentFileSystemApi;
    }

    private final IjentNioPath ensureIjentNioPath(Path path) {
        if (!(path instanceof IjentNioPath)) {
            throw new ProviderMismatchException(path + " (" + path.getClass() + ") is not " + IjentNioPath.class.getSimpleName());
        }
        return (IjentNioPath)path;
    }

    private final AbsoluteIjentNioPath ensureAbsoluteIjentNioPath(Path path) {
        if (!(path instanceof AbsoluteIjentNioPath)) {
            throw new ProviderMismatchException(path + " (" + path.getClass() + ") is not " + IjentNioPath.class.getSimpleName());
        }
        return (AbsoluteIjentNioPath)path;
    }

    private static final Integer getUriParts$lambda$0(int index, char c) {
        return c == '/' ? Integer.valueOf(index) : null;
    }

    private static final URI getUriParts$lambda$1(URI $uri, int it) {
        String string = $uri.getScheme();
        String string2 = $uri.getAuthority();
        String string3 = $uri.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        String string4 = string3;
        int n = 0;
        String string5 = string4.substring(n, it);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
        return new URI(string, string2, string5, null, null);
    }

    @JvmStatic
    @NotNull
    public static final IjentNioFileSystemProvider getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final Map<String, ?> newFileSystemMap(@NotNull IjentFileSystemApi ijentFs) {
        return Companion.newFileSystemMap(ijentFs);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u001a\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030\u00072\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider;", "newFileSystemMap", "", "", "ijentFs", "Lcom/intellij/platform/ijent/fs/IjentFileSystemApi;", "SCHEME", "KEY_IJENT_FS", "intellij.platform.ijent.community.impl"})
    @SourceDebugExtension(value={"SMAP\nIjentNioFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentNioFileSystemProvider.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,610:1\n808#2,11:611\n*S KotlinDebug\n*F\n+ 1 IjentNioFileSystemProvider.kt\ncom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$Companion\n*L\n49#1:611,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final IjentNioFileSystemProvider getInstance() {
            void $this$filterIsInstanceTo$iv$iv;
            List<FileSystemProvider> list2 = FileSystemProvider.installedProviders();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"installedProviders(...)");
            Iterable $this$filterIsInstance$iv = list2;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IjentNioFileSystemProvider)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (IjentNioFileSystemProvider)CollectionsKt.single((List)((List)destination$iv$iv));
        }

        @JvmStatic
        @NotNull
        public final Map<String, ?> newFileSystemMap(@NotNull IjentFileSystemApi ijentFs) {
            Intrinsics.checkNotNullParameter((Object)ijentFs, (String)IjentNioFileSystemProvider.KEY_IJENT_FS);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)IjentNioFileSystemProvider.KEY_IJENT_FS, (Object)ijentFs)};
            return MapsKt.mutableMapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0081@\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J2\u0010\t\u001a\u0002H\n\"\u0004\b\u0001\u0010\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H\n0\f\u00a2\u0006\u0002\b\rH\u0086\n\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001d"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystemProvider$CriticalSection;", "D", "", "hidden", "constructor-impl", "(Ljava/lang/Object;)Ljava/lang/Object;", "getHidden", "()Ljava/lang/Object;", "Ljava/lang/Object;", "invoke", "T", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "invoke-impl", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "equals", "", "other", "equals-impl", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/lang/Object;)I", "toString", "", "toString-impl", "(Ljava/lang/Object;)Ljava/lang/String;", "intellij.platform.ijent.community.impl"})
    public static final class CriticalSection<D> {
        @NotNull
        private final D hidden;

        @NotNull
        public final D getHidden() {
            return this.hidden;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static final <T> T invoke-impl(Object object, @NotNull Function1<? super D, ? extends T> body) {
            Intrinsics.checkNotNullParameter(body, (String)"body");
            boolean bl = false;
            Object object2 = object;
            synchronized (object2) {
                Object object3;
                try {
                    boolean bl2 = false;
                    object3 = body.invoke(object);
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    // MONITOREXIT @DISABLED, blocks:[1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                    InlineMarker.finallyEnd((int)1);
                }
                return (T)object3;
            }
        }

        public static String toString-impl(Object object) {
            return "CriticalSection(hidden=" + object + ")";
        }

        public String toString() {
            return CriticalSection.toString-impl(this.hidden);
        }

        public static int hashCode-impl(Object object) {
            return object.hashCode();
        }

        public int hashCode() {
            return CriticalSection.hashCode-impl(this.hidden);
        }

        public static boolean equals-impl(Object object, Object other) {
            if (!(other instanceof CriticalSection)) {
                return false;
            }
            return Intrinsics.areEqual((Object)object, (Object)((CriticalSection)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return CriticalSection.equals-impl(this.hidden, other);
        }

        private /* synthetic */ CriticalSection(Object hidden) {
            this.hidden = hidden;
        }

        @NotNull
        public static <D> Object constructor-impl(@NotNull D hidden) {
            Intrinsics.checkNotNullParameter(hidden, (String)"hidden");
            return hidden;
        }

        public static final /* synthetic */ CriticalSection box-impl(Object v) {
            return new CriticalSection(v);
        }

        public final /* synthetic */ Object unbox-impl() {
            return this.hidden;
        }

        public static final boolean equals-impl0(Object p1, Object p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }
    }
}

