/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.ijent.community.impl.nio.AbsoluteIjentNioPath;
import com.intellij.platform.ijent.community.impl.nio.IjentNioFileSystem;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\n\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0001H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0001H\u0016J!\u0010!\u001a\u00020\u00012\u0012\u0010\"\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0#\"\u00020$H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0004H\u0016J\u0013\u0010'\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020\u0011H\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/RelativeIjentNioPath;", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "segments", "", "", "nioFs", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem;", "<init>", "(Ljava/util/List;Lcom/intellij/platform/ijent/community/impl/nio/IjentNioFileSystem;)V", "getSegments", "()Ljava/util/List;", "isAbsolute", "", "getRoot", "getFileName", "Ljava/nio/file/Path;", "getNameCount", "", "getParent", "getName", "index", "subpath", "beginIndex", "endIndex", "startsWith", "other", "endsWith", "normalize", "resolve", "relativize", "toUri", "Ljava/net/URI;", "toAbsolutePath", "toRealPath", "options", "", "Ljava/nio/file/LinkOption;", "([Ljava/nio/file/LinkOption;)Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "toString", "equals", "", "hashCode", "intellij.platform.ijent.community.impl"})
@SourceDebugExtension(value={"SMAP\nIjentNioPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentNioPath.kt\ncom/intellij/platform/ijent/community/impl/nio/RelativeIjentNioPath\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,325:1\n1#2:326\n*E\n"})
public final class RelativeIjentNioPath
extends IjentNioPath {
    @NotNull
    private final List<String> segments;

    public RelativeIjentNioPath(@NotNull List<String> segments, @NotNull IjentNioFileSystem nioFs) {
        Intrinsics.checkNotNullParameter(segments, (String)"segments");
        Intrinsics.checkNotNullParameter((Object)nioFs, (String)"nioFs");
        super(nioFs, null, null);
        this.segments = segments;
    }

    @NotNull
    public final List<String> getSegments() {
        return this.segments;
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    @Nullable
    public IjentNioPath getRoot() {
        return null;
    }

    @Override
    @Nullable
    public Path getFileName() {
        IjentNioPath ijentNioPath;
        if (this.segments.size() <= 1) {
            return this;
        }
        String string = (String)CollectionsKt.lastOrNull(this.segments);
        if (string != null) {
            String it = string;
            boolean bl = false;
            ijentNioPath = this.createRelativePath(this, it);
        } else {
            ijentNioPath = null;
        }
        return ijentNioPath;
    }

    @Override
    public int getNameCount() {
        return this.segments.size();
    }

    @Override
    @Nullable
    public IjentNioPath getParent() {
        if (this.segments.size() <= 1) {
            return null;
        }
        return new RelativeIjentNioPath(this.segments.subList(0, this.segments.size() - 1), this.getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    @NotNull
    public IjentNioPath getName(int index) {
        return this.createRelativePath(this, this.segments.get(index));
    }

    @Override
    @NotNull
    public IjentNioPath subpath(int beginIndex, int endIndex) {
        return new RelativeIjentNioPath(this.segments.subList(beginIndex, endIndex), this.getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    public boolean startsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IjentNioPath) || !Intrinsics.areEqual((Object)((IjentNioPath)other).getFileSystem(), (Object)this.getFileSystem())) {
            return false;
        }
        IjentNioPath ijentNioPath = (IjentNioPath)other;
        if (ijentNioPath instanceof AbsoluteIjentNioPath) {
            return false;
        }
        if (ijentNioPath instanceof RelativeIjentNioPath) {
            return this.segments.size() >= ((RelativeIjentNioPath)other).segments.size() && Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)this.segments, (int)((RelativeIjentNioPath)other).segments.size()), ((RelativeIjentNioPath)other).segments);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    public boolean endsWith(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IjentNioPath) || !Intrinsics.areEqual((Object)((IjentNioPath)other).getFileSystem(), (Object)this.getFileSystem())) {
            return false;
        }
        IjentNioPath ijentNioPath = (IjentNioPath)other;
        if (ijentNioPath instanceof AbsoluteIjentNioPath) {
            return false;
        }
        if (ijentNioPath instanceof RelativeIjentNioPath) {
            return this.segments.size() >= ((RelativeIjentNioPath)other).segments.size() && Intrinsics.areEqual((Object)CollectionsKt.takeLast(this.segments, (int)((RelativeIjentNioPath)other).segments.size()), ((RelativeIjentNioPath)other).segments);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Override
    @NotNull
    public IjentNioPath normalize() {
        List result2 = new ArrayList();
        for (String part : this.segments) {
            String string = part;
            if (Intrinsics.areEqual((Object)string, (Object)".")) continue;
            if (Intrinsics.areEqual((Object)string, (Object)"..")) {
                if (!((Collection)result2).isEmpty() && !Intrinsics.areEqual((Object)CollectionsKt.last((List)result2), (Object)"..")) {
                    Object e = result2.removeLast();
                    Intrinsics.checkNotNull(e);
                    continue;
                }
                ((Collection)result2).add(part);
                continue;
            }
            ((Collection)result2).add(part);
        }
        return new RelativeIjentNioPath(result2, this.getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    @NotNull
    public IjentNioPath resolve(@NotNull Path other) {
        IjentNioPath ijentNioPath;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof IjentNioPath)) {
            throw new ProviderMismatchException("Expected IJentNioPath, got " + other);
        }
        IjentNioPath ijentNioPath2 = (IjentNioPath)other;
        if (ijentNioPath2 instanceof AbsoluteIjentNioPath) {
            ijentNioPath = (IjentNioPath)other;
        } else if (ijentNioPath2 instanceof RelativeIjentNioPath) {
            ijentNioPath = new RelativeIjentNioPath(CollectionsKt.plus((Collection)this.segments, (Iterable)((RelativeIjentNioPath)other).segments), this.getNioFs$intellij_platform_ijent_community_impl());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return ijentNioPath;
    }

    @Override
    @NotNull
    public IjentNioPath relativize(@NotNull Path other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof RelativeIjentNioPath) || ((RelativeIjentNioPath)other).segments.size() < this.segments.size()) {
            throw new IllegalArgumentException("Expected RelativeIjentNioPath, got " + other);
        }
        return new RelativeIjentNioPath(((RelativeIjentNioPath)other).segments.subList(this.segments.size(), ((RelativeIjentNioPath)other).segments.size()), this.getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    @NotNull
    public URI toUri() {
        throw new InvalidPathException(this.toString(), "Can't create a URL from a relative path");
    }

    @Override
    @NotNull
    public IjentNioPath toAbsolutePath() {
        throw new InvalidPathException(this.toString(), "Can't build an absolute path for " + this);
    }

    @Override
    @NotNull
    public IjentNioPath toRealPath(LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        throw new InvalidPathException(this.toString(), "Can't find a real path for a relative path");
    }

    @Override
    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.segments, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof RelativeIjentNioPath && Intrinsics.areEqual(this.segments, ((RelativeIjentNioPath)other).segments) && Intrinsics.areEqual((Object)this.getNioFs$intellij_platform_ijent_community_impl(), (Object)((RelativeIjentNioPath)other).getNioFs$intellij_platform_ijent_community_impl());
    }

    @Override
    public int hashCode() {
        return ((Object)this.segments).hashCode() * 31 + this.getNioFs$intellij_platform_ijent_community_impl().hashCode();
    }
}

