/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ijent.community.impl.nio;

import com.intellij.platform.ijent.community.impl.nio.TransitionalIjentWslFileSystem;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0002\b\u0003\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\nH\u0016JG\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0010\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0019\u0018\u00010\u00182\u001e\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u001b\"\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ(\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010 \u001a\u00020\u00132\u0010\u0010!\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u0013\u0018\u00010\"H\u0016J5\u0010#\u001a\u00020$2\u0006\u0010 \u001a\u00020\u00132\u001e\u0010\u001a\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u001c0\u001b\"\b\u0012\u0002\b\u0003\u0018\u00010\u001cH\u0016\u00a2\u0006\u0002\u0010%J\u0010\u0010&\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J5\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010*0\u001b\"\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J5\u0010,\u001a\u00020$2\u0006\u0010(\u001a\u00020\u00132\u0006\u0010)\u001a\u00020\u00132\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010*0\u001b\"\u0004\u0018\u00010*H\u0016\u00a2\u0006\u0002\u0010+J\u0018\u0010-\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u0013H\u0016J\u0010\u00100\u001a\u00020.2\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0010\u00101\u001a\u0002022\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J-\u00103\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00132\u0016\u00104\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001050\u001b\"\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106JI\u00107\u001a\u0002H8\"\n\b\u0000\u00108*\u0004\u0018\u0001092\u0006\u0010\u0016\u001a\u00020\u00132\u000e\u0010:\u001a\n\u0012\u0004\u0012\u0002H8\u0018\u00010;2\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010<0\u001b\"\u0004\u0018\u00010<H\u0016\u00a2\u0006\u0002\u0010=JI\u0010>\u001a\u0002H?\"\n\b\u0000\u0010?*\u0004\u0018\u00010@2\u0006\u0010\u0016\u001a\u00020\u00132\u000e\u0010:\u001a\n\u0012\u0004\u0012\u0002H?\u0018\u00010;2\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010<0\u001b\"\u0004\u0018\u00010<H\u0016\u00a2\u0006\u0002\u0010AJC\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020B0\u00102\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010C\u001a\u0004\u0018\u00010\u00072\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010<0\u001b\"\u0004\u0018\u00010<H\u0016\u00a2\u0006\u0002\u0010DJA\u0010E\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00132\b\u0010F\u001a\u0004\u0018\u00010\u00072\b\u0010G\u001a\u0004\u0018\u00010B2\u0016\u0010\u0017\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010<0\u001b\"\u0004\u0018\u00010<H\u0016\u00a2\u0006\u0002\u0010HR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/intellij/platform/ijent/community/impl/nio/TransitionalIjentWslFileSystemProvider;", "Ljava/nio/file/spi/FileSystemProvider;", "localFsProvider", "ijentFsProvider", "<init>", "(Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/spi/FileSystemProvider;)V", "getScheme", "", "fileSystems", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/net/URI;", "Lcom/intellij/platform/ijent/community/impl/nio/TransitionalIjentWslFileSystem;", "newFileSystem", "Ljava/nio/file/FileSystem;", "uri", "env", "", "getFileSystem", "getPath", "Ljava/nio/file/Path;", "newByteChannel", "Ljava/nio/channels/SeekableByteChannel;", "path", "options", "", "Ljava/nio/file/OpenOption;", "attrs", "", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", "newDirectoryStream", "Ljava/nio/file/DirectoryStream;", "dir", "filter", "Ljava/nio/file/DirectoryStream$Filter;", "createDirectory", "", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "copy", "source", "target", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "move", "isSameFile", "", "path2", "isHidden", "getFileStore", "Ljava/nio/file/FileStore;", "checkAccess", "modes", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)V", "getFileAttributeView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "type", "Ljava/lang/Class;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "attributes", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "setAttribute", "attribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)V", "intellij.platform.ijent.community.impl"})
public final class TransitionalIjentWslFileSystemProvider
extends FileSystemProvider {
    @NotNull
    private final FileSystemProvider localFsProvider;
    @NotNull
    private final FileSystemProvider ijentFsProvider;
    @NotNull
    private final ConcurrentHashMap<URI, TransitionalIjentWslFileSystem> fileSystems;

    public TransitionalIjentWslFileSystemProvider(@NotNull FileSystemProvider localFsProvider, @NotNull FileSystemProvider ijentFsProvider) {
        Intrinsics.checkNotNullParameter((Object)localFsProvider, (String)"localFsProvider");
        Intrinsics.checkNotNullParameter((Object)ijentFsProvider, (String)"ijentFsProvider");
        this.localFsProvider = localFsProvider;
        this.ijentFsProvider = ijentFsProvider;
        this.fileSystems = new ConcurrentHashMap();
    }

    @Override
    @NotNull
    public String getScheme() {
        String string = this.localFsProvider.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        return string;
    }

    @Override
    @NotNull
    public FileSystem newFileSystem(@NotNull URI uri, @Nullable Map<String, ?> env) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        TransitionalIjentWslFileSystem transitionalIjentWslFileSystem = this.fileSystems.compute(uri, (arg_0, arg_1) -> TransitionalIjentWslFileSystemProvider.newFileSystem$lambda$1((arg_0, arg_1) -> TransitionalIjentWslFileSystemProvider.newFileSystem$lambda$0(this, uri, env, arg_0, arg_1), arg_0, arg_1));
        Intrinsics.checkNotNull((Object)transitionalIjentWslFileSystem);
        return transitionalIjentWslFileSystem;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        TransitionalIjentWslFileSystem transitionalIjentWslFileSystem = this.fileSystems.get(uri);
        if (transitionalIjentWslFileSystem == null) {
            throw new FileSystemNotFoundException();
        }
        return transitionalIjentWslFileSystem;
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Path path = this.localFsProvider.getPath(uri);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    @Override
    @NotNull
    public SeekableByteChannel newByteChannel(@NotNull Path path, @Nullable Set<? extends OpenOption> options2, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        SeekableByteChannel seekableByteChannel = this.localFsProvider.newByteChannel(path, options2, Arrays.copyOf(attrs, attrs.length));
        Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"newByteChannel(...)");
        return seekableByteChannel;
    }

    @Override
    @NotNull
    public DirectoryStream<Path> newDirectoryStream(@NotNull Path dir, @Nullable DirectoryStream.Filter<? super Path> filter2) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        DirectoryStream<Path> directoryStream = this.ijentFsProvider.newDirectoryStream(dir, filter2);
        Intrinsics.checkNotNullExpressionValue(directoryStream, (String)"newDirectoryStream(...)");
        return directoryStream;
    }

    @Override
    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.localFsProvider.createDirectory(dir, Arrays.copyOf(attrs, attrs.length));
    }

    @Override
    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.localFsProvider.delete(path);
    }

    @Override
    public void copy(@NotNull Path source, @NotNull Path target, CopyOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.localFsProvider.copy(source, target, Arrays.copyOf(options2, options2.length));
    }

    @Override
    public void move(@NotNull Path source, @NotNull Path target, CopyOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.localFsProvider.move(source, target, Arrays.copyOf(options2, options2.length));
    }

    @Override
    public boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        return this.localFsProvider.isSameFile(path, path2);
    }

    @Override
    public boolean isHidden(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.localFsProvider.isHidden(path);
    }

    @Override
    @NotNull
    public FileStore getFileStore(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileStore fileStore = this.localFsProvider.getFileStore(path);
        Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
        return fileStore;
    }

    @Override
    public void checkAccess(@NotNull Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        this.ijentFsProvider.checkAccess(path, Arrays.copyOf(modes, modes.length));
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(@NotNull Path path, @Nullable Class<V> type, LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return this.localFsProvider.getFileAttributeView(path, type, Arrays.copyOf(options2, options2.length));
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(@NotNull Path path, @Nullable Class<A> type, LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        return this.localFsProvider.readAttributes(path, type, Arrays.copyOf(options2, options2.length));
    }

    @Override
    @NotNull
    public Map<String, Object> readAttributes(@NotNull Path path, @Nullable String attributes, LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        Map<String, Object> map2 = this.localFsProvider.readAttributes(path, attributes, Arrays.copyOf(options2, options2.length));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"readAttributes(...)");
        return map2;
    }

    @Override
    public void setAttribute(@NotNull Path path, @Nullable String attribute, @Nullable Object value, LinkOption ... options2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options2, (String)"options");
        this.localFsProvider.setAttribute(path, attribute, value, Arrays.copyOf(options2, options2.length));
    }

    private static final TransitionalIjentWslFileSystem newFileSystem$lambda$0(TransitionalIjentWslFileSystemProvider this$0, URI $uri, Map $env, URI uRI, TransitionalIjentWslFileSystem old) {
        Intrinsics.checkNotNullParameter((Object)uRI, (String)"<unused var>");
        if (old != null) {
            throw new FileSystemAlreadyExistsException();
        }
        FileSystem fileSystem = this$0.localFsProvider.newFileSystem($uri, $env);
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"newFileSystem(...)");
        FileSystem fileSystem2 = this$0.ijentFsProvider.newFileSystem($uri, $env);
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"newFileSystem(...)");
        return new TransitionalIjentWslFileSystem(this$0, fileSystem, fileSystem2);
    }

    private static final TransitionalIjentWslFileSystem newFileSystem$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        return (TransitionalIjentWslFileSystem)$tmp0.invoke(p0, p1);
    }
}

