/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.syntax.psi.lexer;

import com.intellij.lexer.LexerPosition;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.psi.ElementTypeConverter;
import com.intellij.platform.syntax.psi.ElementTypeConverterKt;
import com.intellij.platform.syntax.psi.lexer.LexerPositionAdapter;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\rH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u000fH\u0016J\b\u0010\u001f\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lcom/intellij/platform/syntax/psi/lexer/LexerAdapter;", "Lcom/intellij/lexer/Lexer;", "lexer", "Lcom/intellij/platform/syntax/lexer/Lexer;", "elementTypeConverter", "Lcom/intellij/platform/syntax/psi/ElementTypeConverter;", "<init>", "(Lcom/intellij/platform/syntax/lexer/Lexer;Lcom/intellij/platform/syntax/psi/ElementTypeConverter;)V", "getLexer", "()Lcom/intellij/platform/syntax/lexer/Lexer;", "getElementTypeConverter", "()Lcom/intellij/platform/syntax/psi/ElementTypeConverter;", "start", "", "buffer", "", "startOffset", "", "endOffset", "initialState", "getState", "getTokenType", "Lcom/intellij/psi/tree/IElementType;", "getTokenStart", "getTokenEnd", "advance", "getCurrentPosition", "Lcom/intellij/lexer/LexerPosition;", "restore", "position", "getBufferSequence", "getBufferEnd", "intellij.platform.syntax.psi"})
@ApiStatus.Experimental
public class LexerAdapter
extends com.intellij.lexer.Lexer {
    @NotNull
    private final Lexer lexer;
    @NotNull
    private final ElementTypeConverter elementTypeConverter;

    public LexerAdapter(@NotNull Lexer lexer, @NotNull ElementTypeConverter elementTypeConverter) {
        this.lexer = lexer;
        this.elementTypeConverter = elementTypeConverter;
    }

    @NotNull
    public final Lexer getLexer() {
        return this.lexer;
    }

    @NotNull
    public final ElementTypeConverter getElementTypeConverter() {
        return this.elementTypeConverter;
    }

    public void start(@NotNull CharSequence buffer2, int startOffset, int endOffset, int initialState) {
        this.lexer.start(buffer2, startOffset, endOffset, initialState);
    }

    public int getState() {
        return this.lexer.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        SyntaxElementType syntaxElementType = this.lexer.getTokenType();
        if (syntaxElementType == null) {
            return null;
        }
        SyntaxElementType syntaxElementType2 = syntaxElementType;
        return ElementTypeConverterKt.convertNotNull(this.elementTypeConverter, syntaxElementType2);
    }

    public int getTokenStart() {
        return this.lexer.getTokenStart();
    }

    public int getTokenEnd() {
        return this.lexer.getTokenEnd();
    }

    public void advance() {
        this.lexer.advance();
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        com.intellij.platform.syntax.lexer.LexerPosition position2 = this.lexer.getCurrentPosition();
        return new LexerPositionAdapter(position2);
    }

    public void restore(@NotNull LexerPosition position2) {
        Intrinsics.checkNotNull((Object)position2, (String)"null cannot be cast to non-null type com.intellij.platform.syntax.psi.lexer.LexerPositionAdapter");
        this.lexer.restore(((LexerPositionAdapter)position2).getPosition());
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.lexer.getBufferSequence();
    }

    public int getBufferEnd() {
        return this.lexer.getBufferEnd();
    }
}

