/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.RequestFocusInToolWindowKt;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/toolWindow/FocusTask;", "Ljava/lang/Runnable;", "toolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "<init>", "(Lcom/intellij/openapi/wm/impl/ToolWindowImpl;)V", "startTime", "", "getStartTime", "()J", "setStartTime", "(J)V", "run", "", "resetStartTime", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nrequestFocusInToolWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 requestFocusInToolWindow.kt\ncom/intellij/toolWindow/FocusTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,122:1\n60#2,5:123\n*S KotlinDebug\n*F\n+ 1 requestFocusInToolWindow.kt\ncom/intellij/toolWindow/FocusTask\n*L\n21#1:123,5\n*E\n"})
public final class FocusTask
implements Runnable {
    @NotNull
    private final ToolWindowImpl toolWindow;
    private long startTime;

    public FocusTask(@NotNull ToolWindowImpl toolWindow2) {
        Intrinsics.checkNotNullParameter((Object)toolWindow2, (String)"toolWindow");
        this.toolWindow = toolWindow2;
        this.startTime = System.currentTimeMillis();
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    @Override
    public void run() {
        if (System.currentTimeMillis() - this.startTime > 10000L) {
            Logger $this$debug_u24default$iv = RequestFocusInToolWindowKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger2 = $this$debug_u24default$iv;
                boolean bl = false;
                logger2.debug("tool window " + this.toolWindow.getId() + " - cannot wait for showing component", t$iv);
            }
            return;
        }
        Component component2 = RequestFocusInToolWindowKt.getShowingComponentToRequestFocus(this.toolWindow);
        if (component2 == null) {
            this.toolWindow.getFocusAlarm().cancel();
            this.resetStartTime();
            this.toolWindow.getFocusAlarm().requestWithCustomDelay(100);
        } else {
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            ToolWindowManagerImpl manager2 = this.toolWindow.toolWindowManager;
            if (owner != component2) {
                manager2.getFocusManager().requestFocusInProject(component2, manager2.getProject());
                RequestFocusInToolWindowKt.bringOwnerToFront(this.toolWindow, true);
            }
            manager2.getFocusManager().doWhenFocusSettlesDown(() -> FocusTask.run$lambda$1(this, component2));
        }
    }

    public final void resetStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    private static final void run$lambda$1(FocusTask this$0, Component $component) {
        RequestFocusInToolWindowKt.access$updateToolWindow(this$0.toolWindow, $component);
    }
}

