/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.toolWindow;

import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.toolWindow.MoreSquareStripeButton;
import com.intellij.toolWindow.ToolWindowLeftToolbar;
import com.intellij.toolWindow.ToolWindowToolbar;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/toolWindow/ShowMoreToolWindowsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "toolWindowToolbar", "Lcom/intellij/toolWindow/ToolWindowToolbar;", "<init>", "(Lcom/intellij/toolWindow/ToolWindowToolbar;)V", "isOnTheLeft", "", "()Z", "minPopupWidth", "", "getMinPopupWidth", "()I", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "showPopup", "popup", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.ide.impl"})
@ApiStatus.Internal
public final class ShowMoreToolWindowsAction
extends DumbAwareAction
implements Toggleable {
    @NotNull
    private final ToolWindowToolbar toolWindowToolbar;
    private final boolean isOnTheLeft;

    public ShowMoreToolWindowsAction(@NotNull ToolWindowToolbar toolWindowToolbar) {
        Intrinsics.checkNotNullParameter((Object)toolWindowToolbar, (String)"toolWindowToolbar");
        this.toolWindowToolbar = toolWindowToolbar;
        this.isOnTheLeft = this.toolWindowToolbar instanceof ToolWindowLeftToolbar;
    }

    public final boolean isOnTheLeft() {
        return this.isOnTheLeft;
    }

    private final int getMinPopupWidth() {
        return JBUI.scale((int)300);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JBPopup jBPopup = this.createPopup(e);
        if (jBPopup == null) {
            return;
        }
        JBPopup popup2 = jBPopup;
        this.showPopup(popup2);
    }

    @Nullable
    public final JBPopup createPopup(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project2 = e.getProject();
        if (project2 == null) {
            return null;
        }
        List<ActivateToolWindowAction> actions = ToolWindowsGroup.getToolWindowActions(project2, true);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(actions), e.getDataContext(), null, true);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup2 = listPopup;
        popup2.setMinimumSize(new Dimension(this.getMinPopupWidth(), -1));
        PopupUtil.addToggledStateListener((JBPopup)((JBPopup)popup2), (Presentation)e.getPresentation());
        return (JBPopup)popup2;
    }

    public final void showPopup(@NotNull JBPopup popup2) {
        Intrinsics.checkNotNullParameter((Object)popup2, (String)"popup");
        MoreSquareStripeButton moreSquareStripeButton = this.toolWindowToolbar.getMoreButton$intellij_platform_ide_impl();
        int x = this.isOnTheLeft ? this.toolWindowToolbar.getWidth() : -this.getMinPopupWidth();
        popup2.show(new RelativePoint((Component)((Object)this.toolWindowToolbar), new Point(x, moreSquareStripeButton.getY())));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

