/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.gdpr.Consent;
import com.intellij.ide.gdpr.ConsentOptions;
import com.intellij.ide.gdpr.localConsents.LocalConsentOptions;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AppIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.svg.SvgKt;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ResourceUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.system.OS;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0006H\u0000\u001a\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001\u001a\u0006\u0010\u001e\u001a\u00020\u0006\u001a\u0016\u0010\u001f\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0003H\u0002\u001a\u0016\u0010\"\u001a\u00020\f2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006$"}, d2={"VENDOR_PREFIX", "", "appIcons", "", "Ljava/awt/Image;", "isMacDocIconSet", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "updateAppWindowIcon", "", "window", "Ljava/awt/Window;", "loadAppIconImage", "svgPath", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "size", "", "findAppIconSvgData", "", "path", "pixScale", "", "loadSmallApplicationIcon", "Ljavax/swing/Icon;", "requestReleaseIcon", "findAppIcon", "isWindowIconAlreadyExternallySet", "removeTraceLocalConsents", "localConsents", "Lcom/intellij/ide/gdpr/Consent;", "removeTraceConsents", "consents", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nAppUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppUIUtil.kt\ncom/intellij/ui/AppUIUtilKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,549:1\n13#2:550\n*S KotlinDebug\n*F\n+ 1 AppUIUtil.kt\ncom/intellij/ui/AppUIUtilKt\n*L\n70#1:550\n*E\n"})
public final class AppUIUtilKt {
    @NotNull
    private static final String VENDOR_PREFIX = "jetbrains-";
    @Nullable
    private static List<Image> appIcons;
    private static volatile boolean isMacDocIconSet;

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger2 = Logger.getInstance(AppUIUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        return logger2;
    }

    public static final void updateAppWindowIcon(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (isMacDocIconSet || AppUIUtilKt.isWindowIconAlreadyExternallySet()) {
            return;
        }
        List<Image> images = null;
        images = appIcons;
        if (images == null) {
            Image it;
            images = new ArrayList<Image>(3);
            ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
            ApplicationInfoEx appInfo = applicationInfoEx;
            ScaleContext scaleContext = ScaleContext.Companion.create((Component)window);
            if (OS.CURRENT == OS.Linux) {
                String string = appInfo.getApplicationSvgIconUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationSvgIconUrl(...)");
                Image image2 = AppUIUtilKt.loadAppIconImage(string, scaleContext, 128);
                if (image2 != null) {
                    it = image2;
                    boolean bl = false;
                    ((ArrayList)images).add(it);
                }
            }
            String string = appInfo.getApplicationSvgIconUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getApplicationSvgIconUrl(...)");
            Image image3 = AppUIUtilKt.loadAppIconImage(string, scaleContext, 32);
            if (image3 != null) {
                it = image3;
                boolean bl = false;
                ((ArrayList)images).add(it);
            }
            if (OS.CURRENT == OS.Windows) {
                String string2 = appInfo.getSmallApplicationSvgIconUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSmallApplicationSvgIconUrl(...)");
                Image image4 = AppUIUtilKt.loadAppIconImage(string2, scaleContext, 16);
                if (image4 != null) {
                    it = image4;
                    boolean bl = false;
                    ((ArrayList)images).add(it);
                }
            }
            int n = ((Collection)images).size();
            for (int i2 = 0; i2 < n; ++i2) {
                Image image5 = (Image)((ArrayList)images).get(i2);
                if (!(image5 instanceof JBHiDPIScaledImage)) continue;
                ((ArrayList)images).set(i2, ((JBHiDPIScaledImage)image5).getDelegate());
            }
            appIcons = images;
        }
        if (!images.isEmpty()) {
            if (OS.CURRENT != OS.macOS) {
                window.setIconImages(images);
            } else if (!isMacDocIconSet) {
                Object object = CollectionsKt.first(images);
                Intrinsics.checkNotNull((Object)object);
                AppIcon.MacAppIcon.setDockIcon(ImageUtil.toBufferedImage((Image)((Image)object)));
                isMacDocIconSet = true;
            }
        }
    }

    private static final Image loadAppIconImage(String svgPath, ScaleContext scaleContext, int size2) {
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        float sysScale = (float)scaleContext.getScale(ScaleType.SYS_SCALE);
        float userScale = (float)scaleContext.getScale(ScaleType.USR_SCALE);
        int userSize = MathKt.roundToInt((float)((float)size2 * userScale));
        byte[] svgData = AppUIUtilKt.findAppIconSvgData(svgPath, pixScale);
        if (svgData == null) {
            AppUIUtilKt.getLOG().warn("Cannot load SVG application icon from " + svgPath);
            return null;
        }
        return (Image)CollectionsKt.first((List)SvgKt.loadWithSizes((List)CollectionsKt.listOf((Object)userSize), (byte[])svgData, (float)sysScale));
    }

    private static final byte[] findAppIconSvgData(String path, float pixScale) {
        long loadingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        List descriptors2 = ImageDescriptorKt.createImageDescriptorList((String)path, (boolean)false, (boolean)false, (float)pixScale);
        String string = path.substring(StringsKt.startsWith$default((CharSequence)path, (char)'/', (boolean)false, (int)2, null) ? 1 : 0, StringsKt.lastIndexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String rawPathWithoutExt = string;
        for (ImageDescriptor descriptor2 : descriptors2) {
            String transformedPath = (String)descriptor2.pathTransform.invoke((Object)rawPathWithoutExt, (Object)"svg");
            long resourceLoadStart = StartUpMeasurer.getCurrentTimeIfEnabled();
            byte[] byArray = ResourceUtil.getResourceAsBytes((String)transformedPath, (ClassLoader)AppUIUtil.class.getClassLoader(), (boolean)true);
            if (byArray == null) continue;
            byte[] data2 = byArray;
            if (resourceLoadStart != -1L) {
                IconLoadMeasurer.loadFromResources.end(resourceLoadStart);
            }
            if (loadingStart != -1L) {
                IconLoadMeasurer.INSTANCE.addLoading(descriptor2.isSvg, loadingStart);
            }
            return data2;
        }
        return null;
    }

    @NotNull
    public static final Icon loadSmallApplicationIcon(@NotNull ScaleContext scaleContext, int size2) {
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        return AppUIUtilKt.loadSmallApplicationIcon(scaleContext, size2, !ApplicationInfoImpl.getShadowInstance().isEAP());
    }

    public static /* synthetic */ Icon loadSmallApplicationIcon$default(ScaleContext scaleContext, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 16;
        }
        return AppUIUtilKt.loadSmallApplicationIcon(scaleContext, n);
    }

    @NotNull
    public static final Icon loadSmallApplicationIcon(@NotNull ScaleContext scaleContext, int size2, boolean requestReleaseIcon) {
        boolean upscale;
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfoEx, (String)"getShadowInstance(...)");
        ApplicationInfoEx appInfo = applicationInfoEx;
        boolean bl = upscale = (double)size2 * scaleContext.getScale(DerivedScaleType.PIX_SCALE) >= 20.0;
        String string = appInfo instanceof ApplicationInfoImpl ? (upscale ? ((ApplicationInfoImpl)appInfo).getApplicationSvgIconUrl(!requestReleaseIcon) : ((ApplicationInfoImpl)appInfo).getSmallApplicationSvgIconUrl(!requestReleaseIcon)) : (upscale ? appInfo.getApplicationSvgIconUrl() : appInfo.getSmallApplicationSvgIconUrl());
        Intrinsics.checkNotNull((Object)string);
        String svgUrl = string;
        Image image2 = AppUIUtilKt.loadAppIconImage(svgUrl, scaleContext, size2);
        if (image2 == null) {
            throw new IllegalStateException(("Can't load '" + svgUrl + "'").toString());
        }
        return (Icon)new JBImageIcon(image2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final String findAppIcon() {
        Path svgFile;
        Path path;
        AutoCloseable autoCloseable = Files.list(Path.of(PathManager.getBinPath(), new String[0]));
        Throwable throwable = null;
        try {
            Stream stream = (Stream)autoCloseable;
            boolean bl = false;
            path = stream.filter(arg_0 -> AppUIUtilKt.findAppIcon$lambda$0$1(AppUIUtilKt::findAppIcon$lambda$0$0, arg_0)).findFirst().orElse(null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Path path2 = svgFile = path;
        if (path2 != null) {
            return ((Object)path2).toString();
        }
        URL url = ApplicationInfo.class.getResource(ApplicationInfoImpl.getShadowInstance().getApplicationSvgIconUrl());
        return url != null && Intrinsics.areEqual((Object)"file", (Object)url.getProtocol()) ? URLUtil.urlToFile((URL)url).getAbsolutePath() : null;
    }

    public static final boolean isWindowIconAlreadyExternallySet() {
        OS oS = OS.CURRENT;
        return switch (oS == null ? -1 : WhenMappings.$EnumSwitchMapping$0[oS.ordinal()]) {
            case 1 -> {
                if (Boolean.getBoolean("ide.native.launcher") && SystemInfo.isJetBrainsJvm) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (isMacDocIconSet || !PluginManagerCore.isRunningFromSources()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static final void removeTraceLocalConsents(List<Consent> localConsents) {
        localConsents.removeIf(arg_0 -> AppUIUtilKt.removeTraceLocalConsents$lambda$1(AppUIUtilKt::removeTraceLocalConsents$lambda$0, arg_0));
    }

    private static final void removeTraceConsents(List<Consent> consents) {
        consents.removeIf(arg_0 -> AppUIUtilKt.removeTraceConsents$lambda$1(AppUIUtilKt::removeTraceConsents$lambda$0, arg_0));
    }

    private static final boolean findAppIcon$lambda$0$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"svg");
    }

    private static final boolean findAppIcon$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeTraceLocalConsents$lambda$0(Consent localConsent) {
        Intrinsics.checkNotNullParameter((Object)localConsent, (String)"localConsent");
        return LocalConsentOptions.condTraceDataCollectionNonComLocalConsent().test(localConsent) || LocalConsentOptions.condTraceDataCollectionComLocalConsent().test(localConsent);
    }

    private static final boolean removeTraceLocalConsents$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeTraceConsents$lambda$0(Consent consent) {
        Intrinsics.checkNotNullParameter((Object)consent, (String)"consent");
        return ConsentOptions.condTraceDataCollectionConsent().test(consent) || ConsentOptions.condTraceDataCollectionComConsent().test(consent) || ConsentOptions.condTraceDataCollectionNonComConsent().test(consent);
    }

    private static final boolean removeTraceConsents$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Image access$loadAppIconImage(String svgPath, ScaleContext scaleContext, int size2) {
        return AppUIUtilKt.loadAppIconImage(svgPath, scaleContext, size2);
    }

    public static final /* synthetic */ void access$removeTraceConsents(List consents) {
        AppUIUtilKt.removeTraceConsents(consents);
    }

    public static final /* synthetic */ void access$removeTraceLocalConsents(List localConsents) {
        AppUIUtilKt.removeTraceLocalConsents(localConsents);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.macOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

