/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IconManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001cJ\u000e\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001cJ\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u001cJ\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u00070\u0003\u00a2\u0006\u0002\b\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\u0007R\u001b\u0010\r\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\u0007R\u001b\u0010\u0010\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0011\u0010\u0007R\u001b\u0010\u0013\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0014\u0010\u0007R\u001b\u0010\u0016\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0017\u0010\u0007R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/intellij/ui/BadgeIconSupplier;", "", "originalIcon", "Ljavax/swing/Icon;", "<init>", "(Ljavax/swing/Icon;)V", "getOriginalIcon", "()Ljavax/swing/Icon;", "oldLiveIndicatorIcon", "Lorg/jetbrains/annotations/NotNull;", "getOldLiveIndicatorIcon", "oldLiveIndicatorIcon$delegate", "Lkotlin/Lazy;", "errorIcon", "getErrorIcon", "errorIcon$delegate", "warningIcon", "getWarningIcon", "warningIcon$delegate", "infoIcon", "getInfoIcon", "infoIcon$delegate", "successIcon", "getSuccessIcon", "successIcon$delegate", "liveIndicatorIcon", "getLiveIndicatorIcon", "error", "", "warning", "info", "success", "alive", "intellij.platform.ide.impl"})
public final class BadgeIconSupplier {
    @NotNull
    private final Icon originalIcon;
    @NotNull
    private final Lazy oldLiveIndicatorIcon$delegate;
    @NotNull
    private final Lazy errorIcon$delegate;
    @NotNull
    private final Lazy warningIcon$delegate;
    @NotNull
    private final Lazy infoIcon$delegate;
    @NotNull
    private final Lazy successIcon$delegate;

    public BadgeIconSupplier(@NotNull Icon originalIcon) {
        Intrinsics.checkNotNullParameter((Object)originalIcon, (String)"originalIcon");
        this.originalIcon = originalIcon;
        this.oldLiveIndicatorIcon$delegate = LazyKt.lazy(() -> BadgeIconSupplier.oldLiveIndicatorIcon_delegate$lambda$0(this));
        this.errorIcon$delegate = LazyKt.lazy(() -> BadgeIconSupplier.errorIcon_delegate$lambda$0(this));
        this.warningIcon$delegate = LazyKt.lazy(() -> BadgeIconSupplier.warningIcon_delegate$lambda$0(this));
        this.infoIcon$delegate = LazyKt.lazy(() -> BadgeIconSupplier.infoIcon_delegate$lambda$0(this));
        this.successIcon$delegate = LazyKt.lazy(() -> BadgeIconSupplier.successIcon_delegate$lambda$0(this));
    }

    @NotNull
    public final Icon getOriginalIcon() {
        return this.originalIcon;
    }

    private final Icon getOldLiveIndicatorIcon() {
        Lazy lazy = this.oldLiveIndicatorIcon$delegate;
        return (Icon)lazy.getValue();
    }

    @NotNull
    public final Icon getErrorIcon() {
        Lazy lazy = this.errorIcon$delegate;
        return (Icon)lazy.getValue();
    }

    @NotNull
    public final Icon getWarningIcon() {
        Lazy lazy = this.warningIcon$delegate;
        return (Icon)lazy.getValue();
    }

    @NotNull
    public final Icon getInfoIcon() {
        Lazy lazy = this.infoIcon$delegate;
        return (Icon)lazy.getValue();
    }

    @NotNull
    public final Icon getSuccessIcon() {
        Lazy lazy = this.successIcon$delegate;
        return (Icon)lazy.getValue();
    }

    @NotNull
    public final Icon getLiveIndicatorIcon() {
        return ExperimentalUI.Companion.isNewUI() ? this.getSuccessIcon() : this.getOldLiveIndicatorIcon();
    }

    @NotNull
    public final Icon getErrorIcon(boolean error2) {
        return error2 ? this.getErrorIcon() : this.originalIcon;
    }

    @NotNull
    public final Icon getWarningIcon(boolean warning) {
        return warning ? this.getWarningIcon() : this.originalIcon;
    }

    @NotNull
    public final Icon getInfoIcon(boolean info) {
        return info ? this.getInfoIcon() : this.originalIcon;
    }

    @NotNull
    public final Icon getSuccessIcon(boolean success2) {
        return success2 ? this.getSuccessIcon() : this.originalIcon;
    }

    @NotNull
    public final Icon getLiveIndicatorIcon(boolean alive) {
        return alive ? this.getLiveIndicatorIcon() : this.originalIcon;
    }

    private static final Icon oldLiveIndicatorIcon_delegate$lambda$0(BadgeIconSupplier this$0) {
        return ExecutionUtil.getLiveIndicator((Icon)this$0.originalIcon);
    }

    private static final Icon errorIcon_delegate$lambda$0(BadgeIconSupplier this$0) {
        IconManager iconManager = IconManager.Companion.getInstance();
        Icon icon2 = this$0.originalIcon;
        Color color = JBUI.CurrentTheme.IconBadge.ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"ERROR");
        return iconManager.withIconBadge(icon2, (Paint)color);
    }

    private static final Icon warningIcon_delegate$lambda$0(BadgeIconSupplier this$0) {
        IconManager iconManager = IconManager.Companion.getInstance();
        Icon icon2 = this$0.originalIcon;
        Color color = JBUI.CurrentTheme.IconBadge.WARNING;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WARNING");
        return iconManager.withIconBadge(icon2, (Paint)color);
    }

    private static final Icon infoIcon_delegate$lambda$0(BadgeIconSupplier this$0) {
        IconManager iconManager = IconManager.Companion.getInstance();
        Icon icon2 = this$0.originalIcon;
        Color color = JBUI.CurrentTheme.IconBadge.INFORMATION;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"INFORMATION");
        return iconManager.withIconBadge(icon2, (Paint)color);
    }

    private static final Icon successIcon_delegate$lambda$0(BadgeIconSupplier this$0) {
        IconManager iconManager = IconManager.Companion.getInstance();
        Icon icon2 = this$0.originalIcon;
        Color color = JBUI.CurrentTheme.IconBadge.SUCCESS;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"SUCCESS");
        return iconManager.withIconBadge(icon2, (Paint)color);
    }
}

