/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.ColorPickerListener;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.SlideComponent;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.colorpicker.ColorPickerBuilder;
import com.intellij.ui.colorpicker.ColorPickerComponentProvider;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipetteButton;
import com.intellij.ui.colorpicker.LightCalloutPopup;
import com.intellij.ui.colorpicker.MaterialGraphicalColorPipetteProvider;
import com.intellij.ui.colorpicker.RecentColorsPalette;
import com.intellij.ui.picker.ColorListener;
import com.intellij.ui.picker.ColorPickerPopupCloseListener;
import com.intellij.ui.picker.ColorPipette;
import com.intellij.ui.picker.ColorPipetteBase;
import com.intellij.ui.picker.MacColorPipette;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorPicker
extends JPanel
implements ColorListener,
DocumentListener {
    private static final String COLOR_CHOOSER_COLORS_KEY = "ColorChooser.RecentColors";
    private static final String HSB_PROPERTY = "color.picker.is.hsb";
    private Color myColor;
    private ColorPreviewComponent myPreviewComponent;
    private final ColorWheelPanel myColorWheelPanel;
    private final JTextField myRed;
    private final JTextField myGreen;
    private final JTextField myBlue;
    private final JTextField myHex;
    private final Alarm myUpdateQueue;
    private final List<? extends ColorPickerListener> myExternalListeners;
    private RecentColorsComponent myRecentColorsComponent;
    @Nullable
    private final ColorPipette myPicker;
    private final JLabel myR;
    private final JLabel myG;
    private final JLabel myB;
    private final JLabel myR_after;
    private final JLabel myG_after;
    private final JLabel myB_after;
    private final JComboBox<String> myFormat;

    public ColorPicker(@NotNull Disposable parent, @Nullable Color color, boolean enableOpacity) {
        if (parent == null) {
            ColorPicker.$$$reportNull$$$0(0);
        }
        this(parent, color, true, enableOpacity, Collections.emptyList(), false);
    }

    private ColorPicker(@NotNull Disposable parent, @Nullable Color color, boolean restoreColors, boolean enableOpacity, List<? extends ColorPickerListener> listeners, boolean opacityInPercent) {
        if (parent == null) {
            ColorPicker.$$$reportNull$$$0(1);
        }
        this.myR = new JLabel(IdeBundle.message((String)"colorpicker.label.red", (Object[])new Object[0]));
        this.myG = new JLabel(IdeBundle.message((String)"colorpicker.label.green", (Object[])new Object[0]));
        this.myB = new JLabel(IdeBundle.message((String)"colorpicker.label.blue", (Object[])new Object[0]));
        this.myR_after = new JLabel(" ");
        this.myG_after = new JLabel(" ");
        this.myB_after = new JLabel(" ");
        this.myFormat = new ComboBox<String>(new String[]{IdeBundle.message((String)"colorpicker.format.rgb", (Object[])new Object[0]), IdeBundle.message((String)"colorpicker.format.hsb", (Object[])new Object[0])}){

            public Dimension getPreferredSize() {
                Dimension size2 = super.getPreferredSize();
                UIThemeLookAndFeelInfo info = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
                if (info != null && info.getName().contains("Windows")) {
                    size2.width += 10;
                }
                return size2;
            }
        };
        this.myUpdateQueue = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parent);
        this.myRed = this.createColorField(false);
        this.myGreen = this.createColorField(false);
        this.myBlue = this.createColorField(false);
        this.myHex = this.createColorField(true);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.myColorWheelPanel = new ColorWheelPanel(this, enableOpacity, opacityInPercent);
        this.myExternalListeners = listeners;
        this.myFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesComponent.getInstance().setValue(ColorPicker.HSB_PROPERTY, String.valueOf(!ColorPicker.this.isRGBMode()), Boolean.FALSE.toString());
                ColorPicker.this.myR.setText(IdeBundle.message((String)(ColorPicker.this.isRGBMode() ? "colorpicker.label.red" : "colorpicker.label.hue"), (Object[])new Object[0]));
                ColorPicker.this.myR_after.setText(ColorPicker.this.isRGBMode() ? " " : "\u00b0");
                ColorPicker.this.myG.setText(IdeBundle.message((String)(ColorPicker.this.isRGBMode() ? "colorpicker.label.green" : "colorpicker.label.saturation"), (Object[])new Object[0]));
                ColorPicker.this.myG_after.setText(ColorPicker.this.isRGBMode() ? " " : "%");
                ColorPicker.this.myB.setText(IdeBundle.message((String)(ColorPicker.this.isRGBMode() ? "colorpicker.label.blue" : "colorpicker.label.brightness"), (Object[])new Object[0]));
                ColorPicker.this.myB_after.setText(ColorPicker.this.isRGBMode() ? " " : "%");
                ColorPicker.this.applyColor(ColorPicker.this.myColor);
            }
        });
        this.myPicker = this.createPipette(new ColorListener(){

            public void colorChanged(Color color, Object source) {
                ColorPicker.this.setColor(color, source);
            }
        }, parent);
        try {
            this.add((Component)this.buildTopPanel(true), "North");
            this.add((Component)this.myColorWheelPanel, "Center");
            this.myRecentColorsComponent = new RecentColorsComponent(new ColorListener(){

                public void colorChanged(Color color, Object source) {
                    ColorPicker.this.setColor(color, source);
                }
            }, restoreColors);
            this.add((Component)this.myRecentColorsComponent, "South");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        Color c = (Color)ObjectUtils.notNull((Object)(color == null ? this.myRecentColorsComponent.getMostRecentColor() : color), (Object)Color.WHITE);
        this.setColor(c, this);
        this.setSize(300, 350);
        boolean hsb = PropertiesComponent.getInstance().getBoolean(HSB_PROPERTY);
        if (hsb) {
            this.myFormat.setSelectedIndex(1);
        }
    }

    @Nullable
    public static RelativePoint bestLocationForColorPickerPopup(@Nullable Editor editor2) {
        Component component2;
        Component clickComponent;
        if (editor2 == null || editor2.isDisposed()) {
            return null;
        }
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && (clickComponent = SwingUtilities.getDeepestComponentAt(component2 = ((MouseEvent)event).getComponent(), ((MouseEvent)event).getX(), ((MouseEvent)event).getY())) instanceof EditorGutter) {
            return null;
        }
        VisualPosition visualPosition = editor2.getCaretModel().getCurrentCaret().getVisualPosition();
        Point pointInEditor = editor2.visualPositionToXY(new VisualPosition(visualPosition.line + 1, visualPosition.column));
        return new RelativePoint((Component)editor2.getContentComponent(), pointInEditor);
    }

    @Nullable
    private ColorPipette createPipette(@NotNull ColorListener colorListener, @NotNull Disposable parentDisposable) {
        ColorPipette pipette;
        if (colorListener == null) {
            ColorPicker.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            ColorPicker.$$$reportNull$$$0(3);
        }
        if (ColorPipetteBase.canUseMacPipette() && (pipette = ColorPicker.getPipetteIfAvailable(new MacColorPipette(this, colorListener), parentDisposable)) != null) {
            return pipette;
        }
        return ColorPicker.getPipetteIfAvailable(new DefaultColorPipette(this, colorListener), parentDisposable);
    }

    @Nullable
    private static ColorPipette getPipetteIfAvailable(@NotNull ColorPipette pipette, @NotNull Disposable parentDisposable) {
        if (pipette == null) {
            ColorPicker.$$$reportNull$$$0(4);
        }
        if (parentDisposable == null) {
            ColorPicker.$$$reportNull$$$0(5);
        }
        if (pipette.isAvailable()) {
            Disposer.register((Disposable)parentDisposable, (Disposable)pipette);
            return pipette;
        }
        Disposer.dispose((Disposable)pipette);
        return null;
    }

    private boolean isRGBMode() {
        return this.myFormat.getSelectedIndex() == 0;
    }

    private JTextField createColorField(boolean hex) {
        NumberDocument doc = new NumberDocument(hex);
        final JTextField field = new JTextField("");
        field.setDocument(doc);
        doc.setSource(field);
        field.getDocument().addDocumentListener(this);
        field.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                field.selectAll();
            }

            @Override
            public void focusLost(FocusEvent event) {
                ColorPicker.this.myUpdateQueue.cancelAllRequests();
                ColorPicker.this.validateAndUpdatePreview(field);
            }
        });
        return field;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myHex;
    }

    private void setColor(Color color, Object src) {
        this.colorChanged(color, src);
        this.myColorWheelPanel.setColor(color, src);
    }

    public void appendRecentColor() {
        this.myRecentColorsComponent.appendColor(this.myColor);
    }

    public void saveRecentColors() {
        this.myRecentColorsComponent.saveColors();
    }

    public Color getColor() {
        if (this.myColorWheelPanel.myColorWheel.myOpacity == 255) {
            return this.myColor;
        }
        return new Color(this.myColor.getRed(), this.myColor.getGreen(), this.myColor.getBlue(), this.myColorWheelPanel.myColorWheel.myOpacity);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(((NumberDocument)e.getDocument()).mySrc);
    }

    private void update(JTextField src) {
        if (!src.hasFocus()) {
            return;
        }
        this.myUpdateQueue.cancelAllRequests();
        this.myUpdateQueue.addRequest(() -> this.validateAndUpdatePreview(src), 300);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(((NumberDocument)e.getDocument()).mySrc);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void validateAndUpdatePreview(JTextField src) {
        Color c;
        boolean fromHex;
        boolean bl = fromHex = src == this.myHex;
        Color color = fromHex ? ((c = ColorUtil.fromHex((String)this.myHex.getText(), null)) != null ? ColorUtil.toAlpha((Color)c, (int)this.myColorWheelPanel.myColorWheel.myOpacity) : null) : this.gatherRGB();
        if (color != null) {
            if (this.myColorWheelPanel.myOpacityComponent != null) {
                color = ColorUtil.toAlpha((Color)color, (int)this.myColorWheelPanel.myOpacityComponent.getValue());
            }
            this.updatePreview(color, fromHex);
        }
    }

    private void updatePreview(Color color, boolean fromHex) {
        if (color != null && !color.equals(this.myColor)) {
            this.myColor = color;
            this.myPreviewComponent.setColor(color);
            this.myColorWheelPanel.setColor(color, fromHex ? this.myHex : null);
            if (fromHex) {
                this.applyColor(color);
            } else {
                this.applyColorToHEX(color);
            }
            this.fireColorChanged(color);
        }
    }

    public void colorChanged(Color color, Object source) {
        if (color != null && !color.equals(this.myColor)) {
            this.myColor = color;
            this.applyColor(color);
            if (source != this.myHex) {
                this.applyColorToHEX(color);
            }
            this.myPreviewComponent.setColor(color);
            this.fireColorChanged(color);
        }
    }

    private void fireColorChanged(Color color) {
        if (this.myExternalListeners == null) {
            return;
        }
        for (ColorPickerListener colorPickerListener : this.myExternalListeners) {
            colorPickerListener.colorChanged(color);
        }
    }

    private void fireClosed(@Nullable Color color) {
        if (this.myExternalListeners == null) {
            return;
        }
        for (ColorPickerListener colorPickerListener : this.myExternalListeners) {
            colorPickerListener.closed(color);
        }
    }

    @Nullable
    private Color gatherRGB() {
        try {
            int r = Integer.parseInt(this.myRed.getText());
            int g = Integer.parseInt(this.myGreen.getText());
            int b = Integer.parseInt(this.myBlue.getText());
            return this.isRGBMode() ? new Color(r, g, b) : new Color(Color.HSBtoRGB((float)r / 360.0f, (float)g / 100.0f, (float)b / 100.0f));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void applyColorToHEX(Color c) {
        this.myHex.setText(String.format("%06X", 0xFFFFFF & c.getRGB()));
    }

    private void applyColorToRGB(Color color) {
        this.myRed.setText(String.valueOf(color.getRed()));
        this.myGreen.setText(String.valueOf(color.getGreen()));
        this.myBlue.setText(String.valueOf(color.getBlue()));
    }

    private void applyColorToHSB(Color c) {
        float[] hbs = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.myRed.setText(String.valueOf((int)(360.0f * hbs[0])));
        this.myGreen.setText(String.valueOf((int)(100.0f * hbs[1])));
        this.myBlue.setText(String.valueOf((int)(100.0f * hbs[2])));
    }

    private void applyColor(Color color) {
        if (this.isRGBMode()) {
            this.applyColorToRGB(color);
        } else {
            this.applyColorToHSB(color);
        }
    }

    @Nullable
    public static Color showDialog(@NotNull Component parent, @NlsContexts.DialogTitle String caption, Color preselectedColor, boolean enableOpacity, List<? extends ColorPickerListener> listeners, boolean opacityInPercent) {
        if (parent == null) {
            ColorPicker.$$$reportNull$$$0(6);
        }
        ColorPickerDialog dialog2 = new ColorPickerDialog(parent, caption, preselectedColor, enableOpacity, listeners, opacityInPercent);
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            return dialog2.getColor();
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static void showColorPickerPopup(@Nullable Project project2, @Nullable Color currentColor, @NotNull ColorListener listener2) {
        if (listener2 == null) {
            ColorPicker.$$$reportNull$$$0(7);
        }
        ColorPicker.showColorPickerPopup(project2, currentColor, listener2, null, false);
    }

    @Deprecated(forRemoval=true)
    public static void showColorPickerPopup(@Nullable Project project2, @Nullable Color currentColor, @NotNull ColorListener listener2, @Nullable RelativePoint location, boolean showAlpha) {
        if (listener2 == null) {
            ColorPicker.$$$reportNull$$$0(8);
        }
        ColorPicker.showColorPickerPopup(project2, currentColor, listener2, location, showAlpha, false, null);
    }

    static void showColorPickerPopup(final @Nullable Project project2, @Nullable Color currentColor, final @NotNull ColorListener listener2, @Nullable RelativePoint location, boolean showAlpha, boolean showAlphaAsPercent, @Nullable ColorPickerPopupCloseListener popupCloseListener) {
        if (listener2 == null) {
            ColorPicker.$$$reportNull$$$0(9);
        }
        if (!ColorPicker.isEnoughSpaceToShowPopup() || !Registry.is((String)"ide.new.color.picker")) {
            Color color = ColorPicker.showDialog(IdeFocusManager.getGlobalInstance().getFocusOwner(), IdeBundle.message((String)"dialog.title.choose.color", (Object[])new Object[0]), currentColor, showAlpha, null, showAlphaAsPercent);
            if (color != null) {
                listener2.colorChanged(color, null);
            }
            return;
        }
        final Ref ref2 = Ref.create();
        ColorListener colorListener = new ColorListener(){
            final Object groupId = new Object();
            final Alarm alarm = new Alarm();

            public void colorChanged(Color color, Object source) {
                Runnable apply2 = () -> CommandProcessor.getInstance().executeCommand(project2, () -> listener2.colorChanged(color, source), IdeBundle.message((String)"command.name.apply.color", (Object[])new Object[0]), this.groupId);
                this.alarm.cancelAllRequests();
                Runnable request = () -> ApplicationManager.getApplication().invokeLaterOnWriteThread(apply2);
                if (source instanceof ColorPipetteButton && ((ColorPipetteButton)source).getCurrentState() == ColorPipetteButton.PipetteState.UPDATING) {
                    this.alarm.addRequest(request, 150);
                } else {
                    request.run();
                }
            }
        };
        final List<Color> recentColors = RecentColorsComponent.getRecentColors();
        ColorPickerBuilder builder = new ColorPickerBuilder(showAlpha, showAlphaAsPercent).setOriginalColor(currentColor).addSaturationBrightnessComponent().addColorAdjustPanel(new MaterialGraphicalColorPipetteProvider()).addColorValuePanel().withFocus();
        if (!recentColors.isEmpty()) {
            builder.addCustomComponent(new ColorPickerComponentProvider(){

                @Override
                @NotNull
                public JComponent createComponent(@NotNull ColorPickerModel colorPickerModel) {
                    if (colorPickerModel == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    return new RecentColorsPalette(colorPickerModel, recentColors);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorPickerModel", "com/intellij/ui/ColorPicker$7", "createComponent"));
                }
            });
        }
        builder.addColorListener(colorListener, true).addColorListener(new ColorListener(){

            public void colorChanged(Color color, Object source) {
                ColorPicker.updatePointer((Ref<LightCalloutPopup>)ref2);
            }
        }, true).addColorListener(new ColorListener(){

            public void colorChanged(Color color, Object source) {
                RecentColorsComponent.saveRecentColors(RecentColorsComponent.appendColor(color, recentColors, 20));
            }
        }, false).focusWhenDisplay(true).setFocusCycleRoot(true).addKeyAction(KeyStroke.getKeyStroke(27, 0), ColorPicker.cancelPopup((Ref<LightCalloutPopup>)ref2)).addKeyAction(KeyStroke.getKeyStroke(10, 0), ColorPicker.applyColor((Ref<LightCalloutPopup>)ref2)).setPopupCloseListener(popupCloseListener);
        LightCalloutPopup popup2 = builder.build();
        ref2.set((Object)popup2);
        if (location == null) {
            location = new RelativePoint(MouseInfo.getPointerInfo().getLocation());
        }
        popup2.show(location.getScreenPoint());
        ColorPicker.updatePointer((Ref<LightCalloutPopup>)ref2);
    }

    private static boolean isEnoughSpaceToShowPopup() {
        DialogWrapper currentDialog = DialogWrapper.findInstanceFromFocus();
        return currentDialog == null || currentDialog.getWindow().getWidth() >= 500 && currentDialog.getWindow().getHeight() >= 500;
    }

    private static void updatePointer(Ref<LightCalloutPopup> ref2) {
        LightCalloutPopup popup2 = (LightCalloutPopup)ref2.get();
        Balloon balloon = popup2.getBalloon();
        if (balloon instanceof BalloonImpl) {
            RelativePoint showingPoint = ((BalloonImpl)balloon).getShowingPoint();
            Color c = popup2.getPointerColor(showingPoint, ((BalloonImpl)balloon).getComponent());
            if (c != null) {
                c = ColorUtil.withAlpha((Color)c, (double)1.0);
            }
            ((BalloonImpl)balloon).setPointerColor(c);
        }
    }

    @NotNull
    private static AbstractAction cancelPopup(final Ref<LightCalloutPopup> ref2) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightCalloutPopup popup2 = (LightCalloutPopup)ref2.get();
                if (popup2 != null) {
                    popup2.cancel();
                }
            }
        };
    }

    @NotNull
    private static AbstractAction applyColor(final Ref<LightCalloutPopup> ref2) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LightCalloutPopup popup2 = (LightCalloutPopup)ref2.get();
                if (popup2 != null) {
                    popup2.close();
                }
            }
        };
    }

    private JComponent buildTopPanel(boolean enablePipette) throws ParseException {
        JPanel result2 = new JPanel(new BorderLayout());
        JPanel previewPanel = new JPanel(new BorderLayout());
        if (enablePipette && this.myPicker != null) {
            JButton pipette = new JButton();
            pipette.setUI(new BasicButtonUI());
            pipette.setRolloverEnabled(true);
            pipette.setIcon(AllIcons.Ide.Pipette);
            pipette.setBorder((Border)JBUI.Borders.empty());
            pipette.setRolloverIcon(AllIcons.Ide.PipetteRollover);
            pipette.setFocusable(false);
            pipette.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorPicker.this.myPicker.setInitialColor(ColorPicker.this.getColor());
                    ColorPicker.this.myPicker.show();
                }
            });
            previewPanel.add((Component)pipette, "West");
        }
        this.myPreviewComponent = new ColorPreviewComponent();
        previewPanel.add((Component)this.myPreviewComponent, "Center");
        result2.add((Component)previewPanel, "North");
        JPanel rgbPanel = new JPanel();
        rgbPanel.setLayout(new BoxLayout(rgbPanel, 0));
        this.myR_after.setPreferredSize(new Dimension(14, -1));
        this.myG_after.setPreferredSize(new Dimension(14, -1));
        this.myB_after.setPreferredSize(new Dimension(14, -1));
        rgbPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        rgbPanel.add(this.myR);
        rgbPanel.add(this.myRed);
        rgbPanel.add(this.myR_after);
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myG);
        rgbPanel.add(this.myGreen);
        rgbPanel.add(this.myG_after);
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myB);
        rgbPanel.add(this.myBlue);
        rgbPanel.add(this.myB_after);
        rgbPanel.add(Box.createHorizontalStrut(2));
        rgbPanel.add(this.myFormat);
        result2.add((Component)rgbPanel, "West");
        JPanel hexPanel = new JPanel();
        hexPanel.setLayout(new BoxLayout(hexPanel, 0));
        hexPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        hexPanel.add(new JLabel("#"));
        hexPanel.add(this.myHex);
        result2.add((Component)hexPanel, "East");
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorListener";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipette";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/ColorPicker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createPipette";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getPipetteIfAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialog";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "showColorPickerPopup";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ColorWheelPanel
    extends JPanel {
        private final ColorWheel myColorWheel;
        private final SlideComponent myBrightnessComponent;
        private SlideComponent myOpacityComponent = null;

        private ColorWheelPanel(ColorListener listener2, boolean enableOpacity, boolean opacityInPercent) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.myColorWheel = new ColorWheel();
            this.add((Component)this.myColorWheel, "Center");
            this.myColorWheel.addListener(listener2);
            this.myBrightnessComponent = new SlideComponent(IdeBundle.message((String)"colorpicker.brightness.slider.title", (Object[])new Object[0]), true);
            this.myBrightnessComponent.setToolTipText(IdeBundle.message((String)"colorpicker.brightness.slider.tooltip", (Object[])new Object[0]));
            this.myBrightnessComponent.addListener((Consumer<? super Integer>)((Consumer)value -> {
                this.myColorWheel.setBrightness(1.0f - (float)value.intValue() / 255.0f);
                this.myColorWheel.repaint();
            }));
            this.add((Component)this.myBrightnessComponent, "East");
            if (enableOpacity) {
                this.myOpacityComponent = new SlideComponent(IdeBundle.message((String)"colorpicker.opacity.slider.title", (Object[])new Object[0]), false);
                this.myOpacityComponent.setUnits(opacityInPercent ? SlideComponent.Unit.PERCENT : SlideComponent.Unit.LEVEL);
                this.myOpacityComponent.setToolTipText(IdeBundle.message((String)"colorpicker.opacity.slider.tooltip", (Object[])new Object[0]));
                this.myOpacityComponent.addListener((Consumer<? super Integer>)((Consumer)integer -> {
                    this.myColorWheel.setOpacity((int)integer);
                    this.myColorWheel.repaint();
                }));
                this.add((Component)this.myOpacityComponent, "South");
            }
        }

        public void setColor(Color color, Object source) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            this.myBrightnessComponent.setValue(255 - (int)(hsb[2] * 255.0f));
            this.myBrightnessComponent.repaint();
            this.myColorWheel.dropImage();
            if (this.myOpacityComponent != null && source instanceof ColorPicker) {
                this.myOpacityComponent.setValue(color.getAlpha());
                this.myOpacityComponent.repaint();
            }
            this.myColorWheel.setColor(color, source);
        }
    }

    private static final class RecentColorsComponent
    extends JComponent {
        private static final int WIDTH = 313;
        private static final int HEIGHT = 65;
        private List<Color> myRecentColors = new ArrayList<Color>();

        private RecentColorsComponent(final ColorListener listener2, boolean restoreColors) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Color color = this.getColor(e);
                    if (color != null) {
                        listener2.colorChanged(color, (Object)this);
                    }
                }
            });
            if (restoreColors) {
                this.myRecentColors.clear();
                this.myRecentColors.addAll(RecentColorsComponent.getRecentColors());
            }
        }

        @Nullable
        public Color getMostRecentColor() {
            return this.myRecentColors.isEmpty() ? null : this.myRecentColors.get(this.myRecentColors.size() - 1);
        }

        public static List<Color> getRecentColors() {
            String value = PropertiesComponent.getInstance().getValue(ColorPicker.COLOR_CHOOSER_COLORS_KEY);
            if (value != null) {
                List colors = StringUtil.split((String)value, (String)",,,");
                ArrayList<Color> recentColors = new ArrayList<Color>();
                for (String color : colors) {
                    if (color.contains("-")) {
                        List components = StringUtil.split((String)color, (String)"-");
                        if (components.size() != 4) continue;
                        recentColors.add(new Color(Integer.parseInt((String)components.get(0)), Integer.parseInt((String)components.get(1)), Integer.parseInt((String)components.get(2)), Integer.parseInt((String)components.get(3))));
                        continue;
                    }
                    recentColors.add(new Color(Integer.parseInt(color)));
                }
                return recentColors;
            }
            return Collections.emptyList();
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            Color color = this.getColor(event);
            if (color != null) {
                return IdeBundle.message((String)"colorpicker.recent.color.tooltip", (Object[])new Object[]{color.getRed(), color.getGreen(), color.getBlue(), String.format("%.2f", Float.valueOf((float)((double)color.getAlpha() / 255.0)))});
            }
            return super.getToolTipText(event);
        }

        @Nullable
        private Color getColor(MouseEvent event) {
            Couple<Integer> pair = this.pointToCellCoords(event.getPoint());
            if (pair != null) {
                int ndx = (Integer)pair.second + (Integer)pair.first * 10;
                if (this.myRecentColors.size() > ndx) {
                    return this.myRecentColors.get(ndx);
                }
            }
            return null;
        }

        public void saveColors() {
            RecentColorsComponent.saveRecentColors(this.myRecentColors);
        }

        private static void saveRecentColors(List<? extends Color> recentColors) {
            ArrayList<String> values2 = new ArrayList<String>();
            for (Color color : recentColors) {
                if (color == null) break;
                values2.add(String.format("%d-%d-%d-%d", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
            }
            PropertiesComponent.getInstance().setValue(ColorPicker.COLOR_CHOOSER_COLORS_KEY, values2.isEmpty() ? null : StringUtil.join(values2, (String)",,,"), null);
        }

        private static List<Color> appendColor(Color color, List<? extends Color> recentColors, int maxSize) {
            ArrayList<Color> colors = new ArrayList<Color>(recentColors);
            colors.remove(color);
            colors.add(0, color);
            if (colors.size() > maxSize) {
                colors = new ArrayList<Color>(recentColors.subList(0, maxSize));
            }
            return colors;
        }

        public void appendColor(Color c) {
            if (!this.myRecentColors.contains(c)) {
                this.myRecentColors.add(c);
            }
            if (this.myRecentColors.size() > 20) {
                this.myRecentColors = new ArrayList<Color>(this.myRecentColors.subList(this.myRecentColors.size() - 20, this.myRecentColors.size()));
            }
        }

        @Nullable
        private Couple<Integer> pointToCellCoords(Point p) {
            int x = p.x;
            int y = p.y;
            Insets i2 = this.getInsets();
            Dimension d = this.getSize();
            int left = i2.left + (d.width - i2.left - i2.right - 313) / 2;
            int top = i2.top + (d.height - i2.top - i2.bottom - 65) / 2;
            int col = (x - left - 2) / 31;
            col = Math.min(col, 9);
            int row2 = (y - top - 2) / 31;
            return (row2 = Math.min(row2, 1)) >= 0 && col >= 0 ? Couple.of((Object)row2, (Object)col) : null;
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(313, 65);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Insets i2 = this.getInsets();
            Dimension d = this.getSize();
            int left = i2.left + (d.width - i2.left - i2.right - 313) / 2;
            int top = i2.top + (d.height - i2.top - i2.bottom - 65) / 2;
            g.setColor(Color.WHITE);
            g.fillRect(left, top, 313, 65);
            g.setColor(Color.GRAY);
            g.drawLine(left + 1, i2.top + 32, left + 313 - 3, i2.top + 32);
            g.drawRect(left + 1, top + 1, 310, 62);
            for (int k = 1; k < 10; ++k) {
                g.drawLine(left + 1 + k * 31, top + 1, left + 1 + k * 31, top + 65 - 3);
            }
            for (int r = 0; r < this.myRecentColors.size(); ++r) {
                int row2 = r / 10;
                int col = r % 10;
                Color color = this.myRecentColors.get(r);
                g.setColor(color);
                g.fillRect(left + 2 + col * 30 + col + 1, top + 2 + row2 * 30 + row2 + 1, 28, 28);
            }
        }
    }

    private static final class DefaultColorPipette
    extends ColorPipetteBase {
        private static final int SIZE = 30;
        private static final int DIALOG_SIZE = 26;
        private static final Point HOT_SPOT = new Point(13, 13);
        private final Rectangle myCaptureRect;
        private final Rectangle myZoomRect;
        private final Point myPreviousLocation;
        private Graphics2D myGraphics;
        private BufferedImage myImage;
        private BufferedImage myPipetteImage;
        private BufferedImage myMaskImage;
        private final Timer myTimer;

        private DefaultColorPipette(@NotNull JComponent parent, @NotNull ColorListener colorListener) {
            if (parent == null) {
                DefaultColorPipette.$$$reportNull$$$0(0);
            }
            if (colorListener == null) {
                DefaultColorPipette.$$$reportNull$$$0(1);
            }
            super(parent, colorListener);
            this.myCaptureRect = new Rectangle(-4, -4, 8, 8);
            this.myZoomRect = new Rectangle(0, 0, 30, 30);
            this.myPreviousLocation = new Point();
            this.myTimer = TimerUtil.createNamedTimer((String)"DefaultColorPipette", (int)5, (ActionListener)new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.updatePipette();
                }
            });
        }

        @Override
        protected Color getPixelColor(Point location) {
            return super.getPixelColor(new Point(location.x - DefaultColorPipette.HOT_SPOT.x + 15, location.y - DefaultColorPipette.HOT_SPOT.y + 15));
        }

        @Override
        public Dialog show() {
            Dialog picker2 = super.show();
            this.myTimer.start();
            WindowManager.getInstance().setAlphaModeRatio((Window)picker2, SystemInfo.isMac ? 0.95f : 0.99f);
            Area area = new Area(new Rectangle(0, 0, 26, 26));
            area.subtract(new Area(new Rectangle(14, 14, 3, 3)));
            picker2.setShape(area);
            return picker2;
        }

        @Override
        public boolean isAvailable() {
            if (this.myRobot != null) {
                this.myRobot.createScreenCapture(new Rectangle(0, 0, 1, 1));
                return WindowManager.getInstance().isAlphaModeSupported();
            }
            return false;
        }

        @Override
        @NotNull
        protected Dialog getOrCreatePickerDialog() {
            Dialog pickerDialog = this.getPickerDialog();
            if (pickerDialog == null) {
                pickerDialog = super.getOrCreatePickerDialog();
                pickerDialog.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseExited(MouseEvent event) {
                        this.updatePipette();
                    }
                });
                pickerDialog.addMouseMotionListener(new MouseAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        this.updatePipette();
                    }
                });
                pickerDialog.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (e.isTemporary()) {
                            this.pickAndClose();
                        } else {
                            this.cancelPipette();
                        }
                    }
                });
                pickerDialog.setSize(26, 26);
                this.myMaskImage = UIUtil.createImage((Component)pickerDialog, (int)30, (int)30, (int)2);
                Graphics2D maskG = this.myMaskImage.createGraphics();
                maskG.setColor(Color.BLUE);
                maskG.fillRect(0, 0, 30, 30);
                maskG.setColor(Color.RED);
                maskG.setComposite(AlphaComposite.SrcOut);
                maskG.fillRect(0, 0, 30, 30);
                maskG.dispose();
                this.myPipetteImage = UIUtil.createImage((Component)pickerDialog, (int)AllIcons.Ide.Pipette.getIconWidth(), (int)AllIcons.Ide.Pipette.getIconHeight(), (int)2);
                Graphics2D graphics = this.myPipetteImage.createGraphics();
                AllIcons.Ide.Pipette.paintIcon(null, graphics, 0, 0);
                graphics.dispose();
                this.myImage = this.myParent.getGraphicsConfiguration().createCompatibleImage(30, 30, 3);
                this.myGraphics = (Graphics2D)this.myImage.getGraphics();
                this.myGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            }
            Dialog dialog2 = pickerDialog;
            if (dialog2 == null) {
                DefaultColorPipette.$$$reportNull$$$0(2);
            }
            return dialog2;
        }

        private void updatePipette() {
            Dialog pickerDialog = this.getPickerDialog();
            if (pickerDialog != null && pickerDialog.isShowing()) {
                Point mouseLoc = this.updateLocation();
                if (mouseLoc == null) {
                    return;
                }
                Color c = this.getPixelColor(mouseLoc);
                if (!c.equals(this.getColor()) || !mouseLoc.equals(this.myPreviousLocation)) {
                    this.setColor(c);
                    this.myPreviousLocation.setLocation(mouseLoc);
                    this.myCaptureRect.setBounds(mouseLoc.x - DefaultColorPipette.HOT_SPOT.x + 15 - 2, mouseLoc.y - DefaultColorPipette.HOT_SPOT.y + 15 - 2, 5, 5);
                    BufferedImage capture = this.myRobot.createScreenCapture(this.myCaptureRect);
                    this.myGraphics.setComposite(AlphaComposite.Src);
                    this.myGraphics.setColor(UIUtil.TRANSPARENT_COLOR);
                    this.myGraphics.fillRect(0, 0, this.myImage.getWidth(), this.myImage.getHeight());
                    this.myGraphics.drawImage(capture, this.myZoomRect.x, this.myZoomRect.y, this.myZoomRect.width, this.myZoomRect.height, this);
                    this.myGraphics.setComposite(AlphaComposite.getInstance(8));
                    this.myGraphics.drawImage(this.myMaskImage, this.myZoomRect.x, this.myZoomRect.y, this.myZoomRect.width, this.myZoomRect.height, this);
                    this.myGraphics.setComposite(AlphaComposite.SrcOver);
                    UIUtil.drawImage((Graphics)this.myGraphics, (Image)this.myPipetteImage, (int)(30 - AllIcons.Ide.Pipette.getIconWidth()), (int)0, (ImageObserver)this);
                    pickerDialog.setCursor(this.myParent.getToolkit().createCustomCursor(this.myImage, HOT_SPOT, "ColorPicker"));
                    this.notifyListener(c, 300);
                }
            }
        }

        @Override
        public void cancelPipette() {
            this.myTimer.stop();
            super.cancelPipette();
        }

        @Override
        public void dispose() {
            this.myTimer.stop();
            super.dispose();
            if (this.myGraphics != null) {
                this.myGraphics.dispose();
            }
            this.myImage = null;
            this.myPipetteImage = null;
            this.myMaskImage = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorListener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/ColorPicker$DefaultColorPipette";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/ColorPicker$DefaultColorPipette";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrCreatePickerDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public final class NumberDocument
    extends PlainDocument {
        private final boolean myHex;
        private JTextField mySrc;

        public NumberDocument(boolean hex) {
            this.myHex = hex;
        }

        void setSource(JTextField field) {
            this.mySrc = field;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            str = StringUtil.trimStart((String)str, (String)"#");
            boolean rgb = ColorPicker.this.isRGBMode();
            char[] source = str.toCharArray();
            if (this.mySrc != null) {
                int selected = this.mySrc.getSelectionEnd() - this.mySrc.getSelectionStart();
                int newLen = this.mySrc.getText().length() - selected + str.length();
                if (newLen > (this.myHex ? 6 : 3)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
            }
            char[] result2 = new char[source.length];
            int j = 0;
            for (int i2 = 0; i2 < result2.length; ++i2) {
                if (this.myHex ? "0123456789abcdefABCDEF".indexOf(source[i2]) >= 0 : Character.isDigit(source[i2])) {
                    result2[j++] = source[i2];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            String toInsert = StringUtil.toUpperCase((String)new String(result2, 0, j));
            String res = new StringBuilder(this.mySrc.getText()).insert(offs, toInsert).toString();
            try {
                if (!this.myHex) {
                    int num = Integer.parseInt(res);
                    if (rgb) {
                        if (num > 255) {
                            Toolkit.getDefaultToolkit().beep();
                            return;
                        }
                    } else if (this.mySrc == ColorPicker.this.myRed && num > 359 || (this.mySrc == ColorPicker.this.myGreen || this.mySrc == ColorPicker.this.myBlue) && num > 100) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.insertString(offs, toInsert, a);
        }
    }

    private static final class ColorWheel
    extends JComponent {
        private static final int BORDER_SIZE = 5;
        private float myBrightness = 1.0f;
        private float myHue = 1.0f;
        private float mySaturation = 0.0f;
        private Image myImage;
        private Rectangle myWheel;
        private boolean myShouldInvalidate = true;
        private Color myColor;
        private final List<ColorListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private int myOpacity;

        private ColorWheel() {
            this.setOpaque(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    myShouldInvalidate = true;
                }
            });
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    int mx = myWheel.x + myWheel.width / 2;
                    int my = myWheel.y + myWheel.height / 2;
                    double s = Math.sqrt((x - mx) * (x - mx) + (y - my) * (y - my)) / (double)(myWheel.height / 2);
                    double h = -Math.atan2(y - my, x - mx) / (Math.PI * 2);
                    if (h < 0.0) {
                        h += 1.0;
                    }
                    if (s > 1.0) {
                        s = 1.0;
                    }
                    this.setHSBValue((float)h, (float)s, myBrightness, myOpacity);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    int y = e.getY();
                    int mx = myWheel.x + myWheel.width / 2;
                    int my = myWheel.y + myWheel.height / 2;
                    double s = Math.sqrt((x - mx) * (x - mx) + (y - my) * (y - my)) / (double)(myWheel.height / 2);
                    double h = -Math.atan2(y - my, x - mx) / (Math.PI * 2);
                    if (h < 0.0) {
                        h += 1.0;
                    }
                    if (s <= 1.0) {
                        this.setHSBValue((float)h, (float)s, myBrightness, myOpacity);
                    }
                }
            });
        }

        private void setHSBValue(float h, float s, float b, int opacity) {
            Color rgb = new Color(Color.HSBtoRGB(h, s, b));
            this.setColor(ColorUtil.toAlpha((Color)rgb, (int)opacity), this);
        }

        private void setColor(Color color, Object source) {
            float[] hsb = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
            this.myColor = color;
            this.myHue = hsb[0];
            this.mySaturation = hsb[1];
            this.myBrightness = hsb[2];
            this.myOpacity = color.getAlpha();
            this.fireColorChanged(source);
            this.repaint();
        }

        public void addListener(ColorListener listener2) {
            this.myListeners.add(listener2);
        }

        private void fireColorChanged(Object source) {
            for (ColorListener listener2 : this.myListeners) {
                listener2.colorChanged(this.myColor, source);
            }
        }

        public void setBrightness(float brightness) {
            if (brightness != this.myBrightness) {
                this.myImage = null;
                this.setHSBValue(this.myHue, this.mySaturation, brightness, this.myOpacity);
            }
        }

        public void setOpacity(int opacity) {
            if (opacity != this.myOpacity) {
                this.setHSBValue(this.myHue, this.mySaturation, this.myBrightness, opacity);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return JBUI.size((int)300, (int)300);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size2 = this.getSize();
            int _size = Math.min(size2.width, size2.height);
            _size = Math.min(_size, 600);
            if (this.myImage != null && this.myShouldInvalidate && this.myImage.getWidth(null) != _size) {
                this.myImage = null;
            }
            this.myShouldInvalidate = false;
            if (this.myImage == null) {
                this.myImage = this.createImage(new ColorWheelImageProducer(_size - 10, _size - 10, this.myBrightness));
                this.myWheel = new Rectangle(5, 5, _size - 10, _size - 10);
            }
            g.setColor(UIManager.getColor("Panel.background"));
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(AlphaComposite.getInstance(3, (float)this.myOpacity / 255.0f));
            g.drawImage(this.myImage, this.myWheel.x, this.myWheel.y, null);
            g2d.setComposite(AlphaComposite.getInstance(2, 1.0f));
            int mx = this.myWheel.x + this.myWheel.width / 2;
            int my = this.myWheel.y + this.myWheel.height / 2;
            g.setColor(Color.WHITE);
            int arcw = (int)((float)this.myWheel.width * this.mySaturation / 2.0f);
            int arch = (int)((float)this.myWheel.height * this.mySaturation / 2.0f);
            double th = (double)(this.myHue * 2.0f) * Math.PI;
            int x = (int)((double)mx + (double)arcw * Math.cos(th));
            int y = (int)((double)my - (double)arch * Math.sin(th));
            g.fillRect(x - 2, y - 2, 4, 4);
            g.setColor(Color.BLACK);
            g.drawRect(x - 2, y - 2, 4, 4);
        }

        public void dropImage() {
            this.myImage = null;
        }
    }

    private static final class ColorPreviewComponent
    extends JComponent {
        private Color myColor;

        private ColorPreviewComponent() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }

        @Override
        public Dimension getPreferredSize() {
            return JBUI.size((int)100, (int)32);
        }

        public void setColor(Color c) {
            this.myColor = c;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            Insets i2 = this.getInsets();
            Rectangle r = this.getBounds();
            int width = r.width - i2.left - i2.right;
            int height = r.height - i2.top - i2.bottom;
            g.setColor(Color.WHITE);
            g.fillRect(i2.left, i2.top, width, height);
            g.setColor(this.myColor);
            g.fillRect(i2.left, i2.top, width, height);
            g.setColor(Color.BLACK);
            g.drawRect(i2.left, i2.top, width - 1, height - 1);
            g.setColor(Color.WHITE);
            g.drawRect(i2.left + 1, i2.top + 1, width - 3, height - 3);
        }
    }

    static final class ColorPickerDialog
    extends DialogWrapper {
        private final Color myPreselectedColor;
        private final List<? extends ColorPickerListener> myListeners;
        private ColorPicker myColorPicker;
        private final boolean myEnableOpacity;
        private final boolean myOpacityInPercent;

        ColorPickerDialog(@NotNull Component parent, @NlsContexts.DialogTitle String caption, @Nullable Color preselectedColor, boolean enableOpacity, List<? extends ColorPickerListener> listeners, boolean opacityInPercent) {
            if (parent == null) {
                ColorPickerDialog.$$$reportNull$$$0(0);
            }
            super(parent, true);
            this.myListeners = listeners;
            this.myPreselectedColor = preselectedColor;
            this.myEnableOpacity = enableOpacity;
            this.myOpacityInPercent = opacityInPercent;
            this.setTitle(caption);
            this.setResizable(false);
            this.setOKButtonText(listeners == null || !listeners.isEmpty() ? IdeBundle.message((String)"button.choose", (Object[])new Object[0]) : IdeBundle.message((String)"button.copy", (Object[])new Object[0]));
            super.init();
        }

        protected JComponent createCenterPanel() {
            if (this.myColorPicker == null) {
                this.myColorPicker = new ColorPicker(this.myDisposable, this.myPreselectedColor, true, this.myEnableOpacity, this.myListeners, this.myOpacityInPercent);
            }
            return this.myColorPicker;
        }

        public Color getColor() {
            return this.myColorPicker.getColor();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myColorPicker.getPreferredFocusedComponent();
        }

        protected void doOKAction() {
            this.myColorPicker.appendRecentColor();
            this.myColorPicker.saveRecentColors();
            if (this.myListeners != null && this.myListeners.isEmpty()) {
                String color = StringUtil.toUpperCase((String)ColorUtil.toHex((Color)this.myColorPicker.myColor));
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(color));
            }
            super.doOKAction();
        }

        public void show() {
            super.show();
            this.myColorPicker.fireClosed(this.getExitCode() == 0 ? this.getColor() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ui/ColorPicker$ColorPickerDialog", "<init>"));
        }
    }

    public static final class ColorWheelImageProducer
    extends MemoryImageSource {
        private final int[] myPixels;
        private final int myWidth;
        private final int myHeight;
        private float myBrightness = 1.0f;
        private float[] myHues;
        private float[] mySat;
        private int[] myAlphas;

        public ColorWheelImageProducer(int w, int h, float brightness) {
            super(w, h, null, 0, w);
            this.myPixels = new int[w * h];
            this.myWidth = w;
            this.myHeight = h;
            this.myBrightness = brightness;
            this.generateLookupTables();
            this.newPixels(this.myPixels, ColorModel.getRGBdefault(), 0, w);
            this.setAnimated(true);
            this.generateColorWheel();
        }

        public int getRadius() {
            return Math.min(this.myWidth, this.myHeight) / 2 - 2;
        }

        private void generateLookupTables() {
            this.mySat = new float[this.myWidth * this.myHeight];
            this.myHues = new float[this.myWidth * this.myHeight];
            this.myAlphas = new int[this.myWidth * this.myHeight];
            float radius = this.getRadius();
            float blend = (radius + 2.0f) / radius - 1.0f;
            int cx = this.myWidth / 2;
            int cy = this.myHeight / 2;
            for (int x = 0; x < this.myWidth; ++x) {
                int kx = x - cx;
                int squarekx = kx * kx;
                for (int y = 0; y < this.myHeight; ++y) {
                    int ky = cy - y;
                    int index = x + y * this.myWidth;
                    this.mySat[index] = (float)Math.sqrt(squarekx + ky * ky) / radius;
                    if (this.mySat[index] <= 1.0f) {
                        this.myAlphas[index] = -16777216;
                    } else {
                        this.myAlphas[index] = (int)((blend - Math.min(blend, this.mySat[index] - 1.0f)) * 255.0f / blend) << 24;
                        this.mySat[index] = 1.0f;
                    }
                    if (this.myAlphas[index] == 0) continue;
                    this.myHues[index] = (float)(Math.atan2(ky, kx) / Math.PI / 2.0);
                }
            }
        }

        public void generateColorWheel() {
            for (int index = 0; index < this.myPixels.length; ++index) {
                if (this.myAlphas[index] == 0) continue;
                this.myPixels[index] = this.myAlphas[index] | 0xFFFFFF & Color.HSBtoRGB(this.myHues[index], this.mySat[index], this.myBrightness);
            }
            this.newPixels();
        }
    }
}

