/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.FrameInfoHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.peer.FramePeer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

@ApiStatus.Internal
public class FrameState {
    private Rectangle myBounds;
    private boolean myMaximized;
    private boolean myFullScreen;

    public Point getLocation() {
        return this.myBounds == null ? null : this.myBounds.getLocation();
    }

    public Dimension getSize() {
        return this.myBounds == null ? null : this.myBounds.getSize();
    }

    public Rectangle getBounds() {
        return this.myBounds == null ? null : new Rectangle(this.myBounds);
    }

    public boolean isMaximized() {
        return this.myMaximized;
    }

    public boolean isFullScreen() {
        return this.myFullScreen;
    }

    public static int getExtendedState(Component component2) {
        int state2 = 0;
        if (component2 instanceof Frame) {
            Object peer;
            state2 = ((Frame)component2).getExtendedState();
            if (SystemInfoRt.isMac && (peer = AWTAccessor.getComponentAccessor().getPeer(component2)) instanceof FramePeer) {
                state2 = ((FramePeer)peer).getState();
            }
        }
        return state2;
    }

    private static FrameState findFrameState(@NotNull Component component2) {
        if (component2 == null) {
            FrameState.$$$reportNull$$$0(0);
        }
        for (ComponentListener listener2 : component2.getComponentListeners()) {
            if (!(listener2 instanceof FrameState)) continue;
            return (FrameState)((Object)listener2);
        }
        return null;
    }

    public static void setFrameStateListener(@NotNull Component component2) {
        FrameState state2;
        if (component2 == null) {
            FrameState.$$$reportNull$$$0(1);
        }
        if (component2 instanceof Frame && (state2 = FrameState.findFrameState(component2)) == null) {
            component2.addComponentListener(new Listener());
        }
    }

    final void update(Component component2) {
        Rectangle bounds = component2.getBounds();
        this.myFullScreen = component2 instanceof IdeFrame && FrameInfoHelper.Companion.isFullScreenSupportedInCurrentOs() && ((IdeFrame)component2).isInFullScreen();
        this.myMaximized = FrameInfoHelper.isMaximized(FrameState.getExtendedState(component2));
        if (this.myBounds != null && (this.myFullScreen || this.myMaximized) && bounds.contains(this.myBounds.x + this.myBounds.width / 2, this.myBounds.y + this.myBounds.height / 2)) {
            return;
        }
        this.myBounds = bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "component";
        objectArray2[1] = "com/intellij/ui/FrameState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findFrameState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setFrameStateListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Listener
    extends FrameState
    implements ComponentListener {
        private Listener() {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            this.update(event.getComponent());
        }

        @Override
        public void componentResized(ComponentEvent event) {
            this.update(event.getComponent());
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }
    }
}

