/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.messages.Topic;
import java.util.Collections;
import java.util.Date;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicensingFacade {
    public String platformProductCode;
    public String licensedTo;
    @NlsSafe
    public String licenseeEmail;
    public List<String> restrictions;
    public boolean isEvaluation;
    public Date expirationDate;
    public Date perpetualFallbackDate;
    @Nullable
    public Integer gracePeriodDays;
    public Map<String, Date> expirationDates;
    public Map<String, String> confirmationStamps;
    public Map<String, ProductLicenseData> productLicenses;
    public String metadata;
    public boolean ai_enabled;
    @Deprecated(forRemoval=true)
    public String subType;
    public String userBucket;
    private static volatile LicensingFacade INSTANCE;
    public static volatile boolean isUnusedSignalled;

    @Nullable
    public Date getExpirationDate(String productCode) {
        Map<String, Date> result2 = this.expirationDates;
        return result2 != null ? result2.get(productCode) : null;
    }

    @Nullable
    public String getLicensedToMessage() {
        return this.licensedTo;
    }

    @NlsSafe
    @Nullable
    public String getLicenseeEmail() {
        return this.licenseeEmail;
    }

    @NotNull
    public List<String> getLicenseRestrictionsMessages() {
        List<String> result2 = this.restrictions;
        List<String> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            LicensingFacade.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public boolean isEvaluationLicense() {
        return this.isEvaluation;
    }

    public boolean isApplicableForProduct(@NotNull Date releaseDate) {
        if (releaseDate == null) {
            LicensingFacade.$$$reportNull$$$0(1);
        }
        Date expDate = this.expirationDate;
        return this.isPerpetualForProduct(releaseDate) || expDate == null || releaseDate.before(expDate);
    }

    public boolean isPerpetualForProduct(@NotNull Date releaseDate) {
        Date result2;
        if (releaseDate == null) {
            LicensingFacade.$$$reportNull$$$0(2);
        }
        return (result2 = this.perpetualFallbackDate) != null && releaseDate.before(result2);
    }

    @Nullable
    public Date getLicenseExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public String getConfirmationStamp(String productCode) {
        Map<String, String> result2 = this.confirmationStamps;
        return result2 != null ? result2.get(productCode) : null;
    }

    @Nullable
    public static LicensingFacade getInstance() {
        return INSTANCE;
    }

    @ApiStatus.Internal
    public static void setInstance(@Nullable LicensingFacade instance2) {
        INSTANCE = instance2;
        ((LicenseStateListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(LicenseStateListener.TOPIC)).licenseStateChanged(instance2);
    }

    @NotNull
    private static Gson createGson() {
        Gson gson = new GsonBuilder().setDateFormat("yyyyMMdd").create();
        if (gson == null) {
            LicensingFacade.$$$reportNull$$$0(3);
        }
        return gson;
    }

    public String toJson() {
        return LicensingFacade.createGson().toJson((Object)this);
    }

    @Nullable
    public static LicensingFacade fromJson(String json) {
        try {
            return (LicensingFacade)LicensingFacade.createGson().fromJson(json, LicensingFacade.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static void signalUnused(boolean value) {
        isUnusedSignalled = value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LicensingFacade";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLicenseRestrictionsMessages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LicensingFacade";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createGson";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableForProduct";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPerpetualForProduct";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static interface LicenseStateListener
    extends EventListener {
        @NotNull
        public static final Topic<LicenseStateListener> TOPIC = new Topic(LicenseStateListener.class);

        public void licenseStateChanged(@Nullable LicensingFacade var1);
    }

    public static final class ProductLicenseData {
        public String productCode;
        @Nullable
        public String confirmationStamp;
        @Nullable
        public Date expirationDate;
        public boolean isPersonal;
    }
}

