/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.GotItComponentBuilder;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.InlineCodeExtension;
import com.intellij.ui.LineSpacingExtension;
import com.intellij.ui.ShortcutExtension;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.io.Closeable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0004\b\f\u0010\rJ,\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nH\u0002J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0002J\u001e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u00182\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/ui/LimitedWidthEditorPane;", "Ljavax/swing/JEditorPane;", "htmlBuilder", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "maxWidth", "", "useContrastColors", "", "allowWidthExtending", "iconsMap", "", "Ljavax/swing/Icon;", "<init>", "(Lcom/intellij/openapi/util/text/HtmlBuilder;IZZLjava/util/Map;)V", "createEditorKit", "Ljavax/swing/text/html/HTMLEditorKit;", "lineSpacing", "", "setTextAndUpdateLayout", "", "builder", "width", "(Lcom/intellij/openapi/util/text/HtmlBuilder;Ljava/lang/Integer;)V", "getRootView", "Ljavax/swing/text/View;", "getRows", "", "visit", "view", "collection", "", "updateUI", "Companion", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nGotItComponentBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GotItComponentBuilder.kt\ncom/intellij/ui/LimitedWidthEditorPane\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1135:1\n1#2:1136\n*E\n"})
final class LimitedWidthEditorPane
extends JEditorPane {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int ADDITIONAL_WIDTH = 1;

    public LimitedWidthEditorPane(@NotNull HtmlBuilder htmlBuilder, int maxWidth, boolean useContrastColors, boolean allowWidthExtending, @NotNull Map<Integer, ? extends Icon> iconsMap) {
        Intrinsics.checkNotNullParameter((Object)htmlBuilder, (String)"htmlBuilder");
        Intrinsics.checkNotNullParameter(iconsMap, (String)"iconsMap");
        this.setForeground(JBUI.CurrentTheme.GotItTooltip.foreground((boolean)useContrastColors));
        this.setBackground(JBUI.CurrentTheme.GotItTooltip.background((boolean)useContrastColors));
        String it = htmlBuilder.toString();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        float lineSpacing = StringsKt.contains$default((CharSequence)it, (CharSequence)"<span class=\"code\">", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"<span class=\"shortcut\">", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)it, (CharSequence)"<icon src=", (boolean)false, (int)2, null) ? 0.2f : 0.1f;
        this.setEditorKit(this.createEditorKit(useContrastColors, lineSpacing, iconsMap));
        this.putClientProperty("caretWidth", 0);
        boolean additionalWidthAdded = false;
        LimitedWidthEditorPane.setTextAndUpdateLayout$default(this, htmlBuilder, null, 2, null);
        if (this.getRootView().getPreferredSpan(0) > (float)maxWidth) {
            Float f;
            Iterator iterator2;
            this.setTextAndUpdateLayout(htmlBuilder, maxWidth);
            Collection<View> rows = this.getRows();
            if (rows.size() >= 5 && allowWidthExtending) {
                this.setTextAndUpdateLayout(htmlBuilder, GotItComponentBuilder.Companion.getEXTENDED_MAX_WIDTH$intellij_platform_ide_impl());
                rows = this.getRows();
            }
            if (!(iterator2 = ((Iterable)rows).iterator()).hasNext()) {
                f = null;
            } else {
                View it2 = (View)iterator2.next();
                boolean bl2 = false;
                float f2 = it2.getPreferredSpan(0) + 1.0f;
                while (iterator2.hasNext()) {
                    View it3 = (View)iterator2.next();
                    $i$a$-maxOfOrNull-LimitedWidthEditorPane$width$1 = false;
                    float f3 = it3.getPreferredSpan(0) + 1.0f;
                    f2 = Math.max(f2, f3);
                }
                f = Float.valueOf(f2);
            }
            float width = f != null ? f.floatValue() : (float)maxWidth;
            this.setTextAndUpdateLayout(htmlBuilder, (int)width);
            additionalWidthAdded = true;
        }
        View root = this.getRootView();
        int width = (int)root.getPreferredSpan(0) + (additionalWidthAdded ? 0 : 1);
        this.setPreferredSize(new Dimension(width, (int)root.getPreferredSpan(1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HTMLEditorKit createEditorKit(boolean useContrastColors, float lineSpacing, Map<Integer, ? extends Icon> iconsMap) {
        StyleSheet styleSheet = new StyleSheet();
        String linkStyles = "a { color: #" + ColorUtil.toHex((Color)JBUI.CurrentTheme.GotItTooltip.linkForeground((boolean)useContrastColors)) + " }";
        Color color = JBUI.CurrentTheme.GotItTooltip.shortcutForeground((boolean)useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"shortcutForeground(...)");
        Color color2 = JBUI.CurrentTheme.GotItTooltip.shortcutBackground((boolean)useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"shortcutBackground(...)");
        Color color3 = JBUI.CurrentTheme.GotItTooltip.shortcutBorder((boolean)useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"shortcutBorder(...)");
        String shortcutStyles = ShortcutExtension.Companion.getStyles(color, color2, color3);
        Font codeFont = EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN).deriveFont((float)JBFont.label().getSize());
        Color color4 = JBUI.CurrentTheme.GotItTooltip.codeForeground((boolean)useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"codeForeground(...)");
        Color color5 = JBUI.CurrentTheme.GotItTooltip.codeBackground((boolean)useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"codeBackground(...)");
        Color color6 = JBUI.CurrentTheme.GotItTooltip.codeBorderColor((boolean)useContrastColors);
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"codeBorderColor(...)");
        Intrinsics.checkNotNull((Object)codeFont);
        String codeStyles = InlineCodeExtension.Companion.getStyles(color4, color5, color6, codeFont);
        Closeable closeable = new StringReader(linkStyles + shortcutStyles + codeStyles);
        Object object = null;
        try {
            StringReader it = (StringReader)closeable;
            boolean bl = false;
            styleSheet.loadRules(it, null);
            it = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            object = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        ExtendableHTMLViewFactory.Extension iconsExtension = ExtendableHTMLViewFactory.Extensions.icons(arg_0 -> LimitedWidthEditorPane.createEditorKit$lambda$1(useContrastColors, iconsMap, arg_0));
        object = new Function2[]{iconsExtension, new ShortcutExtension(), new InlineCodeExtension(), new LineSpacingExtension(lineSpacing)};
        Object $this$createEditorKit_u24lambda_u242 = object = new HTMLEditorKitBuilder().withStyleSheet(styleSheet).withViewFactoryExtensions(object).build();
        boolean bl = false;
        this.setBorder((Border)new JBEmptyBorder(1, 0, 0, 0));
        return object;
    }

    private final void setTextAndUpdateLayout(HtmlBuilder builder, Integer width) {
        HtmlChunk.Element it = HtmlChunk.div();
        boolean bl = false;
        HtmlChunk.Element element = width != null ? it.attr("width", width.intValue()) : it;
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"let(...)");
        HtmlChunk.Element div = element;
        this.setText(builder.wrapWith(div).wrapWith(HtmlChunk.html()).toString());
        View root = this.getRootView();
        root.setSize(root.getPreferredSpan(0), root.getPreferredSpan(1));
    }

    static /* synthetic */ void setTextAndUpdateLayout$default(LimitedWidthEditorPane limitedWidthEditorPane, HtmlBuilder htmlBuilder, Integer n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        limitedWidthEditorPane.setTextAndUpdateLayout(htmlBuilder, n);
    }

    private final View getRootView() {
        ComponentUI componentUI = this.ui;
        Intrinsics.checkNotNull((Object)componentUI, (String)"null cannot be cast to non-null type javax.swing.plaf.TextUI");
        View view2 = ((TextUI)componentUI).getRootView(this);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getRootView(...)");
        return view2;
    }

    private final Collection<View> getRows() {
        ArrayList arrayList;
        ArrayList it = arrayList = new ArrayList();
        boolean bl = false;
        this.visit(this.getRootView(), it);
        return arrayList;
    }

    private final void visit(View view2, Collection<View> collection) {
        String cname;
        String string = cname = view2.getClass().getCanonicalName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)it, (CharSequence)"ParagraphView.Row", (boolean)false, (int)2, null)) {
                collection.add(view2);
            }
        }
        int n = view2.getViewCount();
        for (int i2 = 0; i2 < n; ++i2) {
            View view3 = view2.getView(i2);
            Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"getView(...)");
            this.visit(view3, collection);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFocusable(false);
        this.setEditable(false);
        this.setBorder(null);
    }

    private static final Icon createEditorKit$lambda$1(boolean $useContrastColors, Map $iconsMap, String iconKey) {
        Icon icon2;
        Icon explicitIcon;
        Intrinsics.checkNotNullParameter((Object)iconKey, (String)"iconKey");
        Integer n = StringsKt.toIntOrNull((String)iconKey);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            v1 = (Icon)$iconsMap.get(it);
        } else {
            v1 = explicitIcon = null;
        }
        if (explicitIcon != null) {
            icon2 = GotItComponentBuilder.Companion.adjustIcon$intellij_platform_ide_impl(explicitIcon, $useContrastColors);
        } else {
            Icon icon3 = IconLoader.findIcon((String)iconKey, GotItTooltip.class, (boolean)true, (boolean)false);
            if (icon3 != null) {
                Icon icon4 = icon3;
                boolean bl = false;
                icon2 = GotItComponentBuilder.Companion.adjustIcon$intellij_platform_ide_impl(icon4, $useContrastColors);
            } else {
                icon2 = null;
            }
        }
        return icon2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/LimitedWidthEditorPane$Companion;", "", "<init>", "()V", "ADDITIONAL_WIDTH", "", "intellij.platform.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

