/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.NotificationBalloonShadowBorderProviderKt;
import com.intellij.ui.scale.ScaleContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BY\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000e\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u001cH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ui/NotificationBalloonShadowBorderProvider;", "Lcom/intellij/ui/BalloonImpl$ShadowBorderProvider;", "fillColor", "Ljava/awt/Color;", "borderColor", "topIcon", "Ljavax/swing/Icon;", "leftIcon", "bottomIcon", "rightIcon", "topLeftIcon", "topRightIcon", "bottomLeftIcon", "bottomRightIcon", "<init>", "(Ljava/awt/Color;Ljava/awt/Color;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;Ljavax/swing/Icon;)V", "(Ljava/awt/Color;Ljava/awt/Color;)V", "getInsets", "Ljava/awt/Insets;", "paintShadow", "", "component", "Ljavax/swing/JComponent;", "g", "Ljava/awt/Graphics;", "paintBorder", "bounds", "Ljava/awt/Rectangle;", "Ljava/awt/Graphics2D;", "paintPointingShape", "pointTarget", "Ljava/awt/Point;", "position", "Lcom/intellij/openapi/ui/popup/Balloon$Position;", "intellij.platform.ide.impl"})
public class NotificationBalloonShadowBorderProvider
implements BalloonImpl.ShadowBorderProvider {
    @JvmField
    @NotNull
    protected final Color fillColor;
    @JvmField
    @NotNull
    protected final Color borderColor;
    @NotNull
    private final Icon topIcon;
    @NotNull
    private final Icon leftIcon;
    @NotNull
    private final Icon bottomIcon;
    @NotNull
    private final Icon rightIcon;
    @NotNull
    private final Icon topLeftIcon;
    @NotNull
    private final Icon topRightIcon;
    @NotNull
    private final Icon bottomLeftIcon;
    @NotNull
    private final Icon bottomRightIcon;

    protected NotificationBalloonShadowBorderProvider(@NotNull Color fillColor, @NotNull Color borderColor, @NotNull Icon topIcon, @NotNull Icon leftIcon, @NotNull Icon bottomIcon, @NotNull Icon rightIcon, @NotNull Icon topLeftIcon, @NotNull Icon topRightIcon, @NotNull Icon bottomLeftIcon, @NotNull Icon bottomRightIcon) {
        Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        Intrinsics.checkNotNullParameter((Object)topIcon, (String)"topIcon");
        Intrinsics.checkNotNullParameter((Object)leftIcon, (String)"leftIcon");
        Intrinsics.checkNotNullParameter((Object)bottomIcon, (String)"bottomIcon");
        Intrinsics.checkNotNullParameter((Object)rightIcon, (String)"rightIcon");
        Intrinsics.checkNotNullParameter((Object)topLeftIcon, (String)"topLeftIcon");
        Intrinsics.checkNotNullParameter((Object)topRightIcon, (String)"topRightIcon");
        Intrinsics.checkNotNullParameter((Object)bottomLeftIcon, (String)"bottomLeftIcon");
        Intrinsics.checkNotNullParameter((Object)bottomRightIcon, (String)"bottomRightIcon");
        this.fillColor = fillColor;
        this.borderColor = borderColor;
        this.topIcon = topIcon;
        this.leftIcon = leftIcon;
        this.bottomIcon = bottomIcon;
        this.rightIcon = rightIcon;
        this.topLeftIcon = topLeftIcon;
        this.topRightIcon = topRightIcon;
        this.bottomLeftIcon = bottomLeftIcon;
        this.bottomRightIcon = bottomRightIcon;
    }

    public NotificationBalloonShadowBorderProvider(@NotNull Color fillColor, @NotNull Color borderColor) {
        Intrinsics.checkNotNullParameter((Object)fillColor, (String)"fillColor");
        Intrinsics.checkNotNullParameter((Object)borderColor, (String)"borderColor");
        Icon icon2 = AllIcons.Ide.Shadow.Top;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Top");
        Icon icon3 = AllIcons.Ide.Shadow.Left;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Left");
        Icon icon4 = AllIcons.Ide.Shadow.Bottom;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Bottom");
        Icon icon5 = AllIcons.Ide.Shadow.Right;
        Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Right");
        Icon icon6 = AllIcons.Ide.Shadow.TopLeft;
        Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"TopLeft");
        Icon icon7 = AllIcons.Ide.Shadow.TopRight;
        Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"TopRight");
        Icon icon8 = AllIcons.Ide.Shadow.BottomLeft;
        Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"BottomLeft");
        Icon icon9 = AllIcons.Ide.Shadow.BottomRight;
        Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"BottomRight");
        this(fillColor, borderColor, icon2, icon3, icon4, icon5, icon6, icon7, icon8, icon9);
    }

    @Override
    @NotNull
    public Insets getInsets() {
        return new Insets(this.topIcon.getIconHeight(), this.leftIcon.getIconWidth(), this.bottomIcon.getIconHeight(), this.rightIcon.getIconWidth());
    }

    @Override
    public void paintShadow(@NotNull JComponent component2, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int width = component2.getWidth();
        int height = component2.getHeight();
        int topLeftWidth = this.topLeftIcon.getIconWidth();
        int topLeftHeight = this.topLeftIcon.getIconHeight();
        int topRightWidth = this.topRightIcon.getIconWidth();
        int topRightHeight = this.topRightIcon.getIconHeight();
        int bottomLeftWidth = this.bottomLeftIcon.getIconWidth();
        int bottomLeftHeight = this.bottomLeftIcon.getIconHeight();
        int bottomRightWidth = this.bottomRightIcon.getIconWidth();
        int bottomRightHeight = this.bottomRightIcon.getIconHeight();
        int rightWidth = this.rightIcon.getIconWidth();
        int bottomHeight = this.bottomIcon.getIconHeight();
        ScaleContext scaleContext = ScaleContext.Companion.create((Component)component2);
        NotificationBalloonShadowBorderProviderKt.access$drawLine(component2, g, this.topIcon, width, topLeftWidth, topRightWidth, 0, true, scaleContext);
        NotificationBalloonShadowBorderProviderKt.access$drawLine(component2, g, this.bottomIcon, width, bottomLeftWidth, bottomRightWidth, height - bottomHeight, true, scaleContext);
        NotificationBalloonShadowBorderProviderKt.access$drawLine(component2, g, this.leftIcon, height, topLeftHeight, bottomLeftHeight, 0, false, scaleContext);
        NotificationBalloonShadowBorderProviderKt.access$drawLine(component2, g, this.rightIcon, height, topRightHeight, bottomRightHeight, width - rightWidth, false, scaleContext);
        this.topLeftIcon.paintIcon(component2, g, 0, 0);
        this.topRightIcon.paintIcon(component2, g, width - topRightWidth, 0);
        this.bottomRightIcon.paintIcon(component2, g, width - bottomRightWidth, height - bottomRightHeight);
        this.bottomLeftIcon.paintIcon(component2, g, 0, height - bottomLeftHeight);
    }

    @Override
    public void paintBorder(@NotNull Rectangle bounds, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.fillColor);
        g.fill(new Rectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height));
        g.setColor(this.borderColor);
        g.draw(new RoundRectangle2D.Double((double)bounds.x + 0.5, (double)bounds.y + 0.5, bounds.width - 1, bounds.height - 1, 3.0, 3.0));
    }

    @Override
    public void paintPointingShape(@NotNull Rectangle bounds, @NotNull Point pointTarget, @NotNull Balloon.Position position2, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)pointTarget, (String)"pointTarget");
        Intrinsics.checkNotNullParameter((Object)position2, (String)"position");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int x = 0;
        int y = 0;
        int length = 0;
        switch (WhenMappings.$EnumSwitchMapping$0[position2.ordinal()]) {
            case 1: {
                length = this.getInsets().bottom;
                x = pointTarget.x;
                y = bounds.y + bounds.height + length;
                break;
            }
            case 2: {
                length = this.getInsets().top;
                x = pointTarget.x;
                y = bounds.y - length;
                break;
            }
            case 3: {
                length = this.getInsets().left;
                x = bounds.x - length;
                y = pointTarget.y;
                break;
            }
            default: {
                length = this.getInsets().right;
                x = bounds.x + bounds.width + length;
                y = pointTarget.y;
            }
        }
        Polygon p = new Polygon();
        p.addPoint(x, y);
        length += 2;
        switch (WhenMappings.$EnumSwitchMapping$0[position2.ordinal()]) {
            case 1: {
                p.addPoint(x - length, y - length);
                p.addPoint(x + length, y - length);
                break;
            }
            case 2: {
                p.addPoint(x - length, y + length);
                p.addPoint(x + length, y + length);
                break;
            }
            case 3: {
                p.addPoint(x + length, y - length);
                p.addPoint(x + length, y + length);
                break;
            }
            default: {
                p.addPoint(x - length, y - length);
                p.addPoint(x - length, y + length);
            }
        }
        g.setColor(this.fillColor);
        g.fillPolygon(p);
        g.setColor(this.borderColor);
        length -= 2;
        switch (WhenMappings.$EnumSwitchMapping$0[position2.ordinal()]) {
            case 1: {
                g.drawLine(x, y, x - length, y - length);
                g.drawLine(x, y, x + length, y - length);
                break;
            }
            case 2: {
                g.drawLine(x, y, x - length, y + length);
                g.drawLine(x, y, x + length, y + length);
                break;
            }
            case 3: {
                g.drawLine(x, y, x + length, y - length);
                g.drawLine(x, y, x + length, y + length);
                break;
            }
            default: {
                g.drawLine(x, y, x - length, y - length);
                g.drawLine(x, y, x - length, y + length);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Balloon.Position.values().length];
            try {
                nArray[Balloon.Position.above.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Balloon.Position.below.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Balloon.Position.atRight.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

