/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class SpeedSearchObjectWithWeight {
    public final Object node;
    private final int weight;

    SpeedSearchObjectWithWeight(Object element, int weight) {
        this.node = element;
        this.weight = weight;
    }

    public int compareWith(SpeedSearchObjectWithWeight obj2) {
        return Integer.compare(obj2.weight, this.weight);
    }

    public static List<SpeedSearchObjectWithWeight> findElement(String pattern, SpeedSearchBase<?> speedSearch2) {
        ArrayList<SpeedSearchObjectWithWeight> elements = new ArrayList<SpeedSearchObjectWithWeight>();
        pattern = pattern.trim();
        ListIterator<Object> it = speedSearch2.getElementIterator(0);
        while (it.hasNext()) {
            Object element = it.next();
            String text2 = speedSearch2.getElementText(element);
            if (text2 == null) continue;
            elements.add(new SpeedSearchObjectWithWeight(element, speedSearch2.getComparator().matchingDegree(pattern, text2)));
        }
        SpeedSearchObjectWithWeight cur = null;
        ArrayList<SpeedSearchObjectWithWeight> current = new ArrayList<SpeedSearchObjectWithWeight>();
        for (SpeedSearchObjectWithWeight element : elements) {
            if (cur == null) {
                cur = element;
                current.add(cur);
                continue;
            }
            int i2 = element.compareWith(cur);
            if (i2 == 0) {
                current.add(element);
                continue;
            }
            if (i2 >= 0) continue;
            cur = element;
            current.clear();
            current.add(cur);
        }
        return current;
    }
}

