/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.WindowMouseListener;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class WindowResizeListener
extends WindowMouseListener {
    private final Insets myBorder;
    private final Icon myCorner;

    public WindowResizeListener(Component content2, Insets border, Icon corner) {
        super(content2);
        this.myBorder = border;
        this.myCorner = corner;
    }

    public WindowResizeListener(Component content2, Icon corner) {
        super(content2);
        this.myBorder = null;
        this.myCorner = corner;
    }

    protected Insets getResizeOffset(Component view2) {
        return null;
    }

    protected Insets getResizeBorder(Component view2) {
        return this.myBorder;
    }

    @Override
    protected boolean isDisabled(Component view2) {
        if (view2 instanceof Dialog && !((Dialog)view2).isResizable()) {
            return true;
        }
        if (view2 instanceof Frame && !((Frame)view2).isResizable()) {
            return true;
        }
        return super.isDisabled(view2);
    }

    @Override
    int getCursorType(Component view2, Point location) {
        Container parent;
        Container container = parent = view2 instanceof Window ? null : view2.getParent();
        if (parent != null) {
            SwingUtilities.convertPointFromScreen(location, parent);
        }
        Rectangle bounds = view2.getBounds();
        boolean isWayland = StartupUiUtil.isWaylandToolkit();
        if (isWayland) {
            bounds.setLocation(view2.getLocationOnScreen());
        }
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getResizeOffset(view2));
        int top = location.y - bounds.y;
        if (top < 0) {
            return -1;
        }
        int left = location.x - bounds.x;
        if (left < 0) {
            return -1;
        }
        int right = bounds.width - left;
        if (right < 0) {
            return -1;
        }
        int bottom = bounds.height - top;
        if (bottom < 0) {
            return -1;
        }
        if (this.myCorner != null && right < this.myCorner.getIconWidth() && bottom < this.myCorner.getIconHeight()) {
            return 0;
        }
        Insets resizeArea = this.getResizeBorder(view2);
        if (resizeArea != null) {
            if (view2 instanceof Frame) {
                int state2 = ((Frame)view2).getExtendedState();
                if (WindowResizeListener.isStateSet(2, state2)) {
                    left = Integer.MAX_VALUE;
                    right = Integer.MAX_VALUE;
                }
                if (WindowResizeListener.isStateSet(4, state2)) {
                    top = Integer.MAX_VALUE;
                    bottom = Integer.MAX_VALUE;
                }
            }
            return this.support.getResizeCursor(top, left, bottom, right, resizeArea);
        }
        return -1;
    }

    @Override
    void updateBounds(Rectangle bounds, Component view2, int dx, int dy) {
        Dimension minimum = view2.getMinimumSize();
        int myCursorType = this.getCursorType();
        if (myCursorType == 7 || myCursorType == 11 || myCursorType == 5 || myCursorType == 0) {
            bounds.width += WindowResizeListener.fixMinSize(dx, bounds.width, minimum.width);
        } else if (myCursorType == 6 || myCursorType == 10 || myCursorType == 4) {
            dx = WindowResizeListener.fixMinSize(-dx, bounds.width, minimum.width);
            bounds.x -= dx;
            bounds.width += dx;
        }
        if (myCursorType == 4 || myCursorType == 9 || myCursorType == 5 || myCursorType == 0) {
            bounds.height += WindowResizeListener.fixMinSize(dy, bounds.height, minimum.height);
        } else if (myCursorType == 6 || myCursorType == 8 || myCursorType == 7) {
            dy = WindowResizeListener.fixMinSize(-dy, bounds.height, minimum.height);
            bounds.y -= dy;
            bounds.height += dy;
        }
    }

    private static int fixMinSize(int delta, int value, int min) {
        return delta + value < min ? min - value : delta;
    }
}

