/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.charts;

import com.intellij.ui.charts.BarDataset;
import com.intellij.ui.charts.Grid;
import com.intellij.ui.charts.GridChartWrapper;
import com.intellij.ui.charts.MinMax;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0002J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000 H\u0016J>\u0010!\u001a\u00020\u001b*\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000 H$R&\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00028\u00000\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016\u00a8\u0006%"}, d2={"Lcom/intellij/ui/charts/BarChart;", "T", "", "Lcom/intellij/ui/charts/GridChartWrapper;", "", "<init>", "()V", "datasets", "", "Lcom/intellij/ui/charts/BarDataset;", "getDatasets", "()Ljava/util/List;", "setDatasets", "(Ljava/util/List;)V", "ranges", "Lcom/intellij/ui/charts/Grid;", "getRanges", "()Lcom/intellij/ui/charts/Grid;", "gap", "getGap", "()I", "setGap", "(I)V", "space", "getSpace", "setSpace", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "getDatasetCount", "findMinMax", "Lcom/intellij/ui/charts/MinMax;", "paintDataset", "datasetIndex", "datasetCount", "xy", "intellij.platform.ide.ui"})
@SourceDebugExtension(value={"SMAP\nBarChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarChart.kt\ncom/intellij/ui/charts/BarChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1869#2,2:149\n1563#2:151\n1634#2,3:152\n1869#2,12:155\n*S KotlinDebug\n*F\n+ 1 BarChart.kt\ncom/intellij/ui/charts/BarChart\n*L\n50#1:149,2\n60#1:151\n60#1:152,3\n63#1:155,12\n*E\n"})
public abstract class BarChart<T extends Number>
extends GridChartWrapper<Integer, T> {
    @NotNull
    private List<BarDataset<T>> datasets = new ArrayList();
    @NotNull
    private final Grid<Integer, T> ranges = new Grid();
    private int gap = 10;
    private int space = -1;

    @NotNull
    public final List<BarDataset<T>> getDatasets() {
        return this.datasets;
    }

    public final void setDatasets(@NotNull List<BarDataset<T>> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.datasets = list2;
    }

    @Override
    @NotNull
    public Grid<Integer, T> getRanges() {
        return this.ranges;
    }

    public final int getGap() {
        return this.gap;
    }

    public final void setGap(int n) {
        this.gap = n;
    }

    public final int getSpace() {
        return this.space;
    }

    public final void setSpace(int n) {
        this.space = n;
    }

    @Override
    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        MinMax<Integer, T> xy = this.findMinMax();
        if (xy.isInitialized()) {
            int datasetCount = this.getDatasetCount();
            Graphics graphics = g.create(this.getMargins().left, this.getMargins().top, this.getGridWidth(), this.getGridHeight());
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            Graphics2D grid = (Graphics2D)graphics;
            this.paintGrid(grid, g, xy);
            int index = 0;
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BarDataset dataset = (BarDataset)element$iv;
                boolean bl = false;
                this.paintDataset(dataset, index, datasetCount, grid, xy);
                if (dataset.getStacked()) continue;
                ++index;
            }
            grid.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getDatasetCount() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.datasets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            BarDataset barDataset = (BarDataset)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStacked() ? 0 : 1);
        }
        return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MinMax<Integer, T> findMinMax() {
        MinMax minMax;
        if (this.getRanges().isInitialized()) {
            minMax = this.getRanges();
        } else {
            MinMax minMax2;
            MinMax minMax3 = minMax2 = this.getRanges().plus(new MinMax());
            MinMax minMax4 = this.getRanges();
            boolean bl = false;
            Iterable $this$forEach$iv = this.datasets;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BarDataset it = (BarDataset)element$iv;
                boolean bl2 = false;
                Iterable $this$forEachIndexed$iv = it.getData();
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void v;
                    void $this$findMinMax_u24lambda_u240;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Number number = (Number)item$iv;
                    int i2 = n;
                    boolean bl3 = false;
                    $this$findMinMax_u24lambda_u240.process(i2, v);
                }
            }
            minMax = minMax4.times(minMax2);
        }
        return minMax;
    }

    protected abstract void paintDataset(@NotNull BarDataset<T> var1, int var2, int var3, @NotNull Graphics2D var4, @NotNull MinMax<Integer, T> var5);
}

