/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.filterField;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.ClickListener;
import com.intellij.ui.filterField.FilterFieldKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.function.Supplier;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002\"#B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH%J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0003H'J\b\u0010\u0011\u001a\u00020\fH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\fH\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0014J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001cH\u0002J\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ui/filterField/FilterField;", "Ljavax/swing/JPanel;", "originalMessage", "", "<init>", "(Ljava/lang/String;)V", "getOriginalMessage", "()Ljava/lang/String;", "nameLabel", "Ljavax/swing/JLabel;", "valueLabel", "initUi", "", "buildActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getCurrentText", "indicateFocusing", "showPopupMenuFromKeyboard", "showPopupMenuOnClick", "indicateHovering", "showPopupMenu", "setDefaultForeground", "getDefaultNameForeground", "Ljava/awt/Color;", "getDefaultSelectorForeground", "setOnHoverForeground", "createFocusedBorder", "Ljavax/swing/border/Border;", "createUnfocusedBorder", "wrapBorder", "outerBorder", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "AccessiblePopupComponent", "FilledRoundedBorder", "intellij.platform.ide.impl"})
public abstract class FilterField
extends JPanel {
    @NotNull
    private final String originalMessage;
    @NotNull
    private final JLabel nameLabel;
    @NotNull
    private final JLabel valueLabel;

    public FilterField(@Nls(capitalization=Nls.Capitalization.Title) @NotNull String originalMessage) {
        Intrinsics.checkNotNullParameter((Object)originalMessage, (String)"originalMessage");
        this.originalMessage = originalMessage;
        this.nameLabel = new JLabel(this){
            final /* synthetic */ FilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public String getText() {
                String value = this.this$0.getCurrentText();
                return value == null ? this.this$0.getOriginalMessage() + " " : this.this$0.getOriginalMessage() + ": ";
            }
        };
        this.valueLabel = new JLabel(this){
            final /* synthetic */ FilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public String getText() {
                return this.this$0.getCurrentText();
            }
        };
        this.initUi();
    }

    @NotNull
    public final String getOriginalMessage() {
        return this.originalMessage;
    }

    private final void initUi() {
        this.setFocusable(true);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(this.wrapBorder(this.createUnfocusedBorder()));
        this.add(this.nameLabel);
        this.add(this.valueLabel);
        this.add(new JLabel(AllIcons.General.ArrowDown));
        this.nameLabel.setForeground(this.getDefaultNameForeground());
        this.valueLabel.setForeground(this.getDefaultSelectorForeground());
        this.showPopupMenuOnClick();
        this.showPopupMenuFromKeyboard();
        this.indicateHovering();
        this.indicateFocusing();
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    @RequiresBackgroundThread
    @RequiresReadLock
    @NotNull
    protected abstract Collection<AnAction> buildActions();

    @Nls
    @Nullable
    public abstract String getCurrentText();

    private final void indicateFocusing() {
        this.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ FilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setBorder(FilterField.access$wrapBorder(this.this$0, FilterField.access$createFocusedBorder(this.this$0)));
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setBorder(FilterField.access$wrapBorder(this.this$0, this.this$0.createUnfocusedBorder()));
            }
        });
    }

    private final void showPopupMenuFromKeyboard() {
        this.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ FilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 || e.getKeyCode() == 40) {
                    FilterField.access$showPopupMenu(this.this$0);
                }
            }
        });
    }

    private final void showPopupMenuOnClick() {
        new ClickListener(this){
            final /* synthetic */ FilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean onClick(MouseEvent event, int clickCount) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FilterField.access$showPopupMenu(this.this$0);
                return true;
            }
        }.installOn((Component)this);
    }

    private final void indicateHovering() {
        this.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ FilterField this$0;
            {
                this.this$0 = $receiver;
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterField.access$setOnHoverForeground(this.this$0);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FilterField.access$setDefaultForeground(this.this$0);
            }
        });
    }

    private final void showPopupMenu() {
        JComponent jComponent = this;
        Supplier<Collection> supplier = this::buildActions;
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this);
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        FilterFieldKt.access$showAsyncChooserPopup(jComponent, supplier, dataContext2);
    }

    private final void setDefaultForeground() {
        this.nameLabel.setForeground(this.getDefaultNameForeground());
        this.valueLabel.setForeground(this.getDefaultSelectorForeground());
    }

    private final Color getDefaultNameForeground() {
        Color color = UIUtil.getLabelInfoForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getLabelInfoForeground(...)");
        return color;
    }

    private final Color getDefaultSelectorForeground() {
        Color color;
        if (StartupUiUtil.INSTANCE.isDarkTheme()) {
            Color color2 = UIUtil.getLabelForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getLabelForeground(...)");
        } else {
            Color color3 = NamedColorUtil.getInactiveTextColor().darker().darker();
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"darker(...)");
        }
        return color;
    }

    private final void setOnHoverForeground() {
        this.nameLabel.setForeground(StartupUiUtil.INSTANCE.isDarkTheme() ? UIUtil.getLabelForeground() : UIUtil.getTextAreaForeground());
        this.valueLabel.setForeground(StartupUiUtil.INSTANCE.isDarkTheme() ? UIUtil.getLabelForeground() : UIUtil.getTextFieldForeground());
    }

    private final Border createFocusedBorder() {
        Color color = UIUtil.getFocusedBorderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getFocusedBorderColor(...)");
        return new FilledRoundedBorder(color, 10, 2);
    }

    @NotNull
    protected Border createUnfocusedBorder() {
        Border border = JBUI.Borders.empty((int)2);
        Intrinsics.checkNotNullExpressionValue((Object)border, (String)"empty(...)");
        return border;
    }

    private final Border wrapBorder(Border outerBorder) {
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outerBorder, JBUI.Borders.empty((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)compoundBorder, (String)"createCompoundBorder(...)");
        return compoundBorder;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            AccessibleContext accessibleContext = super.getAccessibleContext();
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"getAccessibleContext(...)");
            this.accessibleContext = (AccessibleContext)((Object)new AccessiblePopupComponent(accessibleContext));
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    public static final /* synthetic */ Border access$wrapBorder(FilterField $this, Border outerBorder) {
        return $this.wrapBorder(outerBorder);
    }

    public static final /* synthetic */ Border access$createFocusedBorder(FilterField $this) {
        return $this.createFocusedBorder();
    }

    public static final /* synthetic */ void access$showPopupMenu(FilterField $this) {
        $this.showPopupMenu();
    }

    public static final /* synthetic */ void access$setOnHoverForeground(FilterField $this) {
        $this.setOnHoverForeground();
    }

    public static final /* synthetic */ void access$setDefaultForeground(FilterField $this) {
        $this.setDefaultForeground();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/filterField/FilterField$AccessiblePopupComponent;", "Lcom/intellij/util/ui/accessibility/AccessibleContextDelegate;", "context", "Ljavax/accessibility/AccessibleContext;", "<init>", "(Lcom/intellij/ui/filterField/FilterField;Ljavax/accessibility/AccessibleContext;)V", "getDelegateParent", "Ljava/awt/Container;", "getAccessibleRole", "Ljavax/accessibility/AccessibleRole;", "getAccessibleName", "", "intellij.platform.ide.impl"})
    private final class AccessiblePopupComponent
    extends AccessibleContextDelegate {
        public AccessiblePopupComponent(AccessibleContext context2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            super(context2);
        }

        @Nullable
        protected Container getDelegateParent() {
            return null;
        }

        @NotNull
        public AccessibleRole getAccessibleRole() {
            AccessibleRole accessibleRole = AccessibleRole.POPUP_MENU;
            Intrinsics.checkNotNullExpressionValue((Object)accessibleRole, (String)"POPUP_MENU");
            return accessibleRole;
        }

        @NotNull
        public String getAccessibleName() {
            Object[] objectArray = new Object[]{FilterField.this.nameLabel.getText(), FilterField.this.valueLabel.getText()};
            String string = IdeBundle.message((String)"accessibility.filter.label", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/filterField/FilterField$FilledRoundedBorder;", "Ljavax/swing/border/Border;", "myColor", "Ljava/awt/Color;", "myArcSize", "", "myThickness", "<init>", "(Ljava/awt/Color;II)V", "paintBorder", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "getBorderInsets", "Ljava/awt/Insets;", "isBorderOpaque", "", "intellij.platform.ide.impl"})
    private static final class FilledRoundedBorder
    implements Border {
        @NotNull
        private final Color myColor;
        private final int myArcSize;
        private final int myThickness;

        public FilledRoundedBorder(@NotNull Color myColor, int myArcSize, int myThickness) {
            Intrinsics.checkNotNullParameter((Object)myColor, (String)"myColor");
            this.myColor = myColor;
            this.myArcSize = myArcSize;
            this.myThickness = myThickness;
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            g.setColor(this.myColor);
            int thickness = JBUI.scale((int)this.myThickness);
            int arcSize = JBUI.scale((int)this.myArcSize);
            Area area = new Area(new RoundRectangle2D.Double(x, y, width, height, arcSize, arcSize));
            int innerArc = RangesKt.coerceAtLeast((int)(arcSize - thickness), (int)0);
            area.subtract(new Area(new RoundRectangle2D.Double(x + thickness, y + thickness, width - 2 * thickness, height - 2 * thickness, innerArc, innerArc)));
            ((Graphics2D)g).fill(area);
            config.restore();
        }

        @Override
        @NotNull
        public Insets getBorderInsets(@NotNull Component c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            JBInsets jBInsets = JBUI.insets((int)this.myThickness);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
            return (Insets)jBInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

