/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefCookie;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBCefCookieManager {
    private static final int DEFAULT_TIMEOUT_MS = 200;
    private static final int BOUNCE_TIMEOUT_MS = 50;
    private static final Logger LOG = Logger.getInstance(JBCefCookieManager.class);
    private final ReentrantLock myLock;
    private final ExecutorService myExecutorService;
    @NotNull
    private final CefCookieManager myCefCookieManager;

    public JBCefCookieManager() {
        this(CefCookieManager.getGlobalManager());
    }

    JBCefCookieManager(@NotNull CefCookieManager cefCookieManager) {
        if (cefCookieManager == null) {
            JBCefCookieManager.$$$reportNull$$$0(0);
        }
        this.myLock = new ReentrantLock();
        this.myExecutorService = AppExecutorUtil.getAppScheduledExecutorService();
        this.myCefCookieManager = cefCookieManager;
    }

    @NotNull
    public CefCookieManager getCefCookieManager() {
        CefCookieManager cefCookieManager = this.myCefCookieManager;
        if (cefCookieManager == null) {
            JBCefCookieManager.$$$reportNull$$$0(1);
        }
        return cefCookieManager;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public @NotNull Future<@NotNull List<JBCefCookie>> getCookies(@Nullable String url, @Nullable Boolean includeHttpOnly) {
        JBCookieVisitor cookieVisitor = new JBCookieVisitor();
        boolean result2 = url != null ? this.myCefCookieManager.visitUrlCookies(url, ((Boolean)ObjectUtils.notNull((Object)includeHttpOnly, (Object)Boolean.FALSE)).booleanValue(), (CefCookieVisitor)cookieVisitor) : this.myCefCookieManager.visitAllCookies((CefCookieVisitor)cookieVisitor);
        if (!result2) {
            LOG.debug("Cookies cannot be accessed");
            CompletableFuture<List<JBCefCookie>> completableFuture = CompletableFuture.completedFuture(Collections.emptyList());
            if (completableFuture == null) {
                JBCefCookieManager.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }
        @NotNull Ref futureRef = new Ref();
        futureRef.set(this.myExecutorService.submit(() -> cookieVisitor.get(() -> futureRef.get() == null || !((Future)futureRef.get()).isDone())));
        Future future = (Future)futureRef.get();
        if (future == null) {
            JBCefCookieManager.$$$reportNull$$$0(3);
        }
        return future;
    }

    @Deprecated
    @NotNull
    public List<JBCefCookie> getCookies() {
        return this.getCookies(null, false, null);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    private List<JBCefCookie> getCookies(@Nullable String url, @Nullable Boolean includeHttpOnly, @Nullable Integer maxTimeToWait) {
        boolean httpOnly = (Boolean)ObjectUtils.notNull((Object)includeHttpOnly, (Object)Boolean.FALSE);
        JBCookieVisitor cookieVisitor = new JBCookieVisitor();
        boolean result2 = url != null ? this.myCefCookieManager.visitUrlCookies(url, httpOnly, (CefCookieVisitor)cookieVisitor) : this.myCefCookieManager.visitAllCookies((CefCookieVisitor)cookieVisitor);
        if (!result2) {
            LOG.debug("Cookies cannot be accessed");
            List<JBCefCookie> list2 = Collections.emptyList();
            if (list2 == null) {
                JBCefCookieManager.$$$reportNull$$$0(4);
            }
            return list2;
        }
        List<JBCefCookie> list3 = cookieVisitor.get((Integer)ObjectUtils.notNull((Object)maxTimeToWait, (Object)200));
        if (list3 == null) {
            JBCefCookieManager.$$$reportNull$$$0(5);
        }
        return list3;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public @NotNull Future<@NotNull Boolean> setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(6);
        }
        if (jbCefCookie == null) {
            JBCefCookieManager.$$$reportNull$$$0(7);
        }
        if (!JBCefCookieManager.checkArgs(url, jbCefCookie)) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            if (completableFuture == null) {
                JBCefCookieManager.$$$reportNull$$$0(8);
            }
            return completableFuture;
        }
        if (!this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie())) {
            LOG.error("Posting task to set cookie is failed");
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            if (completableFuture == null) {
                JBCefCookieManager.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }
        @NotNull Ref futureRef = new Ref();
        futureRef.set(this.myExecutorService.submit(() -> {
            while (futureRef.get() == null || !((Future)futureRef.get()).isDone()) {
                if (!this.getCookies(url, null, 50).contains(jbCefCookie)) continue;
                return true;
            }
            return false;
        }));
        Future future = (Future)futureRef.get();
        if (future == null) {
            JBCefCookieManager.$$$reportNull$$$0(10);
        }
        return future;
    }

    @Deprecated
    public boolean setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie, boolean doSync2) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(11);
        }
        if (jbCefCookie == null) {
            JBCefCookieManager.$$$reportNull$$$0(12);
        }
        if (doSync2) {
            return this.setCookie(url, jbCefCookie, null);
        }
        return this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Deprecated(forRemoval=true)
    private boolean setCookie(@NotNull String url, @NotNull JBCefCookie jbCefCookie, @Nullable Integer maxTimeToWait) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(13);
        }
        if (jbCefCookie == null) {
            JBCefCookieManager.$$$reportNull$$$0(14);
        }
        if (!JBCefCookieManager.checkArgs(url, jbCefCookie)) {
            return false;
        }
        int timeout = (Integer)ObjectUtils.notNull((Object)maxTimeToWait, (Object)200);
        IntFunction<Boolean> checkFunction = timeoutForCheck -> this.getCookies(url, null, timeoutForCheck).contains(jbCefCookie);
        this.myLock.lock();
        try {
            Future<@NotNull Boolean> future = this.myExecutorService.submit(() -> {
                if (((Boolean)checkFunction.apply(timeout / 2)).booleanValue()) {
                    LOG.debug("Cookie is already set");
                    return true;
                }
                if (!this.myCefCookieManager.setCookie(url, jbCefCookie.getCefCookie())) {
                    LOG.error("Posting task to set cookie is failed");
                    return false;
                }
                while (this.myLock.isLocked()) {
                    boolean result2 = (Boolean)checkFunction.apply(timeout / 2);
                    if (!result2) continue;
                    return true;
                }
                return false;
            });
            try {
                boolean bl = future.get(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (TimeoutException e) {
                LOG.error("Cookie setting took more than " + timeout + " ms");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
            }
            catch (InterruptedException e) {
                LOG.error("Cookie setting is interrupted");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
                {
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    private static boolean checkArgs(@NotNull String url, @NotNull JBCefCookie jbCefCookie) {
        if (url == null) {
            JBCefCookieManager.$$$reportNull$$$0(15);
        }
        if (jbCefCookie == null) {
            JBCefCookieManager.$$$reportNull$$$0(16);
        }
        try {
            URI uri = new URI(url);
            String scheme = uri.getScheme();
            Object domain = uri.getHost();
            Object object = domain = ((String)domain).startsWith("www") ? domain : "." + (String)domain;
            if (scheme.equals("https") && !jbCefCookie.isSecure()) {
                LOG.warn("Cannot set cookie without secure flag for HTTPS web-site");
                return false;
            }
            if (!((String)domain).contains(jbCefCookie.getDomain())) {
                LOG.warn("Cookie domain `" + jbCefCookie.getDomain() + "` doesn't match URL host `" + (String)domain + "`");
                return false;
            }
        }
        catch (URISyntaxException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public @NotNull Future<@NotNull Boolean> deleteCookies(@Nullable String url, @Nullable String cookieName) {
        if (!this.myCefCookieManager.deleteCookies(url, cookieName)) {
            LOG.error("Posting task to delete cookies is failed");
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            if (completableFuture == null) {
                JBCefCookieManager.$$$reportNull$$$0(17);
            }
            return completableFuture;
        }
        @NotNull Ref futureRef = new Ref();
        futureRef.set(this.myExecutorService.submit(() -> {
            while (futureRef.get() == null || !((Future)futureRef.get()).isDone()) {
                if (ContainerUtil.exists(this.getCookies(url, false, 50), cookie -> cookie.getName().equals(cookieName))) continue;
                return true;
            }
            return false;
        }));
        Future future = (Future)futureRef.get();
        if (future == null) {
            JBCefCookieManager.$$$reportNull$$$0(18);
        }
        return future;
    }

    @Deprecated
    public boolean deleteCookies(boolean doSync2) {
        if (doSync2) {
            return this.deleteCookies(null, null, timeout -> this.getCookies(null, false, timeout).isEmpty(), null);
        }
        return this.myCefCookieManager.deleteCookies("", "");
    }

    @Deprecated
    public boolean deleteCookies(@Nullable String url, boolean doSync2) {
        if (doSync2) {
            return this.deleteCookies(url, "", timeout -> this.getCookies(url, false, timeout).isEmpty(), null);
        }
        return this.myCefCookieManager.deleteCookies(url, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean deleteCookies(@Nullable String url, @Nullable String cookieName, @NotNull IntFunction<Boolean> checkFunction, @Nullable Integer maxTimeToWait) {
        if (checkFunction == null) {
            JBCefCookieManager.$$$reportNull$$$0(19);
        }
        int timeout = (Integer)ObjectUtils.notNull((Object)maxTimeToWait, (Object)200);
        this.myLock.lock();
        try {
            Future<@NotNull Boolean> future = this.myExecutorService.submit(() -> {
                if (((Boolean)checkFunction.apply(timeout / 2)).booleanValue()) {
                    LOG.debug("No cookies to be deleted");
                    return true;
                }
                if (!this.myCefCookieManager.deleteCookies(url, cookieName)) {
                    LOG.error("Posting task to delete cookies is failed");
                    return false;
                }
                while (this.myLock.isLocked()) {
                    boolean result2 = (Boolean)checkFunction.apply(timeout / 2);
                    if (!result2) continue;
                    return true;
                }
                return false;
            });
            try {
                boolean bl = future.get(timeout, TimeUnit.MILLISECONDS);
                return bl;
            }
            catch (TimeoutException e) {
                LOG.error("Cookie deleting took more than " + timeout + " ms");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
            }
            catch (InterruptedException e) {
                LOG.error("Cookie deleting is interrupted");
                boolean bl = false;
                this.myLock.unlock();
                return bl;
                {
                    catch (Exception e2) {
                        LOG.error((Throwable)e2);
                        boolean bl2 = false;
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    static {
        JBCefApp.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 8, 9, 10, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefCookieManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefCookieManager";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jbCefCookie";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefCookieManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefCookieManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCookies";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setCookie";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "deleteCookies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 18: {
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setCookie";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkArgs";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deleteCookies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 8, 9, 10, 17, 18 -> new IllegalStateException(string);
        };
    }

    private static class JBCookieVisitor
    implements CefCookieVisitor {
        @NotNull
        final List<JBCefCookie> myCefCookies = Collections.synchronizedList(new ArrayList());
        @NotNull
        final CountDownLatch myCountDownLatch;
        long myStartTime = Clock.getTime();

        JBCookieVisitor() {
            this.myCountDownLatch = new CountDownLatch(1);
        }

        public boolean visit(CefCookie cookie, int count, int total, BoolRef delete2) {
            this.myCefCookies.add(new JBCefCookie(cookie));
            if (this.myCefCookies.size() >= total) {
                this.myCountDownLatch.countDown();
            }
            return true;
        }

        @NotNull
        public List<JBCefCookie> get(@NotNull Supplier<Boolean> condition) {
            if (condition == null) {
                JBCookieVisitor.$$$reportNull$$$0(0);
            }
            while (condition.get().booleanValue()) {
                List<JBCefCookie> list2;
                try {
                    if (!this.myCountDownLatch.await(50L, TimeUnit.MILLISECONDS)) continue;
                    list2 = this.myCefCookies;
                }
                catch (InterruptedException e) {
                    LOG.error("Cookie visiting is interrupted");
                    break;
                }
                if (list2 == null) {
                    JBCookieVisitor.$$$reportNull$$$0(1);
                }
                return list2;
            }
            List<JBCefCookie> list3 = Collections.emptyList();
            if (list3 == null) {
                JBCookieVisitor.$$$reportNull$$$0(2);
            }
            return list3;
        }

        @NotNull
        public List<JBCefCookie> get(int timeout) {
            boolean result2;
            try {
                result2 = this.myCountDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("Cookie visiting is interrupted");
                List<JBCefCookie> list2 = Collections.emptyList();
                if (list2 == null) {
                    JBCookieVisitor.$$$reportNull$$$0(3);
                }
                return list2;
            }
            long timeSpent = Clock.getTime() - this.myStartTime;
            if (!result2) {
                LOG.debug("Timeout for cookie visiting is reached, " + timeSpent + " ms time spent");
            } else {
                LOG.debug("Cookie getting took " + timeSpent + " ms");
            }
            List<JBCefCookie> list3 = this.myCefCookies;
            if (list3 == null) {
                JBCookieVisitor.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/jcef/JBCefCookieManager$JBCookieVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/jcef/JBCefCookieManager$JBCookieVisitor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

