/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefCaretListener;
import com.intellij.ui.jcef.JBCefOsrComponent;
import com.intellij.util.ObjectUtils;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Arrays;
import java.util.List;
import org.cef.browser.CefBrowser;
import org.cef.input.CefCompositionUnderline;
import org.cef.misc.CefLog;
import org.cef.misc.CefRange;
import org.jetbrains.annotations.Nullable;

class JBCefInputMethodAdapter
implements InputMethodRequests,
InputMethodListener,
JBCefCaretListener {
    public static final CefRange DEFAULT_RANGE = new CefRange(-1, -1);
    private CefBrowser myBrowser;
    private final JBCefOsrComponent myMyComponent;
    private volatile CefRange myCompositionSelectionRange;
    private volatile Rectangle[] myCompositionCharacterBounds;
    private volatile String mySelectedText = "";
    private volatile CefRange mySelectionRange = DEFAULT_RANGE;

    JBCefInputMethodAdapter(JBCefOsrComponent myComponent) {
        this.myMyComponent = myComponent;
    }

    void setBrowser(CefBrowser browser) {
        this.myBrowser = browser;
    }

    @Override
    public void inputMethodTextChanged(InputMethodEvent event) {
        StringBuilder textBuffer;
        CefLog.Debug((String)"InputMethodListener::inputMethodTextChanged(event: %s)", (Object[])new Object[]{event});
        int committedCharacterCount = event.getCommittedCharacterCount();
        AttributedCharacterIterator text2 = event.getText();
        if (text2 == null) {
            return;
        }
        char c = text2.first();
        if (committedCharacterCount > 0) {
            textBuffer = new StringBuilder();
            while (committedCharacterCount-- > 0) {
                textBuffer.append(c);
                c = text2.next();
            }
            String committedText = textBuffer.toString();
            CefRange replacementRange = DEFAULT_RANGE;
            int relativeCursorPos = 0;
            CefLog.Debug((String)"CefBrowser::ImeCommitText(compositionText: '%s', replacementRange: %s, selectionRange: %s)", (Object[])new Object[]{committedText, replacementRange, relativeCursorPos});
            this.myBrowser.ImeCommitText(committedText, replacementRange, relativeCursorPos);
            this.mySelectedText = "";
            this.mySelectionRange = DEFAULT_RANGE;
        }
        textBuffer = new StringBuilder();
        while (c != '\uffff') {
            textBuffer.append(c);
            c = text2.next();
        }
        String composedText = textBuffer.toString();
        if (!composedText.isEmpty()) {
            JBColor color = new JBColor(new Color(0, true), new Color(0, true));
            CefCompositionUnderline underline = new CefCompositionUnderline(new CefRange(0, composedText.length()), (Color)color, (Color)color, 0, CefCompositionUnderline.Style.SOLID);
            CefRange replacementRange = this.mySelectionRange;
            if (replacementRange == null || replacementRange.from == replacementRange.to) {
                replacementRange = DEFAULT_RANGE;
            }
            CefRange selectionRange = new CefRange(composedText.length(), composedText.length());
            CefLog.Debug((String)"CefBrowser::ImeSetComposition(compositionText: '%s', replacementRange: %s, selectionRange: %s)", (Object[])new Object[]{composedText, replacementRange, selectionRange});
            this.myBrowser.ImeSetComposition(composedText, List.of(underline), replacementRange, selectionRange);
        }
        event.consume();
    }

    @Override
    public void caretPositionChanged(InputMethodEvent event) {
        CefLog.Debug((String)"InputMethodListener::caretPositionChanged(event: %s)", (Object[])new Object[]{event});
    }

    @Override
    public Rectangle getTextLocation(TextHitInfo offset) {
        Rectangle[] boxes = (Rectangle[])ObjectUtils.notNull((Object)this.myCompositionCharacterBounds, (Object)new Rectangle[]{this.getDefaultImePositions()});
        Rectangle candidateWindowPosition = boxes.length == 0 ? this.getDefaultImePositions() : new Rectangle(boxes[0]);
        Point componentLocation = this.myMyComponent.getLocationOnScreen();
        candidateWindowPosition.translate(componentLocation.x, componentLocation.y);
        CefLog.Debug((String)"InputMethodRequests::getTextLocation(offset: %s) -> %s", (Object[])new Object[]{offset, candidateWindowPosition});
        return candidateWindowPosition;
    }

    @Override
    @Nullable
    public TextHitInfo getLocationOffset(int x, int y) {
        Point p = new Point(x, y);
        Point componentLocation = this.myMyComponent.getLocationOnScreen();
        p.translate(-componentLocation.x, -componentLocation.y);
        Rectangle[] boxes = (Rectangle[])ObjectUtils.notNull((Object)this.myCompositionCharacterBounds, (Object)new Rectangle[0]);
        TextHitInfo result2 = null;
        for (int i2 = 0; i2 < boxes.length; ++i2) {
            Rectangle r = boxes[i2];
            if (!r.contains(p)) continue;
            result2 = TextHitInfo.leading(i2);
            break;
        }
        CefLog.Debug((String)"InputMethodRequests::getTextLocation(x: %s, y: %s) -> %s", (Object[])new Object[]{x, y, result2});
        return result2;
    }

    @Override
    public int getInsertPositionOffset() {
        CefLog.Debug((String)"InputMethodRequests::getInsertPositionOffset() -> 0", (Object[])new Object[0]);
        return 0;
    }

    @Override
    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        CefLog.Debug((String)"InputMethodRequests::getCommittedText(beginIndex: %s, endIndex: %s) -> ''", (Object[])new Object[]{beginIndex, endIndex});
        return new AttributedString("").getIterator();
    }

    @Override
    public int getCommittedTextLength() {
        CefLog.Debug((String)"InputMethodRequests::getCommittedTextLength() -> 0", (Object[])new Object[0]);
        return 0;
    }

    @Override
    @Nullable
    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        CefLog.Debug((String)"InputMethodRequests::cancelLatestCommittedText(attributes: %s) -> 0", (Object[])new Object[]{Arrays.toString(attributes)});
        return null;
    }

    @Override
    @Nullable
    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        CefLog.Debug((String)"InputMethodRequests::getSelectedText(attributes: %s) -> 0", (Object[])new Object[]{Arrays.toString(attributes)});
        return new AttributedString(this.mySelectedText).getIterator();
    }

    private Rectangle getDefaultImePositions() {
        return new Rectangle(0, this.myMyComponent.getHeight(), 0, 0);
    }

    @Override
    public void onImeCompositionRangeChanged(CefRange selectionRange, Rectangle[] characterBounds) {
        this.myCompositionSelectionRange = selectionRange;
        this.myCompositionCharacterBounds = characterBounds;
        CefLog.Debug((String)"CefRenderHandler::OnImeCompositionRangeChanged(selectionRange: '%s', characterBounds: %s)", (Object[])new Object[]{this.mySelectionRange, Arrays.toString(characterBounds)});
    }

    @Override
    public void onTextSelectionChanged(String selectedText, CefRange selectionRange) {
        this.mySelectedText = selectedText;
        this.mySelectionRange = selectionRange;
        CefLog.Debug((String)"CefRenderHandler::OnTextSelectionChanged(selectionText: '%s', selectionRange: %s)", (Object[])new Object[]{this.mySelectedText, this.mySelectionRange});
    }
}

