/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.cef.browser.CefFrame;

public final class JcefShortcutProvider {
    private static final List<Pair<String, AnAction>> ourActions = JcefShortcutProvider.isSupportedByJCefApi() ? List.of(JcefShortcutProvider.createAction("$Cut", CefFrame::cut), JcefShortcutProvider.createAction("$Copy", CefFrame::copy), JcefShortcutProvider.createAction("$Paste", CefFrame::paste), JcefShortcutProvider.createAction("$SelectAll", CefFrame::selectAll), JcefShortcutProvider.createAction("$Undo", CefFrame::undo), JcefShortcutProvider.createAction("$Redo", CefFrame::redo)) : List.of();

    public static List<Pair<String, AnAction>> getActions() {
        return ourActions;
    }

    private static boolean isSupportedByJCefApi() {
        try {
            JCefAppConfig.getVersionDetails();
            return true;
        }
        catch (JCefVersionDetails.VersionUnavailableException | NoSuchMethodError e) {
            Logger.getInstance(JcefShortcutProvider.class).warn("JCEF shortcuts are unavailable (incompatible API)", e);
            return false;
        }
    }

    private static Pair<String, AnAction> createAction(String shortcut, Consumer<? super CefFrame> action2) {
        return Pair.create((Object)shortcut, (Object)LightEditActionFactory.create(event -> {
            Component component2 = (Component)event.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            if (component2 == null) {
                return;
            }
            if (component2 instanceof JComponent && ((JComponent)component2).getClientProperty("JBCefBrowser.instance") != null) {
                Object browser = ((JComponent)component2).getClientProperty("JBCefBrowser.instance");
                action2.accept(((JBCefBrowserBase)browser).getCefBrowser().getFocusedFrame());
                return;
            }
            Container parentComponent = component2.getParent();
            if (!(parentComponent instanceof JComponent)) {
                return;
            }
            Object browser = ((JComponent)parentComponent).getClientProperty("JBCefBrowser.instance");
            if (!(browser instanceof JBCefBrowserBase)) {
                return;
            }
            action2.accept(((JBCefBrowserBase)browser).getCefBrowser().getFocusedFrame());
        }));
    }

    public static void registerShortcuts(JComponent uiComp, JBCefBrowser jbCefBrowser) {
        ActionManager actionManager = ActionManager.getInstance();
        for (Pair<String, AnAction> action2 : ourActions) {
            ((AnAction)action2.second).registerCustomShortcutSet(actionManager.getAction((String)action2.first).getShortcutSet(), uiComp, (Disposable)jbCefBrowser);
        }
    }
}

