/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PropertiesHelper {
    @NotNull
    private static final Map<String, Class<?>> TYPES = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final Map<String, Object> myProperties = new HashMap<String, Object>();
    @NotNull
    private final PropertyChangeSupport myPropertyChangeSupport = new PropertyChangeSupport(this);

    PropertiesHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperty(@NotNull String name2, @Nullable Object value) {
        Class<?> type;
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(0);
        }
        if ((type = TYPES.get(name2)) != null && !type.isInstance(value)) {
            throw new IllegalArgumentException("JCEF: the property " + name2 + " should be " + type.getName());
        }
        Map<String, Object> map2 = this.myProperties;
        synchronized (map2) {
            Object oldValue = this.myProperties.put(name2, value);
            this.myPropertyChangeSupport.firePropertyChange(name2, oldValue, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object getProperty(@NotNull String name2) {
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(1);
        }
        Map<String, Object> map2 = this.myProperties;
        synchronized (map2) {
            return this.myProperties.get(name2);
        }
    }

    void addPropertyChangeListener(@NotNull String name2, @NotNull PropertyChangeListener listener2) {
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(2);
        }
        if (listener2 == null) {
            PropertiesHelper.$$$reportNull$$$0(3);
        }
        this.myPropertyChangeSupport.addPropertyChangeListener(name2, listener2);
    }

    void removePropertyChangeListener(@NotNull String name2, @NotNull PropertyChangeListener listener2) {
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(4);
        }
        if (listener2 == null) {
            PropertiesHelper.$$$reportNull$$$0(5);
        }
        this.myPropertyChangeSupport.removePropertyChangeListener(name2, listener2);
    }

    static void setType(@NotNull String name2, @NotNull Class<?> type) {
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(6);
        }
        if (type == null) {
            PropertiesHelper.$$$reportNull$$$0(7);
        }
        TYPES.put(name2, type);
    }

    boolean is(@NotNull String name2) {
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(8);
        }
        return Boolean.TRUE.equals(this.myProperties.get(name2));
    }

    int intValue(@NotNull String name2, int defaultValue) {
        Object value;
        if (name2 == null) {
            PropertiesHelper.$$$reportNull$$$0(9);
        }
        return (value = this.getProperty(name2)) instanceof Integer ? (Integer)value : defaultValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/jcef/PropertiesHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setProperty";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addPropertyChangeListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removePropertyChangeListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "is";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "intValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

