/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef.menu;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.jcef.menu.JBCefContextMenuImplementationChoserKt;
import com.intellij.ui.jcef.menu.JBCefMenuAdapter;
import java.awt.Point;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefRunContextMenuCallback;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u00112\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0006\u0010\u0013\u001a\u00020\u0005R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ui/jcef/menu/CefContextMenuRunner;", "Lorg/cef/handler/CefContextMenuHandlerAdapter;", "<init>", "()V", "runContextMenu", "", "browser", "Lorg/cef/browser/CefBrowser;", "frame", "Lorg/cef/browser/CefFrame;", "params", "Lorg/cef/callback/CefContextMenuParams;", "model", "Lorg/cef/callback/CefMenuModel;", "callback", "Lorg/cef/callback/CefRunContextMenuCallback;", "onContextMenuDismissed", "", "closePopup", "isShowing", "myCurrentPopup", "Lcom/intellij/openapi/ui/popup/ListPopup;", "mySelectionCallback", "intellij.platform.ui.jcef"})
@SourceDebugExtension(value={"SMAP\nCefContextMenuRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CefContextMenuRunner.kt\ncom/intellij/ui/jcef/menu/CefContextMenuRunner\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n23#2:68\n*S KotlinDebug\n*F\n+ 1 CefContextMenuRunner.kt\ncom/intellij/ui/jcef/menu/CefContextMenuRunner\n*L\n25#1:68\n*E\n"})
public final class CefContextMenuRunner
extends CefContextMenuHandlerAdapter {
    @Nullable
    private ListPopup myCurrentPopup;
    @Nullable
    private CefRunContextMenuCallback mySelectionCallback;

    public boolean runContextMenu(@NotNull CefBrowser browser, @NotNull CefFrame frame, @NotNull CefContextMenuParams params, @NotNull CefMenuModel model2, @NotNull CefRunContextMenuCallback callback) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (model2.getCount() <= 0) {
            this.closePopup();
            return true;
        }
        if (JBCefContextMenuImplementationChoserKt.isJcefContextMenuActionGroupRegistered()) {
            CefContextMenuRunner $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(CefContextMenuRunner.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Native context menu actions are overridden, skip native menu popup");
            return true;
        }
        JBCefMenuAdapter menuAdapter = new JBCefMenuAdapter(model2, arg_0 -> CefContextMenuRunner.runContextMenu$lambda$0(callback, arg_0));
        Point popupCoordinates = new Point(params.getXCoord(), params.getYCoord());
        SwingUtilities.invokeLater(() -> CefContextMenuRunner.runContextMenu$lambda$1(this, menuAdapter, browser, popupCoordinates));
        return true;
    }

    public void onContextMenuDismissed(@Nullable CefBrowser browser, @Nullable CefFrame frame) {
        this.closePopup();
    }

    private final void closePopup() {
        SwingUtilities.invokeLater(() -> CefContextMenuRunner.closePopup$lambda$0(this));
    }

    public final boolean isShowing() {
        return this.myCurrentPopup != null;
    }

    private static final void runContextMenu$lambda$0(CefRunContextMenuCallback $callback, JBCefMenuAdapter.MenuItem selectedItem) {
        if (selectedItem == null) {
            $callback.cancel();
        } else {
            $callback.Continue(selectedItem.getCommandId(), 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void runContextMenu$lambda$1(CefContextMenuRunner this$0, JBCefMenuAdapter $menuAdapter, CefBrowser $browser, Point $popupCoordinates) {
        void $this$runContextMenu_u24lambda_u241_u240;
        ListPopup listPopup;
        ListPopup listPopup2 = listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)$menuAdapter);
        CefContextMenuRunner cefContextMenuRunner = this$0;
        boolean bl = false;
        $this$runContextMenu_u24lambda_u241_u240.setRequestFocus(false);
        $this$runContextMenu_u24lambda_u241_u240.show(new RelativePoint($browser.getUIComponent(), $popupCoordinates));
        cefContextMenuRunner.myCurrentPopup = listPopup;
    }

    private static final void closePopup$lambda$0(CefContextMenuRunner this$0) {
        CefRunContextMenuCallback cefRunContextMenuCallback = this$0.mySelectionCallback;
        if (cefRunContextMenuCallback != null) {
            cefRunContextMenuCallback.cancel();
        }
        this$0.mySelectionCallback = null;
        ListPopup listPopup = this$0.myCurrentPopup;
        if (listPopup != null) {
            listPopup.cancel();
        }
        this$0.myCurrentPopup = null;
    }
}

