/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mouse;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.observable.properties.AtomicBooleanProperty;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.SpinnerKt;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.mouse.MouseWheelSmoothScrollOptionsAction;
import com.intellij.util.Alarm;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.Animations;
import com.intellij.util.animation.JBAnimator;
import com.intellij.util.animation.JBAnimatorHelper;
import com.intellij.util.animation.components.BezierPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\r\u0010\t\u001a\u00020\n*\u00020\u000bH\u0082\u0002J\r\u0010\f\u001a\u00020\n*\u00020\u000bH\u0082\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/mouse/MouseWheelSmoothScrollOptionsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "component1", "", "Ljava/awt/geom/Point2D;", "component2", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "BooleanPropertyPredicate", "BezierPainterWithAnimation", "intellij.platform.ide.impl"})
public final class MouseWheelSmoothScrollOptionsAction
extends DumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public void actionPerformed(@NotNull AnActionEvent e) {
        BezierPainterWithAnimation bezierPainterWithAnimation;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        UISettingsState settings = UISettings.Companion.getInstance().getState();
        int points = settings.getAnimatedScrollingCurvePoints();
        BezierPainterWithAnimation $this$actionPerformed_u24lambda_u240 = bezierPainterWithAnimation = new BezierPainterWithAnimation((double)(points >> 24 & 0xFF) / 200.0, (double)(points >> 16 & 0xFF) / 200.0, (double)(points >> 8 & 0xFF) / 200.0, (double)(points & 0xFF) / 200.0);
        boolean $i$a$-apply-MouseWheelSmoothScrollOptionsAction$actionPerformed$myBezierPainter$22 = false;
        $this$actionPerformed_u24lambda_u240.setMinimumSize(new Dimension(300, 200));
        BezierPainterWithAnimation myBezierPainter = bezierPainterWithAnimation;
        BooleanPropertyPredicate isPlaying = new BooleanPropertyPredicate(false);
        String string = IdeBundle.message((String)"title.smooth.scrolling.options", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        DialogPanel $i$a$-apply-MouseWheelSmoothScrollOptionsAction$actionPerformed$myBezierPainter$22 = BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1(settings, isPlaying, myBezierPainter, arg_0)));
        String it = string2 = ComponentsKt.dialog$default(string2, (JComponent)$i$a$-apply-MouseWheelSmoothScrollOptionsAction$actionPerformed$myBezierPainter$22, true, null, false, null, null, null, null, null, null, 2040, null);
        boolean bl = false;
        Disposer.register((Disposable)it.getDisposable(), (Disposable)myBezierPainter);
        boolean it2 = string2.showAndGet();
        boolean bl2 = false;
        if (it2) {
            Point2D point2D = myBezierPainter.getFirstControlPoint();
            double x1 = this.component1(point2D);
            double y1 = this.component2(point2D);
            Point2D point2D2 = myBezierPainter.getSecondControlPoint();
            double x2 = this.component1(point2D2);
            double y2 = this.component2(point2D2);
            int targetValue = 0;
            targetValue += (int)(x1 * (double)200) << 24 & 0xFF000000;
            targetValue += (int)(y1 * (double)200) << 16 & 0xFF0000;
            targetValue += (int)(x2 * (double)200) << 8 & 0xFF00;
            settings.setAnimatedScrollingCurvePoints(targetValue += (int)(y2 * (double)200) & 0xFF);
        }
    }

    private final double component1(Point2D $this$component1) {
        Intrinsics.checkNotNullParameter((Object)$this$component1, (String)"<this>");
        return $this$component1.getX();
    }

    private final double component2(Point2D $this$component2) {
        Intrinsics.checkNotNullParameter((Object)$this$component2, (String)"<this>");
        return $this$component2.getY();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit actionPerformed$lambda$1(UISettingsState $settings, BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Ref.ObjectRef c = new Ref.ObjectRef();
        Panel.row$default($this$panel, null, arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$0(c, $settings, $isPlaying, arg_0), 1, null);
        String string = IdeBundle.message((String)"label.smooth.scrolling.duration", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, (Function1<? super Row, Unit>)((Function1)arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$1($settings, c, $isPlaying, arg_0)));
        Panel.row$default($this$panel, null, arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$2($myBezierPainter, c, $isPlaying, arg_0), 1, null);
        Panel.row$default($this$panel, null, arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$3($isPlaying, $myBezierPainter, arg_0), 1, null);
        $this$panel.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$4($isPlaying, $myBezierPainter, arg_0))).visible(SystemInfoRt.isWindows);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1$0(Ref.ObjectRef $c, UISettingsState $settings, BooleanPropertyPredicate $isPlaying, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"checkbox.smooth.scrolling.animated", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $c.element = ButtonKt.bindSelected($this$row.checkBox(string), (KMutableProperty0<Boolean>)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((UISettingsState)this.receiver).getAnimatedScrolling();
            }

            public void set(Object value) {
                ((UISettingsState)this.receiver).setAnimatedScrolling(((Boolean)value).booleanValue());
            }
        })).enabledIf(ComponentPredicateKt.not((ComponentPredicate)$isPlaying));
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1$1(UISettingsState $settings, Ref.ObjectRef $c, BooleanPropertyPredicate $isPlaying, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JBIntSpinner> cell2 = SpinnerKt.bindIntValue($this$row.spinner(new IntRange(0, 2000), 50), (KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl($settings){

            public Object get() {
                return ((UISettingsState)this.receiver).getAnimatedScrollingDuration();
            }

            public void set(Object value) {
                ((UISettingsState)this.receiver).setAnimatedScrollingDuration(((Number)value).intValue());
            }
        }));
        if ($c.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"c");
            cell = null;
        } else {
            cell = (Cell)$c.element;
        }
        cell2.enabledIf(ComponentPredicateKt.and((ComponentPredicate)ButtonKt.getSelected(cell), (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)$isPlaying)));
        String string = IdeBundle.message((String)"label.milliseconds", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1$2(BezierPainterWithAnimation $myBezierPainter, Ref.ObjectRef $c, BooleanPropertyPredicate $isPlaying, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        Cell<JComponent> cell2 = $this$row.cell((JComponent)((Object)$myBezierPainter)).align(Align.FILL);
        if ($c.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"c");
            cell = null;
        } else {
            cell = (Cell)$c.element;
        }
        cell2.enabledIf(ComponentPredicateKt.and((ComponentPredicate)ButtonKt.getSelected(cell), (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)$isPlaying)));
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1$3(BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"link.smooth.scrolling.play.curve.animation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row.text$default($this$row, string, 0, arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$3$0($isPlaying, $myBezierPainter, arg_0), 2, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)$isPlaying));
        String string2 = IdeBundle.message((String)"link.smooth.scrolling.stop.curve.animation", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row.text$default($this$row, string2, 0, arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$3$1($isPlaying, $myBezierPainter, arg_0), 2, null).visibleIf($isPlaying);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$1$3$0(BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $isPlaying.set(true);
        $myBezierPainter.startAnimation();
    }

    private static final void actionPerformed$lambda$1$3$1(BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, HyperlinkEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $isPlaying.set(false);
        $myBezierPainter.stopAnimation();
    }

    private static final Unit actionPerformed$lambda$1$4(BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default($this$panel, null, arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$4$0($isPlaying, $myBezierPainter, arg_0), 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1$4$0(BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = IdeBundle.message((String)"checkbox.smooth.scrolling.enable.high.precision.timer", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBCheckBox> cell = ButtonKt.bindSelected($this$row.checkBox(string).applyToComponent((Function1<JBCheckBox, Unit>)((Function1)arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$4$0$0($isPlaying, $myBezierPainter, arg_0))), (Function0<Boolean>)((Function0)actionPerformed.1.5.1.2.INSTANCE), (Function1<? super Boolean, Unit>)((Function1)actionPerformed.1.5.1.3.INSTANCE));
        String string2 = IdeBundle.message((String)"checkbox.smooth.scrolling.enable.high.precision.timer.help", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Cell.comment$default(Cell.contextHelp$default(cell, string2, null, 2, null), IdeBundle.message((String)"checkbox.smooth.scrolling.enable.high.precision.timer.comments", (Object[])new Object[0]), 0, null, 6, null);
        return Unit.INSTANCE;
    }

    private static final Unit actionPerformed$lambda$1$4$0$0(BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.addItemListener(arg_0 -> MouseWheelSmoothScrollOptionsAction.actionPerformed$lambda$1$4$0$0$0($this$applyToComponent, $isPlaying, $myBezierPainter, arg_0));
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$1$4$0$0$0(JBCheckBox $this_applyToComponent, BooleanPropertyPredicate $isPlaying, BezierPainterWithAnimation $myBezierPainter, ItemEvent it) {
        JBAnimatorHelper.setAvailable((boolean)$this_applyToComponent.isSelected());
        if (JBAnimatorHelper.isAvailable() && $isPlaying.get()) {
            JBAnimatorHelper.requestHighPrecisionTimer((JBAnimator)$myBezierPainter.getAnimator());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u0014H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ui/mouse/MouseWheelSmoothScrollOptionsAction$BezierPainterWithAnimation;", "Lcom/intellij/util/animation/components/BezierPainter;", "Lcom/intellij/openapi/Disposable;", "x1", "", "y1", "x2", "y2", "<init>", "(DDDD)V", "animator", "Lcom/intellij/util/animation/JBAnimator;", "getAnimator", "()Lcom/intellij/util/animation/JBAnimator;", "animationId", "", "x", "frames", "", "startAnimation", "", "stopAnimation", "paintComponent", "g", "Ljava/awt/Graphics;", "dispose", "intellij.platform.ide.impl"})
    private static final class BezierPainterWithAnimation
    extends BezierPainter
    implements Disposable {
        @NotNull
        private final JBAnimator animator;
        private long animationId;
        private double x;
        @NotNull
        private List<Long> frames;

        /*
         * WARNING - void declaration
         */
        public BezierPainterWithAnimation(double x1, double y1, double x2, double y2) {
            super(x1, y1, x2, y2);
            void $this$animator_u24lambda_u240;
            JBAnimator jBAnimator;
            JBAnimator jBAnimator2 = jBAnimator = new JBAnimator(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
            BezierPainterWithAnimation bezierPainterWithAnimation = this;
            boolean bl = false;
            $this$animator_u24lambda_u240.setPeriod(1);
            $this$animator_u24lambda_u240.setCyclic(true);
            $this$animator_u24lambda_u240.setName("Bezier Painter Animation Test");
            bezierPainterWithAnimation.animator = jBAnimator;
            this.animationId = -1L;
            this.frames = new ArrayList();
        }

        @NotNull
        public final JBAnimator getAnimator() {
            return this.animator;
        }

        /*
         * WARNING - void declaration
         */
        public final void startAnimation() {
            void $this$startAnimation_u24lambda_u241;
            Animation animation;
            Animation[] animationArray = new Animation[1];
            Animation animation2 = animation = Animations.animation(arg_0 -> BezierPainterWithAnimation.startAnimation$lambda$0(this, arg_0));
            int n = 0;
            Animation[] animationArray2 = animationArray;
            JBAnimator jBAnimator = this.animator;
            BezierPainterWithAnimation bezierPainterWithAnimation = this;
            boolean bl = false;
            $this$startAnimation_u24lambda_u241.setEasing(this.getEasing().freeze(0.0, 0.6666666666666666));
            $this$startAnimation_u24lambda_u241.setDuration(1000);
            $this$startAnimation_u24lambda_u241.runWhenUpdated(() -> BezierPainterWithAnimation.startAnimation$lambda$1$0(this));
            $this$startAnimation_u24lambda_u241.runWhenExpiredOrCancelled(() -> BezierPainterWithAnimation.startAnimation$lambda$1$1(this));
            Unit unit = Unit.INSTANCE;
            animationArray2[n] = animation;
            bezierPainterWithAnimation.animationId = jBAnimator.animate(animationArray);
        }

        public final void stopAnimation() {
            this.animator.stop();
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintComponent(g);
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Rectangle bounds = ((Graphics2D)g).getClipBounds();
            if (this.animator.isRunning(this.animationId)) {
                double d = 5.0;
                Path2D.Double shape = new Path2D.Double();
                double x1 = 0.0;
                double y1 = (1.0 - this.x) * (double)bounds.height;
                shape.moveTo(x1, y1);
                shape.lineTo(x1 + d, y1 - d);
                shape.lineTo(x1 + (double)3 * d, y1 - d);
                shape.lineTo(x1 + (double)3 * d, y1 + d);
                shape.lineTo(x1 + d, y1 + d);
                shape.closePath();
                ((Graphics2D)g).setColor((Color)JBColor.YELLOW);
                ((Graphics2D)g).fill(shape);
                long t = System.nanoTime();
                this.frames.add(t);
                Iterator<Long> it = this.frames.iterator();
                while (t - ((Number)it.next()).longValue() > TimeUnit.SECONDS.toNanos(1L)) {
                    it.remove();
                }
            }
            if (!((Collection)this.frames).isEmpty()) {
                GraphicsUtil.setupAntialiasing((Graphics)g);
                ((Graphics2D)g).setColor(UIUtil.getLabelDisabledForeground());
                Object[] objectArray = new Object[]{this.frames.size()};
                String string = IdeBundle.message((String)"label.smooth.scrolling.bezier.panel.updates", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String text2 = string;
                ((Graphics2D)g).drawString(text2, this.getWidth() / 16, bounds.height - 5);
            }
        }

        public void dispose() {
        }

        private static final void startAnimation$lambda$0(BezierPainterWithAnimation this$0, double it) {
            this$0.x = it;
        }

        private static final void startAnimation$lambda$1$0(BezierPainterWithAnimation this$0) {
            this$0.repaint();
        }

        private static final void startAnimation$lambda$1$1(BezierPainterWithAnimation this$0) {
            this$0.x = 0.0;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003J\u001c\u0010\u000b\u001a\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ui/mouse/MouseWheelSmoothScrollOptionsAction$BooleanPropertyPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "value", "", "<init>", "(Z)V", "property", "Lcom/intellij/openapi/observable/properties/AtomicBooleanProperty;", "set", "", "get", "addListener", "listener", "Lkotlin/Function1;", "invoke", "()Ljava/lang/Boolean;", "intellij.platform.ide.impl"})
    private static final class BooleanPropertyPredicate
    extends ComponentPredicate {
        @NotNull
        private final AtomicBooleanProperty property;

        public BooleanPropertyPredicate(boolean value) {
            this.property = new AtomicBooleanProperty(value);
        }

        public final void set(boolean value) {
            this.property.set(value);
        }

        public final boolean get() {
            return this.property.get();
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.property.afterChange(arg_0 -> BooleanPropertyPredicate.addListener$lambda$0(listener2, this, arg_0));
        }

        @NotNull
        public Boolean invoke() {
            return this.get();
        }

        private static final Unit addListener$lambda$0(Function1 $listener, BooleanPropertyPredicate this$0, boolean it) {
            $listener.invoke((Object)this$0.get());
            return Unit.INSTANCE;
        }
    }
}

