/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.tree;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.NextStepHandler;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.util.PopupImplUtil;
import com.intellij.ui.tree.FilteringTreeModel;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.filtered.FilteringTreeStructure;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreePopupImpl
extends WizardPopup
implements TreePopup,
NextStepHandler {
    private MyTree myWizardTree;
    private MouseMotionListener myMouseMotionListener;
    private MouseListener myMouseListener;
    private TreePath myShowingChildPath;
    private TreePath myPendingChildPath;
    private FilteringTreeModel myModel;

    public TreePopupImpl(@Nullable Project project2, @Nullable JBPopup parent, @NotNull TreePopupStep<Object> aStep, @Nullable Object parentValue) {
        if (aStep == null) {
            TreePopupImpl.$$$reportNull$$$0(0);
        }
        super(project2, parent, (PopupStep<Object>)aStep);
        this.setParentValue(parentValue);
    }

    @Override
    protected JComponent createContent() {
        this.myWizardTree = new MyTree();
        this.myWizardTree.getAccessibleContext().setAccessibleName("WizardTree");
        this.myModel = FilteringTreeModel.createModel(this.getTreeStep().getStructure(), this, Invoker.forEventDispatchThread((Disposable)this), this);
        this.myWizardTree.setModel((TreeModel)((Object)this.myModel));
        this.myModel.updateTree((JTree)((Object)this.myWizardTree), false, null);
        this.myWizardTree.getSelectionModel().setSelectionMode(1);
        Action action2 = this.myWizardTree.getActionMap().get("toggleSelectionPreserveAnchor");
        if (action2 != null) {
            action2.setEnabled(false);
        }
        this.myWizardTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 32) {
                    TreePopupImpl.this.toggleExpansion(TreePopupImpl.this.myWizardTree.getAnchorSelectionPath());
                }
            }
        });
        this.myWizardTree.setRootVisible(this.getTreeStep().isRootVisible());
        this.myWizardTree.setShowsRootHandles(true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myWizardTree));
        this.myWizardTree.setCellRenderer((TreeCellRenderer)((Object)new MyRenderer()));
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        this.registerAction("select", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePopupImpl.this.handleSelect(true, null);
            }
        });
        this.registerAction("toggleExpansion", 32, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePopupImpl.this.toggleExpansion(TreePopupImpl.this.myWizardTree.getSelectionPath());
            }
        });
        final Action oldExpandAction = this.getActionMap().get("selectChild");
        this.getActionMap().put("selectChild", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = TreePopupImpl.this.myWizardTree.getSelectionPath();
                if (path != null && 0 == TreePopupImpl.this.myWizardTree.getModel().getChildCount(path.getLastPathComponent())) {
                    TreePopupImpl.this.handleSelect(false, null);
                    return;
                }
                oldExpandAction.actionPerformed(e);
            }
        });
        final Action oldCollapseAction = this.getActionMap().get("selectParent");
        this.getActionMap().put("selectParent", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = TreePopupImpl.this.myWizardTree.getSelectionPath();
                if (TreePopupImpl.this.shouldHidePopup(path)) {
                    TreePopupImpl.this.goBack();
                    return;
                }
                oldCollapseAction.actionPerformed(e);
            }
        });
        PopupUtil.applyNewUIBackground((Component)((Object)this.myWizardTree));
        return this.myWizardTree;
    }

    private boolean shouldHidePopup(TreePath path) {
        if (this.getParent() == null) {
            return false;
        }
        if (path == null) {
            return false;
        }
        if (!this.myWizardTree.isCollapsed(path)) {
            return false;
        }
        if (this.myWizardTree.isRootVisible()) {
            return path.getPathCount() == 1;
        }
        return path.getPathCount() == 2;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myWizardTree.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myWizardTree.getInputMap();
    }

    private void addListeners() {
        this.myWizardTree.addMouseMotionListener(this.myMouseMotionListener);
        this.myWizardTree.addMouseListener(this.myMouseListener);
    }

    @Override
    public void dispose() {
        this.myWizardTree.removeMouseMotionListener(this.myMouseMotionListener);
        this.myWizardTree.removeMouseListener(this.myMouseListener);
        super.dispose();
    }

    @Override
    protected boolean beforeShow() {
        this.addListeners();
        this.expandAll();
        return super.beforeShow();
    }

    @Override
    protected void afterShow() {
        this.selectFirstSelectableItem();
    }

    protected void selectFirstSelectableItem() {
        for (int i2 = 0; i2 < this.myWizardTree.getRowCount(); ++i2) {
            TreePath path = this.myWizardTree.getPathForRow(i2);
            if (!this.getTreeStep().isSelectable(path.getLastPathComponent(), this.extractUserObject(path.getLastPathComponent()))) continue;
            this.myWizardTree.setSelectionPath(path);
            break;
        }
    }

    public void expandAll() {
        for (int i2 = 0; i2 < this.myWizardTree.getRowCount(); ++i2) {
            this.myWizardTree.expandRow(i2);
        }
    }

    public void collapseAll() {
        for (int row2 = this.myWizardTree.getRowCount() - 1; row2 > 0; --row2) {
            this.myWizardTree.collapseRow(row2);
        }
    }

    public void scrollToSelection() {
        this.myWizardTree.scrollPathToVisible(this.myWizardTree.getSelectionPath());
    }

    private TreePopupStep<Object> getTreeStep() {
        return (TreePopupStep)this.myStep;
    }

    private TreePath getPath(MouseEvent e) {
        return this.myWizardTree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y);
    }

    private void toggleExpansion(TreePath path) {
        if (path == null) {
            return;
        }
        if (this.getTreeStep().isSelectable(path.getLastPathComponent(), this.extractUserObject(path.getLastPathComponent()))) {
            if (this.myWizardTree.isExpanded(path)) {
                this.myWizardTree.collapsePath(path);
            } else {
                this.myWizardTree.expandPath(path);
            }
        }
    }

    protected void handleSelect(boolean handleFinalChoices, MouseEvent e) {
        boolean pathIsAlreadySelected;
        boolean bl = pathIsAlreadySelected = this.myShowingChildPath != null && this.myShowingChildPath.equals(this.myWizardTree.getSelectionPath());
        if (pathIsAlreadySelected) {
            return;
        }
        this.myPendingChildPath = null;
        Object selected = this.myWizardTree.getLastSelectedPathComponent();
        if (selected != null) {
            Object userObject = this.extractUserObject(selected);
            if (this.getTreeStep().isSelectable(selected, userObject)) {
                PopupStep queriedStep;
                this.disposeChildren();
                boolean hasNextStep = this.myStep.hasSubstep(userObject);
                if (!hasNextStep && !handleFinalChoices) {
                    this.myShowingChildPath = null;
                    return;
                }
                try (AccessToken ignore = PopupImplUtil.prohibitFocusEventsInHandleSelect();
                     AccessToken ignore2 = SlowOperations.startSection((String)"action.perform");){
                    queriedStep = this.myStep.onChosen(userObject, handleFinalChoices);
                }
                if (queriedStep == PopupStep.FINAL_CHOICE || !hasNextStep) {
                    this.setFinalRunnable(this.myStep.getFinalRunnable());
                    this.setOk(true);
                    this.disposeAllParents(e);
                } else {
                    this.myShowingChildPath = this.myWizardTree.getSelectionPath();
                    this.handleNextStep(queriedStep, this.myShowingChildPath);
                    this.myShowingChildPath = null;
                }
            }
        }
    }

    @Override
    public void handleNextStep(PopupStep nextStep, Object parentValue) {
        Rectangle pathBounds = this.myWizardTree.getPathBounds(this.myWizardTree.getSelectionPath());
        Point point = new RelativePoint((Component)((Object)this.myWizardTree), new Point(this.getContent().getWidth() + 2, (int)pathBounds.getY())).getScreenPoint();
        this.myChild = this.createPopup(this, nextStep, parentValue);
        this.myChild.show(this.getContent(), point.x - 2, point.y, true);
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myWizardTree.processKeyEvent(aEvent);
    }

    protected Object extractUserObject(Object aNode) {
        Object object = ((DefaultMutableTreeNode)aNode).getUserObject();
        if (object instanceof FilteringTreeStructure.FilteringNode) {
            return ((FilteringTreeStructure.FilteringNode)object).getDelegate();
        }
        return object;
    }

    @Override
    protected void onAutoSelectionTimer() {
        this.handleSelect(false, null);
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myWizardTree;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.myModel.updateTree((JTree)((Object)this.myWizardTree), this.mySpeedSearch.isHoldingFilter(), null);
        this.selectFirstSelectableItem();
    }

    @Override
    protected void onChildSelectedFor(Object value) {
        TreePath path = (TreePath)value;
        if (this.myWizardTree.getSelectionPath() != path) {
            this.myWizardTree.setSelectionPath(path);
        }
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aStep", "com/intellij/ui/popup/tree/TreePopupImpl", "<init>"));
    }

    private final class MyTree
    extends SimpleTree {
        private MyTree() {
        }

        public void processKeyEvent(KeyEvent e) {
            e.setSource((Object)this);
            super.processKeyEvent(e);
        }

        public Dimension getPreferredSize() {
            Dimension pref = super.getPreferredSize();
            return new Dimension(pref.width + 10, pref.height);
        }

        protected void paintChildren(Graphics g) {
            super.paintChildren(g);
            Rectangle visibleRect = this.getVisibleRect();
            int rowForLocation = this.getClosestRowForLocation(0, visibleRect.y);
            int limit = rowForLocation + TreeUtil.getVisibleRowCount((JTree)((Object)this)) + 1;
            for (int i2 = rowForLocation; i2 < limit; ++i2) {
                TreePath eachPath = this.getPathForRow(i2);
                if (eachPath == null) continue;
                Object lastPathComponent = eachPath.getLastPathComponent();
                boolean hasNextStep = TreePopupImpl.this.getTreeStep().hasSubstep(TreePopupImpl.this.extractUserObject(lastPathComponent));
                if (!hasNextStep) continue;
                Icon icon2 = AllIcons.Icons.Ide.NextStep;
                Rectangle rec = this.getPathBounds(eachPath);
                int x = this.getSize().width - icon2.getIconWidth() - 1;
                int y = rec.y + (rec.height - icon2.getIconWidth()) / 2;
                icon2.paintIcon((Component)((Object)this), g, x, y);
            }
        }

        protected void configureUiHelper(TreeUIHelper helper) {
            if (TreePopupImpl.this.mySpeedSearch != null) {
                TreePopupImpl.this.mySpeedSearch.installSupplyTo((JComponent)((Object)this), false);
            }
        }
    }

    private final class MyRenderer
    extends NodeRenderer {
        private MyRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
            if (tree2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            boolean shouldPaintSelected = TreePopupImpl.this.getTreeStep().isSelectable(value, TreePopupImpl.this.extractUserObject(value)) && selected || TreePopupImpl.this.getTreeStep().isSelectable(value, TreePopupImpl.this.extractUserObject(value)) && hasFocus;
            boolean shouldPaintFocus = !TreePopupImpl.this.getTreeStep().isSelectable(value, TreePopupImpl.this.extractUserObject(value)) && selected || shouldPaintSelected || hasFocus;
            super.customizeCellRenderer(tree2, value, shouldPaintSelected, expanded, leaf, row2, shouldPaintFocus);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension size2 = super.getPreferredSize();
            if (ExperimentalUI.isNewUI()) {
                size2.height = JBUI.CurrentTheme.Tree.rowHeight();
            }
            Dimension dimension = size2;
            if (dimension == null) {
                MyRenderer.$$$reportNull$$$0(1);
            }
            return dimension;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/tree/TreePopupImpl$MyRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/tree/TreePopupImpl$MyRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyMouseMotionListener
    extends MouseMotionAdapter {
        private Point myLastMouseLocation;

        private MyMouseMotionListener() {
        }

        private boolean isMouseMoved(Point location) {
            if (this.myLastMouseLocation == null) {
                this.myLastMouseLocation = location;
                return false;
            }
            Point prev = this.myLastMouseLocation;
            this.myLastMouseLocation = location;
            return !prev.equals(location);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.isMouseMoved(e.getLocationOnScreen())) {
                return;
            }
            TreePath path = TreePopupImpl.this.getPath(e);
            if (path != null) {
                TreePopupImpl.this.myWizardTree.setSelectionPath(path);
                TreePopupImpl.this.notifyParentOnChildSelection();
                if (TreePopupImpl.this.getTreeStep().isSelectable(path.getLastPathComponent(), TreePopupImpl.this.extractUserObject(path.getLastPathComponent()))) {
                    TreePopupImpl.this.myWizardTree.setCursor(Cursor.getPredefinedCursor(12));
                    if (TreePopupImpl.this.myPendingChildPath == null || !TreePopupImpl.this.myPendingChildPath.equals(path)) {
                        TreePopupImpl.this.myPendingChildPath = path;
                        TreePopupImpl.this.restartTimer();
                    }
                    return;
                }
            }
            TreePopupImpl.this.myWizardTree.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private final class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            TreePath path = TreePopupImpl.this.getPath(e);
            if (path == null) {
                return;
            }
            if (e.getButton() != 1) {
                return;
            }
            Object selected = path.getLastPathComponent();
            if (TreePopupImpl.this.getTreeStep().isSelectable(selected, TreePopupImpl.this.extractUserObject(selected))) {
                TreePopupImpl.this.handleSelect(true, e);
            } else if (!TreeUtil.isLocationInExpandControl((JTree)((Object)TreePopupImpl.this.myWizardTree), (TreePath)path, (int)e.getX(), (int)e.getY())) {
                TreePopupImpl.this.toggleExpansion(path);
            }
        }
    }
}

