/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.CachedTreePresentation;
import com.intellij.ide.util.treeView.CachedTreePresentationNode;
import com.intellij.ide.util.treeView.CachedTreePresentationSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.tree.AbstractTreeWalker;
import com.intellij.ui.tree.BgtTreeWalker;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.ui.tree.RequestedTreeModelUpdateEvent;
import com.intellij.ui.tree.Searchable;
import com.intellij.ui.tree.TreeModelUpdateRequest;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.TreeWalkerBase;
import com.intellij.ui.treeStructure.BgtAwareTreeModel;
import com.intellij.ui.treeStructure.CachingTreePath;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.tree.AbstractTreeModel;
import com.intellij.util.ui.tree.TreeModelAdapter;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class AsyncTreeModel
extends AbstractTreeModel
implements Searchable,
TreeVisitor.LoadingAwareAcceptor,
CachedTreePresentationSupport,
BgtAwareTreeModel {
    private static final Logger LOG = Logger.getInstance(AsyncTreeModel.class);
    private final Invoker foreground;
    private final Invoker background;
    private final Tree tree;
    private final TreeModel model;
    private final boolean showLoadingNode;
    private final TreeModelListener listener;

    @Nullable
    private static RequestHandler wrapRequest(@Nullable TreeModelUpdateRequest request) {
        return request == null ? null : new RequestHandler(request);
    }

    public AsyncTreeModel(@NotNull TreeModel model2, @NotNull Disposable parent) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(1);
        }
        this(model2, true, parent);
    }

    public AsyncTreeModel(@NotNull TreeModel model2, boolean showLoadingNode, @NotNull Disposable parent) {
        if (model2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(3);
        }
        this.tree = new Tree();
        this.listener = new TreeModelAdapter(){

            protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                TreeModelUpdateRequest treeModelUpdateRequest;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (event instanceof RequestedTreeModelUpdateEvent) {
                    RequestedTreeModelUpdateEvent requested = (RequestedTreeModelUpdateEvent)event;
                    treeModelUpdateRequest = requested.getRequest();
                } else {
                    treeModelUpdateRequest = null;
                }
                RequestHandler request = AsyncTreeModel.wrapRequest(treeModelUpdateRequest);
                TreePath path = event.getTreePath();
                if (path == null) {
                    AsyncTreeModel.this.submit(new CmdGetRoot(request, "Reload root", null));
                    return;
                }
                Object object = path.getLastPathComponent();
                if (object == null) {
                    LOG.warn("unsupported path: " + String.valueOf(path));
                    if (request != null) {
                        request.finished();
                    }
                    return;
                }
                if (path.getParentPath() == null && type == TreeModelAdapter.EventType.StructureChanged) {
                    AsyncTreeModel.this.submit(new CmdGetRoot(request, "Update root", object));
                    return;
                }
                AsyncTreeModel.this.onValidThread(() -> {
                    Node node = AsyncTreeModel.this.tree.map.get(object);
                    if (node == null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.debug("ignore updating of nonexistent node: ", new Object[]{object});
                        }
                    } else if (type == TreeModelAdapter.EventType.NodesChanged) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), event.getChildIndices(), event.getChildren());
                    } else if (node.isLoadingRequired()) {
                        AsyncTreeModel.this.treeNodesChanged(event.getTreePath(), null, null);
                    } else if (type == TreeModelAdapter.EventType.NodesInserted) {
                        AsyncTreeModel.this.submit(new CmdGetChildren(request, "Insert children", node, false));
                    } else if (type == TreeModelAdapter.EventType.NodesRemoved) {
                        AsyncTreeModel.this.submit(new CmdGetChildren(request, "Remove children", node, false));
                    } else {
                        AsyncTreeModel.this.submit(new CmdGetChildren(request, "Update children", node, true));
                    }
                    if (request != null && request.commandsInProgress.get() == 0) {
                        request.finished();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ui/tree/AsyncTreeModel$1";
                objectArray[2] = "process";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (model2 instanceof Disposable) {
            Disposer.register((Disposable)this, (Disposable)((Disposable)model2));
        }
        this.foreground = Invoker.forEventDispatchThread((Disposable)this);
        if (model2 instanceof InvokerSupplier) {
            InvokerSupplier supplier = (InvokerSupplier)model2;
            this.background = supplier.getInvoker();
        } else {
            this.background = this.foreground;
        }
        if (this.background instanceof Invoker.EDT && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.error(new Throwable("Background invoker shall not be EDT. Please implement InvokerSupplier in your TreeModel"));
        }
        this.model = model2;
        this.model.addTreeModelListener(this.listener);
        this.showLoadingNode = showLoadingNode;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public TreeModel getModel() {
        TreeModel treeModel = this.model;
        if (treeModel == null) {
            AsyncTreeModel.$$$reportNull$$$0(4);
        }
        return treeModel;
    }

    public void dispose() {
        EDT.assertIsEdt();
        super.dispose();
        this.model.removeTreeModelListener(this.listener);
    }

    @Override
    @NotNull
    public Promise<TreePath> getTreePath(Object object) {
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(5);
            }
            return promise;
        }
        return this.resolve(this.model instanceof Searchable ? ((Searchable)((Object)this.model)).getTreePath(object) : null);
    }

    @NotNull
    public Promise<TreePath> resolve(TreePath path) {
        AsyncPromise async2 = new AsyncPromise();
        this.onValidThread(() -> this.resolve((AsyncPromise<? super TreePath>)async2, path));
        AsyncPromise asyncPromise = async2;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(6);
        }
        return asyncPromise;
    }

    @NotNull
    private Promise<TreePath> resolve(Promise<? extends TreePath> promise) {
        if (promise == null && this.isValidThread()) {
            Promise promise2 = Promises.rejectedPromise();
            if (promise2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(7);
            }
            return promise2;
        }
        AsyncPromise async2 = new AsyncPromise();
        if (promise == null) {
            this.onValidThread(() -> async2.setError("rejected"));
        } else {
            promise.onError(this.onValidThread((? super T error2) -> async2.setError(error2)));
            promise.onSuccess(this.onValidThread((? super T path) -> this.resolve((AsyncPromise<? super TreePath>)async2, (TreePath)path)));
        }
        AsyncPromise asyncPromise = async2;
        if (asyncPromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(8);
        }
        return asyncPromise;
    }

    private void resolve(@NotNull AsyncPromise<? super TreePath> async2, TreePath path) {
        if (async2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(9);
        }
        if (LOG.isTraceEnabled()) {
            LOG.debug("resolve path: ", new Object[]{path});
        }
        if (path == null) {
            async2.setError("path is null");
            return;
        }
        Object object = path.getLastPathComponent();
        if (object == null) {
            async2.setError("path is wrong");
            return;
        }
        this.accept((TreeVisitor)new TreeVisitor.ByTreePath(path, o -> o)).onProcessed(result2 -> {
            if (result2 == null) {
                async2.setError("path not found");
                return;
            }
            async2.setResult(result2);
        });
    }

    public Object getRoot() {
        if (this.disposed) {
            return null;
        }
        this.onValidThread(() -> this.promiseRootEntry());
        Node node = this.tree.root;
        return node == null ? null : node.object;
    }

    public Object getChild(Object object, int index) {
        List<Node> children2 = this.getEntryChildren(object);
        return 0 <= index && index < children2.size() ? children2.get((int)index).object : null;
    }

    public int getChildCount(Object object) {
        return this.getEntryChildren(object).size();
    }

    public boolean isLeaf(Object object) {
        List<Node> children2;
        Node node = this.getEntry(object);
        if (node == null) {
            return true;
        }
        if (node.leafState == LeafState.ALWAYS) {
            return true;
        }
        if (node.leafState == LeafState.NEVER) {
            return false;
        }
        if (node.leafState == LeafState.ASYNC && node.children == null) {
            this.promiseChildren(node);
        }
        return (children2 = node.children) != null && children2.isEmpty();
    }

    public void valueForPathChanged(@NotNull TreePath path, Object value) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(10);
        }
        this.background.invoke(() -> this.model.valueForPathChanged(path, value));
    }

    public int getIndexOfChild(Object object, Object child) {
        if (child != null) {
            List<Node> children2 = this.getEntryChildren(object);
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                if (!child.equals(children2.get((int)i2).object)) continue;
                return i2;
            }
        }
        return -1;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(11);
        }
        Promise<TreePath> promise = this.accept(visitor, true);
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(12);
        }
        return promise;
    }

    @NotNull
    public Promise<TreePath> accept(@NotNull TreeVisitor visitor, boolean allowLoading) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(13);
        }
        TreeWalkerBase<Node> walker = this.createWalker(visitor, allowLoading);
        if (allowLoading) {
            this.background.invokeLater(() -> this.onValidThread(() -> this.promiseRootEntry().onSuccess(node -> walker.start((Node)node)).onError(error2 -> walker.setError((Throwable)error2))));
        } else {
            this.onValidThread(() -> walker.start(this.tree.root));
        }
        Promise<TreePath> promise = walker.promise();
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(14);
        }
        return promise;
    }

    @NotNull
    private TreeWalkerBase<Node> createWalker(@NotNull TreeVisitor visitor, final boolean allowLoading) {
        if (visitor == null) {
            AsyncTreeModel.$$$reportNull$$$0(15);
        }
        if (visitor.visitThread() == TreeVisitor.VisitThread.BGT) {
            return new BgtTreeWalker<Node>(visitor, this.background, this.foreground, node -> node.object){

                @Override
                protected @Unmodifiable @Nullable Collection<Node> getChildren(@NotNull Node node) {
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return AsyncTreeModel.this.getChildrenForWalker(node, this, allowLoading);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/tree/AsyncTreeModel$2", "getChildren"));
                }
            };
        }
        return new AbstractTreeWalker<Node>(visitor, node -> node.object){

            @Override
            protected @Unmodifiable @Nullable Collection<Node> getChildren(@NotNull Node node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                return AsyncTreeModel.this.getChildrenForWalker(node, this, allowLoading);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/ui/tree/AsyncTreeModel$3", "getChildren"));
            }
        };
    }

    private @Unmodifiable @Nullable Collection<@NotNull Node> getChildrenForWalker(@NotNull Node node, TreeWalkerBase<Node> walker, boolean allowLoading) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(16);
        }
        if (node.leafState == LeafState.ALWAYS || !allowLoading) {
            return ContainerUtil.filter(node.getChildren(), n -> n.isLoaded());
        }
        this.promiseChildren(node).onSuccess(parent -> walker.setChildren(parent.getChildren())).onError(error2 -> walker.setError((Throwable)error2));
        return null;
    }

    public boolean isProcessing() {
        if (this.foreground.getTaskCount() > 0) {
            return true;
        }
        if (this.background.getTaskCount() > 0) {
            return true;
        }
        Command command = this.tree.queue.get();
        return command != null && command.isPending();
    }

    private void submit(@NotNull Command command) {
        if (command == null) {
            AsyncTreeModel.$$$reportNull$$$0(17);
        }
        this.computeTreeDataOnBgt(command).thenAsync(value -> this.applyToUiTree(command, (Node)value));
    }

    @NotNull
    private Promise<Node> computeTreeDataOnBgt(@NotNull Command command) {
        if (command == null) {
            AsyncTreeModel.$$$reportNull$$$0(18);
        }
        if (command.canRunAsync()) {
            CancellablePromise cancellablePromise = this.background.computeAsync(() -> command.computeAsync());
            if (cancellablePromise == null) {
                AsyncTreeModel.$$$reportNull$$$0(19);
            }
            return cancellablePromise;
        }
        CancellablePromise cancellablePromise = this.background.compute(() -> command.computeNode());
        if (cancellablePromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(20);
        }
        return cancellablePromise;
    }

    @NotNull
    private Promise<Void> applyToUiTree(@NotNull Command command, @Nullable Node value) {
        if (command == null) {
            AsyncTreeModel.$$$reportNull$$$0(21);
        }
        CancellablePromise cancellablePromise = this.foreground.compute(() -> {
            command.applyToUiTree(value);
            return null;
        });
        if (cancellablePromise == null) {
            AsyncTreeModel.$$$reportNull$$$0(22);
        }
        return cancellablePromise;
    }

    private boolean isValidThread() {
        if (this.foreground.isValidThread()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException("AsyncTreeModel is used from unexpected thread"));
        return false;
    }

    public void onValidThread(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(23);
        }
        this.foreground.invoke(runnable2);
    }

    @NotNull
    private <T> Consumer<T> onValidThread(@NotNull Consumer<? super T> consumer) {
        if (consumer == null) {
            AsyncTreeModel.$$$reportNull$$$0(24);
        }
        Consumer<Object> consumer2 = value -> this.onValidThread(() -> consumer.accept(value));
        if (consumer2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(25);
        }
        return consumer2;
    }

    @NotNull
    private Promise<Node> promiseRootEntry() {
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(26);
            }
            return promise;
        }
        Promise<Node> promise = this.tree.queue.promise(command -> this.submit((Command)command), () -> new CmdGetRoot(null, "Load root", null));
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(27);
        }
        return promise;
    }

    @NotNull
    private Promise<Node> promiseChildren(@NotNull Node node) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(28);
        }
        if (this.disposed) {
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                AsyncTreeModel.$$$reportNull$$$0(29);
            }
            return promise;
        }
        Promise<Node> promise = node.queue.promise(command -> this.submit((Command)command), () -> {
            List<Node> cachedNodes = this.getChildrenFromCachedPresentation(node);
            if (cachedNodes != null) {
                node.setChildren(cachedNodes);
            } else if (this.showLoadingNode) {
                node.setLoading(new Node(new LoadingNode(), LeafState.ALWAYS));
            } else {
                node.setLoading(null);
            }
            return new CmdGetChildren(null, "Load children", node, false);
        });
        if (promise == null) {
            AsyncTreeModel.$$$reportNull$$$0(30);
        }
        return promise;
    }

    private @Unmodifiable @Nullable List<Node> getChildrenFromCachedPresentation(@NotNull Node parent) {
        CachedTreePresentation cachedPresentation;
        if (parent == null) {
            AsyncTreeModel.$$$reportNull$$$0(31);
        }
        if ((cachedPresentation = this.tree.cachedPresentation) == null) {
            return null;
        }
        for (TreePath parentPath : parent.paths) {
            List cachedChildren = cachedPresentation.getChildren(parentPath.getLastPathComponent());
            if (cachedChildren == null) continue;
            return ContainerUtil.map((Collection)cachedChildren, child -> this.toNode(parent, cachedPresentation, parentPath.pathByAddingChild(child)));
        }
        return null;
    }

    @NotNull
    private Node toNode(@Nullable Node parent, @NotNull CachedTreePresentation cachedPresentation, @NotNull TreePath nodePath) {
        Object object;
        if (cachedPresentation == null) {
            AsyncTreeModel.$$$reportNull$$$0(32);
        }
        if (nodePath == null) {
            AsyncTreeModel.$$$reportNull$$$0(33);
        }
        Node result2 = new Node(object, cachedPresentation.isLeaf(object = nodePath.getLastPathComponent()) ? LeafState.ALWAYS : LeafState.NEVER);
        if (parent == null) {
            result2.paths.add((TreePath)new CachingTreePath(object));
        } else {
            for (TreePath path : parent.paths) {
                result2.paths.add(path.pathByAddingChild(object));
            }
        }
        this.tree.map.put(object, result2);
        List resultChildren = cachedPresentation.getChildren(nodePath.getLastPathComponent());
        if (resultChildren != null) {
            result2.children = ContainerUtil.map((Collection)resultChildren, child -> this.toNode(result2, cachedPresentation, nodePath.pathByAddingChild(child)));
        }
        Node node = result2;
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(34);
        }
        return node;
    }

    private Node getEntry(Object object) {
        return this.disposed || object == null || !this.isValidThread() ? null : this.tree.map.get(object);
    }

    @NotNull
    private List<Node> getEntryChildren(Object object) {
        Node node = this.getEntry(object);
        if (node == null) {
            List<Node> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(35);
            }
            return list2;
        }
        if (node.isLoadingRequired()) {
            if (object instanceof CachedTreePresentationNode) {
                node.setLoading(new Node(new LoadingNode(), LeafState.ALWAYS));
            } else {
                this.promiseChildren(node);
            }
        }
        List<Node> list3 = node.getChildren();
        if (list3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(36);
        }
        return list3;
    }

    @NotNull
    private TreeModelEvent createEvent(@NotNull TreePath path, @Nullable Object2IntMap<Object> map2) {
        if (path == null) {
            AsyncTreeModel.$$$reportNull$$$0(37);
        }
        if (map2 == null || map2.isEmpty()) {
            return new TreeModelEvent((Object)this, path, null, null);
        }
        int i2 = 0;
        int size2 = map2.size();
        int[] indices = new int[size2];
        Object[] children2 = new Object[size2];
        for (Object2IntMap.Entry entry : map2.object2IntEntrySet()) {
            indices[i2] = entry.getIntValue();
            children2[i2] = entry.getKey();
            ++i2;
        }
        return new TreeModelEvent((Object)this, path, indices, children2);
    }

    private void treeNodesChanged(@NotNull Node node, @Nullable Object2IntMap<Object> map2) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(38);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesChanged(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesInserted(@NotNull Node node, @NotNull Object2IntMap<Object> map2) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(39);
        }
        if (map2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(40);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesInserted(this.createEvent(path, map2));
            }
        }
    }

    private void treeNodesRemoved(@NotNull Node node, @NotNull Object2IntMap<Object> map2) {
        if (node == null) {
            AsyncTreeModel.$$$reportNull$$$0(41);
        }
        if (map2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(42);
        }
        if (!this.listeners.isEmpty()) {
            for (TreePath path : node.paths) {
                this.listeners.treeNodesRemoved(this.createEvent(path, map2));
            }
        }
    }

    @NotNull
    private static Object2IntMap<Object> createObject2IntLinkedMap(int size2) {
        Object2IntLinkedOpenHashMap map2 = new Object2IntLinkedOpenHashMap(size2);
        map2.defaultReturnValue(-1);
        Object2IntLinkedOpenHashMap object2IntLinkedOpenHashMap = map2;
        if (object2IntLinkedOpenHashMap == null) {
            AsyncTreeModel.$$$reportNull$$$0(43);
        }
        return object2IntLinkedOpenHashMap;
    }

    @NotNull
    private static Object2IntMap<Object> getIndices(@NotNull List<? extends Node> children2, @Nullable ToIntFunction<? super Node> function) {
        if (children2 == null) {
            AsyncTreeModel.$$$reportNull$$$0(44);
        }
        Object2IntMap<Object> map2 = AsyncTreeModel.createObject2IntLinkedMap(children2.size());
        for (int i2 = 0; i2 < children2.size(); ++i2) {
            Node child = children2.get(i2);
            if (map2.containsKey(child.object)) {
                LOG.warn("ignore duplicated " + (function == null ? "old" : "new") + " child at " + i2);
                continue;
            }
            map2.put(child.object, function == null ? i2 : function.applyAsInt(child));
        }
        Object2IntMap<Object> object2IntMap = map2;
        if (object2IntMap == null) {
            AsyncTreeModel.$$$reportNull$$$0(45);
        }
        return object2IntMap;
    }

    private static int getIntersectionCount(@NotNull Object2IntMap<Object> indices, @NotNull Iterable<Object> objects) {
        if (indices == null) {
            AsyncTreeModel.$$$reportNull$$$0(46);
        }
        if (objects == null) {
            AsyncTreeModel.$$$reportNull$$$0(47);
        }
        int count = 0;
        int last = -1;
        for (Object object : objects) {
            int index = indices.getOrDefault(object, -1);
            if (index == -1 || last >= index) continue;
            last = index;
            ++count;
        }
        return count;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Object2IntMap<Object> indices, @NotNull Iterable<Object> objects) {
        if (indices == null) {
            AsyncTreeModel.$$$reportNull$$$0(48);
        }
        if (objects == null) {
            AsyncTreeModel.$$$reportNull$$$0(49);
        }
        ArrayList<Object> list2 = new ArrayList<Object>(indices.size());
        int last = -1;
        for (Object object : objects) {
            int index = indices.getOrDefault(object, -1);
            if (index == -1 || last >= index) continue;
            last = index;
            list2.add(object);
        }
        ArrayList<Object> arrayList = list2;
        if (arrayList == null) {
            AsyncTreeModel.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    private static List<Object> getIntersection(@NotNull Object2IntMap<Object> removed, @NotNull Object2IntMap<Object> inserted) {
        int countTwo;
        if (removed == null) {
            AsyncTreeModel.$$$reportNull$$$0(51);
        }
        if (inserted == null) {
            AsyncTreeModel.$$$reportNull$$$0(52);
        }
        if (removed.isEmpty() || inserted.isEmpty()) {
            List<Object> list2 = Collections.emptyList();
            if (list2 == null) {
                AsyncTreeModel.$$$reportNull$$$0(53);
            }
            return list2;
        }
        int countOne = AsyncTreeModel.getIntersectionCount(removed, (Iterable<Object>)inserted.keySet());
        if (countOne > (countTwo = AsyncTreeModel.getIntersectionCount(inserted, (Iterable<Object>)removed.keySet()))) {
            return AsyncTreeModel.getIntersection(removed, (Iterable<Object>)inserted.keySet());
        }
        if (countTwo > 0) {
            return AsyncTreeModel.getIntersection(inserted, (Iterable<Object>)removed.keySet());
        }
        List<Object> list3 = Collections.emptyList();
        if (list3 == null) {
            AsyncTreeModel.$$$reportNull$$$0(54);
        }
        return list3;
    }

    @ApiStatus.Internal
    @Nullable
    public CachedTreePresentation getCachedPresentation() {
        return this.tree.cachedPresentation;
    }

    @ApiStatus.Internal
    public void setCachedPresentation(@Nullable CachedTreePresentation presentation2) {
        this.tree.cachedPresentation = presentation2;
        if (this.tree.root == null && presentation2 != null) {
            CachingTreePath rootPath = new CachingTreePath(presentation2.getRoot());
            this.tree.root = this.toNode(null, presentation2, (TreePath)rootPath);
            this.treeStructureChanged((TreePath)new CachingTreePath(this.tree.root.object), null, null);
        }
    }

    protected void treeStructureChanged(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeStructureChanged(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + String.valueOf(this.model), throwable);
        }
    }

    public void treeStructureChanged(TreePath path) {
        this.treeStructureChanged(path, null, null);
    }

    protected void treeNodesChanged(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesChanged(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + String.valueOf(this.model), throwable);
        }
    }

    public void treeNodesChanged(TreePath path) {
        this.treeNodesChanged(path, null, null);
    }

    protected void treeNodesInserted(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesInserted(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + String.valueOf(this.model), throwable);
        }
    }

    public void treeNodesInserted(TreePath path) {
        this.treeNodesInserted(path, null, null);
    }

    protected void treeNodesRemoved(TreePath path, int[] indices, Object[] children2) {
        try {
            super.treeNodesRemoved(path, indices, children2);
        }
        catch (Throwable throwable) {
            LOG.error("custom model: " + String.valueOf(this.model), throwable);
        }
    }

    public void treeNodesRemoved(TreePath path) {
        this.treeNodesRemoved(path, null, null);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Internal
    public void setRootImmediately(@NotNull Object object) {
        if (object == null) {
            AsyncTreeModel.$$$reportNull$$$0(55);
        }
        Node node = new Node(object, LeafState.NEVER);
        node.insertPath((TreePath)new CachingTreePath(object));
        this.tree.root = node;
        this.tree.map.put(object, node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 12, 14, 19, 20, 22, 25, 26, 27, 29, 30, 34, 35, 36, 43, 45, 50, 53, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 45: 
            case 50: 
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "async";
                break;
            }
            case 10: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 16: 
            case 28: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedPresentation";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePath";
                break;
            }
            case 40: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreePath";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "accept";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTreeDataOnBgt";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "applyToUiTree";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "onValidThread";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseRootEntry";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "promiseChildren";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "toNode";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryChildren";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "createObject2IntLinkedMap";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndices";
                break;
            }
            case 50: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 43: 
            case 45: 
            case 50: 
            case 53: 
            case 54: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "valueForPathChanged";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createWalker";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenForWalker";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "computeTreeDataOnBgt";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "applyToUiTree";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "onValidThread";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "promiseChildren";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenFromCachedPresentation";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toNode";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createEvent";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesChanged";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesInserted";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "treeNodesRemoved";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getIndices";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionCount";
                break;
            }
            case 48: 
            case 49: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getIntersection";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setRootImmediately";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 12, 14, 19, 20, 22, 25, 26, 27, 29, 30, 34, 35, 36, 43, 45, 50, 53, 54 -> new IllegalStateException(string);
        };
    }

    private static class RequestHandler {
        @NotNull
        private final TreeModelUpdateRequest request;
        @NotNull
        private final AtomicInteger commandsInProgress;

        RequestHandler(@NotNull TreeModelUpdateRequest request) {
            if (request == null) {
                RequestHandler.$$$reportNull$$$0(0);
            }
            this.commandsInProgress = new AtomicInteger();
            this.request = request;
        }

        void commandStarted() {
            this.commandsInProgress.incrementAndGet();
        }

        void commandFinished() {
            if (this.commandsInProgress.decrementAndGet() == 0) {
                this.request.finished();
            }
        }

        void nodesLoaded(int count) {
            this.request.nodesLoaded(count);
        }

        void finished() {
            this.request.finished();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/ui/tree/AsyncTreeModel$RequestHandler", "<init>"));
        }
    }

    private static final class Tree {
        private final CommandQueue<CmdGetRoot> queue = new CommandQueue();
        private final Map<Object, Node> map = new HashMap<Object, Node>();
        private volatile Node root;
        @Nullable
        private CachedTreePresentation cachedPresentation;

        private Tree() {
        }

        private void removeEmpty(@NotNull Node child) {
            if (child == null) {
                Tree.$$$reportNull$$$0(0);
            }
            child.forEachChildExceptLoading(node -> this.removeEmpty((Node)node));
            if (child.paths.isEmpty()) {
                child.queue.close();
                Node node2 = this.map.remove(child.object);
                if (node2 != child) {
                    LOG.warn("invalid node: " + String.valueOf(child.object));
                    if (node2 != null) {
                        this.map.put(node2.object, node2);
                    }
                }
            }
        }

        private void fixEqualButNotSame(@NotNull Node node, @NotNull Object object) {
            if (node == null) {
                Tree.$$$reportNull$$$0(1);
            }
            if (object == null) {
                Tree.$$$reportNull$$$0(2);
            }
            if (object == node.object) {
                return;
            }
            this.map.remove(node.object);
            node.updatePaths(node.object, object);
            node.object = object;
            this.map.put(object, node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "child";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Tree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeEmpty";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fixEqualButNotSame";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Node {
        private final CommandQueue<CmdGetChildren> queue;
        private final Set<TreePath> paths;
        @NotNull
        private volatile Object object;
        private volatile LeafState leafState;
        @Nullable
        private volatile List<Node> children;
        private volatile Node loading;

        private Node(@NotNull Object object, @NotNull LeafState leafState) {
            if (object == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (leafState == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.queue = new CommandQueue();
            this.paths = new SmartHashSet();
            this.object = object;
            this.leafState = leafState;
        }

        boolean isLoaded() {
            return !(this.object instanceof CachedTreePresentationNode);
        }

        private void setLeafState(@NotNull LeafState leafState) {
            if (leafState == null) {
                Node.$$$reportNull$$$0(2);
            }
            this.leafState = leafState;
            this.children = leafState == LeafState.ALWAYS ? null : Collections.emptyList();
            this.loading = null;
        }

        private void setChildren(@NotNull List<Node> children2) {
            if (children2 == null) {
                Node.$$$reportNull$$$0(3);
            }
            this.leafState = LeafState.NEVER;
            this.children = children2;
            this.loading = null;
        }

        private void setLoading(Node loading) {
            this.leafState = LeafState.NEVER;
            this.children = ContainerUtil.createMaybeSingletonList((Object)loading);
            this.loading = loading;
        }

        private boolean isLoadingRequired() {
            return this.leafState != LeafState.ALWAYS && this.children == null;
        }

        @NotNull
        private List<Node> getChildren() {
            List<Node> list2 = this.children;
            List<Node> list3 = list2 != null ? list2 : Collections.emptyList();
            if (list3 == null) {
                Node.$$$reportNull$$$0(4);
            }
            return list3;
        }

        private void forEachChildExceptLoading(Consumer<? super Node> consumer) {
            for (Node node : this.getChildren()) {
                if (node == this.loading) continue;
                consumer.accept(node);
            }
        }

        private void insertPath(@NotNull TreePath path) {
            if (path == null) {
                Node.$$$reportNull$$$0(5);
            }
            if (!this.paths.add(path)) {
                LOG.warn("node is already attached to " + String.valueOf(path));
            }
            this.forEachChildExceptLoading(child -> child.insertPath(path.pathByAddingChild(child.object)));
        }

        private void insertMapping(Node parent) {
            if (parent == null) {
                this.insertPath((TreePath)new CachingTreePath(this.object));
            } else if (parent.loading == this) {
                LOG.warn("insert loading node unexpectedly");
            } else if (parent.paths.isEmpty()) {
                LOG.warn("insert to invalid parent");
            } else {
                parent.paths.forEach(path -> this.insertPath(path.pathByAddingChild(this.object)));
            }
        }

        private void removePath(@NotNull TreePath path) {
            if (path == null) {
                Node.$$$reportNull$$$0(6);
            }
            if (!this.paths.remove(path)) {
                LOG.warn("node is not attached to " + String.valueOf(path));
            }
            this.forEachChildExceptLoading(child -> child.removePath(path.pathByAddingChild(child.object)));
        }

        private void removeMapping(Node parent, @NotNull Tree tree2) {
            if (tree2 == null) {
                Node.$$$reportNull$$$0(7);
            }
            if (parent == null) {
                this.removePath((TreePath)new CachingTreePath(this.object));
                tree2.removeEmpty(this);
            } else if (parent.loading == this) {
                parent.loading = null;
            } else if (parent.paths.isEmpty()) {
                LOG.warn("remove from invalid parent");
            } else {
                parent.paths.forEach(path -> this.removePath(path.pathByAddingChild(this.object)));
                tree2.removeEmpty(this);
            }
        }

        private void updatePaths(@NotNull Object oldObject, @NotNull Object newObject) {
            if (oldObject == null) {
                Node.$$$reportNull$$$0(8);
            }
            if (newObject == null) {
                Node.$$$reportNull$$$0(9);
            }
            if (ContainerUtil.exists(this.paths, path -> Node.contains(path, oldObject))) {
                List updated = ContainerUtil.map(this.paths, path -> Node.update(path, oldObject, newObject));
                this.paths.clear();
                this.paths.addAll(updated);
                this.forEachChildExceptLoading(child -> child.updatePaths(oldObject, newObject));
            }
        }

        @NotNull
        private static TreePath update(@NotNull TreePath path, @NotNull Object oldObject, @NotNull Object newObject) {
            if (path == null) {
                Node.$$$reportNull$$$0(10);
            }
            if (oldObject == null) {
                Node.$$$reportNull$$$0(11);
            }
            if (newObject == null) {
                Node.$$$reportNull$$$0(12);
            }
            if (!Node.contains(path, oldObject)) {
                TreePath treePath = path;
                if (treePath == null) {
                    Node.$$$reportNull$$$0(13);
                }
                return treePath;
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("update path: ", new Object[]{path});
            }
            Object[] objects = TreePathUtil.convertTreePathToArray(path);
            for (int i2 = 0; i2 < objects.length; ++i2) {
                if (oldObject != objects[i2]) continue;
                objects[i2] = newObject;
            }
            TreePath treePath = TreePathUtil.convertArrayToTreePath(objects);
            if (treePath == null) {
                Node.$$$reportNull$$$0(14);
            }
            return treePath;
        }

        private static boolean contains(@NotNull TreePath path, @NotNull Object object) {
            if (path == null) {
                Node.$$$reportNull$$$0(15);
            }
            if (object == null) {
                Node.$$$reportNull$$$0(16);
            }
            while (object != path.getLastPathComponent()) {
                if ((path = path.getParentPath()) != null) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "leafState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 5: 
                case 6: 
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldObject";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newObject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Node";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "update";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setLeafState";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setChildren";
                    break;
                }
                case 4: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "insertPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removePath";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMapping";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePaths";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 13, 14 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CommandQueue<T extends Command> {
        private final Deque<T> deque = new LinkedList<T>();
        private volatile boolean closed;

        private CommandQueue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Command get() {
            Deque<T> deque = this.deque;
            synchronized (deque) {
                return (Command)this.deque.peekFirst();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @NotNull
        Promise<Node> promise(@NotNull Consumer<? super Command> submitter, @NotNull Supplier<? extends Command> supplier) {
            Command command;
            if (submitter == null) {
                CommandQueue.$$$reportNull$$$0(0);
            }
            if (supplier == null) {
                CommandQueue.$$$reportNull$$$0(1);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                command = (Command)this.deque.peekFirst();
                if (command != null) {
                    AsyncPromise<Node> asyncPromise = command.promise;
                    // MONITOREXIT @DISABLED, blocks:[2, 5] lbl10 : MonitorExitStatement: MONITOREXIT : var4_3
                    if (asyncPromise == null) {
                        CommandQueue.$$$reportNull$$$0(2);
                    }
                    return asyncPromise;
                }
                command = supplier.get();
            }
            submitter.accept(command);
            AsyncPromise<Node> asyncPromise = command.promise;
            if (asyncPromise == null) {
                CommandQueue.$$$reportNull$$$0(3);
            }
            return asyncPromise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@NotNull T command, @NotNull Predicate<? super T> predicate) {
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(4);
            }
            if (predicate == null) {
                CommandQueue.$$$reportNull$$$0(5);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                boolean add2;
                if (this.closed) {
                    return;
                }
                Command old = (Command)this.deque.peekFirst();
                boolean bl = add2 = old == null || predicate.test(old);
                if (add2) {
                    this.deque.addFirst(command);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done(@NotNull T command, Node node) {
            Iterable<AsyncPromise<Node>> promises;
            if (command == null) {
                CommandQueue.$$$reportNull$$$0(6);
            }
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                if (!this.deque.contains(command)) {
                    return;
                }
                promises = this.getPromises((Command)command);
                if (this.deque.isEmpty()) {
                    this.deque.addLast(command);
                }
            }
            promises.forEach(promise -> promise.setResult((Object)node));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Iterable<AsyncPromise<Node>> promises;
            Deque<T> deque = this.deque;
            synchronized (deque) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                if (this.deque.isEmpty()) {
                    return;
                }
                promises = this.getPromises(null);
            }
            promises.forEach(promise -> promise.setError("cancel loading"));
        }

        @NotNull
        private Iterable<AsyncPromise<Node>> getPromises(@Nullable Command command) {
            Command last;
            ArrayList<AsyncPromise<Node>> list2 = new ArrayList<AsyncPromise<Node>>();
            while ((last = (Command)this.deque.pollLast()) != null) {
                if (last.isPending()) {
                    list2.add(last.promise);
                }
                if (!last.equals(command)) continue;
                break;
            }
            ArrayList<AsyncPromise<Node>> arrayList = list2;
            if (arrayList == null) {
                CommandQueue.$$$reportNull$$$0(7);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "submitter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CommandQueue";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "promise";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPromises";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "promise";
                    break;
                }
                case 2: 
                case 3: 
                case 7: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "done";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class Command
    implements Obsolescent {
        final AsyncPromise<Node> promise;
        @Nullable
        final RequestHandler request;
        final String name;
        final Object object;
        volatile boolean started;

        Command(@Nullable RequestHandler request, @NotNull @NonNls String name2, Object object) {
            if (name2 == null) {
                Command.$$$reportNull$$$0(0);
            }
            this.promise = new AsyncPromise();
            this.request = request;
            if (request != null) {
                request.commandStarted();
                this.promise.onProcessed(loaded -> {
                    if (loaded != null) {
                        request.nodesLoaded(this.getLoadedNodeCount((Node)loaded));
                    }
                    request.commandFinished();
                });
            }
            this.name = name2;
            this.object = object;
            if (LOG.isTraceEnabled()) {
                LOG.debug("create command: ", new Object[]{this});
            }
        }

        abstract int getLoadedNodeCount(@NotNull Node var1);

        boolean canRunAsync() {
            return false;
        }

        @NotNull
        Promise<Node> computeAsync() {
            this.started = true;
            if (this.isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("obsolete command: ", new Object[]{this});
                }
                Promise promise = Promises.resolvedPromise(null);
                if (promise == null) {
                    Command.$$$reportNull$$$0(1);
                }
                return promise;
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("background async command: ", new Object[]{this});
            }
            Promise<Node> promise = this.computeAsync(this.object);
            if (promise == null) {
                Command.$$$reportNull$$$0(2);
            }
            return promise;
        }

        @NotNull
        Promise<Node> computeAsync(Object object) {
            Node node = this.computeNode(object);
            Promise promise = Promises.resolvedPromise((Object)node);
            if (promise == null) {
                Command.$$$reportNull$$$0(3);
            }
            return promise;
        }

        abstract Node computeNode(Object var1);

        abstract void applyNodeToUiTree(Node var1);

        boolean isPending() {
            return Promise.State.PENDING == this.promise.getState();
        }

        public String toString() {
            return this.object == null ? this.name : this.name + ": " + String.valueOf(this.object);
        }

        public Node computeNode() {
            this.started = true;
            if (this.isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("obsolete command: ", new Object[]{this});
                }
                return null;
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("background command: ", new Object[]{this});
            }
            return this.computeNode(this.object);
        }

        public void applyToUiTree(Node node) {
            if (this.isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("obsolete command: ", new Object[]{this});
                }
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("foreground command: ", new Object[]{this});
                }
                this.applyNodeToUiTree(node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$Command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$Command";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private final class CmdGetChildren
    extends Command {
        private final Node node;
        private volatile boolean deep;

        CmdGetChildren(@NotNull @NonNls RequestHandler request, @NotNull String name2, Node node, boolean deep) {
            if (name2 == null) {
                CmdGetChildren.$$$reportNull$$$0(0);
            }
            if (node == null) {
                CmdGetChildren.$$$reportNull$$$0(1);
            }
            super(request, name2, node.object);
            this.node = node;
            if (deep) {
                this.deep = true;
            }
            node.queue.add(this, old -> {
                if (!deep && old.deep && old.isPending()) {
                    this.deep = true;
                }
                return true;
            });
        }

        @Override
        int getLoadedNodeCount(@NotNull Node loaded) {
            if (loaded == null) {
                CmdGetChildren.$$$reportNull$$$0(2);
            }
            return loaded.getChildren().size();
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != this.node.queue.get();
        }

        @Override
        boolean canRunAsync() {
            return AsyncTreeModel.this.model instanceof AsyncChildrenProvider;
        }

        @Override
        @NotNull
        Promise<Node> computeAsync(Object object) {
            Node loaded = new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
            if (loaded.leafState == LeafState.ALWAYS || this.isObsolete()) {
                Promise promise = Promises.resolvedPromise((Object)loaded);
                if (promise == null) {
                    CmdGetChildren.$$$reportNull$$$0(3);
                }
                return promise;
            }
            TreeModel treeModel = AsyncTreeModel.this.model;
            if (treeModel instanceof AsyncChildrenProvider) {
                AsyncChildrenProvider provider = (AsyncChildrenProvider)((Object)treeModel);
                Promise childrenPromise = provider.getChildrenAsync(object);
                Promise promise = childrenPromise.then(children2 -> {
                    loaded.children = this.load((List<?>)children2);
                    return loaded;
                });
                if (promise == null) {
                    CmdGetChildren.$$$reportNull$$$0(4);
                }
                return promise;
            }
            Promise<Node> promise = super.computeAsync(object);
            if (promise == null) {
                CmdGetChildren.$$$reportNull$$$0(5);
            }
            return promise;
        }

        @Override
        @NotNull
        Node computeNode(Object object) {
            Node loaded = new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
            if (loaded.leafState == LeafState.ALWAYS || this.isObsolete()) {
                Node node = loaded;
                if (node == null) {
                    CmdGetChildren.$$$reportNull$$$0(6);
                }
                return node;
            }
            TreeModel treeModel = AsyncTreeModel.this.model;
            if (treeModel instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)treeModel);
                loaded.children = this.load(provider.getChildren(object));
            } else {
                loaded.children = this.load(AsyncTreeModel.this.model.getChildCount(object), index -> AsyncTreeModel.this.model.getChild(object, index));
            }
            Node node = loaded;
            if (node == null) {
                CmdGetChildren.$$$reportNull$$$0(7);
            }
            return node;
        }

        @Nullable
        private List<Node> load(@Nullable List<?> children2) {
            if (children2 == null) {
                throw new ProcessCanceledException();
            }
            return this.load(children2.size(), index -> children2.get(index));
        }

        @Nullable
        private List<Node> load(int count, @NotNull IntFunction<?> childGetter) {
            if (childGetter == null) {
                CmdGetChildren.$$$reportNull$$$0(8);
            }
            if (count < 0) {
                LOG.warn("illegal child count: " + count);
            }
            if (count <= 0) {
                return Collections.emptyList();
            }
            Object set = count == 1 ? new SmartHashSet() : new HashSet(count);
            ArrayList<Node> children2 = new ArrayList<Node>(count);
            for (int i2 = 0; i2 < count; ++i2) {
                ProgressManager.checkCanceled();
                if (this.isObsolete()) {
                    return null;
                }
                Object child = childGetter.apply(i2);
                if (child == null) {
                    LOG.warn("ignore null child at " + i2);
                    continue;
                }
                if (!set.add(child)) {
                    LOG.warn("ignore duplicated child at " + i2 + ": " + String.valueOf(child));
                    continue;
                }
                if (this.isObsolete()) {
                    return null;
                }
                children2.add(new Node(child, LeafState.get(child, (TreeModel)AsyncTreeModel.this.model)));
            }
            return children2;
        }

        @Override
        void applyNodeToUiTree(Node loaded) {
            if (loaded == null || loaded.isLoadingRequired()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("cancelled command: ", new Object[]{this});
                }
                return;
            }
            if (this.node != AsyncTreeModel.this.tree.map.get(loaded.object)) {
                this.node.queue.close();
                LOG.warn("ignore removed node: " + String.valueOf(this.node.object));
                return;
            }
            List<Node> oldChildren = this.node.getChildren();
            List<Node> newChildren = loaded.getChildren();
            if (AsyncTreeModel.this.tree.cachedPresentation != null) {
                AsyncTreeModel.this.tree.cachedPresentation.childrenLoaded(this.node.object, ContainerUtil.map(newChildren, child -> child.object));
            }
            if (oldChildren.isEmpty() && newChildren.isEmpty()) {
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("no children: ", new Object[]{this.node.object});
                }
                this.node.queue.done(this, this.node);
                return;
            }
            Object2IntMap<Object> removed = AsyncTreeModel.getIndices(oldChildren, null);
            if (newChildren.isEmpty()) {
                oldChildren.forEach(child -> child.removeMapping(this.node, AsyncTreeModel.this.tree));
                this.node.setLeafState(loaded.leafState);
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("children removed: ", new Object[]{this.node.object});
                }
                this.node.queue.done(this, this.node);
                return;
            }
            ArrayList<Node> list2 = new ArrayList<Node>(newChildren.size());
            SmartHashSet reload = new SmartHashSet();
            Object2IntMap<Object> inserted = AsyncTreeModel.getIndices(newChildren, arg_0 -> this.lambda$applyNodeToUiTree$6(list2, (Set)reload, removed, arg_0));
            newChildren = list2;
            if (oldChildren.isEmpty()) {
                newChildren.forEach(child -> child.insertMapping(this.node));
                this.node.setChildren(newChildren);
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("children inserted: ", new Object[]{this.node.object});
                }
                this.node.queue.done(this, this.node);
                return;
            }
            List<Object> intersection = AsyncTreeModel.getIntersection(removed, inserted);
            Object2IntMap<Object> contained = AsyncTreeModel.createObject2IntLinkedMap(intersection.size());
            for (Object object : intersection) {
                int newIndex;
                int oldIndex = removed.removeInt(object);
                if (oldIndex == -1) {
                    LOG.warn("intersection failed");
                }
                if ((newIndex = inserted.removeInt(object)) == -1) {
                    LOG.warn("intersection failed");
                    continue;
                }
                contained.put(object, newIndex);
            }
            for (Node child2 : newChildren) {
                if (removed.containsKey(child2.object) || !inserted.containsKey(child2.object)) continue;
                child2.insertMapping(this.node);
            }
            for (Node child2 : oldChildren) {
                if (!removed.containsKey(child2.object) || inserted.containsKey(child2.object)) continue;
                child2.removeMapping(this.node, AsyncTreeModel.this.tree);
            }
            this.node.setChildren(newChildren);
            if (!removed.isEmpty()) {
                AsyncTreeModel.this.treeNodesRemoved(this.node, removed);
            }
            if (!inserted.isEmpty()) {
                AsyncTreeModel.this.treeNodesInserted(this.node, inserted);
            }
            if (!contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, contained);
            }
            if (removed.isEmpty() && inserted.isEmpty() && contained.isEmpty()) {
                AsyncTreeModel.this.treeNodesChanged(this.node, null);
            }
            if (LOG.isTraceEnabled()) {
                LOG.debug("children changed: ", new Object[]{this.node.object});
            }
            if (!reload.isEmpty()) {
                for (Node child2 : newChildren) {
                    if (!reload.contains(child2.object)) continue;
                    AsyncTreeModel.this.submit(new CmdGetChildren(this.request, "Update children recursively", child2, true));
                }
            }
            this.node.queue.done(this, this.node);
        }

        private /* synthetic */ int lambda$applyNodeToUiTree$6(List list2, Set reload, Object2IntMap removed, Node child) {
            Node found = AsyncTreeModel.this.tree.map.get(child.object);
            if (found == null) {
                AsyncTreeModel.this.tree.map.put(child.object, child);
                list2.add(child);
            } else {
                AsyncTreeModel.this.tree.fixEqualButNotSame(found, child.object);
                list2.add(found);
                if (found.leafState == LeafState.ALWAYS) {
                    if (child.leafState != LeafState.ALWAYS) {
                        found.setLeafState(child.leafState);
                        reload.add(found.object);
                    }
                } else if (child.leafState == LeafState.ALWAYS || !found.isLoadingRequired() && (this.deep || !removed.containsKey(found.object))) {
                    reload.add(found.object);
                }
            }
            return list2.size() - 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loaded";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/AsyncTreeModel$CmdGetChildren";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childGetter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CmdGetChildren";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAsync";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLoadedNodeCount";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private final class CmdGetRoot
    extends Command {
        private CmdGetRoot(@NotNull @NonNls RequestHandler request, String name2, Object object) {
            if (name2 == null) {
                CmdGetRoot.$$$reportNull$$$0(0);
            }
            super(request, name2, object);
            AsyncTreeModel.this.tree.queue.add(this, old -> old.started || old.object != object);
        }

        @Override
        int getLoadedNodeCount(@NotNull Node loaded) {
            if (loaded == null) {
                CmdGetRoot.$$$reportNull$$$0(1);
            }
            return 1;
        }

        public boolean isObsolete() {
            return AsyncTreeModel.this.disposed || this != AsyncTreeModel.this.tree.queue.get();
        }

        @Override
        Node computeNode(Object object) {
            if (object == null) {
                object = AsyncTreeModel.this.model.getRoot();
            }
            if (object == null || this.isObsolete()) {
                return null;
            }
            return new Node(object, LeafState.get((Object)object, (TreeModel)AsyncTreeModel.this.model));
        }

        @Override
        void applyNodeToUiTree(Node loaded) {
            Node root = AsyncTreeModel.this.tree.root;
            if (root == null && loaded == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("no root");
                }
                AsyncTreeModel.this.tree.queue.done(this, null);
                return;
            }
            if (root != null && loaded != null && root.object.equals(loaded.object)) {
                AsyncTreeModel.this.tree.fixEqualButNotSame(root, loaded.object);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("same root: ", new Object[]{root.object});
                }
                if (!root.isLoadingRequired()) {
                    AsyncTreeModel.this.submit(new CmdGetChildren(this.request, "Update root children", root, true));
                }
                AsyncTreeModel.this.tree.queue.done(this, root);
                return;
            }
            if (root != null) {
                root.removeMapping(null, AsyncTreeModel.this.tree);
            }
            if (!AsyncTreeModel.this.tree.map.isEmpty()) {
                AsyncTreeModel.this.tree.map.values().forEach(node -> {
                    node.queue.close();
                    LOG.warn("remove staled node: " + String.valueOf(node.object));
                });
                AsyncTreeModel.this.tree.map.clear();
            }
            AsyncTreeModel.this.tree.root = loaded;
            if (loaded != null) {
                AsyncTreeModel.this.tree.map.put(loaded.object, loaded);
                CachingTreePath path = new CachingTreePath(loaded.object);
                loaded.insertPath((TreePath)path);
                if (AsyncTreeModel.this.tree.cachedPresentation != null) {
                    AsyncTreeModel.this.tree.cachedPresentation.rootLoaded(loaded.object);
                }
                AsyncTreeModel.this.treeStructureChanged((TreePath)path, null, null);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("new root: ", new Object[]{loaded.object});
                }
                AsyncTreeModel.this.tree.queue.done(this, loaded);
            } else {
                AsyncTreeModel.this.treeStructureChanged(null, null, null);
                if (LOG.isTraceEnabled()) {
                    LOG.debug("root removed");
                }
                AsyncTreeModel.this.tree.queue.done(this, null);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loaded";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/tree/AsyncTreeModel$CmdGetRoot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLoadedNodeCount";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static interface AsyncChildrenProvider<T> {
        @NotNull
        public Promise<? extends List<? extends T>> getChildrenAsync(Object var1);
    }
}

