/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ui.tree.BgtTreeWalkerKt;
import com.intellij.ui.tree.EdtBgtTreeVisitor;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.TreeWalkerBase;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\b9:;<=>?@B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0$H\u0016J\u0017\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00018\u0000H\u0017\u00a2\u0006\u0002\u0010(J\u0016\u0010)\u001a\u00020&2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0017J\u0010\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020.H\u0017J\u0018\u0010/\u001a\u00020&2\u0006\u00100\u001a\u00020\u00162\u0006\u00101\u001a\u00020\u0016H\u0002J\u0010\u00102\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020&2\u0006\u00103\u001a\u000204H\u0002J\u001a\u00105\u001a\u00020&2\u0006\u00103\u001a\u0002042\b\u00106\u001a\u0004\u0018\u00010\u0002H\u0002J$\u00105\u001a\u00020&2\u0006\u00103\u001a\u0002042\b\u00107\u001a\u0004\u0018\u00010\u00022\b\u00108\u001a\u0004\u0018\u00010\u0002H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u000e\u0012\f0\u0014R\b\u0012\u0004\u0012\u00028\u00000\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@CX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\f0\u001bR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001c\u001a\f0\u001dR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u001e\u001a\f0\u001fR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\f0!R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\"\u001a\f0#R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker;", "N", "", "Lcom/intellij/ui/tree/TreeWalkerBase;", "visitor", "Lcom/intellij/ui/tree/TreeVisitor;", "background", "Lcom/intellij/util/concurrency/Invoker;", "foreground", "convert", "Lkotlin/Function1;", "<init>", "(Lcom/intellij/ui/tree/TreeVisitor;Lcom/intellij/util/concurrency/Invoker;Lcom/intellij/util/concurrency/Invoker;Lkotlin/jvm/functions/Function1;)V", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Ljavax/swing/tree/TreePath;", "getPromise", "()Lorg/jetbrains/concurrency/AsyncPromise;", "stack", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/ui/tree/BgtTreeWalker$Level;", "value", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "state", "setState", "(Lcom/intellij/ui/tree/BgtTreeWalker$State;)V", "lookingForNextNode", "Lcom/intellij/ui/tree/BgtTreeWalker$LookingForNextNode;", "visitingNode", "Lcom/intellij/ui/tree/BgtTreeWalker$VisitingNode;", "requestingChildren", "Lcom/intellij/ui/tree/BgtTreeWalker$RequestingChildren;", "success", "Lcom/intellij/ui/tree/BgtTreeWalker$Success;", "failure", "Lcom/intellij/ui/tree/BgtTreeWalker$Failure;", "Lorg/jetbrains/concurrency/Promise;", "start", "", "node", "(Ljava/lang/Object;)V", "setChildren", "children", "", "setError", "error", "", "checkValidStateTransition", "oldState", "newState", "warn", "message", "", "debug", "details", "details1", "details2", "Level", "State", "InitialState", "LookingForNextNode", "VisitingNode", "RequestingChildren", "Success", "Failure", "intellij.platform.ide.impl"})
public abstract class BgtTreeWalker<N>
extends TreeWalkerBase<N> {
    @NotNull
    private final TreeVisitor visitor;
    @NotNull
    private final Invoker background;
    @NotNull
    private final Invoker foreground;
    @NotNull
    private final Function1<N, Object> convert;
    @NotNull
    private final AsyncPromise<TreePath> promise;
    @NotNull
    private final ArrayDeque<Level> stack;
    @NotNull
    private State state;
    @NotNull
    private final LookingForNextNode lookingForNextNode;
    @NotNull
    private final VisitingNode visitingNode;
    @NotNull
    private final RequestingChildren requestingChildren;
    @NotNull
    private final Success success;
    @NotNull
    private final Failure failure;

    public BgtTreeWalker(@NotNull TreeVisitor visitor, @NotNull Invoker background, @NotNull Invoker foreground, @NotNull Function1<? super N, ? extends Object> convert) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
        Intrinsics.checkNotNullParameter(convert, (String)"convert");
        this.visitor = visitor;
        this.background = background;
        this.foreground = foreground;
        this.convert = convert;
        this.promise = new AsyncPromise();
        this.stack = new ArrayDeque();
        this.state = InitialState.INSTANCE;
        this.lookingForNextNode = new LookingForNextNode();
        this.visitingNode = new VisitingNode();
        this.requestingChildren = new RequestingChildren();
        this.success = new Success();
        this.failure = new Failure();
    }

    @NotNull
    public final AsyncPromise<TreePath> getPromise() {
        return this.promise;
    }

    @RequiresEdt
    private final void setState(State value) {
        this.checkValidStateTransition(this.state, value);
        this.state = value;
    }

    @Override
    @NotNull
    public Promise<TreePath> promise() {
        return (Promise)this.promise;
    }

    @Override
    @RequiresEdt
    public void start(@Nullable N node) {
        if (node != null) {
            this.stack.addLast((Object)new Level(null, new ArrayDeque((Collection)CollectionsKt.listOf(node))));
        }
        this.lookingForNextNode.enter();
    }

    @Override
    @RequiresEdt
    public void setChildren(@NotNull Collection<? extends N> children2) {
        Intrinsics.checkNotNullParameter(children2, (String)"children");
        this.requestingChildren.setChildren(children2);
    }

    @Override
    @RequiresEdt
    public void setError(@NotNull Throwable error2) {
        Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
        this.failure.enter(error2);
    }

    private final void checkValidStateTransition(State oldState, State newState) {
        boolean valid;
        State state2 = newState;
        boolean bl = Intrinsics.areEqual((Object)state2, (Object)InitialState.INSTANCE) ? false : (Intrinsics.areEqual((Object)state2, (Object)this.lookingForNextNode) ? Intrinsics.areEqual((Object)oldState, (Object)InitialState.INSTANCE) || Intrinsics.areEqual((Object)oldState, (Object)this.visitingNode) || Intrinsics.areEqual((Object)oldState, (Object)this.requestingChildren) : (Intrinsics.areEqual((Object)state2, (Object)this.visitingNode) ? Intrinsics.areEqual((Object)oldState, (Object)this.lookingForNextNode) : (Intrinsics.areEqual((Object)state2, (Object)this.requestingChildren) ? Intrinsics.areEqual((Object)oldState, (Object)this.visitingNode) : (Intrinsics.areEqual((Object)state2, (Object)this.success) ? Intrinsics.areEqual((Object)oldState, (Object)this.lookingForNextNode) || Intrinsics.areEqual((Object)oldState, (Object)this.visitingNode) : (Intrinsics.areEqual((Object)state2, (Object)this.failure) ? !Intrinsics.areEqual((Object)oldState, (Object)this.success) : (valid = false))))));
        if (!valid) {
            throw new IllegalStateException("Invalid state transition in BgtTreeWalker: " + oldState + " -> " + newState);
        }
    }

    private final void warn(String message) {
        BgtTreeWalkerKt.access$getLOG$p().warn(this + "(" + Thread.currentThread() + "): " + message);
    }

    private final void debug(String message) {
        if (BgtTreeWalkerKt.access$getLOG$p().isDebugEnabled()) {
            BgtTreeWalkerKt.access$getLOG$p().debug(this + "(" + Thread.currentThread() + "): " + message);
        }
    }

    private final void debug(String message, Object details) {
        if (BgtTreeWalkerKt.access$getLOG$p().isDebugEnabled()) {
            Object[] objectArray = new Object[]{details};
            BgtTreeWalkerKt.access$getLOG$p().debug(this + "(" + Thread.currentThread() + "): " + message, objectArray);
        }
    }

    private final void debug(String message, Object details1, Object details2) {
        if (BgtTreeWalkerKt.access$getLOG$p().isDebugEnabled()) {
            Object[] objectArray = new Object[]{details1, details2};
            BgtTreeWalkerKt.access$getLOG$p().debug(this + "(" + Thread.currentThread() + "): " + message, objectArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$Failure;", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "<init>", "(Lcom/intellij/ui/tree/BgtTreeWalker;)V", "enter", "", "error", "", "intellij.platform.ide.impl"})
    private final class Failure
    extends State {
        public final void enter(@NotNull Throwable error2) {
            Intrinsics.checkNotNullParameter((Object)error2, (String)"error");
            if (BgtTreeWalker.this.getPromise().isDone()) {
                BgtTreeWalker.this.warn("Already complete, can't register failure " + error2);
                return;
            }
            BgtTreeWalker.this.debug("Entering failure state: ", error2);
            BgtTreeWalker.this.setState(this);
            BgtTreeWalker.this.getPromise().setError(error2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$InitialState;", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "<init>", "()V", "intellij.platform.ide.impl"})
    private static final class InitialState
    extends State {
        @NotNull
        public static final InitialState INSTANCE = new InitialState();

        private InitialState() {
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$Level;", "", "path", "Ljavax/swing/tree/TreePath;", "nodes", "Lkotlin/collections/ArrayDeque;", "<init>", "(Lcom/intellij/ui/tree/BgtTreeWalker;Ljavax/swing/tree/TreePath;Lkotlin/collections/ArrayDeque;)V", "getPath", "()Ljavax/swing/tree/TreePath;", "getNodes", "()Lkotlin/collections/ArrayDeque;", "intellij.platform.ide.impl"})
    private final class Level {
        @Nullable
        private final TreePath path;
        @NotNull
        private final ArrayDeque<N> nodes;

        public Level(@NotNull TreePath path, ArrayDeque<N> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.path = path;
            this.nodes = nodes;
        }

        @Nullable
        public final TreePath getPath() {
            return this.path;
        }

        @NotNull
        public final ArrayDeque<N> getNodes() {
            return this.nodes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$LookingForNextNode;", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "<init>", "(Lcom/intellij/ui/tree/BgtTreeWalker;)V", "enter", "", "intellij.platform.ide.impl"})
    private final class LookingForNextNode
    extends State {
        public final void enter() {
            Object node;
            Level level;
            BgtTreeWalker.this.setState(this);
            BgtTreeWalker.this.debug("Looking for next node");
            while (true) {
                if ((level = (Level)BgtTreeWalker.this.stack.lastOrNull()) == null) {
                    BgtTreeWalker.this.debug("No nodes remaining in the tree");
                    BgtTreeWalker.this.success.enter(null);
                    return;
                }
                node = level.getNodes().removeFirstOrNull();
                if (node != null) break;
                BgtTreeWalker.this.debug("No nodes remaining on the level, going up");
                BgtTreeWalker.this.stack.removeLast();
            }
            TreePath treePath = TreePathUtil.createTreePath(level.getPath(), BgtTreeWalker.this.convert.invoke(node));
            Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"createTreePath(...)");
            TreePath path = treePath;
            BgtTreeWalker.this.debug("Found node ", node, path);
            BgtTreeWalker.this.visitingNode.enter(node, path);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u00002\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$RequestingChildren;", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "<init>", "(Lcom/intellij/ui/tree/BgtTreeWalker;)V", "path", "Ljavax/swing/tree/TreePath;", "enter", "", "node", "(Ljava/lang/Object;Ljavax/swing/tree/TreePath;)V", "setChildren", "children", "", "intellij.platform.ide.impl"})
    private final class RequestingChildren
    extends State {
        private TreePath path;

        public final void enter(@NotNull N node, @NotNull TreePath path) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            BgtTreeWalker.this.setState(this);
            BgtTreeWalker.this.debug("Requesting children ", node, path);
            this.path = path;
            Collection children2 = BgtTreeWalker.this.getChildren(node);
            if (children2 != null) {
                this.setChildren(children2);
            }
        }

        public final void setChildren(@NotNull Collection<? extends N> children2) {
            Intrinsics.checkNotNullParameter(children2, (String)"children");
            BgtTreeWalker.this.foreground.invokeLater(() -> RequestingChildren.setChildren$lambda$0(BgtTreeWalker.this, this, children2));
        }

        private static final void setChildren$lambda$0(BgtTreeWalker this$0, RequestingChildren this$1, Collection $children) {
            ArrayDeque arrayDeque = this$0.stack;
            TreePath treePath = this$1.path;
            if (treePath == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"path");
                treePath = null;
            }
            arrayDeque.addLast((Object)this$0.new Level(treePath, new ArrayDeque($children)));
            this$0.lookingForNextNode.enter();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$State;", "", "<init>", "()V", "intellij.platform.ide.impl"})
    private static abstract class State {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$Success;", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "<init>", "(Lcom/intellij/ui/tree/BgtTreeWalker;)V", "enter", "", "result", "Ljavax/swing/tree/TreePath;", "intellij.platform.ide.impl"})
    private final class Success
    extends State {
        public final void enter(@Nullable TreePath result2) {
            if (BgtTreeWalker.this.getPromise().isDone()) {
                BgtTreeWalker.this.warn("Already complete, can't register success " + result2);
                return;
            }
            BgtTreeWalker.this.debug("Entering success state: ", result2);
            BgtTreeWalker.this.setState(this);
            BgtTreeWalker.this.getPromise().setResult((Object)result2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ%\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ui/tree/BgtTreeWalker$VisitingNode;", "Lcom/intellij/ui/tree/BgtTreeWalker$State;", "<init>", "(Lcom/intellij/ui/tree/BgtTreeWalker;)V", "enter", "", "node", "path", "Ljavax/swing/tree/TreePath;", "(Ljava/lang/Object;Ljavax/swing/tree/TreePath;)V", "processVisitResult", "visitResult", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "(Lcom/intellij/ui/tree/TreeVisitor$Action;Ljavax/swing/tree/TreePath;Ljava/lang/Object;)V", "intellij.platform.ide.impl"})
    private final class VisitingNode
    extends State {
        public final void enter(@NotNull N node, @NotNull TreePath path) {
            TreeVisitor.Action preVisitResult;
            EdtBgtTreeVisitor edtBgtVisitor;
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            BgtTreeWalker.this.setState(this);
            BgtTreeWalker.this.debug("Visiting node ", node, path);
            TreeVisitor treeVisitor = BgtTreeWalker.this.visitor;
            EdtBgtTreeVisitor edtBgtTreeVisitor = edtBgtVisitor = treeVisitor instanceof EdtBgtTreeVisitor ? (EdtBgtTreeVisitor)treeVisitor : null;
            Object object = preVisitResult = edtBgtTreeVisitor != null ? edtBgtTreeVisitor.preVisitEDT(path) : null;
            if (preVisitResult != null) {
                this.processVisitResult(preVisitResult, path, node);
                return;
            }
            BgtTreeWalker.this.background.computeLater(() -> VisitingNode.enter$lambda$0(BgtTreeWalker.this, path)).onSuccess(arg_0 -> VisitingNode.enter$lambda$2(arg_0 -> VisitingNode.enter$lambda$1(BgtTreeWalker.this, edtBgtVisitor, path, this, node, arg_0), arg_0)).onError(arg_0 -> VisitingNode.enter$lambda$4(arg_0 -> VisitingNode.enter$lambda$3(BgtTreeWalker.this, arg_0), arg_0));
        }

        private final void processVisitResult(TreeVisitor.Action visitResult, TreePath path, N node) {
            switch (WhenMappings.$EnumSwitchMapping$0[visitResult.ordinal()]) {
                case 1: {
                    BgtTreeWalker.this.success.enter(path);
                    break;
                }
                case 2: {
                    BgtTreeWalker.this.requestingChildren.enter(node, path);
                    break;
                }
                case 3: {
                    BgtTreeWalker.this.lookingForNextNode.enter();
                    break;
                }
                case 4: {
                    BgtTreeWalker.this.stack.removeLastOrNull();
                    BgtTreeWalker.this.lookingForNextNode.enter();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }

        private static final TreeVisitor.Action enter$lambda$0(BgtTreeWalker this$0, TreePath $path) {
            return this$0.visitor.visit($path);
        }

        private static final Unit enter$lambda$1(BgtTreeWalker this$0, EdtBgtTreeVisitor $edtBgtVisitor, TreePath $path, VisitingNode this$1, Object $node, TreeVisitor.Action action2) {
            this$0.foreground.invokeLater(() -> VisitingNode.enter$lambda$1$0(action2, $edtBgtVisitor, $path, this$1, $node));
            return Unit.INSTANCE;
        }

        private static final void enter$lambda$1$0(TreeVisitor.Action $action, EdtBgtTreeVisitor $edtBgtVisitor, TreePath $path, VisitingNode this$0, Object $node) {
            TreeVisitor.Action action2 = $action;
            Intrinsics.checkNotNull((Object)action2);
            TreeVisitor.Action visitResult = action2;
            EdtBgtTreeVisitor edtBgtTreeVisitor = $edtBgtVisitor;
            TreeVisitor.Action postVisitResult = edtBgtTreeVisitor != null ? edtBgtTreeVisitor.postVisitEDT($path, visitResult) : null;
            TreeVisitor.Action action3 = postVisitResult;
            if (action3 == null) {
                action3 = visitResult;
            }
            this$0.processVisitResult(action3, $path, $node);
        }

        private static final void enter$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit enter$lambda$3(BgtTreeWalker this$0, Throwable error2) {
            this$0.foreground.invokeLater(() -> VisitingNode.enter$lambda$3$0(this$0, error2));
            return Unit.INSTANCE;
        }

        private static final void enter$lambda$3$0(BgtTreeWalker this$0, Throwable $error) {
            Failure failure = this$0.failure;
            Intrinsics.checkNotNull((Object)$error);
            failure.enter($error);
        }

        private static final void enter$lambda$4(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TreeVisitor.Action.values().length];
                try {
                    nArray[TreeVisitor.Action.INTERRUPT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeVisitor.Action.CONTINUE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeVisitor.Action.SKIP_CHILDREN.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TreeVisitor.Action.SKIP_SIBLINGS.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

