/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.TreeNodePresentationBuilder;
import com.intellij.ui.treeStructure.TreeNodePresentationImpl;
import com.intellij.ui.treeStructure.TreeNodeTextFragment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0016\u0010\u001e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ui/tree/TreeNodePresentationBuilderImpl;", "Lcom/intellij/ui/treeStructure/TreeNodePresentationBuilder;", "isLeaf", "", "<init>", "(Z)V", "()Z", "iconValue", "Ljavax/swing/Icon;", "mainTextValue", "", "fullTextValue", "", "Lcom/intellij/ui/treeStructure/TreeNodeTextFragment;", "toolTipValue", "setIcon", "", "icon", "setMainText", "text", "appendTextFragment", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "setToolTipText", "toolTip", "build", "Lcom/intellij/ui/treeStructure/TreeNodePresentationImpl;", "buildColoredText", "", "mainText", "buildMainText", "fullText", "intellij.platform.ide.impl"})
public final class TreeNodePresentationBuilderImpl
implements TreeNodePresentationBuilder {
    private final boolean isLeaf;
    @Nullable
    private Icon iconValue;
    @Nullable
    private String mainTextValue;
    @Nullable
    private List<TreeNodeTextFragment> fullTextValue;
    @Nullable
    private String toolTipValue;

    public TreeNodePresentationBuilderImpl(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public final boolean isLeaf() {
        return this.isLeaf;
    }

    public void setIcon(@Nullable Icon icon2) {
        this.iconValue = icon2;
    }

    public void setMainText(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.mainTextValue = text2;
    }

    public void appendTextFragment(@NotNull String text2, @NotNull SimpleTextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        List list2 = this.fullTextValue;
        if (list2 == null) {
            list2 = new ArrayList();
        }
        List coloredText = list2;
        coloredText.add(new TreeNodeTextFragment(text2, attributes));
        this.fullTextValue = coloredText;
    }

    public void setToolTipText(@Nullable String toolTip) {
        this.toolTipValue = toolTip;
    }

    @NotNull
    public TreeNodePresentationImpl build() {
        String specifiedMainText = this.mainTextValue;
        List<TreeNodeTextFragment> specifiedFullText = this.fullTextValue;
        String mainText = null;
        List<TreeNodeTextFragment> fullText = null;
        if (specifiedMainText != null) {
            if (specifiedFullText != null) {
                mainText = specifiedMainText;
                fullText = specifiedFullText;
            } else {
                mainText = specifiedMainText;
                fullText = this.buildColoredText(mainText);
            }
        } else if (specifiedFullText != null) {
            mainText = this.buildMainText(specifiedFullText);
            fullText = specifiedFullText;
        } else {
            throw new IllegalStateException("Either the main text or the full text must be specified");
        }
        return new TreeNodePresentationImpl(this.isLeaf, this.iconValue, mainText, fullText, this.toolTipValue);
    }

    private final List<TreeNodeTextFragment> buildColoredText(String mainText) {
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        return CollectionsKt.listOf((Object)new TreeNodeTextFragment(mainText, simpleTextAttributes));
    }

    private final String buildMainText(List<TreeNodeTextFragment> fullText) {
        TreeNodeTextFragment fragment;
        SimpleTextAttributes attributes;
        StringBuilder builder = new StringBuilder();
        Iterator<TreeNodeTextFragment> iterator2 = fullText.iterator();
        while (iterator2.hasNext() && !Intrinsics.areEqual((Object)(attributes = (fragment = iterator2.next()).getAttributes()).getFgColor(), (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor())) {
            builder.append(fragment.getText());
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

